/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSet {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceSet.class);
    private Map<String, Path> localizedResources = new ConcurrentHashMap<String, Path>();
    private Map<LocalResourceRequest, Set<String>> pendingResources = new ConcurrentHashMap<LocalResourceRequest, Set<String>>();
    private Set<LocalResourceRequest> resourcesFailedToBeLocalized = new HashSet<LocalResourceRequest>();
    private final List<LocalResourceRequest> publicRsrcs = new ArrayList<LocalResourceRequest>();
    private final List<LocalResourceRequest> privateRsrcs = new ArrayList<LocalResourceRequest>();
    private final List<LocalResourceRequest> appRsrcs = new ArrayList<LocalResourceRequest>();
    private final Map<LocalResourceRequest, Path> resourcesToBeUploaded = new ConcurrentHashMap<LocalResourceRequest, Path>();
    private final Map<LocalResourceRequest, Boolean> resourcesUploadPolicies = new ConcurrentHashMap<LocalResourceRequest, Boolean>();

    public Map<LocalResourceVisibility, Collection<LocalResourceRequest>> addResources(Map<String, LocalResource> localResourceMap) throws URISyntaxException {
        if (localResourceMap == null || localResourceMap.isEmpty()) {
            return null;
        }
        HashMap allResources = new HashMap();
        ArrayList<LocalResourceRequest> publicList = new ArrayList<LocalResourceRequest>();
        ArrayList<LocalResourceRequest> privateList = new ArrayList<LocalResourceRequest>();
        ArrayList<LocalResourceRequest> appList = new ArrayList<LocalResourceRequest>();
        for (Map.Entry<String, LocalResource> rsrc : localResourceMap.entrySet()) {
            LocalResource resource = rsrc.getValue();
            LocalResourceRequest req = new LocalResourceRequest(rsrc.getValue());
            if (!allResources.containsKey(req)) {
                allResources.put(req, new HashSet());
            }
            ((Set)allResources.get(req)).add(rsrc.getKey());
            this.storeSharedCacheUploadPolicy(req, resource.getShouldBeUploadedToSharedCache());
            switch (resource.getVisibility()) {
                case PUBLIC: {
                    publicList.add(req);
                    break;
                }
                case PRIVATE: {
                    privateList.add(req);
                    break;
                }
                case APPLICATION: {
                    appList.add(req);
                    break;
                }
            }
        }
        LinkedHashMap<LocalResourceVisibility, Collection<LocalResourceRequest>> req = new LinkedHashMap<LocalResourceVisibility, Collection<LocalResourceRequest>>();
        if (!publicList.isEmpty()) {
            this.publicRsrcs.addAll(publicList);
            req.put(LocalResourceVisibility.PUBLIC, publicList);
        }
        if (!privateList.isEmpty()) {
            this.privateRsrcs.addAll(privateList);
            req.put(LocalResourceVisibility.PRIVATE, privateList);
        }
        if (!appList.isEmpty()) {
            this.appRsrcs.addAll(appList);
            req.put(LocalResourceVisibility.APPLICATION, appList);
        }
        if (!allResources.isEmpty()) {
            this.pendingResources.putAll(allResources);
        }
        return req;
    }

    public Set<String> resourceLocalized(LocalResourceRequest request, Path location) {
        Set<String> symlinks = this.pendingResources.remove(request);
        if (symlinks == null) {
            return null;
        }
        for (String symlink : symlinks) {
            this.localizedResources.put(symlink, location);
        }
        return symlinks;
    }

    public void resourceLocalizationFailed(LocalResourceRequest request) {
        this.pendingResources.remove(request);
        this.resourcesFailedToBeLocalized.add(request);
    }

    public synchronized Map<LocalResourceVisibility, Collection<LocalResourceRequest>> getAllResourcesByVisibility() {
        HashMap<LocalResourceVisibility, Collection<LocalResourceRequest>> rsrc = new HashMap<LocalResourceVisibility, Collection<LocalResourceRequest>>();
        if (!this.publicRsrcs.isEmpty()) {
            rsrc.put(LocalResourceVisibility.PUBLIC, this.publicRsrcs);
        }
        if (!this.privateRsrcs.isEmpty()) {
            rsrc.put(LocalResourceVisibility.PRIVATE, this.privateRsrcs);
        }
        if (!this.appRsrcs.isEmpty()) {
            rsrc.put(LocalResourceVisibility.APPLICATION, this.appRsrcs);
        }
        return rsrc;
    }

    private void storeSharedCacheUploadPolicy(LocalResourceRequest resourceRequest, Boolean uploadPolicy) {
        Boolean storedUploadPolicy = this.resourcesUploadPolicies.get(resourceRequest);
        if (storedUploadPolicy == null || !storedUploadPolicy.booleanValue() && uploadPolicy.booleanValue()) {
            this.resourcesUploadPolicies.put(resourceRequest, uploadPolicy);
        }
    }

    public Map<Path, List<String>> getLocalizedResources() {
        HashMap<Path, List<String>> map = new HashMap<Path, List<String>>();
        for (Map.Entry<String, Path> entry : this.localizedResources.entrySet()) {
            if (!map.containsKey(entry.getValue())) {
                map.put(entry.getValue(), new ArrayList());
            }
            ((List)map.get(entry.getValue())).add(entry.getKey());
        }
        return map;
    }

    public Map<LocalResourceRequest, Path> getResourcesToBeUploaded() {
        return this.resourcesToBeUploaded;
    }

    public Map<LocalResourceRequest, Boolean> getResourcesUploadPolicies() {
        return this.resourcesUploadPolicies;
    }

    public Map<LocalResourceRequest, Set<String>> getPendingResources() {
        return this.pendingResources;
    }

    public static ResourceSet merge(ResourceSet ... resourceSets) {
        ResourceSet merged = new ResourceSet();
        for (ResourceSet rs : resourceSets) {
            merged.localizedResources.putAll(rs.localizedResources);
            merged.resourcesToBeUploaded.putAll(rs.resourcesToBeUploaded);
            merged.resourcesUploadPolicies.putAll(rs.resourcesUploadPolicies);
            merged.publicRsrcs.addAll(rs.publicRsrcs);
            merged.privateRsrcs.addAll(rs.privateRsrcs);
            merged.appRsrcs.addAll(rs.appRsrcs);
        }
        return merged;
    }
}

