/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerClient;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerInspectCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerRunCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerStopCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DockerLinuxContainerRuntime
implements LinuxContainerRuntime {
    private static final Log LOG = LogFactory.getLog(DockerLinuxContainerRuntime.class);
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_IMAGE = "YARN_CONTAINER_RUNTIME_DOCKER_IMAGE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_IMAGE_FILE = "YARN_CONTAINER_RUNTIME_DOCKER_IMAGE_FILE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_RUN_OVERRIDE_DISABLE = "YARN_CONTAINER_RUNTIME_DOCKER_RUN_OVERRIDE_DISABLE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_NETWORK = "YARN_CONTAINER_RUNTIME_DOCKER_CONTAINER_NETWORK";
    public static final String ENV_DOCKER_CONTAINER_RUN_PRIVILEGED_CONTAINER = "YARN_CONTAINER_RUNTIME_DOCKER_RUN_PRIVILEGED_CONTAINER";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_LOCAL_RESOURCE_MOUNTS = "YARN_CONTAINER_RUNTIME_DOCKER_LOCAL_RESOURCE_MOUNTS";
    private Configuration conf;
    private DockerClient dockerClient;
    private PrivilegedOperationExecutor privilegedOperationExecutor;
    private Set<String> allowedNetworks = new HashSet<String>();
    private String defaultNetwork;
    private CGroupsHandler cGroupsHandler;
    private AccessControlList privilegedContainersAcl;

    public static boolean isDockerContainerRequested(Map<String, String> env) {
        if (env == null) {
            return false;
        }
        String type = env.get("YARN_CONTAINER_RUNTIME_TYPE");
        return type != null && type.equals("docker");
    }

    public DockerLinuxContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor) {
        this(privilegedOperationExecutor, ResourceHandlerModule.getCGroupsHandler());
    }

    @VisibleForTesting
    public DockerLinuxContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor, CGroupsHandler cGroupsHandler) {
        this.privilegedOperationExecutor = privilegedOperationExecutor;
        if (cGroupsHandler == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"cGroupsHandler is null - cgroups not in use.");
            }
        } else {
            this.cGroupsHandler = cGroupsHandler;
        }
    }

    @Override
    public void initialize(Configuration conf) throws ContainerExecutionException {
        this.conf = conf;
        this.dockerClient = new DockerClient(conf);
        this.allowedNetworks.clear();
        this.allowedNetworks.addAll(Arrays.asList(conf.getStrings("yarn.nodemanager.runtime.linux.docker.allowed-container-networks", YarnConfiguration.DEFAULT_NM_DOCKER_ALLOWED_CONTAINER_NETWORKS)));
        this.defaultNetwork = conf.get("yarn.nodemanager.runtime.linux.docker.default-container-network", "host");
        if (!this.allowedNetworks.contains(this.defaultNetwork)) {
            String message = "Default network: " + this.defaultNetwork + " is not in the set of allowed networks: " + this.allowedNetworks;
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(message + ". Please check configuration"));
            }
            throw new ContainerExecutionException(message);
        }
        this.privilegedContainersAcl = new AccessControlList(conf.get("yarn.nodemanager.runtime.linux.docker.privileged-containers.acl", ""));
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
    }

    private void validateContainerNetworkType(String network) throws ContainerExecutionException {
        if (this.allowedNetworks.contains(network)) {
            return;
        }
        String msg = "Disallowed network:  '" + network + "' specified. Allowed networks: are " + this.allowedNetworks.toString();
        throw new ContainerExecutionException(msg);
    }

    @VisibleForTesting
    protected void addCGroupParentIfRequired(String resourcesOptions, String containerIdStr, DockerRunCommand runCommand) {
        if (this.cGroupsHandler == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"cGroupsHandler is null. cgroups are not in use. nothing to do.");
            }
            return;
        }
        if (resourcesOptions.equals("cgroups=none")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"no resource restrictions specified. not using docker's cgroup options");
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"using docker's cgroups options");
            }
            String cGroupPath = "/" + this.cGroupsHandler.getRelativePathForCGroup(containerIdStr);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("using cgroup parent: " + cGroupPath));
            }
            runCommand.setCGroupParent(cGroupPath);
        }
    }

    private boolean allowPrivilegedContainerExecution(Container container) throws ContainerExecutionException {
        boolean privilegedContainersEnabledOnCluster;
        Map environment = container.getLaunchContext().getEnvironment();
        String runPrivilegedContainerEnvVar = (String)environment.get(ENV_DOCKER_CONTAINER_RUN_PRIVILEGED_CONTAINER);
        if (runPrivilegedContainerEnvVar == null) {
            return false;
        }
        if (!runPrivilegedContainerEnvVar.equalsIgnoreCase("true")) {
            LOG.warn((Object)("NOT running a privileged container. Value of YARN_CONTAINER_RUNTIME_DOCKER_RUN_PRIVILEGED_CONTAINERis invalid: " + runPrivilegedContainerEnvVar));
            return false;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Privileged container requested for : " + container.getContainerId().toString()));
        }
        if (!(privilegedContainersEnabledOnCluster = this.conf.getBoolean("yarn.nodemanager.runtime.linux.docker.privileged-containers.allowed", false))) {
            String message = "Privileged container being requested but privileged containers are not enabled on this cluster";
            LOG.warn((Object)message);
            throw new ContainerExecutionException(message);
        }
        String submittingUser = container.getUser();
        UserGroupInformation submitterUgi = UserGroupInformation.createRemoteUser((String)submittingUser);
        if (!this.privilegedContainersAcl.isUserAllowed(submitterUgi)) {
            String message = "Cannot launch privileged container. Submitting user (" + submittingUser + ") fails ACL check.";
            LOG.warn((Object)message);
            throw new ContainerExecutionException(message);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("All checks pass. Launching privileged container for : " + container.getContainerId().toString()));
        }
        return true;
    }

    @VisibleForTesting
    protected String validateMount(String mount, Map<Path, List<String>> localizedResources) throws ContainerExecutionException {
        for (Map.Entry<Path, List<String>> resource : localizedResources.entrySet()) {
            if (!resource.getValue().contains(mount)) continue;
            java.nio.file.Path path = Paths.get(resource.getKey().toString(), new String[0]);
            if (!path.isAbsolute()) {
                throw new ContainerExecutionException("Mount must be absolute: " + mount);
            }
            if (Files.isSymbolicLink(path)) {
                throw new ContainerExecutionException("Mount cannot be a symlink: " + mount);
            }
            return path.toString();
        }
        throw new ContainerExecutionException("Mount must be a localized resource: " + mount);
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        String mounts;
        Container container = ctx.getContainer();
        Map environment = container.getLaunchContext().getEnvironment();
        String imageName = (String)environment.get(ENV_DOCKER_CONTAINER_IMAGE);
        String network = (String)environment.get(ENV_DOCKER_CONTAINER_NETWORK);
        if (network == null || network.isEmpty()) {
            network = this.defaultNetwork;
        }
        this.validateContainerNetworkType(network);
        if (imageName == null) {
            throw new ContainerExecutionException("YARN_CONTAINER_RUNTIME_DOCKER_IMAGE not set!");
        }
        String containerIdStr = container.getContainerId().toString();
        String runAsUser = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER);
        Path containerWorkDir = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_WORK_DIR);
        List localDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOCAL_DIRS);
        List logDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOG_DIRS);
        List filecacheDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.FILECACHE_DIRS);
        List containerLocalDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LOCAL_DIRS);
        List containerLogDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LOG_DIRS);
        Map localizedResources = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOCALIZED_RESOURCES);
        List userLocalDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER_LOCAL_DIRS);
        HashSet<String> capabilities = new HashSet<String>(Arrays.asList(this.conf.getStrings("yarn.nodemanager.runtime.linux.docker.capabilities", YarnConfiguration.DEFAULT_NM_DOCKER_CONTAINER_CAPABILITIES)));
        DockerRunCommand runCommand = new DockerRunCommand(containerIdStr, runAsUser, imageName).detachOnRun().setContainerWorkDir(containerWorkDir.toString()).setNetworkType(network).setCapabilities(capabilities).addMountLocation("/sys/fs/cgroup", "/sys/fs/cgroup:ro", false);
        ArrayList<String> allDirs = new ArrayList<String>(containerLocalDirs);
        allDirs.addAll(filecacheDirs);
        allDirs.add(containerWorkDir.toString());
        allDirs.addAll(containerLogDirs);
        allDirs.addAll(userLocalDirs);
        for (String string : allDirs) {
            runCommand.addMountLocation(string, string, true);
        }
        if (environment.containsKey(ENV_DOCKER_CONTAINER_LOCAL_RESOURCE_MOUNTS) && !(mounts = (String)environment.get(ENV_DOCKER_CONTAINER_LOCAL_RESOURCE_MOUNTS)).isEmpty()) {
            for (String mount : StringUtils.split((String)mounts)) {
                String[] dir = StringUtils.split((String)mount, (char)':');
                if (dir.length != 2) {
                    throw new ContainerExecutionException("Invalid mount : " + mount);
                }
                String src = this.validateMount(dir[0], localizedResources);
                String dst = dir[1];
                runCommand.addMountLocation(src, dst + ":ro", true);
            }
        }
        if (this.allowPrivilegedContainerExecution(container)) {
            runCommand.setPrivileged();
        }
        String resourcesOpts = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RESOURCES_OPTIONS);
        this.addCGroupParentIfRequired(resourcesOpts, containerIdStr, runCommand);
        Path path = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_CONTAINER_SCRIPT_PATH);
        String disableOverride = (String)environment.get(ENV_DOCKER_CONTAINER_RUN_OVERRIDE_DISABLE);
        if (disableOverride != null && disableOverride.equals("true")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"command override disabled");
            }
        } else {
            ArrayList<String> overrideCommands = new ArrayList<String>();
            Path launchDst = new Path(containerWorkDir, ContainerLaunch.CONTAINER_SCRIPT);
            overrideCommands.add("bash");
            overrideCommands.add(launchDst.toUri().getPath());
            runCommand.setOverrideCommandWithArgs(overrideCommands);
        }
        String commandFile = this.dockerClient.writeCommandToTempFile(runCommand, containerIdStr);
        PrivilegedOperation launchOp = new PrivilegedOperation(PrivilegedOperation.OperationType.LAUNCH_DOCKER_CONTAINER);
        launchOp.appendArgs(runAsUser, ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.LAUNCH_DOCKER_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.APPID), containerIdStr, containerWorkDir.toString(), path.toUri().getPath(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_TOKENS_PATH).toUri().getPath(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID_FILE_PATH).toString(), StringUtils.join((char)'%', (Iterable)localDirs), StringUtils.join((char)'%', (Iterable)logDirs), commandFile, resourcesOpts);
        String tcCommandFile = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.TC_COMMAND_FILE);
        if (tcCommandFile != null) {
            launchOp.appendArgs(tcCommandFile);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Launching container with cmd: " + runCommand.getCommandWithArguments()));
        }
        try {
            this.privilegedOperationExecutor.executePrivilegedOperation(null, launchOp, null, container.getLaunchContext().getEnvironment(), false, false);
        }
        catch (PrivilegedOperationException e) {
            LOG.warn((Object)"Launch container failed. Exception: ", (Throwable)((Object)e));
            LOG.info((Object)("Docker command used: " + runCommand.getCommandWithArguments()));
            throw new ContainerExecutionException("Launch container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void signalContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        ContainerExecutor.Signal signal = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.SIGNAL);
        PrivilegedOperation privOp = null;
        if (ContainerExecutor.Signal.NULL.equals((Object)signal)) {
            privOp = new PrivilegedOperation(PrivilegedOperation.OperationType.SIGNAL_CONTAINER);
            privOp.appendArgs(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.SIGNAL_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID), Integer.toString(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.SIGNAL).getValue()));
        } else {
            String containerId = ctx.getContainer().getContainerId().toString();
            DockerStopCommand stopCommand = new DockerStopCommand(containerId);
            String commandFile = this.dockerClient.writeCommandToTempFile(stopCommand, containerId);
            privOp = new PrivilegedOperation(PrivilegedOperation.OperationType.RUN_DOCKER_CMD);
            privOp.appendArgs(commandFile);
        }
        privOp.disableFailureLogging();
        try {
            this.privilegedOperationExecutor.executePrivilegedOperation(null, privOp, null, container.getLaunchContext().getEnvironment(), false, false);
        }
        catch (PrivilegedOperationException e) {
            throw new ContainerExecutionException("Signal container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void reapContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
    }

    @Override
    public String[] getIpAndHost(Container container) {
        String containerId = container.getContainerId().toString();
        DockerInspectCommand inspectCommand = new DockerInspectCommand(containerId).getIpAndHost();
        try {
            String commandFile = this.dockerClient.writeCommandToTempFile(inspectCommand, containerId);
            PrivilegedOperation privOp = new PrivilegedOperation(PrivilegedOperation.OperationType.RUN_DOCKER_CMD);
            privOp.appendArgs(commandFile);
            String output = this.privilegedOperationExecutor.executePrivilegedOperation(null, privOp, null, container.getLaunchContext().getEnvironment(), true, false);
            LOG.info((Object)("Docker inspect output for " + containerId + ": " + output));
            int index = output.lastIndexOf(44);
            if (index == -1) {
                LOG.error((Object)"Incorrect format for ip and host");
                return null;
            }
            String ips = output.substring(0, index).trim();
            String host = output.substring(index + 1).trim();
            String[] ipAndHost = new String[]{ips, host};
            return ipAndHost;
        }
        catch (ContainerExecutionException e) {
            LOG.error((Object)"Error when writing command to temp file", (Throwable)((Object)e));
        }
        catch (PrivilegedOperationException e) {
            LOG.error((Object)"Error when executing command.", (Throwable)((Object)e));
        }
        return null;
    }
}

