/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.server.api.ContainerLogAggregationPolicy;
import org.apache.hadoop.yarn.server.api.ContainerLogContext;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation.AllContainerLogAggregationPolicy;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation.AppLogAggregator;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.Times;

public class AppLogAggregatorImpl
implements AppLogAggregator {
    private static final Log LOG = LogFactory.getLog(AppLogAggregatorImpl.class);
    private static final int THREAD_SLEEP_TIME = 1000;
    private static final String NM_LOG_AGGREGATION_NUM_LOG_FILES_SIZE_PER_APP = "yarn.nodemanager.log-aggregation.num-log-files-per-app";
    private static final int DEFAULT_NM_LOG_AGGREGATION_NUM_LOG_FILES_SIZE_PER_APP = 30;
    private static final String NM_LOG_AGGREGATION_DEBUG_ENABLED = "yarn.nodemanager.log-aggregation.debug-enabled";
    private final LocalDirsHandlerService dirsHandler;
    private final Dispatcher dispatcher;
    private final ApplicationId appId;
    private final String applicationId;
    private boolean logAggregationDisabled = false;
    private final Configuration conf;
    private final DeletionService delService;
    private final UserGroupInformation userUgi;
    private final Path remoteNodeLogFileForApp;
    private final Path remoteNodeTmpLogFileForApp;
    private final BlockingQueue<ContainerId> pendingContainers;
    private final AtomicBoolean appFinishing = new AtomicBoolean();
    private final AtomicBoolean appAggregationFinished = new AtomicBoolean();
    private final AtomicBoolean aborted = new AtomicBoolean();
    private final Map<ApplicationAccessType, String> appAcls;
    private final FileContext lfs;
    private final LogAggregationContext logAggregationContext;
    private final Context context;
    private final int retentionSize;
    private final long rollingMonitorInterval;
    private final boolean logAggregationInRolling;
    private final NodeId nodeId;
    private final AtomicBoolean waiting = new AtomicBoolean(false);
    private int logAggregationTimes = 0;
    private int cleanupOldLogTimes = 0;
    private boolean renameTemporaryLogFileFailed = false;
    private final Map<ContainerId, ContainerLogAggregator> containerLogAggregators = new HashMap<ContainerId, ContainerLogAggregator>();
    private final ContainerLogAggregationPolicy logAggPolicy;
    private final long recoveredLogInitedTime;

    public AppLogAggregatorImpl(Dispatcher dispatcher, DeletionService deletionService, Configuration conf, ApplicationId appId, UserGroupInformation userUgi, NodeId nodeId, LocalDirsHandlerService dirsHandler, Path remoteNodeLogFileForApp, Map<ApplicationAccessType, String> appAcls, LogAggregationContext logAggregationContext, Context context, FileContext lfs, long rollingMonitorInterval) {
        this(dispatcher, deletionService, conf, appId, userUgi, nodeId, dirsHandler, remoteNodeLogFileForApp, appAcls, logAggregationContext, context, lfs, rollingMonitorInterval, -1L);
    }

    public AppLogAggregatorImpl(Dispatcher dispatcher, DeletionService deletionService, Configuration conf, ApplicationId appId, UserGroupInformation userUgi, NodeId nodeId, LocalDirsHandlerService dirsHandler, Path remoteNodeLogFileForApp, Map<ApplicationAccessType, String> appAcls, LogAggregationContext logAggregationContext, Context context, FileContext lfs, long rollingMonitorInterval, long recoveredLogInitedTime) {
        this.dispatcher = dispatcher;
        this.conf = conf;
        this.delService = deletionService;
        this.appId = appId;
        this.applicationId = appId.toString();
        this.userUgi = userUgi;
        this.dirsHandler = dirsHandler;
        this.remoteNodeLogFileForApp = remoteNodeLogFileForApp;
        this.remoteNodeTmpLogFileForApp = this.getRemoteNodeTmpLogFileForApp();
        this.pendingContainers = new LinkedBlockingQueue<ContainerId>();
        this.appAcls = appAcls;
        this.lfs = lfs;
        this.logAggregationContext = logAggregationContext;
        this.context = context;
        this.nodeId = nodeId;
        int configuredRentionSize = conf.getInt(NM_LOG_AGGREGATION_NUM_LOG_FILES_SIZE_PER_APP, 30);
        this.retentionSize = configuredRentionSize <= 0 ? 30 : configuredRentionSize;
        this.rollingMonitorInterval = rollingMonitorInterval;
        this.logAggregationInRolling = this.rollingMonitorInterval > 0L && this.logAggregationContext != null && this.logAggregationContext.getRolledLogsIncludePattern() != null && !this.logAggregationContext.getRolledLogsIncludePattern().isEmpty();
        this.logAggPolicy = this.getLogAggPolicy(conf);
        this.recoveredLogInitedTime = recoveredLogInitedTime;
    }

    private ContainerLogAggregationPolicy getLogAggPolicy(Configuration conf) {
        ContainerLogAggregationPolicy policy = this.getLogAggPolicyInstance(conf);
        String params = this.getLogAggPolicyParameters(conf);
        if (params != null) {
            policy.parseParameters(params);
        }
        return policy;
    }

    private ContainerLogAggregationPolicy getLogAggPolicyInstance(Configuration conf) {
        String className;
        Class<ContainerLogAggregationPolicy> policyClass = null;
        if (this.logAggregationContext != null && (className = this.logAggregationContext.getLogAggregationPolicyClassName()) != null) {
            try {
                Class policyFromContext = conf.getClassByName(className);
                if (ContainerLogAggregationPolicy.class.isAssignableFrom(policyFromContext)) {
                    policyClass = policyFromContext.asSubclass(ContainerLogAggregationPolicy.class);
                } else {
                    LOG.warn((Object)(this.appId + " specified invalid log aggregation policy " + className));
                }
            }
            catch (ClassNotFoundException cnfe) {
                LOG.warn((Object)(this.appId + " specified invalid log aggregation policy " + className));
            }
        }
        if (policyClass == null) {
            policyClass = conf.getClass("yarn.nodemanager.log-aggregation.policy.class", AllContainerLogAggregationPolicy.class, ContainerLogAggregationPolicy.class);
        } else {
            LOG.info((Object)(this.appId + " specifies ContainerLogAggregationPolicy of " + policyClass));
        }
        return (ContainerLogAggregationPolicy)ReflectionUtils.newInstance((Class)policyClass, (Configuration)conf);
    }

    private String getLogAggPolicyParameters(Configuration conf) {
        String params = null;
        if (this.logAggregationContext != null) {
            params = this.logAggregationContext.getLogAggregationPolicyParameters();
        }
        if (params == null) {
            params = conf.get("yarn.nodemanager.log-aggregation.policy.parameters");
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadLogsForContainers(boolean appFinished) {
        LogAggregationStatus logAggregationStatus;
        boolean logAggregationSucceedInThisCycle;
        String diagnosticMessage;
        AggregatedLogFormat.LogWriter writer;
        HashSet finishedContainers;
        HashSet<ContainerId> pendingContainerInThisCycle;
        block27: {
            Credentials systemCredentials;
            if (this.logAggregationDisabled) {
                return;
            }
            if (UserGroupInformation.isSecurityEnabled() && (systemCredentials = this.context.getSystemCredentialsForApps().get(this.appId)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding new framework-token for " + this.appId + " for log-aggregation: " + systemCredentials.getAllTokens() + "; userUgi=" + this.userUgi));
                }
                this.userUgi.addCredentials(systemCredentials);
            }
            pendingContainerInThisCycle = new HashSet<ContainerId>();
            this.pendingContainers.drainTo(pendingContainerInThisCycle);
            finishedContainers = new HashSet(pendingContainerInThisCycle);
            if (this.context.getApplications().get(this.appId) != null) {
                for (Container container : ((Application)this.context.getApplications().get(this.appId)).getContainers().values()) {
                    ContainerType containerType = container.getContainerTokenIdentifier().getContainerType();
                    if (!this.shouldUploadLogs(new ContainerLogContext(container.getContainerId(), containerType, 0))) continue;
                    pendingContainerInThisCycle.add(container.getContainerId());
                }
            }
            writer = null;
            diagnosticMessage = "";
            logAggregationSucceedInThisCycle = true;
            if (!pendingContainerInThisCycle.isEmpty()) break block27;
            LogAggregationStatus logAggregationStatus2 = logAggregationSucceedInThisCycle ? LogAggregationStatus.RUNNING : LogAggregationStatus.RUNNING_WITH_FAILURE;
            this.sendLogAggregationReport(logAggregationStatus2, diagnosticMessage);
            if (appFinished) {
                LogAggregationStatus finalLogAggregationStatus = this.renameTemporaryLogFileFailed || !logAggregationSucceedInThisCycle ? LogAggregationStatus.FAILED : LogAggregationStatus.SUCCEEDED;
                this.sendLogAggregationReport(finalLogAggregationStatus, "");
            }
            if (writer != null) {
                writer.close();
            }
            return;
        }
        ++this.logAggregationTimes;
        try {
            writer = this.createLogWriter();
            writer.writeApplicationACLs(this.appAcls);
            writer.writeApplicationOwner(this.userUgi.getShortUserName());
        }
        catch (IOException e1) {
            logAggregationSucceedInThisCycle = false;
            LOG.error((Object)("Cannot create writer for app " + this.applicationId + ". Skip log upload this time. "), (Throwable)e1);
            LogAggregationStatus logAggregationStatus3 = logAggregationSucceedInThisCycle ? LogAggregationStatus.RUNNING : LogAggregationStatus.RUNNING_WITH_FAILURE;
            this.sendLogAggregationReport(logAggregationStatus3, diagnosticMessage);
            if (appFinished) {
                LogAggregationStatus finalLogAggregationStatus = this.renameTemporaryLogFileFailed || !logAggregationSucceedInThisCycle ? LogAggregationStatus.FAILED : LogAggregationStatus.SUCCEEDED;
                this.sendLogAggregationReport(finalLogAggregationStatus, "");
            }
            if (writer != null) {
                writer.close();
            }
            return;
        }
        try {
            boolean uploadedLogsInThisCycle = false;
            for (ContainerId container : pendingContainerInThisCycle) {
                ContainerLogAggregator aggregator = null;
                if (this.containerLogAggregators.containsKey(container)) {
                    aggregator = this.containerLogAggregators.get(container);
                } else {
                    aggregator = new ContainerLogAggregator(container);
                    this.containerLogAggregators.put(container, aggregator);
                }
                Set<Path> uploadedFilePathsInThisCycle = aggregator.doContainerLogAggregation(writer, appFinished, finishedContainers.contains(container));
                if (uploadedFilePathsInThisCycle.size() > 0) {
                    uploadedLogsInThisCycle = true;
                    this.delService.delete(this.userUgi.getShortUserName(), null, uploadedFilePathsInThisCycle.toArray(new Path[uploadedFilePathsInThisCycle.size()]));
                }
                if (!finishedContainers.contains(container)) continue;
                this.containerLogAggregators.remove(container);
            }
            if (uploadedLogsInThisCycle && this.logAggregationInRolling) {
                this.cleanOldLogs();
                ++this.cleanupOldLogTimes;
            }
            if (writer != null) {
                writer.close();
                writer = null;
            }
            long currentTime = System.currentTimeMillis();
            final Path renamedPath = this.rollingMonitorInterval <= 0L ? this.remoteNodeLogFileForApp : new Path(this.remoteNodeLogFileForApp.getParent(), this.remoteNodeLogFileForApp.getName() + "_" + currentTime);
            final boolean rename = uploadedLogsInThisCycle;
            try {
                this.userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        FileSystem remoteFS = AppLogAggregatorImpl.this.remoteNodeLogFileForApp.getFileSystem(AppLogAggregatorImpl.this.conf);
                        if (rename) {
                            remoteFS.rename(AppLogAggregatorImpl.this.remoteNodeTmpLogFileForApp, renamedPath);
                        } else {
                            remoteFS.delete(AppLogAggregatorImpl.this.remoteNodeTmpLogFileForApp, false);
                        }
                        return null;
                    }
                });
                diagnosticMessage = "Log uploaded successfully for Application: " + this.appId + " in NodeManager: " + LogAggregationUtils.getNodeString((NodeId)this.nodeId) + " at " + Times.format((long)currentTime) + "\n";
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to move temporary log file to final location: [" + this.remoteNodeTmpLogFileForApp + "] to [" + renamedPath + "]"), (Throwable)e);
                diagnosticMessage = "Log uploaded failed for Application: " + this.appId + " in NodeManager: " + LogAggregationUtils.getNodeString((NodeId)this.nodeId) + " at " + Times.format((long)currentTime) + "\n";
                this.renameTemporaryLogFileFailed = true;
                logAggregationSucceedInThisCycle = false;
            }
            logAggregationStatus = logAggregationSucceedInThisCycle ? LogAggregationStatus.RUNNING : LogAggregationStatus.RUNNING_WITH_FAILURE;
        }
        catch (Throwable throwable) {
            LogAggregationStatus logAggregationStatus4 = logAggregationSucceedInThisCycle ? LogAggregationStatus.RUNNING : LogAggregationStatus.RUNNING_WITH_FAILURE;
            this.sendLogAggregationReport(logAggregationStatus4, diagnosticMessage);
            if (appFinished) {
                LogAggregationStatus finalLogAggregationStatus = this.renameTemporaryLogFileFailed || !logAggregationSucceedInThisCycle ? LogAggregationStatus.FAILED : LogAggregationStatus.SUCCEEDED;
                this.sendLogAggregationReport(finalLogAggregationStatus, "");
            }
            if (writer != null) {
                writer.close();
            }
            throw throwable;
        }
        this.sendLogAggregationReport(logAggregationStatus, diagnosticMessage);
        if (appFinished) {
            LogAggregationStatus finalLogAggregationStatus = this.renameTemporaryLogFileFailed || !logAggregationSucceedInThisCycle ? LogAggregationStatus.FAILED : LogAggregationStatus.SUCCEEDED;
            this.sendLogAggregationReport(finalLogAggregationStatus, "");
        }
        if (writer != null) {
            writer.close();
        }
    }

    protected AggregatedLogFormat.LogWriter createLogWriter() throws IOException {
        return new AggregatedLogFormat.LogWriter(this.conf, this.remoteNodeTmpLogFileForApp, this.userUgi);
    }

    private void sendLogAggregationReport(LogAggregationStatus logAggregationStatus, String diagnosticMessage) {
        LogAggregationReport report = (LogAggregationReport)Records.newRecord(LogAggregationReport.class);
        report.setApplicationId(this.appId);
        report.setDiagnosticMessage(diagnosticMessage);
        report.setLogAggregationStatus(logAggregationStatus);
        this.context.getLogAggregationStatusForApps().add(report);
    }

    private void cleanOldLogs() {
        try {
            final FileSystem remoteFS = this.remoteNodeLogFileForApp.getFileSystem(this.conf);
            Path appDir = this.remoteNodeLogFileForApp.getParent().makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
            HashSet status = new HashSet(Arrays.asList(remoteFS.listStatus(appDir)));
            Iterable mask = Iterables.filter(status, (Predicate)new Predicate<FileStatus>(){

                public boolean apply(FileStatus next) {
                    return next.getPath().getName().contains(LogAggregationUtils.getNodeString((NodeId)AppLogAggregatorImpl.this.nodeId)) && !next.getPath().getName().endsWith(".tmp");
                }
            });
            status = Sets.newHashSet((Iterable)mask);
            if (status.size() >= this.retentionSize) {
                ArrayList statusList = new ArrayList(status);
                Collections.sort(statusList, new Comparator<FileStatus>(){

                    @Override
                    public int compare(FileStatus s1, FileStatus s2) {
                        return s1.getModificationTime() < s2.getModificationTime() ? -1 : (s1.getModificationTime() > s2.getModificationTime() ? 1 : 0);
                    }
                });
                for (int i = 0; i <= statusList.size() - this.retentionSize; ++i) {
                    final FileStatus remove = (FileStatus)statusList.get(i);
                    try {
                        this.userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                remoteFS.delete(remove.getPath(), false);
                                return null;
                            }
                        });
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to delete " + remove.getPath()), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to clean old logs", (Throwable)e);
        }
    }

    @Override
    public void run() {
        try {
            this.doAppLogAggregation();
        }
        catch (Exception e) {
            LOG.error((Object)("Error occured while aggregating the log for the application " + this.appId), (Throwable)e);
            this.doAppLogAggregationPostCleanUp();
        }
        finally {
            if (!this.appAggregationFinished.get()) {
                LOG.warn((Object)("Aggregation did not complete for application " + this.appId));
                this.dispatcher.getEventHandler().handle((Event)new ApplicationEvent(this.appId, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED));
            }
            this.appAggregationFinished.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAppLogAggregation() {
        while (!this.appFinishing.get() && !this.aborted.get()) {
            AppLogAggregatorImpl appLogAggregatorImpl = this;
            synchronized (appLogAggregatorImpl) {
                try {
                    this.waiting.set(true);
                    if (this.logAggregationInRolling) {
                        this.wait(this.rollingMonitorInterval * 1000L);
                        if (this.appFinishing.get() || this.aborted.get()) {
                            break;
                        }
                        this.uploadLogsForContainers(false);
                    } else {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"PendingContainers queue is interrupted");
                    this.appFinishing.set(true);
                }
            }
        }
        if (this.aborted.get()) {
            return;
        }
        this.uploadLogsForContainers(true);
        this.doAppLogAggregationPostCleanUp();
        this.dispatcher.getEventHandler().handle((Event)new ApplicationEvent(this.appId, ApplicationEventType.APPLICATION_LOG_HANDLING_FINISHED));
        this.appAggregationFinished.set(true);
    }

    private void doAppLogAggregationPostCleanUp() {
        ArrayList<Path> localAppLogDirs = new ArrayList<Path>();
        for (String rootLogDir : this.dirsHandler.getLogDirsForCleanup()) {
            Path logPath = new Path(rootLogDir, this.applicationId);
            try {
                this.lfs.getFileStatus(logPath);
                localAppLogDirs.add(logPath);
            }
            catch (UnsupportedFileSystemException ue) {
                LOG.warn((Object)("Log dir " + rootLogDir + "is an unsupported file system"), (Throwable)ue);
            }
            catch (IOException fe) {}
        }
        if (localAppLogDirs.size() > 0) {
            this.delService.delete(this.userUgi.getShortUserName(), null, localAppLogDirs.toArray(new Path[localAppLogDirs.size()]));
        }
    }

    private Path getRemoteNodeTmpLogFileForApp() {
        return new Path(this.remoteNodeLogFileForApp.getParent(), this.remoteNodeLogFileForApp.getName() + ".tmp");
    }

    private boolean shouldUploadLogs(ContainerLogContext logContext) {
        return this.logAggPolicy.shouldDoLogAggregation(logContext);
    }

    @Override
    public void startContainerLogAggregation(ContainerLogContext logContext) {
        if (this.shouldUploadLogs(logContext)) {
            LOG.info((Object)("Considering container " + logContext.getContainerId() + " for log-aggregation"));
            this.pendingContainers.add(logContext.getContainerId());
        }
    }

    @Override
    public synchronized void finishLogAggregation() {
        LOG.info((Object)("Application just finished : " + this.applicationId));
        this.appFinishing.set(true);
        this.notifyAll();
    }

    @Override
    public synchronized void abortLogAggregation() {
        LOG.info((Object)("Aborting log aggregation for " + this.applicationId));
        this.aborted.set(true);
        this.notifyAll();
    }

    @Override
    public void disableLogAggregation() {
        this.logAggregationDisabled = true;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized void doLogAggregationOutOfBand() {
        while (!this.waiting.get()) {
            try {
                this.wait(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        LOG.info((Object)"Do OutOfBand log aggregation");
        this.notifyAll();
    }

    @VisibleForTesting
    public UserGroupInformation getUgi() {
        return this.userUgi;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public int getLogAggregationTimes() {
        return this.logAggregationTimes;
    }

    @VisibleForTesting
    int getCleanupOldLogTimes() {
        return this.cleanupOldLogTimes;
    }

    class ContainerLogAggregator {
        private final AggregatedLogFormat.LogRetentionContext retentionContext;
        private final ContainerId containerId;
        private Set<String> uploadedFileMeta = new HashSet<String>();

        public ContainerLogAggregator(ContainerId containerId) {
            this.containerId = containerId;
            this.retentionContext = this.getRetentionContext();
        }

        private AggregatedLogFormat.LogRetentionContext getRetentionContext() {
            long logRetentionSecs = AppLogAggregatorImpl.this.conf.getLong("yarn.log-aggregation.retain-seconds", -1L);
            return new AggregatedLogFormat.LogRetentionContext(AppLogAggregatorImpl.this.recoveredLogInitedTime, logRetentionSecs * 1000L);
        }

        public Set<Path> doContainerLogAggregation(AggregatedLogFormat.LogWriter writer, boolean appFinished, boolean containerFinished) {
            LOG.info((Object)("Uploading logs for container " + this.containerId + ". Current good log dirs are " + StringUtils.join((CharSequence)",", AppLogAggregatorImpl.this.dirsHandler.getLogDirsForRead())));
            AggregatedLogFormat.LogKey logKey = new AggregatedLogFormat.LogKey(this.containerId);
            final AggregatedLogFormat.LogValue logValue = new AggregatedLogFormat.LogValue(AppLogAggregatorImpl.this.dirsHandler.getLogDirsForRead(), this.containerId, AppLogAggregatorImpl.this.userUgi.getShortUserName(), AppLogAggregatorImpl.this.logAggregationContext, this.uploadedFileMeta, this.retentionContext, appFinished, containerFinished);
            try {
                writer.append(logKey, logValue);
            }
            catch (Exception e) {
                LOG.error((Object)("Couldn't upload logs for " + this.containerId + ". Skipping this container."), (Throwable)e);
                return new HashSet<Path>();
            }
            this.uploadedFileMeta.addAll(logValue.getCurrentUpLoadedFileMeta());
            Iterable mask = Iterables.filter(this.uploadedFileMeta, (Predicate)new Predicate<String>(){

                public boolean apply(String next) {
                    return logValue.getAllExistingFilesMeta().contains(next);
                }
            });
            this.uploadedFileMeta = Sets.newHashSet((Iterable)mask);
            return Sets.union((Set)logValue.getCurrentUpLoadedFilesPath(), (Set)logValue.getObseleteRetentionLogFiles());
        }
    }
}

