/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ChangeMonitoringContainerResourceEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainerStartMonitoringEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorEventType;
import org.apache.hadoop.yarn.server.nodemanager.timelineservice.NMTimelinePublisher;
import org.apache.hadoop.yarn.server.nodemanager.util.NodeManagerHardwareUtils;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;

public class ContainersMonitorImpl
extends AbstractService
implements ContainersMonitor {
    static final Log LOG = LogFactory.getLog(ContainersMonitorImpl.class);
    private long monitoringInterval;
    private MonitoringThread monitoringThread;
    private boolean containerMetricsEnabled;
    private long containerMetricsPeriodMs;
    private long containerMetricsUnregisterDelayMs;
    @VisibleForTesting
    final Map<ContainerId, ProcessTreeInfo> trackingContainers = new ConcurrentHashMap<ContainerId, ProcessTreeInfo>();
    private final ContainerExecutor containerExecutor;
    private final Dispatcher eventDispatcher;
    protected final Context context;
    private ResourceCalculatorPlugin resourceCalculatorPlugin;
    private Configuration conf;
    private static float vmemRatio;
    private Class<? extends ResourceCalculatorProcessTree> processTreeClass;
    private long maxVmemAllottedForContainers = -1L;
    private long maxPmemAllottedForContainers = -1L;
    private boolean pmemCheckEnabled;
    private boolean vmemCheckEnabled;
    private boolean containersMonitorEnabled;
    private long maxVCoresAllottedForContainers;
    private static final long UNKNOWN_MEMORY_LIMIT = -1L;
    private int nodeCpuPercentageForYARN;
    private ResourceUtilization containersUtilization;
    private ResourceUtilization containersAllocation;
    private volatile boolean stopped = false;

    public ContainersMonitorImpl(ContainerExecutor exec, AsyncDispatcher dispatcher, Context context) {
        super("containers-monitor");
        this.containerExecutor = exec;
        this.eventDispatcher = dispatcher;
        this.context = context;
        this.monitoringThread = new MonitoringThread();
        this.containersUtilization = ResourceUtilization.newInstance((int)0, (int)0, (float)0.0f);
        this.containersAllocation = ResourceUtilization.newInstance((int)0, (int)0, (float)0.0f);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.monitoringInterval = conf.getLong("yarn.nodemanager.container-monitor.interval-ms", conf.getLong("yarn.nodemanager.resource-monitor.interval-ms", 3000L));
        Class clazz = conf.getClass("yarn.nodemanager.container-monitor.resource-calculator.class", conf.getClass("yarn.nodemanager.resource-calculator.class", null, ResourceCalculatorPlugin.class), ResourceCalculatorPlugin.class);
        this.resourceCalculatorPlugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin((Class)clazz, (Configuration)conf);
        LOG.info((Object)(" Using ResourceCalculatorPlugin : " + this.resourceCalculatorPlugin));
        this.processTreeClass = conf.getClass("yarn.nodemanager.container-monitor.process-tree.class", null, ResourceCalculatorProcessTree.class);
        this.conf = conf;
        LOG.info((Object)(" Using ResourceCalculatorProcessTree : " + this.processTreeClass));
        this.containerMetricsEnabled = conf.getBoolean("yarn.nodemanager.container-metrics.enable", true);
        this.containerMetricsPeriodMs = conf.getLong("yarn.nodemanager.container-metrics.period-ms", -1L);
        this.containerMetricsUnregisterDelayMs = conf.getLong("yarn.nodemanager.container-metrics.unregister-delay-ms", 10000L);
        long configuredPMemForContainers = (long)(NodeManagerHardwareUtils.getContainerMemoryMB(this.resourceCalculatorPlugin, conf) * 1024) * 1024L;
        long configuredVCoresForContainers = NodeManagerHardwareUtils.getVCores(this.resourceCalculatorPlugin, conf);
        this.maxPmemAllottedForContainers = configuredPMemForContainers;
        this.maxVCoresAllottedForContainers = configuredVCoresForContainers;
        vmemRatio = conf.getFloat("yarn.nodemanager.vmem-pmem-ratio", 2.1f);
        Preconditions.checkArgument((vmemRatio > 0.99f ? 1 : 0) != 0, (Object)"yarn.nodemanager.vmem-pmem-ratio should be at least 1.0");
        this.maxVmemAllottedForContainers = (long)(vmemRatio * (float)configuredPMemForContainers);
        this.pmemCheckEnabled = conf.getBoolean("yarn.nodemanager.pmem-check-enabled", true);
        this.vmemCheckEnabled = conf.getBoolean("yarn.nodemanager.vmem-check-enabled", true);
        LOG.info((Object)("Physical memory check enabled: " + this.pmemCheckEnabled));
        LOG.info((Object)("Virtual memory check enabled: " + this.vmemCheckEnabled));
        this.containersMonitorEnabled = this.isEnabled();
        LOG.info((Object)("ContainersMonitor enabled: " + this.containersMonitorEnabled));
        this.nodeCpuPercentageForYARN = NodeManagerHardwareUtils.getNodeCpuPercentage(conf);
        if (this.pmemCheckEnabled) {
            long totalPhysicalMemoryOnNM = -1L;
            if (this.resourceCalculatorPlugin != null && (totalPhysicalMemoryOnNM = this.resourceCalculatorPlugin.getPhysicalMemorySize()) <= 0L) {
                LOG.warn((Object)"NodeManager's totalPmem could not be calculated. Setting it to -1");
                totalPhysicalMemoryOnNM = -1L;
            }
            if (totalPhysicalMemoryOnNM != -1L && (float)this.maxPmemAllottedForContainers > (float)totalPhysicalMemoryOnNM * 0.8f) {
                LOG.warn((Object)("NodeManager configured with " + StringUtils.TraditionalBinaryPrefix.long2String((long)this.maxPmemAllottedForContainers, (String)"", (int)1) + " physical memory allocated to containers, which is more than 80% of the total physical memory available (" + StringUtils.TraditionalBinaryPrefix.long2String((long)totalPhysicalMemoryOnNM, (String)"", (int)1) + "). Thrashing might happen."));
            }
        }
        super.serviceInit(conf);
    }

    private boolean isEnabled() {
        if (this.resourceCalculatorPlugin == null) {
            LOG.info((Object)("ResourceCalculatorPlugin is unavailable on this system. " + this.getClass().getName() + " is disabled."));
            return false;
        }
        if (ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)"0", this.processTreeClass, (Configuration)this.conf) == null) {
            LOG.info((Object)("ResourceCalculatorProcessTree is unavailable on this system. " + this.getClass().getName() + " is disabled."));
            return false;
        }
        if (!this.isPmemCheckEnabled() && !this.isVmemCheckEnabled()) {
            LOG.info((Object)"Neither virutal-memory nor physical-memory monitoring is needed. Not running the monitor-thread");
            return false;
        }
        return true;
    }

    protected void serviceStart() throws Exception {
        if (this.containersMonitorEnabled) {
            this.monitoringThread.start();
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.containersMonitorEnabled) {
            this.stopped = true;
            this.monitoringThread.interrupt();
            try {
                this.monitoringThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        super.serviceStop();
    }

    boolean isProcessTreeOverLimit(String containerId, long currentMemUsage, long curMemUsageOfAgedProcesses, long vmemLimit) {
        boolean isOverLimit = false;
        if (currentMemUsage > 2L * vmemLimit) {
            LOG.warn((Object)("Process tree for container: " + containerId + " running over twice the configured limit. Limit=" + vmemLimit + ", current usage = " + currentMemUsage));
            isOverLimit = true;
        } else if (curMemUsageOfAgedProcesses > vmemLimit) {
            LOG.warn((Object)("Process tree for container: " + containerId + " has processes older than 1 iteration running over the configured limit. Limit=" + vmemLimit + ", current usage = " + curMemUsageOfAgedProcesses));
            isOverLimit = true;
        }
        return isOverLimit;
    }

    boolean isProcessTreeOverLimit(ResourceCalculatorProcessTree pTree, String containerId, long limit) {
        long currentMemUsage = pTree.getVirtualMemorySize();
        long curMemUsageOfAgedProcesses = pTree.getVirtualMemorySize(1);
        return this.isProcessTreeOverLimit(containerId, currentMemUsage, curMemUsageOfAgedProcesses, limit);
    }

    private void changeContainerResource(ContainerId containerId, Resource resource) {
        Container container = (Container)this.context.getContainers().get(containerId);
        if (container == null) {
            LOG.warn((Object)("Container " + containerId.toString() + "does not exist"));
            return;
        }
        container.setResource(resource);
    }

    private void updateContainerMetrics(ContainersMonitorEvent monitoringEvent) {
        if (!this.containerMetricsEnabled || monitoringEvent == null) {
            return;
        }
        ContainerId containerId = monitoringEvent.getContainerId();
        switch ((ContainersMonitorEventType)monitoringEvent.getType()) {
            case START_MONITORING_CONTAINER: {
                ContainerMetrics usageMetrics = ContainerMetrics.forContainer(containerId, this.containerMetricsPeriodMs, this.containerMetricsUnregisterDelayMs);
                ContainerStartMonitoringEvent startEvent = (ContainerStartMonitoringEvent)monitoringEvent;
                usageMetrics.recordStateChangeDurations(startEvent.getLaunchDuration(), startEvent.getLocalizationDuration());
                int cpuVcores = startEvent.getCpuVcores();
                int vmemLimitMBs = (int)(startEvent.getVmemLimit() >> 20);
                int pmemLimitMBs = (int)(startEvent.getPmemLimit() >> 20);
                usageMetrics.recordResourceLimit(vmemLimitMBs, pmemLimitMBs, cpuVcores);
                break;
            }
            case STOP_MONITORING_CONTAINER: {
                ContainerMetrics usageMetrics = ContainerMetrics.getContainerMetrics(containerId);
                if (usageMetrics == null) break;
                usageMetrics.finished();
                break;
            }
            case CHANGE_MONITORING_CONTAINER_RESOURCE: {
                ContainerMetrics usageMetrics = ContainerMetrics.forContainer(containerId, this.containerMetricsPeriodMs, this.containerMetricsUnregisterDelayMs);
                ChangeMonitoringContainerResourceEvent changeEvent = (ChangeMonitoringContainerResourceEvent)monitoringEvent;
                Resource resource = changeEvent.getResource();
                int pmemLimitMBs = (int)resource.getMemorySize();
                int vmemLimitMBs = (int)((float)pmemLimitMBs * vmemRatio);
                int cpuVcores = resource.getVirtualCores();
                usageMetrics.recordResourceLimit(vmemLimitMBs, pmemLimitMBs, cpuVcores);
                break;
            }
        }
    }

    @Override
    public long getVmemAllocatedForContainers() {
        return this.maxVmemAllottedForContainers;
    }

    @Override
    public boolean isPmemCheckEnabled() {
        return this.pmemCheckEnabled;
    }

    @Override
    public long getPmemAllocatedForContainers() {
        return this.maxPmemAllottedForContainers;
    }

    @Override
    public long getVCoresAllocatedForContainers() {
        return this.maxVCoresAllottedForContainers;
    }

    @Override
    public boolean isVmemCheckEnabled() {
        return this.vmemCheckEnabled;
    }

    @Override
    public ResourceUtilization getContainersUtilization() {
        return this.containersUtilization;
    }

    public void setContainersUtilization(ResourceUtilization utilization) {
        this.containersUtilization = utilization;
    }

    @Override
    public ResourceUtilization getContainersAllocation() {
        return this.containersAllocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResourcesAvailable(ProcessTreeInfo pti) {
        ResourceUtilization resourceUtilization = this.containersAllocation;
        synchronized (resourceUtilization) {
            if (this.containersAllocation.getPhysicalMemory() + (int)(pti.getPmemLimit() >> 20) > (int)(this.getPmemAllocatedForContainers() >> 20)) {
                return false;
            }
            if (this.isVmemCheckEnabled() && this.containersAllocation.getVirtualMemory() + (int)(pti.getVmemLimit() >> 20) > (int)(this.getVmemAllocatedForContainers() >> 20)) {
                return false;
            }
            if (this.containersAllocation.getCPU() + this.allocatedCpuUsage(pti) > 1.0f) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increaseContainersAllocation(ProcessTreeInfo pti) {
        ResourceUtilization resourceUtilization = this.containersAllocation;
        synchronized (resourceUtilization) {
            this.increaseResourceUtilization(this.containersAllocation, pti);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decreaseContainersAllocation(ProcessTreeInfo pti) {
        ResourceUtilization resourceUtilization = this.containersAllocation;
        synchronized (resourceUtilization) {
            this.decreaseResourceUtilization(this.containersAllocation, pti);
        }
    }

    @Override
    public void increaseResourceUtilization(ResourceUtilization resourceUtil, ProcessTreeInfo pti) {
        resourceUtil.addTo((int)(pti.getPmemLimit() >> 20), (int)(pti.getVmemLimit() >> 20), this.allocatedCpuUsage(pti));
    }

    @Override
    public void decreaseResourceUtilization(ResourceUtilization resourceUtil, ProcessTreeInfo pti) {
        resourceUtil.subtractFrom((int)(pti.getPmemLimit() >> 20), (int)(pti.getVmemLimit() >> 20), this.allocatedCpuUsage(pti));
    }

    @Override
    public void subtractNodeResourcesFromResourceUtilization(ResourceUtilization resourceUtil) {
        resourceUtil.subtractFrom((int)(this.getPmemAllocatedForContainers() >> 20), (int)(this.getVmemAllocatedForContainers() >> 20), 1.0f);
    }

    private float allocatedCpuUsage(ProcessTreeInfo pti) {
        return (float)pti.getCpuVcores() / (float)this.getVCoresAllocatedForContainers();
    }

    public void handle(ContainersMonitorEvent monitoringEvent) {
        ContainerId containerId = monitoringEvent.getContainerId();
        if (!this.containersMonitorEnabled) {
            if (monitoringEvent.getType() == ContainersMonitorEventType.CHANGE_MONITORING_CONTAINER_RESOURCE) {
                ChangeMonitoringContainerResourceEvent changeEvent = (ChangeMonitoringContainerResourceEvent)monitoringEvent;
                this.changeContainerResource(containerId, changeEvent.getResource());
            }
            return;
        }
        switch ((ContainersMonitorEventType)monitoringEvent.getType()) {
            case START_MONITORING_CONTAINER: {
                this.onStartMonitoringContainer(monitoringEvent, containerId);
                break;
            }
            case STOP_MONITORING_CONTAINER: {
                this.onStopMonitoringContainer(monitoringEvent, containerId);
                break;
            }
            case CHANGE_MONITORING_CONTAINER_RESOURCE: {
                this.onChangeMonitoringContainerResource(monitoringEvent, containerId);
                break;
            }
        }
    }

    protected void onChangeMonitoringContainerResource(ContainersMonitorEvent monitoringEvent, ContainerId containerId) {
        ChangeMonitoringContainerResourceEvent changeEvent = (ChangeMonitoringContainerResourceEvent)monitoringEvent;
        ProcessTreeInfo processTreeInfo = this.trackingContainers.get(containerId);
        if (processTreeInfo == null) {
            LOG.warn((Object)("Failed to track container " + containerId.toString() + ". It may have already completed."));
            return;
        }
        LOG.info((Object)("Changing resource-monitoring for " + containerId));
        this.updateContainerMetrics(monitoringEvent);
        long pmemLimit = changeEvent.getResource().getMemorySize() * 1024L * 1024L;
        long vmemLimit = (long)((float)pmemLimit * vmemRatio);
        int cpuVcores = changeEvent.getResource().getVirtualCores();
        processTreeInfo.setResourceLimit(pmemLimit, vmemLimit, cpuVcores);
        this.changeContainerResource(containerId, changeEvent.getResource());
    }

    protected void onStopMonitoringContainer(ContainersMonitorEvent monitoringEvent, ContainerId containerId) {
        LOG.info((Object)("Stopping resource-monitoring for " + containerId));
        this.updateContainerMetrics(monitoringEvent);
        this.trackingContainers.remove(containerId);
    }

    protected void onStartMonitoringContainer(ContainersMonitorEvent monitoringEvent, ContainerId containerId) {
        ContainerStartMonitoringEvent startEvent = (ContainerStartMonitoringEvent)monitoringEvent;
        LOG.info((Object)("Starting resource-monitoring for " + containerId));
        this.updateContainerMetrics(monitoringEvent);
        this.trackingContainers.put(containerId, new ProcessTreeInfo(containerId, null, null, startEvent.getVmemLimit(), startEvent.getPmemLimit(), startEvent.getCpuVcores()));
    }

    private class MonitoringThread
    extends Thread {
        public MonitoringThread() {
            super("Container Monitor");
        }

        @Override
        public void run() {
            while (!ContainersMonitorImpl.this.stopped && !Thread.currentThread().isInterrupted()) {
                if (LOG.isDebugEnabled()) {
                    StringBuilder tmp = new StringBuilder("[ ");
                    for (ProcessTreeInfo p : ContainersMonitorImpl.this.trackingContainers.values()) {
                        tmp.append(p.getPID());
                        tmp.append(" ");
                    }
                    LOG.debug((Object)("Current ProcessTree list : " + tmp.substring(0, tmp.length()) + "]"));
                }
                ResourceUtilization trackedContainersUtilization = ResourceUtilization.newInstance((int)0, (int)0, (float)0.0f);
                long vmemUsageByAllContainers = 0L;
                long pmemByAllContainers = 0L;
                long cpuUsagePercentPerCoreByAllContainers = 0L;
                long cpuUsageTotalCoresByAllContainers = 0L;
                for (Map.Entry<ContainerId, ProcessTreeInfo> entry : ContainersMonitorImpl.this.trackingContainers.entrySet()) {
                    ContainerId containerId = entry.getKey();
                    ProcessTreeInfo ptInfo = entry.getValue();
                    try {
                        ContainerImpl container;
                        NMTimelinePublisher nmMetricsPublisher;
                        String pId = ptInfo.getPID();
                        if (pId == null && (pId = ContainersMonitorImpl.this.containerExecutor.getProcessId(ptInfo.getContainerId())) != null) {
                            LOG.debug((Object)("Tracking ProcessTree " + pId + " for the first time"));
                            ResourceCalculatorProcessTree pt = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)pId, (Class)ContainersMonitorImpl.this.processTreeClass, (Configuration)ContainersMonitorImpl.this.conf);
                            ptInfo.setPid(pId);
                            ptInfo.setProcessTree(pt);
                            if (ContainersMonitorImpl.this.containerMetricsEnabled) {
                                ContainerMetrics usageMetrics = ContainerMetrics.forContainer(containerId, ContainersMonitorImpl.this.containerMetricsPeriodMs, ContainersMonitorImpl.this.containerMetricsUnregisterDelayMs);
                                usageMetrics.recordProcessId(pId);
                            }
                            Container container2 = (Container)ContainersMonitorImpl.this.context.getContainers().get(containerId);
                            Object[] ipAndHost = ContainersMonitorImpl.this.containerExecutor.getIpAndHost(container2);
                            if (ipAndHost != null && ipAndHost[0] != null && ipAndHost[1] != null) {
                                container2.setIpAndHost((String[])ipAndHost);
                                LOG.info((Object)(containerId + "'s ip = " + (String)ipAndHost[0] + ", and hostname = " + (String)ipAndHost[1]));
                            } else {
                                LOG.info((Object)("Can not get both ip and hostname: " + Arrays.toString(ipAndHost)));
                            }
                        }
                        if (pId == null) continue;
                        LOG.debug((Object)("Constructing ProcessTree for : PID = " + pId + " ContainerId = " + containerId));
                        ResourceCalculatorProcessTree pTree = ptInfo.getProcessTree();
                        pTree.updateProcessTree();
                        long currentVmemUsage = pTree.getVirtualMemorySize();
                        long currentPmemUsage = pTree.getRssMemorySize();
                        float cpuUsagePercentPerCore = pTree.getCpuUsagePercent();
                        if (cpuUsagePercentPerCore < 0.0f) {
                            LOG.info((Object)("Skipping monitoring container " + containerId + " since CPU usage is not yet available."));
                            continue;
                        }
                        float cpuUsageTotalCoresPercentage = cpuUsagePercentPerCore / (float)ContainersMonitorImpl.this.resourceCalculatorPlugin.getNumProcessors();
                        int milliVcoresUsed = (int)(cpuUsageTotalCoresPercentage * 1000.0f * (float)ContainersMonitorImpl.this.maxVCoresAllottedForContainers / (float)ContainersMonitorImpl.this.nodeCpuPercentageForYARN);
                        long curMemUsageOfAgedProcesses = pTree.getVirtualMemorySize(1);
                        long curRssMemUsageOfAgedProcesses = pTree.getRssMemorySize(1);
                        long vmemLimit = ptInfo.getVmemLimit();
                        long pmemLimit = ptInfo.getPmemLimit();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(String.format("Memory usage of ProcessTree %s for container-id %s: ", pId, containerId.toString()) + this.formatUsageString(currentVmemUsage, vmemLimit, currentPmemUsage, pmemLimit)));
                        }
                        trackedContainersUtilization.addTo((int)(currentPmemUsage >> 20), (int)(currentVmemUsage >> 20), (float)milliVcoresUsed / 1000.0f);
                        if (ContainersMonitorImpl.this.containerMetricsEnabled) {
                            ContainerMetrics.forContainer(containerId, ContainersMonitorImpl.this.containerMetricsPeriodMs, ContainersMonitorImpl.this.containerMetricsUnregisterDelayMs).recordMemoryUsage((int)(currentPmemUsage >> 20));
                            ContainerMetrics.forContainer(containerId, ContainersMonitorImpl.this.containerMetricsPeriodMs, ContainersMonitorImpl.this.containerMetricsUnregisterDelayMs).recordCpuUsage((int)cpuUsagePercentPerCore, milliVcoresUsed);
                        }
                        boolean isMemoryOverLimit = false;
                        String msg = "";
                        int containerExitStatus = -1000;
                        if (ContainersMonitorImpl.this.isVmemCheckEnabled() && ContainersMonitorImpl.this.isProcessTreeOverLimit(containerId.toString(), currentVmemUsage, curMemUsageOfAgedProcesses, vmemLimit)) {
                            msg = this.formatErrorMessage("virtual", currentVmemUsage, vmemLimit, currentPmemUsage, pmemLimit, pId, containerId, pTree);
                            isMemoryOverLimit = true;
                            containerExitStatus = -103;
                        } else if (ContainersMonitorImpl.this.isPmemCheckEnabled() && ContainersMonitorImpl.this.isProcessTreeOverLimit(containerId.toString(), currentPmemUsage, curRssMemUsageOfAgedProcesses, pmemLimit)) {
                            msg = this.formatErrorMessage("physical", currentVmemUsage, vmemLimit, currentPmemUsage, pmemLimit, pId, containerId, pTree);
                            isMemoryOverLimit = true;
                            containerExitStatus = -104;
                        }
                        vmemUsageByAllContainers += currentVmemUsage;
                        pmemByAllContainers += currentPmemUsage;
                        cpuUsagePercentPerCoreByAllContainers = (long)((float)cpuUsagePercentPerCoreByAllContainers + cpuUsagePercentPerCore);
                        cpuUsageTotalCoresByAllContainers = (long)((float)cpuUsageTotalCoresByAllContainers + cpuUsagePercentPerCore);
                        if (isMemoryOverLimit) {
                            LOG.warn((Object)msg);
                            if (!pTree.checkPidPgrpidForMatch()) {
                                LOG.error((Object)("Killed container process with PID " + pId + " but it is not a process group leader."));
                            }
                            ContainersMonitorImpl.this.eventDispatcher.getEventHandler().handle((Event)new ContainerKillEvent(containerId, containerExitStatus, msg));
                            ContainersMonitorImpl.this.trackingContainers.remove(containerId);
                            LOG.info((Object)("Removed ProcessTree with root " + pId));
                        }
                        if ((nmMetricsPublisher = (container = (ContainerImpl)ContainersMonitorImpl.this.context.getContainers().get(containerId)).getNMTimelinePublisher()) == null) continue;
                        nmMetricsPublisher.reportContainerResourceUsage(container, currentPmemUsage, Float.valueOf(cpuUsagePercentPerCore));
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Uncaught exception in ContainersMonitorImpl while monitoring resource of " + containerId), (Throwable)e);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Total Resource Usage stats in NM by all containers : Virtual Memory= " + vmemUsageByAllContainers + ", Physical Memory= " + pmemByAllContainers + ", Total CPU usage= " + cpuUsageTotalCoresByAllContainers + ", Total CPU(% per core) usage" + cpuUsagePercentPerCoreByAllContainers));
                }
                ContainersMonitorImpl.this.setContainersUtilization(trackedContainersUtilization);
                try {
                    Thread.sleep(ContainersMonitorImpl.this.monitoringInterval);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)(ContainersMonitorImpl.class.getName() + " is interrupted. Exiting."));
                    break;
                }
            }
        }

        private String formatErrorMessage(String memTypeExceeded, long currentVmemUsage, long vmemLimit, long currentPmemUsage, long pmemLimit, String pId, ContainerId containerId, ResourceCalculatorProcessTree pTree) {
            return String.format("Container [pid=%s,containerID=%s] is running beyond %s memory limits. ", pId, containerId, memTypeExceeded) + "Current usage: " + this.formatUsageString(currentVmemUsage, vmemLimit, currentPmemUsage, pmemLimit) + ". Killing container.\nDump of the process-tree for " + containerId + " :\n" + pTree.getProcessTreeDump();
        }

        private String formatUsageString(long currentVmemUsage, long vmemLimit, long currentPmemUsage, long pmemLimit) {
            return String.format("%sB of %sB physical memory used; %sB of %sB virtual memory used", StringUtils.TraditionalBinaryPrefix.long2String((long)currentPmemUsage, (String)"", (int)1), StringUtils.TraditionalBinaryPrefix.long2String((long)pmemLimit, (String)"", (int)1), StringUtils.TraditionalBinaryPrefix.long2String((long)currentVmemUsage, (String)"", (int)1), StringUtils.TraditionalBinaryPrefix.long2String((long)vmemLimit, (String)"", (int)1));
        }
    }

    public static class ProcessTreeInfo {
        private ContainerId containerId;
        private String pid;
        private ResourceCalculatorProcessTree pTree;
        private long vmemLimit;
        private long pmemLimit;
        private int cpuVcores;

        public ProcessTreeInfo(ContainerId containerId, String pid, ResourceCalculatorProcessTree pTree, long vmemLimit, long pmemLimit, int cpuVcores) {
            this.containerId = containerId;
            this.pid = pid;
            this.pTree = pTree;
            this.vmemLimit = vmemLimit;
            this.pmemLimit = pmemLimit;
            this.cpuVcores = cpuVcores;
        }

        public ContainerId getContainerId() {
            return this.containerId;
        }

        public String getPID() {
            return this.pid;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }

        public ResourceCalculatorProcessTree getProcessTree() {
            return this.pTree;
        }

        public void setProcessTree(ResourceCalculatorProcessTree pTree) {
            this.pTree = pTree;
        }

        public synchronized long getVmemLimit() {
            return this.vmemLimit;
        }

        public synchronized long getPmemLimit() {
            return this.pmemLimit;
        }

        public synchronized int getCpuVcores() {
            return this.cpuVcores;
        }

        public synchronized void setResourceLimit(long pmemLimit, long vmemLimit, int cpuVcores) {
            this.pmemLimit = pmemLimit;
            this.vmemLimit = vmemLimit;
            this.cpuVcores = cpuVcores;
        }
    }

    @InterfaceAudience.Private
    public static enum ContainerMetric {
        CPU,
        MEMORY;

    }
}

