/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.queuing;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.records.ContainerQueuingLimit;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuingContainerManagerImpl
extends ContainerManagerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(QueuingContainerManagerImpl.class);
    private ConcurrentMap<ContainerId, AllocatedContainerInfo> allocatedGuaranteedContainers = new ConcurrentHashMap<ContainerId, AllocatedContainerInfo>();
    private ConcurrentMap<ContainerId, AllocatedContainerInfo> allocatedOpportunisticContainers = new ConcurrentHashMap<ContainerId, AllocatedContainerInfo>();
    private Queue<AllocatedContainerInfo> queuedGuaranteedContainers = new ConcurrentLinkedQueue<AllocatedContainerInfo>();
    private Queue<AllocatedContainerInfo> queuedOpportunisticContainers = new ConcurrentLinkedQueue<AllocatedContainerInfo>();
    private Set<ContainerId> opportunisticContainersToKill = Collections.synchronizedSet(new HashSet());
    private final ContainerQueuingLimit queuingLimit = ContainerQueuingLimit.newInstance();

    public QueuingContainerManagerImpl(Context context, ContainerExecutor exec, DeletionService deletionContext, NodeStatusUpdater nodeStatusUpdater, NodeManagerMetrics metrics, LocalDirsHandlerService dirsHandler) {
        super(context, exec, deletionContext, nodeStatusUpdater, metrics, dirsHandler);
    }

    @Override
    protected EventHandler<ApplicationEvent> createApplicationEventDispatcher() {
        return new QueuingApplicationEventDispatcher(super.createApplicationEventDispatcher());
    }

    @Override
    protected void startContainerInternal(ContainerTokenIdentifier containerTokenIdentifier, StartContainerRequest request) throws YarnException, IOException {
        this.context.getQueuingContext().getQueuedContainers().put(containerTokenIdentifier.getContainerID(), containerTokenIdentifier);
        AllocatedContainerInfo allocatedContInfo = new AllocatedContainerInfo(containerTokenIdentifier, request, containerTokenIdentifier.getExecutionType(), containerTokenIdentifier.getResource(), this.getConfig());
        if (this.queuedGuaranteedContainers.isEmpty() && this.queuedOpportunisticContainers.isEmpty() && this.getContainersMonitor().hasResourcesAvailable(allocatedContInfo.getPti())) {
            this.startAllocatedContainer(allocatedContInfo);
        } else {
            ContainerId cIdToStart = containerTokenIdentifier.getContainerID();
            this.context.getNMStateStore().storeContainer(cIdToStart, request);
            this.context.getNMStateStore().storeContainerQueued(cIdToStart);
            LOG.info("No available resources for container {} to start its execution immediately.", (Object)cIdToStart);
            if (allocatedContInfo.getExecutionType() == ExecutionType.GUARANTEED) {
                this.queuedGuaranteedContainers.add(allocatedContInfo);
                this.killOpportunisticContainers(allocatedContInfo);
            } else {
                LOG.info("Opportunistic container {} will be queued at the NM.", (Object)cIdToStart);
                this.queuedOpportunisticContainers.add(allocatedContInfo);
            }
        }
    }

    @Override
    protected void stopContainerInternal(ContainerId containerID) throws YarnException, IOException {
        Container container = (Container)this.context.getContainers().get(containerID);
        if (container == null && this.context.getQueuingContext().getQueuedContainers().containsKey(containerID)) {
            ContainerTokenIdentifier containerTokenId = (ContainerTokenIdentifier)this.context.getQueuingContext().getQueuedContainers().remove(containerID);
            boolean foundInQueue = this.removeQueuedContainer(containerID, containerTokenId.getExecutionType());
            if (foundInQueue) {
                LOG.info("Removing queued container with ID " + containerID);
                this.context.getQueuingContext().getKilledQueuedContainers().put(containerTokenId, "Queued container request removed by ApplicationMaster.");
                this.context.getNMStateStore().storeContainerKilled(containerID);
            } else {
                try {
                    this.stopContainerInternalIfRunning(containerID);
                }
                catch (IOException | YarnException e) {
                    LOG.error("Container did not get removed successfully.", e);
                }
            }
            this.nodeStatusUpdater.sendOutofBandHeartBeat();
        } else {
            super.stopContainerInternal(containerID);
        }
    }

    private void startAllocatedContainer(AllocatedContainerInfo allocatedContainerInfo) {
        ContainersMonitorImpl.ProcessTreeInfo pti = allocatedContainerInfo.getPti();
        if (allocatedContainerInfo.getExecutionType() == ExecutionType.GUARANTEED) {
            this.allocatedGuaranteedContainers.put(pti.getContainerId(), allocatedContainerInfo);
        } else {
            this.allocatedOpportunisticContainers.put(pti.getContainerId(), allocatedContainerInfo);
        }
        this.getContainersMonitor().increaseContainersAllocation(pti);
        ContainerId containerId = allocatedContainerInfo.getContainerTokenIdentifier().getContainerID();
        this.context.getQueuingContext().getQueuedContainers().remove(containerId);
        try {
            LOG.info("Starting container [" + containerId + "]");
            super.startContainerInternal(allocatedContainerInfo.getContainerTokenIdentifier(), allocatedContainerInfo.getStartRequest());
        }
        catch (IOException | YarnException e) {
            this.containerFailedToStart(pti.getContainerId(), allocatedContainerInfo.getContainerTokenIdentifier());
            LOG.error("Container failed to start.", e);
        }
    }

    private void containerFailedToStart(ContainerId containerId, ContainerTokenIdentifier containerTokenId) {
        this.context.getQueuingContext().getQueuedContainers().remove(containerId);
        this.removeAllocatedContainer(containerId);
        this.context.getQueuingContext().getKilledQueuedContainers().put(containerTokenId, "Container removed from queue as it failed to start.");
    }

    private boolean removeQueuedContainer(ContainerId containerId, ExecutionType executionType) {
        Queue<AllocatedContainerInfo> queue = executionType == ExecutionType.GUARANTEED ? this.queuedGuaranteedContainers : this.queuedOpportunisticContainers;
        boolean foundInQueue = false;
        Iterator iter = queue.iterator();
        while (iter.hasNext() && !foundInQueue) {
            if (!((AllocatedContainerInfo)iter.next()).getPti().getContainerId().equals((Object)containerId)) continue;
            iter.remove();
            foundInQueue = true;
        }
        return foundInQueue;
    }

    private void removeAllocatedContainer(ContainerId containerId) {
        AllocatedContainerInfo contToRemove = null;
        contToRemove = (AllocatedContainerInfo)this.allocatedGuaranteedContainers.remove(containerId);
        if (contToRemove == null) {
            contToRemove = (AllocatedContainerInfo)this.allocatedOpportunisticContainers.remove(containerId);
        }
        if (contToRemove != null) {
            this.getContainersMonitor().decreaseContainersAllocation(contToRemove.getPti());
        }
    }

    private void stopContainerInternalIfRunning(ContainerId containerID) throws YarnException, IOException {
        if (this.context.getContainers().containsKey(containerID)) {
            this.stopContainerInternal(containerID);
        }
    }

    private void killOpportunisticContainers(AllocatedContainerInfo allocatedContInfo) {
        ContainerId containerToStartId = allocatedContInfo.getPti().getContainerId();
        List<ContainerId> extraOpportContainersToKill = this.pickOpportunisticContainersToKill(containerToStartId);
        for (ContainerId contIdToKill : extraOpportContainersToKill) {
            try {
                this.stopContainerInternalIfRunning(contIdToKill);
            }
            catch (IOException | YarnException e) {
                LOG.error("Container did not get removed successfully.", e);
            }
            LOG.info("Opportunistic container {} will be killed in order to start the execution of guaranteed container {}.", (Object)contIdToKill, (Object)containerToStartId);
        }
    }

    protected List<ContainerId> pickOpportunisticContainersToKill(ContainerId containerToStartId) {
        ArrayList<ContainerId> extraOpportContainersToKill = new ArrayList<ContainerId>();
        ResourceUtilization resourcesToFreeUp = this.resourcesToFreeUp(containerToStartId);
        boolean hasSufficientResources = false;
        for (Map.Entry runningOpportCont : this.allocatedOpportunisticContainers.entrySet()) {
            ContainerId runningOpportContId = (ContainerId)runningOpportCont.getKey();
            if (resourcesToFreeUp.getPhysicalMemory() <= 0 && resourcesToFreeUp.getVirtualMemory() <= 0 && resourcesToFreeUp.getCPU() <= 0.0f) {
                hasSufficientResources = true;
                break;
            }
            if (this.opportunisticContainersToKill.contains(runningOpportContId)) continue;
            extraOpportContainersToKill.add(runningOpportContId);
            this.opportunisticContainersToKill.add(runningOpportContId);
            this.getContainersMonitor().decreaseResourceUtilization(resourcesToFreeUp, ((AllocatedContainerInfo)runningOpportCont.getValue()).getPti());
        }
        if (!hasSufficientResources) {
            LOG.info("There are no sufficient resources to start guaranteed {} even after attempting to kill any running opportunistic containers.", (Object)containerToStartId);
        }
        return extraOpportContainersToKill;
    }

    private ResourceUtilization resourcesToFreeUp(ContainerId containerToStartId) {
        ResourceUtilization resourceAllocationToFreeUp = ResourceUtilization.newInstance((ResourceUtilization)this.getContainersMonitor().getContainersAllocation());
        for (ContainerId opportContId : this.opportunisticContainersToKill) {
            if (!this.allocatedOpportunisticContainers.containsKey(opportContId)) continue;
            this.getContainersMonitor().decreaseResourceUtilization(resourceAllocationToFreeUp, ((AllocatedContainerInfo)this.allocatedOpportunisticContainers.get(opportContId)).getPti());
        }
        for (AllocatedContainerInfo guarContInfo : this.queuedGuaranteedContainers) {
            this.getContainersMonitor().increaseResourceUtilization(resourceAllocationToFreeUp, guarContInfo.getPti());
            if (!guarContInfo.getPti().getContainerId().equals((Object)containerToStartId)) continue;
            break;
        }
        this.getContainersMonitor().subtractNodeResourcesFromResourceUtilization(resourceAllocationToFreeUp);
        return resourceAllocationToFreeUp;
    }

    private void startPendingContainers() {
        boolean resourcesAvailable = this.startContainersFromQueue(this.queuedGuaranteedContainers);
        if (resourcesAvailable) {
            this.startContainersFromQueue(this.queuedOpportunisticContainers);
        }
    }

    private boolean startContainersFromQueue(Queue<AllocatedContainerInfo> queuedContainers) {
        Iterator guarIter = queuedContainers.iterator();
        boolean resourcesAvailable = true;
        while (guarIter.hasNext() && resourcesAvailable) {
            AllocatedContainerInfo allocatedContInfo = (AllocatedContainerInfo)guarIter.next();
            if (this.getContainersMonitor().hasResourcesAvailable(allocatedContInfo.getPti())) {
                this.startAllocatedContainer(allocatedContInfo);
                guarIter.remove();
                continue;
            }
            resourcesAvailable = false;
        }
        return resourcesAvailable;
    }

    @Override
    protected ContainerStatus getContainerStatusInternal(ContainerId containerID, NMTokenIdentifier nmTokenIdentifier) throws YarnException {
        Container container = (Container)this.context.getContainers().get(containerID);
        if (container == null) {
            ContainerTokenIdentifier containerTokenId = (ContainerTokenIdentifier)this.context.getQueuingContext().getQueuedContainers().get(containerID);
            if (containerTokenId != null) {
                ExecutionType executionType = ((ContainerTokenIdentifier)this.context.getQueuingContext().getQueuedContainers().get(containerID)).getExecutionType();
                return BuilderUtils.newContainerStatus((ContainerId)containerID, (ContainerState)ContainerState.QUEUED, (String)"", (int)-1000, (Resource)((ContainerTokenIdentifier)this.context.getQueuingContext().getQueuedContainers().get(containerID)).getResource(), (ExecutionType)executionType);
            }
            for (ContainerTokenIdentifier cTokenId : this.context.getQueuingContext().getKilledQueuedContainers().keySet()) {
                if (!cTokenId.getContainerID().equals((Object)containerID)) continue;
                return BuilderUtils.newContainerStatus((ContainerId)containerID, (ContainerState)ContainerState.COMPLETE, (String)((String)this.context.getQueuingContext().getKilledQueuedContainers().get(cTokenId)), (int)-100, (Resource)cTokenId.getResource(), (ExecutionType)cTokenId.getExecutionType());
            }
        }
        return super.getContainerStatusInternal(containerID, nmTokenIdentifier);
    }

    @Override
    protected void recoverActiveContainer(ContainerLaunchContext launchContext, ContainerTokenIdentifier token, NMStateStoreService.RecoveredContainerState rcs) throws IOException {
        if (rcs.getStatus() == NMStateStoreService.RecoveredContainerStatus.QUEUED && !rcs.getKilled()) {
            LOG.info(token.getContainerID() + "will be added to the queued containers.");
            AllocatedContainerInfo allocatedContInfo = new AllocatedContainerInfo(token, rcs.getStartRequest(), token.getExecutionType(), token.getResource(), this.getConfig());
            this.context.getQueuingContext().getQueuedContainers().put(token.getContainerID(), token);
            if (allocatedContInfo.getExecutionType() == ExecutionType.GUARANTEED) {
                this.queuedGuaranteedContainers.add(allocatedContInfo);
                this.killOpportunisticContainers(allocatedContInfo);
            } else {
                this.queuedOpportunisticContainers.add(allocatedContInfo);
            }
        } else {
            super.recoverActiveContainer(launchContext, token, rcs);
        }
    }

    @VisibleForTesting
    public int getNumAllocatedGuaranteedContainers() {
        return this.allocatedGuaranteedContainers.size();
    }

    @VisibleForTesting
    public int getNumAllocatedOpportunisticContainers() {
        return this.allocatedOpportunisticContainers.size();
    }

    @VisibleForTesting
    public int getNumQueuedGuaranteedContainers() {
        return this.queuedGuaranteedContainers.size();
    }

    @VisibleForTesting
    public int getNumQueuedOpportunisticContainers() {
        return this.queuedOpportunisticContainers.size();
    }

    @Override
    public void updateQueuingLimit(ContainerQueuingLimit limit) {
        this.queuingLimit.setMaxQueueLength(limit.getMaxQueueLength());
        if (this.queuingLimit.getMaxQueueLength() > -1) {
            this.shedQueuedOpportunisticContainers();
        }
    }

    private void shedQueuedOpportunisticContainers() {
        int numAllowed = this.queuingLimit.getMaxQueueLength();
        Iterator containerIter = this.queuedOpportunisticContainers.iterator();
        while (containerIter.hasNext()) {
            AllocatedContainerInfo cInfo = (AllocatedContainerInfo)containerIter.next();
            if (numAllowed <= 0) {
                containerIter.remove();
                ContainerTokenIdentifier containerTokenIdentifier = (ContainerTokenIdentifier)this.context.getQueuingContext().getQueuedContainers().remove(cInfo.getContainerTokenIdentifier().getContainerID());
                if (containerTokenIdentifier != null) {
                    this.context.getQueuingContext().getKilledQueuedContainers().putIfAbsent(cInfo.getContainerTokenIdentifier(), "Container de-queued to meet NM queuing limits. Max Queue length[" + this.queuingLimit.getMaxQueueLength() + "]");
                }
            }
            --numAllowed;
        }
    }

    static class AllocatedContainerInfo {
        private final ContainerTokenIdentifier containerTokenIdentifier;
        private final StartContainerRequest startRequest;
        private final ExecutionType executionType;
        private final ContainersMonitorImpl.ProcessTreeInfo pti;

        AllocatedContainerInfo(ContainerTokenIdentifier containerTokenIdentifier, StartContainerRequest startRequest, ExecutionType executionType, Resource resource, Configuration conf) {
            this.containerTokenIdentifier = containerTokenIdentifier;
            this.startRequest = startRequest;
            this.executionType = executionType;
            this.pti = this.createProcessTreeInfo(containerTokenIdentifier.getContainerID(), resource, conf);
        }

        private ContainerTokenIdentifier getContainerTokenIdentifier() {
            return this.containerTokenIdentifier;
        }

        private StartContainerRequest getStartRequest() {
            return this.startRequest;
        }

        private ExecutionType getExecutionType() {
            return this.executionType;
        }

        protected ContainersMonitorImpl.ProcessTreeInfo getPti() {
            return this.pti;
        }

        private ContainersMonitorImpl.ProcessTreeInfo createProcessTreeInfo(ContainerId containerId, Resource resource, Configuration conf) {
            long pmemBytes = resource.getMemorySize() * 1024L * 1024L;
            float pmemRatio = conf.getFloat("yarn.nodemanager.vmem-pmem-ratio", 2.1f);
            long vmemBytes = (long)(pmemRatio * (float)pmemBytes);
            int cpuVcores = resource.getVirtualCores();
            return new ContainersMonitorImpl.ProcessTreeInfo(containerId, null, null, vmemBytes, pmemBytes, cpuVcores);
        }

        public boolean equals(Object obj) {
            boolean equal = false;
            if (obj instanceof AllocatedContainerInfo) {
                AllocatedContainerInfo otherContInfo = (AllocatedContainerInfo)obj;
                equal = this.getPti().getContainerId().equals((Object)otherContInfo.getPti().getContainerId());
            }
            return equal;
        }

        public int hashCode() {
            return this.getPti().getContainerId().hashCode();
        }
    }

    class QueuingApplicationEventDispatcher
    implements EventHandler<ApplicationEvent> {
        private EventHandler<ApplicationEvent> applicationEventDispatcher;

        public QueuingApplicationEventDispatcher(EventHandler<ApplicationEvent> applicationEventDispatcher) {
            this.applicationEventDispatcher = applicationEventDispatcher;
        }

        public void handle(ApplicationEvent event) {
            if (event.getType() == ApplicationEventType.APPLICATION_CONTAINER_FINISHED) {
                if (!(event instanceof ApplicationContainerFinishedEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                ApplicationContainerFinishedEvent finishEvent = (ApplicationContainerFinishedEvent)event;
                ContainerId contIdToRemove = finishEvent.getContainerID();
                QueuingContainerManagerImpl.this.removeAllocatedContainer(contIdToRemove);
                QueuingContainerManagerImpl.this.opportunisticContainersToKill.remove(contIdToRemove);
                QueuingContainerManagerImpl.this.startPendingContainers();
            }
            this.applicationEventDispatcher.handle((Event)event);
        }
    }
}

