/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.scheduler;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.DistributedSchedulingAllocateRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DistributedSchedulingAllocateResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterDistributedSchedulingAMResponse;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyApplicationContext;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AbstractRequestInterceptor;
import org.apache.hadoop.yarn.server.nodemanager.security.NMTokenSecretManagerInNM;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerAllocator;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DistributedScheduler
extends AbstractRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedScheduler.class);
    private static final RecordFactory RECORD_FACTORY = RecordFactoryProvider.getRecordFactory(null);
    private OpportunisticContainerContext oppContainerContext = new OpportunisticContainerContext();
    private ApplicationAttemptId applicationAttemptId;
    private OpportunisticContainerAllocator containerAllocator;
    private NMTokenSecretManagerInNM nmSecretManager;
    private String appSubmitter;
    private long rmIdentifier;

    @Override
    public void init(AMRMProxyApplicationContext applicationContext) {
        super.init(applicationContext);
        this.initLocal(applicationContext.getNMCotext().getNodeStatusUpdater().getRMIdentifier(), applicationContext.getApplicationAttemptId(), applicationContext.getNMCotext().getContainerAllocator(), applicationContext.getNMCotext().getNMTokenSecretManager(), applicationContext.getUser());
    }

    @VisibleForTesting
    void initLocal(long rmId, ApplicationAttemptId appAttemptId, OpportunisticContainerAllocator oppContainerAllocator, NMTokenSecretManagerInNM nmSecretManager, String appSubmitter) {
        this.rmIdentifier = rmId;
        this.applicationAttemptId = appAttemptId;
        this.containerAllocator = oppContainerAllocator;
        this.nmSecretManager = nmSecretManager;
        this.appSubmitter = appSubmitter;
        this.oppContainerContext.setContainerIdGenerator(new OpportunisticContainerAllocator.ContainerIdGenerator(){

            public long generateContainerId() {
                return this.containerIdCounter.decrementAndGet();
            }
        });
    }

    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        return this.registerApplicationMasterForDistributedScheduling(request).getRegisterResponse();
    }

    public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
        DistributedSchedulingAllocateRequest distRequest = (DistributedSchedulingAllocateRequest)RECORD_FACTORY.newRecordInstance(DistributedSchedulingAllocateRequest.class);
        distRequest.setAllocateRequest(request);
        return this.allocateForDistributedScheduling(distRequest).getAllocateResponse();
    }

    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        return this.getNextInterceptor().finishApplicationMaster(request);
    }

    private void updateResponseWithNMTokens(AllocateResponse response, List<NMToken> nmTokens, List<Container> allocatedContainers) {
        ArrayList<NMToken> newTokens = new ArrayList<NMToken>();
        if (allocatedContainers.size() > 0) {
            response.getAllocatedContainers().addAll(allocatedContainers);
            for (Container alloc : allocatedContainers) {
                if (this.oppContainerContext.getNodeTokens().containsKey(alloc.getNodeId())) continue;
                newTokens.add(this.nmSecretManager.generateNMToken(this.appSubmitter, alloc));
            }
            ArrayList<NMToken> retTokens = new ArrayList<NMToken>(nmTokens);
            retTokens.addAll(newTokens);
            response.setNMTokens(retTokens);
        }
    }

    private void updateParameters(RegisterDistributedSchedulingAMResponse registerResponse) {
        this.oppContainerContext.getAppParams().setMinResource(registerResponse.getMinContainerResource());
        this.oppContainerContext.getAppParams().setMaxResource(registerResponse.getMaxContainerResource());
        this.oppContainerContext.getAppParams().setIncrementResource(registerResponse.getIncrContainerResource());
        if (this.oppContainerContext.getAppParams().getIncrementResource() == null) {
            this.oppContainerContext.getAppParams().setIncrementResource(this.oppContainerContext.getAppParams().getMinResource());
        }
        this.oppContainerContext.getAppParams().setContainerTokenExpiryInterval(registerResponse.getContainerTokenExpiryInterval());
        this.oppContainerContext.getContainerIdGenerator().resetContainerIdCounter(registerResponse.getContainerIdStart());
        this.setNodeList(registerResponse.getNodesForScheduling());
    }

    private void setNodeList(List<NodeId> nodeList) {
        this.oppContainerContext.getNodeMap().clear();
        this.addToNodeList(nodeList);
    }

    private void addToNodeList(List<NodeId> nodes) {
        for (NodeId n : nodes) {
            this.oppContainerContext.getNodeMap().put(n.getHost(), n);
        }
    }

    @Override
    public RegisterDistributedSchedulingAMResponse registerApplicationMasterForDistributedScheduling(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        LOG.info("Forwarding registration request to theDistributed Scheduler Service on YARN RM");
        RegisterDistributedSchedulingAMResponse dsResp = this.getNextInterceptor().registerApplicationMasterForDistributedScheduling(request);
        this.updateParameters(dsResp);
        return dsResp;
    }

    @Override
    public DistributedSchedulingAllocateResponse allocateForDistributedScheduling(DistributedSchedulingAllocateRequest request) throws YarnException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forwarding allocate request to theDistributed Scheduler Service on YARN RM");
        }
        List allocatedContainers = this.containerAllocator.allocateContainers(request.getAllocateRequest(), this.applicationAttemptId, this.oppContainerContext, this.rmIdentifier, this.appSubmitter);
        request.setAllocatedContainers(allocatedContainers);
        DistributedSchedulingAllocateResponse dsResp = this.getNextInterceptor().allocateForDistributedScheduling(request);
        this.setNodeList(dsResp.getNodesForScheduling());
        List nmTokens = dsResp.getAllocateResponse().getNMTokens();
        for (NMToken nmToken : nmTokens) {
            this.oppContainerContext.getNodeTokens().put(nmToken.getNodeId(), nmToken);
        }
        List completedContainers = dsResp.getAllocateResponse().getCompletedContainersStatuses();
        for (ContainerStatus cs : completedContainers) {
            if (cs.getExecutionType() != ExecutionType.OPPORTUNISTIC) continue;
            this.oppContainerContext.getContainersAllocated().remove(cs.getContainerId());
        }
        this.updateResponseWithNMTokens(dsResp.getAllocateResponse(), nmTokens, allocatedContainers);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Number of opportunistic containers currentlyallocated by application: " + this.oppContainerContext.getContainersAllocated().size());
        }
        return dsResp;
    }
}

