/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMNullStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.security.BaseNMTokenSecretManager;
import org.apache.hadoop.yarn.server.security.MasterKeyData;

public class NMTokenSecretManagerInNM
extends BaseNMTokenSecretManager {
    private static final Log LOG = LogFactory.getLog(NMTokenSecretManagerInNM.class);
    private MasterKeyData previousMasterKey;
    private final Map<ApplicationAttemptId, MasterKeyData> oldMasterKeys = new HashMap<ApplicationAttemptId, MasterKeyData>();
    private final Map<ApplicationId, List<ApplicationAttemptId>> appToAppAttemptMap = new HashMap<ApplicationId, List<ApplicationAttemptId>>();
    private final NMStateStoreService stateStore;
    private NodeId nodeId;

    public NMTokenSecretManagerInNM() {
        this(new NMNullStateStoreService());
    }

    public NMTokenSecretManagerInNM(NMStateStoreService stateStore) {
        this.stateStore = stateStore;
    }

    public synchronized void recover() throws IOException {
        NMStateStoreService.RecoveredNMTokensState state = this.stateStore.loadNMTokensState();
        MasterKey key = state.getCurrentMasterKey();
        if (key != null) {
            this.currentMasterKey = new MasterKeyData(key, NMTokenSecretManagerInNM.createSecretKey((byte[])key.getBytes().array()));
        }
        if ((key = state.getPreviousMasterKey()) != null) {
            this.previousMasterKey = new MasterKeyData(key, NMTokenSecretManagerInNM.createSecretKey((byte[])key.getBytes().array()));
        }
        if (this.currentMasterKey != null) {
            this.serialNo = this.currentMasterKey.getMasterKey().getKeyId() + 1;
        }
        for (Map.Entry<ApplicationAttemptId, MasterKey> entry : state.getApplicationMasterKeys().entrySet()) {
            key = entry.getValue();
            this.oldMasterKeys.put(entry.getKey(), new MasterKeyData(key, NMTokenSecretManagerInNM.createSecretKey((byte[])key.getBytes().array())));
        }
        this.appToAppAttemptMap.clear();
        for (ApplicationAttemptId attempt : this.oldMasterKeys.keySet()) {
            ApplicationId app = attempt.getApplicationId();
            List<ApplicationAttemptId> attempts = this.appToAppAttemptMap.get(app);
            if (attempts == null) {
                attempts = new ArrayList<ApplicationAttemptId>();
                this.appToAppAttemptMap.put(app, attempts);
            }
            attempts.add(attempt);
        }
    }

    private void updateCurrentMasterKey(MasterKeyData key) {
        this.currentMasterKey = key;
        try {
            this.stateStore.storeNMTokenCurrentMasterKey(key.getMasterKey());
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to update current master key in state store", (Throwable)e);
        }
    }

    private void updatePreviousMasterKey(MasterKeyData key) {
        this.previousMasterKey = key;
        try {
            this.stateStore.storeNMTokenPreviousMasterKey(key.getMasterKey());
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to update previous master key in state store", (Throwable)e);
        }
    }

    @InterfaceAudience.Private
    public synchronized void setMasterKey(MasterKey masterKey) {
        if (this.currentMasterKey == null || this.currentMasterKey.getMasterKey().getKeyId() != masterKey.getKeyId()) {
            LOG.info((Object)("Rolling master-key for container-tokens, got key with id " + masterKey.getKeyId()));
            if (this.currentMasterKey != null) {
                this.updatePreviousMasterKey(this.currentMasterKey);
            }
            this.updateCurrentMasterKey(new MasterKeyData(masterKey, NMTokenSecretManagerInNM.createSecretKey((byte[])masterKey.getBytes().array())));
        }
    }

    public synchronized byte[] retrievePassword(NMTokenIdentifier identifier) throws SecretManager.InvalidToken {
        MasterKeyData oldMasterKey;
        int keyId = identifier.getKeyId();
        ApplicationAttemptId appAttemptId = identifier.getApplicationAttemptId();
        MasterKeyData masterKeyToUse = oldMasterKey = this.oldMasterKeys.get(appAttemptId);
        if (this.previousMasterKey != null && keyId == this.previousMasterKey.getMasterKey().getKeyId()) {
            masterKeyToUse = this.previousMasterKey;
        } else if (keyId == this.currentMasterKey.getMasterKey().getKeyId()) {
            masterKeyToUse = this.currentMasterKey;
        }
        if (this.nodeId != null && !identifier.getNodeId().equals((Object)this.nodeId)) {
            throw new SecretManager.InvalidToken("Given NMToken for application : " + appAttemptId.toString() + " is not valid for current node manager.expected : " + this.nodeId.toString() + " found : " + identifier.getNodeId().toString());
        }
        if (masterKeyToUse != null) {
            byte[] password = this.retrivePasswordInternal(identifier, masterKeyToUse);
            LOG.debug((Object)"NMToken password retrieved successfully!!");
            return password;
        }
        throw new SecretManager.InvalidToken("Given NMToken for application : " + appAttemptId.toString() + " seems to have been generated illegally.");
    }

    public synchronized void appFinished(ApplicationId appId) {
        List<ApplicationAttemptId> appAttemptList = this.appToAppAttemptMap.get(appId);
        if (appAttemptList != null) {
            LOG.debug((Object)("Removing application attempts NMToken keys for application " + appId));
            for (ApplicationAttemptId appAttemptId : appAttemptList) {
                this.removeAppAttemptKey(appAttemptId);
            }
            this.appToAppAttemptMap.remove(appId);
        } else {
            LOG.error((Object)("No application Attempt for application : " + appId + " started on this NM."));
        }
    }

    public synchronized void appAttemptStartContainer(NMTokenIdentifier identifier) throws SecretManager.InvalidToken {
        MasterKeyData oldKey;
        ApplicationAttemptId appAttemptId = identifier.getApplicationAttemptId();
        if (!this.appToAppAttemptMap.containsKey(appAttemptId.getApplicationId())) {
            this.appToAppAttemptMap.put(appAttemptId.getApplicationId(), new ArrayList());
        }
        if ((oldKey = this.oldMasterKeys.get(appAttemptId)) == null) {
            this.appToAppAttemptMap.get(appAttemptId.getApplicationId()).add(appAttemptId);
        }
        if (oldKey == null || oldKey.getMasterKey().getKeyId() != identifier.getKeyId()) {
            LOG.debug((Object)("NMToken key updated for application attempt : " + identifier.getApplicationAttemptId().toString()));
            if (identifier.getKeyId() == this.currentMasterKey.getMasterKey().getKeyId()) {
                this.updateAppAttemptKey(appAttemptId, this.currentMasterKey);
            } else if (this.previousMasterKey != null && identifier.getKeyId() == this.previousMasterKey.getMasterKey().getKeyId()) {
                this.updateAppAttemptKey(appAttemptId, this.previousMasterKey);
            } else {
                throw new SecretManager.InvalidToken("Older NMToken should not be used while starting the container.");
            }
        }
    }

    public synchronized void setNodeId(NodeId nodeId) {
        LOG.debug((Object)("updating nodeId : " + nodeId));
        this.nodeId = nodeId;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized boolean isAppAttemptNMTokenKeyPresent(ApplicationAttemptId appAttemptId) {
        return this.oldMasterKeys.containsKey(appAttemptId);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized NodeId getNodeId() {
        return this.nodeId;
    }

    private void updateAppAttemptKey(ApplicationAttemptId attempt, MasterKeyData key) {
        this.oldMasterKeys.put(attempt, key);
        try {
            this.stateStore.storeNMTokenApplicationMasterKey(attempt, key.getMasterKey());
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to store master key for application " + attempt), (Throwable)e);
        }
    }

    private void removeAppAttemptKey(ApplicationAttemptId attempt) {
        this.oldMasterKeys.remove(attempt);
        try {
            this.stateStore.removeNMTokenApplicationMasterKey(attempt);
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to remove master key for application " + attempt), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NMToken generateNMToken(String applicationSubmitter, Container container) {
        this.readLock.lock();
        try {
            Token token = this.createNMToken(container.getId().getApplicationAttemptId(), container.getNodeId(), applicationSubmitter);
            NMToken nMToken = NMToken.newInstance((NodeId)container.getNodeId(), (Token)token);
            return nMToken;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

