/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp.dao;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.webapp.ContainerLogsUtils;

@XmlRootElement(name="containerLogsInfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ContainerLogsInfo {
    @XmlElement(name="containerLogInfo")
    protected List<ContainerLogInfo> containerLogsInfo;

    public ContainerLogsInfo() {
    }

    public ContainerLogsInfo(Context nmContext, ContainerId containerId, String remoteUser) throws YarnException {
        this.containerLogsInfo = ContainerLogsInfo.getContainerLogsInfo(containerId, remoteUser, nmContext);
    }

    public List<ContainerLogInfo> getContainerLogsInfo() {
        return this.containerLogsInfo;
    }

    private static List<ContainerLogInfo> getContainerLogsInfo(ContainerId id, String remoteUser, Context nmContext) throws YarnException {
        ArrayList<ContainerLogInfo> logFiles = new ArrayList<ContainerLogInfo>();
        List<File> logDirs = ContainerLogsUtils.getContainerLogDirs(id, remoteUser, nmContext);
        for (File containerLogsDir : logDirs) {
            File[] logs = containerLogsDir.listFiles();
            if (logs == null) continue;
            for (File log : logs) {
                if (!log.isFile()) continue;
                ContainerLogInfo logMeta = new ContainerLogInfo(log.getName(), log.length());
                logFiles.add(logMeta);
            }
        }
        return logFiles;
    }

    private static class ContainerLogInfo {
        private String fileName;
        private long fileSize;

        public ContainerLogInfo() {
        }

        public ContainerLogInfo(String fileName, long fileSize) {
            this.setFileName(fileName);
            this.setFileSize(fileSize);
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }
    }
}

