/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.server.nodemanager.NodeResourceMonitor;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;

public class NodeResourceMonitorImpl
extends AbstractService
implements NodeResourceMonitor {
    static final Log LOG = LogFactory.getLog(NodeResourceMonitorImpl.class);
    private long monitoringInterval;
    private MonitoringThread monitoringThread = new MonitoringThread();
    private ResourceCalculatorPlugin resourceCalculatorPlugin;
    private ResourceUtilization nodeUtilization;

    public NodeResourceMonitorImpl() {
        super(NodeResourceMonitorImpl.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.monitoringInterval = conf.getLong("yarn.nodemanager.resource-monitor.interval-ms", 3000L);
        this.resourceCalculatorPlugin = ResourceCalculatorPlugin.getNodeResourceMonitorPlugin((Configuration)conf);
        LOG.info((Object)(" Using ResourceCalculatorPlugin : " + this.resourceCalculatorPlugin));
    }

    private boolean isEnabled() {
        if (this.monitoringInterval <= 0L) {
            LOG.info((Object)("Node Resource monitoring interval is <=0. " + this.getClass().getName() + " is disabled."));
            return false;
        }
        if (this.resourceCalculatorPlugin == null) {
            LOG.info((Object)("ResourceCalculatorPlugin is unavailable on this system. " + this.getClass().getName() + " is disabled."));
            return false;
        }
        return true;
    }

    protected void serviceStart() throws Exception {
        if (this.isEnabled()) {
            this.monitoringThread.start();
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.isEnabled()) {
            this.monitoringThread.interrupt();
            try {
                this.monitoringThread.join(10000L);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Could not wait for the thread to join");
            }
        }
        super.serviceStop();
    }

    @Override
    public ResourceUtilization getUtilization() {
        return this.nodeUtilization;
    }

    private class MonitoringThread
    extends Thread {
        public MonitoringThread() {
            super("Node Resource Monitor");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                long pmem = NodeResourceMonitorImpl.this.resourceCalculatorPlugin.getPhysicalMemorySize() - NodeResourceMonitorImpl.this.resourceCalculatorPlugin.getAvailablePhysicalMemorySize();
                long vmem = NodeResourceMonitorImpl.this.resourceCalculatorPlugin.getVirtualMemorySize() - NodeResourceMonitorImpl.this.resourceCalculatorPlugin.getAvailableVirtualMemorySize();
                float vcores = NodeResourceMonitorImpl.this.resourceCalculatorPlugin.getNumVCoresUsed();
                NodeResourceMonitorImpl.this.nodeUtilization = ResourceUtilization.newInstance((int)((int)(pmem >> 20)), (int)((int)(vmem >> 20)), (float)vcores);
                try {
                    Thread.sleep(NodeResourceMonitorImpl.this.monitoringInterval);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)(NodeResourceMonitorImpl.class.getName() + " is interrupted. Exiting."));
                    return;
                }
            }
        }
    }
}

