/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.timelineservice;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.timelineservice.ContainerEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetricOperation;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ContainerLocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.timelineservice.NMTimelineEvent;
import org.apache.hadoop.yarn.server.nodemanager.timelineservice.NMTimelineEventType;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;

public class NMTimelinePublisher
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(NMTimelinePublisher.class);
    private Dispatcher dispatcher;
    private Context context;
    private NodeId nodeId;
    private String httpAddress;
    private final Map<ApplicationId, TimelineClient> appToClientMap;

    public NMTimelinePublisher(Context context) {
        super(NMTimelinePublisher.class.getName());
        this.context = context;
        this.appToClientMap = new ConcurrentHashMap<ApplicationId, TimelineClient>();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.dispatcher = new AsyncDispatcher("NM Timeline dispatcher");
        this.dispatcher.register(NMTimelineEventType.class, (EventHandler)new ForwardingEventHandler());
        this.addIfService(this.dispatcher);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.nodeId = this.context.getNodeId();
    }

    @VisibleForTesting
    Map<ApplicationId, TimelineClient> getAppToClientMap() {
        return this.appToClientMap;
    }

    protected void handleNMTimelineEvent(NMTimelineEvent event) {
        switch ((NMTimelineEventType)event.getType()) {
            case TIMELINE_ENTITY_PUBLISH: {
                this.putEntity(((TimelinePublishEvent)event).getTimelineEntityToPublish(), ((TimelinePublishEvent)event).getApplicationId());
                break;
            }
            default: {
                LOG.error((Object)("Unknown NMTimelineEvent type: " + event.getType()));
            }
        }
    }

    public void reportContainerResourceUsage(Container container, Long pmemUsage, Float cpuUsagePercentPerCore) {
        if (pmemUsage != -1L || cpuUsagePercentPerCore.floatValue() != -1.0f) {
            ContainerEntity entity = NMTimelinePublisher.createContainerEntity(container.getContainerId());
            long currentTimeMillis = System.currentTimeMillis();
            if (pmemUsage != -1L) {
                TimelineMetric memoryMetric = new TimelineMetric();
                memoryMetric.setId(ContainersMonitorImpl.ContainerMetric.MEMORY.toString());
                memoryMetric.setRealtimeAggregationOp(TimelineMetricOperation.SUM);
                memoryMetric.addValue(currentTimeMillis, (Number)pmemUsage);
                entity.addMetric(memoryMetric);
            }
            if (cpuUsagePercentPerCore.floatValue() != -1.0f) {
                TimelineMetric cpuMetric = new TimelineMetric();
                cpuMetric.setId(ContainersMonitorImpl.ContainerMetric.CPU.toString());
                cpuMetric.setRealtimeAggregationOp(TimelineMetricOperation.SUM);
                cpuMetric.addValue(currentTimeMillis, (Number)Math.round(cpuUsagePercentPerCore.floatValue()));
                entity.addMetric(cpuMetric);
            }
            ApplicationId appId = container.getContainerId().getApplicationAttemptId().getApplicationId();
            try {
                TimelineClient timelineClient = this.getTimelineClient(appId);
                if (timelineClient != null) {
                    timelineClient.putEntitiesAsync(new TimelineEntity[]{entity});
                } else {
                    LOG.error((Object)("Seems like client has been removed before the container metric could be published for " + container.getContainerId()));
                }
            }
            catch (IOException | YarnException e) {
                LOG.error((Object)("Failed to publish Container metrics for container " + container.getContainerId()), e);
            }
        }
    }

    private void publishContainerCreatedEvent(ContainerEvent event) {
        ContainerId containerId = event.getContainerID();
        ContainerEntity entity = NMTimelinePublisher.createContainerEntity(containerId);
        Container container = (Container)this.context.getContainers().get(containerId);
        Resource resource = container.getResource();
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfo.put("YARN_CONTAINER_ALLOCATED_MEMORY", resource.getMemorySize());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_VCORE", resource.getVirtualCores());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST", this.nodeId.getHost());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_PORT", this.nodeId.getPort());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_PRIORITY", container.getPriority().toString());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS", this.httpAddress);
        entity.setInfo(entityInfo);
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId("YARN_CONTAINER_CREATED");
        tEvent.setTimestamp(event.getTimestamp());
        entity.addEvent(tEvent);
        entity.setCreatedTime(Long.valueOf(event.getTimestamp()));
        this.dispatcher.getEventHandler().handle((Event)new TimelinePublishEvent((TimelineEntity)entity, containerId.getApplicationAttemptId().getApplicationId()));
    }

    private void publishContainerFinishedEvent(ContainerStatus containerStatus, long timeStamp) {
        ContainerId containerId = containerStatus.getContainerId();
        ContainerEntity entity = NMTimelinePublisher.createContainerEntity(containerId);
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfo.put("YARN_CONTAINER_DIAGNOSTICS_INFO", containerStatus.getDiagnostics());
        entityInfo.put("YARN_CONTAINER_EXIT_STATUS", containerStatus.getExitStatus());
        entityInfo.put("YARN_CONTAINER_STATE", ContainerState.COMPLETE.toString());
        entityInfo.put("YARN_CONTAINER_FINISHED_TIME", timeStamp);
        entity.setInfo(entityInfo);
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId("YARN_CONTAINER_FINISHED");
        tEvent.setTimestamp(timeStamp);
        entity.addEvent(tEvent);
        this.dispatcher.getEventHandler().handle((Event)new TimelinePublishEvent((TimelineEntity)entity, containerId.getApplicationAttemptId().getApplicationId()));
    }

    private void publishContainerLocalizationEvent(ContainerLocalizationEvent event, String eventType) {
        Container container = event.getContainer();
        ContainerId containerId = container.getContainerId();
        ContainerEntity entity = NMTimelinePublisher.createContainerEntity(containerId);
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(eventType);
        tEvent.setTimestamp(event.getTimestamp());
        entity.addEvent(tEvent);
        ApplicationId appId = container.getContainerId().getApplicationAttemptId().getApplicationId();
        try {
            TimelineClient timelineClient = this.getTimelineClient(appId);
            if (timelineClient != null) {
                timelineClient.putEntitiesAsync(new TimelineEntity[]{entity});
            } else {
                LOG.error((Object)("Seems like client has been removed before the event could be published for " + container.getContainerId()));
            }
        }
        catch (IOException | YarnException e) {
            LOG.error((Object)("Failed to publish Container metrics for container " + container.getContainerId()), e);
        }
    }

    private static ContainerEntity createContainerEntity(ContainerId containerId) {
        ContainerEntity entity = new ContainerEntity();
        entity.setId(containerId.toString());
        TimelineEntity.Identifier parentIdentifier = new TimelineEntity.Identifier();
        parentIdentifier.setType(TimelineEntityType.YARN_APPLICATION_ATTEMPT.name());
        parentIdentifier.setId(containerId.getApplicationAttemptId().toString());
        entity.setParent(parentIdentifier);
        return entity;
    }

    private void putEntity(TimelineEntity entity, ApplicationId appId) {
        try {
            TimelineClient timelineClient;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Publishing the entity " + entity + ", JSON-style content: " + TimelineUtils.dumpTimelineRecordtoJSON((Object)entity)));
            }
            if ((timelineClient = this.getTimelineClient(appId)) != null) {
                timelineClient.putEntities(new TimelineEntity[]{entity});
            } else {
                LOG.error((Object)("Seems like client has been removed before the entity could be published for " + entity));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error when publishing entity " + entity), (Throwable)e);
        }
    }

    public void publishApplicationEvent(ApplicationEvent event) {
        switch ((ApplicationEventType)event.getType()) {
            case INIT_APPLICATION: 
            case FINISH_APPLICATION: 
            case APPLICATION_LOG_HANDLING_FAILED: {
                break;
            }
            case APPLICATION_CONTAINER_FINISHED: {
                ApplicationContainerFinishedEvent evnt = (ApplicationContainerFinishedEvent)event;
                this.publishContainerFinishedEvent(evnt.getContainerStatus(), event.getTimestamp());
                break;
            }
            default: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)(event.getType() + " is not a desired ApplicationEvent which needs to be published by NMTimelinePublisher"));
            }
        }
    }

    public void publishContainerEvent(ContainerEvent event) {
        if (this.httpAddress == null) {
            this.httpAddress = this.nodeId.getHost() + ":" + this.context.getHttpPort();
        }
        switch ((ContainerEventType)event.getType()) {
            case INIT_CONTAINER: {
                this.publishContainerCreatedEvent(event);
                break;
            }
            default: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)(event.getType() + " is not a desired ContainerEvent which needs to be published by NMTimelinePublisher"));
            }
        }
    }

    public void publishLocalizationEvent(LocalizationEvent event) {
        switch ((LocalizationEventType)event.getType()) {
            case CONTAINER_RESOURCES_LOCALIZED: {
                this.publishContainerLocalizationEvent((ContainerLocalizationEvent)event, "YARN_NM_CONTAINER_LOCALIZATION_FINISHED");
                break;
            }
            case LOCALIZE_CONTAINER_RESOURCES: {
                this.publishContainerLocalizationEvent((ContainerLocalizationEvent)event, "YARN_NM_CONTAINER_LOCALIZATION_STARTED");
                break;
            }
            default: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)(event.getType() + " is not a desired LocalizationEvent which needs to be published by NMTimelinePublisher"));
            }
        }
    }

    public void createTimelineClient(ApplicationId appId) {
        if (!this.appToClientMap.containsKey(appId)) {
            TimelineClient timelineClient = TimelineClient.createTimelineClient((ApplicationId)appId);
            timelineClient.init(this.getConfig());
            timelineClient.start();
            this.appToClientMap.put(appId, timelineClient);
        }
    }

    public void stopTimelineClient(ApplicationId appId) {
        TimelineClient client = this.appToClientMap.remove(appId);
        if (client != null) {
            client.stop();
        }
    }

    public void setTimelineServiceAddress(ApplicationId appId, String collectorAddr) {
        TimelineClient client = this.appToClientMap.get(appId);
        if (client != null) {
            client.setTimelineServiceAddress(collectorAddr);
        }
    }

    private TimelineClient getTimelineClient(ApplicationId appId) {
        return this.appToClientMap.get(appId);
    }

    private static class TimelinePublishEvent
    extends NMTimelineEvent {
        private ApplicationId appId;
        private TimelineEntity entityToPublish;

        public TimelinePublishEvent(TimelineEntity entity, ApplicationId appId) {
            super(NMTimelineEventType.TIMELINE_ENTITY_PUBLISH, System.currentTimeMillis());
            this.appId = appId;
            this.entityToPublish = entity;
        }

        public ApplicationId getApplicationId() {
            return this.appId;
        }

        public TimelineEntity getTimelineEntityToPublish() {
            return this.entityToPublish;
        }
    }

    private final class ForwardingEventHandler
    implements EventHandler<NMTimelineEvent> {
        private ForwardingEventHandler() {
        }

        public void handle(NMTimelineEvent event) {
            NMTimelinePublisher.this.handleNMTimelineEvent(event);
        }
    }
}

