/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.api.impl.pb;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.recovery.DeletionTaskRecoveryInfo;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.DeletionTask;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.DeletionTaskType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.FileDeletionTask;

public final class NMProtoUtils {
    private static final Log LOG = LogFactory.getLog(NMProtoUtils.class);

    private NMProtoUtils() {
    }

    public static DeletionTask convertProtoToDeletionTask(YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto proto, DeletionService deletionService) {
        int taskId = proto.getId();
        if (proto.hasTaskType() && proto.getTaskType() != null && proto.getTaskType().equals(DeletionTaskType.FILE.name())) {
            LOG.debug((Object)"Converting recovered FileDeletionTask");
            return NMProtoUtils.convertProtoToFileDeletionTask(proto, deletionService, taskId);
        }
        LOG.debug((Object)"Unable to get task type, trying FileDeletionTask");
        return NMProtoUtils.convertProtoToFileDeletionTask(proto, deletionService, taskId);
    }

    public static FileDeletionTask convertProtoToFileDeletionTask(YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto proto, DeletionService deletionService, int taskId) {
        String user = proto.hasUser() ? proto.getUser() : null;
        Path subdir = null;
        if (proto.hasSubdir()) {
            subdir = new Path(proto.getSubdir());
        }
        ArrayList<Path> basePaths = null;
        List<String> basedirs = proto.getBasedirsList();
        if (basedirs != null && basedirs.size() > 0) {
            basePaths = new ArrayList<Path>(basedirs.size());
            for (String basedir : basedirs) {
                basePaths.add(new Path(basedir));
            }
        }
        return new FileDeletionTask(taskId, deletionService, user, subdir, basePaths);
    }

    public static DeletionTaskRecoveryInfo convertProtoToDeletionTaskRecoveryInfo(YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto proto, DeletionService deletionService) {
        DeletionTask deletionTask = NMProtoUtils.convertProtoToDeletionTask(proto, deletionService);
        ArrayList<Integer> successorTaskIds = new ArrayList();
        if (proto.getSuccessorIdsList() != null && !proto.getSuccessorIdsList().isEmpty()) {
            successorTaskIds = proto.getSuccessorIdsList();
        }
        long deletionTimestamp = proto.getDeletionTime();
        return new DeletionTaskRecoveryInfo(deletionTask, successorTaskIds, deletionTimestamp);
    }
}

