/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.DeletionTask;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.DeletionTaskType;
import org.apache.hadoop.yarn.server.nodemanager.executor.DeletionAsUserContext;

public class FileDeletionTask
extends DeletionTask
implements Runnable {
    private final Path subDir;
    private final List<Path> baseDirs;
    private static final FileContext lfs = FileDeletionTask.getLfs();

    private static FileContext getLfs() {
        try {
            return FileContext.getLocalFSFileContext();
        }
        catch (UnsupportedFileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public FileDeletionTask(DeletionService deletionService, String user, Path subDir, List<Path> baseDirs) {
        this(-1, deletionService, user, subDir, baseDirs);
    }

    public FileDeletionTask(int taskId, DeletionService deletionService, String user, Path subDir, List<Path> baseDirs) {
        super(taskId, deletionService, user, DeletionTaskType.FILE);
        this.subDir = subDir;
        this.baseDirs = baseDirs;
    }

    public Path getSubDir() {
        return this.subDir;
    }

    public List<Path> getBaseDirs() {
        return this.baseDirs;
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            String msg = String.format("Running DeletionTask : %s", this.toString());
            LOG.debug((Object)msg);
        }
        boolean error = false;
        if (null == this.getUser()) {
            if (this.baseDirs == null || this.baseDirs.size() == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("NM deleting absolute path : " + this.subDir));
                }
                try {
                    lfs.delete(this.subDir, true);
                }
                catch (IOException e) {
                    error = true;
                    LOG.warn((Object)("Failed to delete " + this.subDir));
                }
            } else {
                for (Path baseDir : this.baseDirs) {
                    Path del;
                    Path path = del = this.subDir == null ? baseDir : new Path(baseDir, this.subDir);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("NM deleting path : " + del));
                    }
                    try {
                        lfs.delete(del, true);
                    }
                    catch (IOException e) {
                        error = true;
                        LOG.warn((Object)("Failed to delete " + this.subDir));
                    }
                }
            }
        } else {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Deleting path: [" + this.subDir + "] as user: [" + this.getUser() + "]"));
                }
                if (this.baseDirs == null || this.baseDirs.size() == 0) {
                    this.getDeletionService().getContainerExecutor().deleteAsUser(new DeletionAsUserContext.Builder().setUser(this.getUser()).setSubDir(this.subDir).build());
                }
                this.getDeletionService().getContainerExecutor().deleteAsUser(new DeletionAsUserContext.Builder().setUser(this.getUser()).setSubDir(this.subDir).setBasedirs(this.baseDirs.toArray(new Path[0])).build());
            }
            catch (IOException | InterruptedException e) {
                error = true;
                LOG.warn((Object)("Failed to delete as user " + this.getUser()), (Throwable)e);
            }
        }
        if (error) {
            this.setSuccess(!error);
        }
        this.deletionTaskFinished();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileDeletionTask :");
        sb.append("  id : ").append(this.getTaskId());
        sb.append("  user : ").append(this.getUser());
        sb.append("  subDir : ").append(this.subDir == null ? "null" : this.subDir.toString());
        sb.append("  baseDir : ");
        if (this.baseDirs == null || this.baseDirs.size() == 0) {
            sb.append("null");
        } else {
            for (Path baseDir : this.baseDirs) {
                sb.append(baseDir.toString()).append(',');
            }
        }
        return sb.toString().trim();
    }

    @Override
    public YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto convertDeletionTaskToProto() {
        YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto.Builder builder = this.getBaseDeletionTaskProtoBuilder();
        builder.setTaskType(DeletionTaskType.FILE.name());
        if (this.getSubDir() != null) {
            builder.setSubdir(this.getSubDir().toString());
        }
        if (this.getBaseDirs() != null) {
            for (Path dir : this.getBaseDirs()) {
                builder.addBasedirs(dir.toString());
            }
        }
        return builder.build();
    }
}

