/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DefaultLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DockerLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.JavaSandboxLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegatingLinuxContainerRuntime
implements LinuxContainerRuntime {
    private static final Log LOG = LogFactory.getLog(DelegatingLinuxContainerRuntime.class);
    private DefaultLinuxContainerRuntime defaultLinuxContainerRuntime;
    private DockerLinuxContainerRuntime dockerLinuxContainerRuntime;
    private JavaSandboxLinuxContainerRuntime javaSandboxLinuxContainerRuntime;

    @Override
    public void initialize(Configuration conf) throws ContainerExecutionException {
        PrivilegedOperationExecutor privilegedOperationExecutor = PrivilegedOperationExecutor.getInstance(conf);
        this.defaultLinuxContainerRuntime = new DefaultLinuxContainerRuntime(privilegedOperationExecutor);
        this.defaultLinuxContainerRuntime.initialize(conf);
        this.dockerLinuxContainerRuntime = new DockerLinuxContainerRuntime(privilegedOperationExecutor);
        this.dockerLinuxContainerRuntime.initialize(conf);
        this.javaSandboxLinuxContainerRuntime = new JavaSandboxLinuxContainerRuntime(privilegedOperationExecutor);
        this.javaSandboxLinuxContainerRuntime.initialize(conf);
    }

    private LinuxContainerRuntime pickContainerRuntime(Map<String, String> environment) {
        LinuxContainerRuntime runtime = this.javaSandboxLinuxContainerRuntime.isSandboxContainerRequested() ? this.javaSandboxLinuxContainerRuntime : (DockerLinuxContainerRuntime.isDockerContainerRequested(environment) ? this.dockerLinuxContainerRuntime : this.defaultLinuxContainerRuntime);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using container runtime: " + runtime.getClass().getSimpleName()));
        }
        return runtime;
    }

    private LinuxContainerRuntime pickContainerRuntime(Container container) {
        return this.pickContainerRuntime(container.getLaunchContext().getEnvironment());
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        LinuxContainerRuntime runtime = this.pickContainerRuntime(ctx.getContainer());
        runtime.prepareContainer(ctx);
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.launchContainer(ctx);
    }

    @Override
    public void signalContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.signalContainer(ctx);
    }

    @Override
    public void reapContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.reapContainer(ctx);
    }

    @Override
    public String[] getIpAndHost(Container container) {
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        return runtime.getIpAndHost(container);
    }
}

