/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import java.io.Closeable;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.AllPermission;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DefaultLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;
import org.apache.log4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JavaSandboxLinuxContainerRuntime
extends DefaultLinuxContainerRuntime {
    private static final Log LOG = LogFactory.getLog(DefaultLinuxContainerRuntime.class);
    private Configuration configuration;
    private SandboxMode sandboxMode;
    public static final String POLICY_FILE_DIR = "nm-sandbox-policies";
    private static java.nio.file.Path policyFileDir;
    private static final FileAttribute<Set<PosixFilePermission>> POLICY_ATTR;
    private Map<String, java.nio.file.Path> containerPolicies = new HashMap<String, java.nio.file.Path>();

    public JavaSandboxLinuxContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor) {
        super(privilegedOperationExecutor);
    }

    @Override
    public void initialize(Configuration conf) throws ContainerExecutionException {
        this.configuration = conf;
        this.sandboxMode = SandboxMode.get(this.configuration.get("yarn.nodemanager.runtime.linux.sandbox-mode", "disabled"));
        super.initialize(conf);
    }

    private void initializePolicyDir() throws ContainerExecutionException {
        block19: {
            String hadoopTempDir = this.configuration.get("hadoop.tmp.dir");
            if (hadoopTempDir == null) {
                throw new ContainerExecutionException("hadoop.tmp.dir not set!");
            }
            policyFileDir = Paths.get(hadoopTempDir, POLICY_FILE_DIR);
            if (Files.exists(policyFileDir, new LinkOption[0])) {
                try (DirectoryStream<java.nio.file.Path> stream = Files.newDirectoryStream(policyFileDir);){
                    for (java.nio.file.Path policyFile : stream) {
                        Files.delete(policyFile);
                    }
                    break block19;
                }
                catch (IOException e) {
                    throw new ContainerExecutionException("Unable to initialize policy directory: " + e);
                }
            }
            try {
                policyFileDir = Files.createDirectories(Paths.get(hadoopTempDir, POLICY_FILE_DIR), POLICY_ATTR);
            }
            catch (IOException e) {
                throw new ContainerExecutionException("Unable to create policy file directory: " + e);
            }
        }
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        List localDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LOCAL_DIRS);
        Map resources = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOCALIZED_RESOURCES);
        List commands = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_RUN_CMDS);
        Map env = ctx.getContainer().getLaunchContext().getEnvironment();
        String username = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER);
        if (!this.isSandboxContainerWhitelisted(username, commands)) {
            String tmpDirBase = this.configuration.get("hadoop.tmp.dir");
            if (tmpDirBase == null) {
                throw new ContainerExecutionException("hadoop.tmp.dir not set!");
            }
            OutputStream policyOutputStream = null;
            try {
                String containerID = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_ID_STR);
                this.initializePolicyDir();
                List<String> groupPolicyFiles = JavaSandboxLinuxContainerRuntime.getGroupPolicyFiles(this.configuration, ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER));
                java.nio.file.Path policyFilePath = Files.createFile(Paths.get(policyFileDir.toString(), containerID + "-" + "java.policy"), POLICY_ATTR);
                policyOutputStream = Files.newOutputStream(policyFilePath, new OpenOption[0]);
                this.containerPolicies.put(containerID, policyFilePath);
                NMContainerPolicyUtils.generatePolicyFile(policyOutputStream, localDirs, groupPolicyFiles, resources, this.configuration);
                NMContainerPolicyUtils.appendSecurityFlags(commands, env, policyFilePath, this.sandboxMode);
            }
            catch (IOException e) {
                try {
                    throw new ContainerExecutionException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{policyOutputStream});
                    throw throwable;
                }
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{policyOutputStream});
        }
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        try {
            super.launchContainer(ctx);
        }
        finally {
            this.deletePolicyFiles(ctx);
        }
    }

    boolean isSandboxContainerRequested() {
        return this.sandboxMode != SandboxMode.disabled;
    }

    private static List<String> getGroupPolicyFiles(Configuration conf, String user) throws ContainerExecutionException {
        List userGroups;
        Groups groups = Groups.getUserToGroupsMappingService((Configuration)conf);
        try {
            userGroups = groups.getGroups(user);
        }
        catch (IOException e) {
            throw new ContainerExecutionException("Container user does not exist");
        }
        return userGroups.stream().map(group -> conf.get("yarn.nodemanager.runtime.linux.sandbox-mode.policy.group." + group)).filter(groupPolicy -> groupPolicy != null).collect(Collectors.toList());
    }

    private boolean isSandboxContainerWhitelisted(String username, List<String> commands) throws ContainerExecutionException {
        List userGroups;
        String whitelistGroup = this.configuration.get("yarn.nodemanager.runtime.linux.sandbox-mode.whitelist-group");
        Groups groups = Groups.getUserToGroupsMappingService((Configuration)this.configuration);
        boolean isWhitelisted = false;
        try {
            userGroups = groups.getGroups(username);
        }
        catch (IOException e) {
            throw new ContainerExecutionException("Container user does not exist");
        }
        if (whitelistGroup != null && userGroups.contains(whitelistGroup)) {
            for (String cmd : commands) {
                if (cmd.contains("-Djava.security.manager")) {
                    isWhitelisted = false;
                    break;
                }
                isWhitelisted = true;
            }
        }
        return isWhitelisted;
    }

    private void deletePolicyFiles(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        try {
            Files.delete(this.containerPolicies.remove(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_ID_STR)));
        }
        catch (IOException e) {
            throw new ContainerExecutionException("Unable to delete policy file: " + e);
        }
    }

    static {
        POLICY_ATTR = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-xr-x"));
    }

    static final class NMContainerPolicyUtils {
        static final String POLICY_FILE = "java.policy";
        static final String SECURITY_DEBUG = " -Djava.security.debug=all";
        static final String SECURITY_FLAG = "-Djava.security.manager";
        static final String POLICY_APPEND_FLAG = "-Djava.security.policy=";
        static final String POLICY_FLAG = "-Djava.security.policy==";
        static final String JAVA_CMD = "/bin/java ";
        static final String JVM_SECURITY_CMD = "/bin/java -Djava.security.manager -Djava.security.policy==";
        static final String STRIP_POLICY_FLAG = "-Djava.security.policy=[^ ]+";
        static final String CONTAINS_JAVA_CMD = "\\$" + ApplicationConstants.Environment.JAVA_HOME + "/bin/java " + ".*";
        static final String MULTI_COMMAND_REGEX = "(?s).*((&[^>]|&&)|(\\|{1,2})|(\\|&)|(`[^`]+`)|(\\$\\([^)]+\\))|(;)).*";
        static final String CLEAN_CMD_REGEX = "(-Djava.security.manager)|(-Djava.security.policy=[^ ]+)";
        static final String FILE_PERMISSION_FORMAT = "   permission " + FilePermission.class.getCanonicalName() + " \"%1$s" + "/" + "-\", \"%2$s\";%n";
        static final String HADOOP_HOME_PERMISSION = "%ngrant codeBase \"file:" + Paths.get(System.getProperty("hadoop.home.dir"), new String[0]) + "/" + "-\" {%n  permission " + AllPermission.class.getCanonicalName() + ";%n};%n";
        static final Logger LOG = Logger.getLogger(NMContainerPolicyUtils.class);

        NMContainerPolicyUtils() {
        }

        static void generatePolicyFile(OutputStream policyOutStream, List<String> localDirs, List<String> groupPolicyPaths, Map<Path, List<String>> resources, Configuration conf) throws IOException {
            String policyFilePath = conf.get("yarn.nodemanager.runtime.linux.sandbox-mode.policy");
            String filePermissions = conf.get("yarn.nodemanager.runtime.linux.sandbox-mode.local-dirs.permissions", "read");
            HashSet<String> cacheDirs = new HashSet<String>();
            for (Path path : resources.keySet()) {
                cacheDirs.add(path.getParent().toString());
            }
            if (groupPolicyPaths != null) {
                for (String policyPath : groupPolicyPaths) {
                    Files.copy(Paths.get(policyPath, new String[0]), policyOutStream);
                }
            } else if (policyFilePath == null) {
                IOUtils.copyBytes((InputStream)NMContainerPolicyUtils.class.getResourceAsStream("/java.policy"), (OutputStream)policyOutStream, (Configuration)conf, (boolean)false);
            } else {
                Files.copy(Paths.get(policyFilePath, new String[0]), policyOutStream);
            }
            Formatter filePermissionFormat = new Formatter(policyOutStream, StandardCharsets.UTF_8.name());
            filePermissionFormat.format(HADOOP_HOME_PERMISSION, new Object[0]);
            filePermissionFormat.format("grant {%n", new Object[0]);
            for (String localDir : localDirs) {
                filePermissionFormat.format(FILE_PERMISSION_FORMAT, localDir, filePermissions);
            }
            for (String cacheDir : cacheDirs) {
                filePermissionFormat.format(FILE_PERMISSION_FORMAT, cacheDir, filePermissions);
            }
            filePermissionFormat.format("};%n", new Object[0]);
            filePermissionFormat.flush();
        }

        static void appendSecurityFlags(List<String> commands, Map<String, String> env, java.nio.file.Path policyPath, SandboxMode sandboxMode) throws ContainerExecutionException {
            for (int i = 0; i < commands.size(); ++i) {
                String command = commands.get(i);
                if (NMContainerPolicyUtils.validateJavaHome(env.get(ApplicationConstants.Environment.JAVA_HOME.name())) && command.matches(CONTAINS_JAVA_CMD) && !command.matches(MULTI_COMMAND_REGEX)) {
                    command = command.replaceAll(CLEAN_CMD_REGEX, "");
                    String securityString = JVM_SECURITY_CMD + policyPath + " ";
                    if (LOG.isDebugEnabled()) {
                        securityString = securityString + SECURITY_DEBUG;
                    }
                    commands.set(i, command.replaceFirst(JAVA_CMD, securityString));
                    continue;
                }
                if (sandboxMode == SandboxMode.enforcing) {
                    throw new ContainerExecutionException("Only JVM containers permitted in YARN sandbox mode (enforcing). The following command can not be executed securely: " + command);
                }
                if (sandboxMode != SandboxMode.permissive) continue;
                LOG.warn((Object)("The container will run without the java security manager due to an unsupported container command.  The command will be permitted to run in Sandbox permissive mode: " + command));
            }
        }

        private static boolean validateJavaHome(String containerJavaHome) throws ContainerExecutionException {
            if (System.getenv(ApplicationConstants.Environment.JAVA_HOME.name()) == null) {
                throw new ContainerExecutionException("JAVA_HOME is not set for NodeManager");
            }
            if (containerJavaHome == null) {
                throw new ContainerExecutionException("JAVA_HOME is not set for container");
            }
            return System.getenv(ApplicationConstants.Environment.JAVA_HOME.name()).equals(containerJavaHome);
        }
    }

    public static enum SandboxMode {
        enforcing("enforcing"),
        permissive("permissive"),
        disabled("disabled");

        private final String mode;

        private SandboxMode(String mode) {
            this.mode = mode;
        }

        public static SandboxMode get(String mode) {
            if (SandboxMode.enforcing.mode.equals(mode)) {
                return enforcing;
            }
            if (SandboxMode.permissive.mode.equals(mode)) {
                return permissive;
            }
            return disabled;
        }

        public String toString() {
            return this.mode;
        }
    }
}

