/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerClient;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerInspectCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;

public final class DockerCommandExecutor {
    private static final Log LOG = LogFactory.getLog(DockerCommandExecutor.class);

    private DockerCommandExecutor() {
    }

    public static String executeDockerCommand(DockerCommand dockerCommand, String containerId, Map<String, String> env, Configuration conf, PrivilegedOperationExecutor privilegedOperationExecutor, boolean disableFailureLogging) throws ContainerExecutionException {
        DockerClient dockerClient = new DockerClient(conf);
        String commandFile = dockerClient.writeCommandToTempFile(dockerCommand, containerId);
        PrivilegedOperation dockerOp = new PrivilegedOperation(PrivilegedOperation.OperationType.RUN_DOCKER_CMD);
        dockerOp.appendArgs(commandFile);
        if (disableFailureLogging) {
            dockerOp.disableFailureLogging();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running docker command: " + dockerCommand.getCommandWithArguments()));
        }
        try {
            String result = privilegedOperationExecutor.executePrivilegedOperation(null, dockerOp, null, env, true, false);
            if (result != null && !result.isEmpty()) {
                result = result.trim();
            }
            return result;
        }
        catch (PrivilegedOperationException e) {
            throw new ContainerExecutionException("Docker operation failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    public static DockerContainerStatus getContainerStatus(String containerId, Configuration conf, PrivilegedOperationExecutor privilegedOperationExecutor) {
        try {
            String currentContainerStatus = DockerCommandExecutor.executeStatusCommand(containerId, conf, privilegedOperationExecutor);
            DockerContainerStatus dockerContainerStatus = currentContainerStatus == null ? DockerContainerStatus.UNKNOWN : (currentContainerStatus.equals(DockerContainerStatus.CREATED.getName()) ? DockerContainerStatus.CREATED : (currentContainerStatus.equals(DockerContainerStatus.RUNNING.getName()) ? DockerContainerStatus.RUNNING : (currentContainerStatus.equals(DockerContainerStatus.STOPPED.getName()) ? DockerContainerStatus.STOPPED : (currentContainerStatus.equals(DockerContainerStatus.RESTARTING.getName()) ? DockerContainerStatus.RESTARTING : (currentContainerStatus.equals(DockerContainerStatus.REMOVING.getName()) ? DockerContainerStatus.REMOVING : (currentContainerStatus.equals(DockerContainerStatus.DEAD.getName()) ? DockerContainerStatus.DEAD : (currentContainerStatus.equals(DockerContainerStatus.EXITED.getName()) ? DockerContainerStatus.EXITED : (currentContainerStatus.equals(DockerContainerStatus.NONEXISTENT.getName()) ? DockerContainerStatus.NONEXISTENT : DockerContainerStatus.UNKNOWN))))))));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Container Status: " + dockerContainerStatus.getName() + " ContainerId: " + containerId));
            }
            return dockerContainerStatus;
        }
        catch (ContainerExecutionException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Container Status: " + DockerContainerStatus.NONEXISTENT.getName() + " ContainerId: " + containerId));
            }
            return DockerContainerStatus.NONEXISTENT;
        }
    }

    private static String executeStatusCommand(String containerId, Configuration conf, PrivilegedOperationExecutor privilegedOperationExecutor) throws ContainerExecutionException {
        DockerInspectCommand dockerInspectCommand = new DockerInspectCommand(containerId).getContainerStatus();
        try {
            return DockerCommandExecutor.executeDockerCommand(dockerInspectCommand, containerId, null, conf, privilegedOperationExecutor, false);
        }
        catch (ContainerExecutionException e) {
            throw new ContainerExecutionException((Throwable)((Object)e));
        }
    }

    public static enum DockerContainerStatus {
        CREATED("created"),
        RUNNING("running"),
        STOPPED("stopped"),
        RESTARTING("restarting"),
        REMOVING("removing"),
        DEAD("dead"),
        EXITED("exited"),
        NONEXISTENT("nonexistent"),
        UNKNOWN("unknown");

        private final String name;

        private DockerContainerStatus(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

