/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NodeManagerHardwareUtils {
    private static final Log LOG = LogFactory.getLog(NodeManagerHardwareUtils.class);

    private static boolean isHardwareDetectionEnabled(Configuration conf) {
        return conf.getBoolean("yarn.nodemanager.resource.detect-hardware-capabilities", false);
    }

    public static int getNodeCPUs(Configuration conf) {
        ResourceCalculatorPlugin plugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin(null, (Configuration)conf);
        return NodeManagerHardwareUtils.getNodeCPUs(plugin, conf);
    }

    public static int getNodeCPUs(ResourceCalculatorPlugin plugin, Configuration conf) {
        int numProcessors = plugin.getNumProcessors();
        boolean countLogicalCores = conf.getBoolean("yarn.nodemanager.resource.count-logical-processors-as-cores", false);
        if (!countLogicalCores) {
            numProcessors = plugin.getNumCores();
        }
        return numProcessors;
    }

    public static float getContainersCPUs(Configuration conf) {
        ResourceCalculatorPlugin plugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin(null, (Configuration)conf);
        return NodeManagerHardwareUtils.getContainersCPUs(plugin, conf);
    }

    public static float getContainersCPUs(ResourceCalculatorPlugin plugin, Configuration conf) {
        int numProcessors = NodeManagerHardwareUtils.getNodeCPUs(plugin, conf);
        int nodeCpuPercentage = NodeManagerHardwareUtils.getNodeCpuPercentage(conf);
        return (float)(nodeCpuPercentage * numProcessors) / 100.0f;
    }

    public static int getNodeCpuPercentage(Configuration conf) {
        int nodeCpuPercentage = Math.min(conf.getInt("yarn.nodemanager.resource.percentage-physical-cpu-limit", 100), 100);
        if ((nodeCpuPercentage = Math.max(0, nodeCpuPercentage)) == 0) {
            String message = "Illegal value for yarn.nodemanager.resource.percentage-physical-cpu-limit. Value cannot be less than or equal to 0.";
            throw new IllegalArgumentException(message);
        }
        return nodeCpuPercentage;
    }

    private static int getConfiguredVCores(Configuration conf) {
        int cores = conf.getInt("yarn.nodemanager.resource.cpu-vcores", 8);
        if (cores == -1) {
            cores = 8;
        }
        return cores;
    }

    public static int getVCores(Configuration conf) {
        if (!NodeManagerHardwareUtils.isHardwareDetectionEnabled(conf)) {
            return NodeManagerHardwareUtils.getConfiguredVCores(conf);
        }
        ResourceCalculatorPlugin plugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin(null, (Configuration)conf);
        if (plugin == null) {
            return NodeManagerHardwareUtils.getConfiguredVCores(conf);
        }
        return NodeManagerHardwareUtils.getVCoresInternal(plugin, conf);
    }

    public static int getVCores(ResourceCalculatorPlugin plugin, Configuration conf) {
        if (!NodeManagerHardwareUtils.isHardwareDetectionEnabled(conf) || plugin == null) {
            return NodeManagerHardwareUtils.getConfiguredVCores(conf);
        }
        return NodeManagerHardwareUtils.getVCoresInternal(plugin, conf);
    }

    private static int getVCoresInternal(ResourceCalculatorPlugin plugin, Configuration conf) {
        int cores = conf.getInt("yarn.nodemanager.resource.cpu-vcores", -1);
        if (cores == -1) {
            float physicalCores = NodeManagerHardwareUtils.getContainersCPUs(plugin, conf);
            float multiplier = conf.getFloat("yarn.nodemanager.resource.pcores-vcores-multiplier", 1.0f);
            if (multiplier > 0.0f) {
                float tmp = physicalCores * multiplier;
                cores = tmp > 0.0f && tmp < 1.0f ? 1 : (int)tmp;
            } else {
                String message = "Illegal value for yarn.nodemanager.resource.pcores-vcores-multiplier. Value must be greater than 0.";
                throw new IllegalArgumentException(message);
            }
        }
        if (cores <= 0) {
            String message = "Illegal value for yarn.nodemanager.resource.cpu-vcores. Value must be greater than 0.";
            throw new IllegalArgumentException(message);
        }
        return cores;
    }

    private static int getConfiguredMemoryMB(Configuration conf) {
        int memoryMb = conf.getInt("yarn.nodemanager.resource.memory-mb", 8192);
        if (memoryMb == -1) {
            memoryMb = 8192;
        }
        return memoryMb;
    }

    public static int getContainerMemoryMB(Configuration conf) {
        if (!NodeManagerHardwareUtils.isHardwareDetectionEnabled(conf)) {
            return NodeManagerHardwareUtils.getConfiguredMemoryMB(conf);
        }
        ResourceCalculatorPlugin plugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin(null, (Configuration)conf);
        if (plugin == null) {
            return NodeManagerHardwareUtils.getConfiguredMemoryMB(conf);
        }
        return NodeManagerHardwareUtils.getContainerMemoryMBInternal(plugin, conf);
    }

    public static int getContainerMemoryMB(ResourceCalculatorPlugin plugin, Configuration conf) {
        if (!NodeManagerHardwareUtils.isHardwareDetectionEnabled(conf) || plugin == null) {
            return NodeManagerHardwareUtils.getConfiguredMemoryMB(conf);
        }
        return NodeManagerHardwareUtils.getContainerMemoryMBInternal(plugin, conf);
    }

    private static int getContainerMemoryMBInternal(ResourceCalculatorPlugin plugin, Configuration conf) {
        int memoryMb = conf.getInt("yarn.nodemanager.resource.memory-mb", -1);
        if (memoryMb == -1) {
            int physicalMemoryMB = (int)(plugin.getPhysicalMemorySize() / 0x100000L);
            int hadoopHeapSizeMB = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
            int containerPhysicalMemoryMB = (int)(0.8f * (float)(physicalMemoryMB - 2 * hadoopHeapSizeMB));
            int reservedMemoryMB = conf.getInt("yarn.nodemanager.resource.system-reserved-memory-mb", -1);
            if (reservedMemoryMB != -1) {
                containerPhysicalMemoryMB = physicalMemoryMB - reservedMemoryMB;
            }
            if (containerPhysicalMemoryMB <= 0) {
                LOG.error((Object)("Calculated memory for YARN containers is too low. Node memory is " + physicalMemoryMB + " MB, system reserved memory is " + reservedMemoryMB + " MB."));
            }
            memoryMb = containerPhysicalMemoryMB = Math.max(containerPhysicalMemoryMB, 0);
        }
        if (memoryMb <= 0) {
            String message = "Illegal value for yarn.nodemanager.resource.memory-mb. Value must be greater than 0.";
            throw new IllegalArgumentException(message);
        }
        return memoryMb;
    }
}

