/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.amrmproxy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.PreemptionContract;
import org.apache.hadoop.yarn.api.records.PreemptionMessage;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.StrictPreemptionContract;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.failover.FederationProxyProviderUtil;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.FederationAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyApplicationContext;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AbstractRequestInterceptor;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.RequestInterceptor;
import org.apache.hadoop.yarn.server.uam.UnmanagedAMPoolManager;
import org.apache.hadoop.yarn.server.utils.AMRMClientUtils;
import org.apache.hadoop.yarn.server.utils.YarnServerSecurityUtils;
import org.apache.hadoop.yarn.util.AsyncCallback;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationInterceptor
extends AbstractRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(FederationInterceptor.class);
    private ApplicationMasterProtocol homeRM;
    private SubClusterId homeSubClusterId;
    private UnmanagedAMPoolManager uamPool;
    private ExecutorService threadpool;
    private Map<SubClusterId, List<AllocateResponse>> asyncResponseSink;
    private Map<ContainerId, SubClusterId> containerIdToSubClusterIdMap = new ConcurrentHashMap<ContainerId, SubClusterId>();
    private RegisterApplicationMasterRequest amRegistrationRequest = null;
    private RegisterApplicationMasterResponse amRegistrationResponse = null;
    private FederationStateStoreFacade federationFacade;
    private SubClusterResolver subClusterResolver;
    private FederationAMRMProxyPolicy policyInterpreter;
    private UserGroupInformation appOwner;

    public FederationInterceptor() {
        this.asyncResponseSink = new ConcurrentHashMap<SubClusterId, List<AllocateResponse>>();
        this.threadpool = Executors.newCachedThreadPool();
        this.uamPool = this.createUnmanagedAMPoolManager(this.threadpool);
    }

    @Override
    public void init(AMRMProxyApplicationContext appContext) {
        super.init(appContext);
        LOG.info("Initializing Federation Interceptor");
        Configuration conf = appContext.getConf();
        if (conf == null) {
            conf = this.getConf();
        } else {
            this.setConf(conf);
        }
        try {
            this.appOwner = UserGroupInformation.createProxyUser((String)appContext.getUser(), (UserGroupInformation)UserGroupInformation.getCurrentUser());
        }
        catch (Exception ex) {
            throw new YarnRuntimeException((Throwable)ex);
        }
        this.homeSubClusterId = SubClusterId.newInstance((String)YarnConfiguration.getClusterId((Configuration)conf));
        this.homeRM = this.createHomeRMProxy(appContext);
        this.federationFacade = FederationStateStoreFacade.getInstance();
        this.subClusterResolver = this.federationFacade.getSubClusterResolver();
        this.policyInterpreter = null;
        this.uamPool.init(conf);
        this.uamPool.start();
    }

    public synchronized RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        if (this.amRegistrationRequest != null) {
            if (!this.amRegistrationRequest.equals(request)) {
                throw new YarnException("AM should not call registerApplicationMaster with a different request body");
            }
        } else {
            this.amRegistrationRequest = request;
        }
        if (this.amRegistrationResponse != null) {
            return this.amRegistrationResponse;
        }
        this.amRegistrationResponse = this.homeRM.registerApplicationMaster(request);
        String queue = this.amRegistrationResponse.getQueue();
        if (queue == null) {
            LOG.warn("Received null queue for application " + this.getApplicationContext().getApplicationAttemptId().getApplicationId() + " from home sub-cluster. Will use default queue name " + "default" + " for getting AMRMProxyPolicy");
        } else {
            LOG.info("Application " + this.getApplicationContext().getApplicationAttemptId().getApplicationId() + " belongs to queue " + queue);
        }
        try {
            this.policyInterpreter = FederationPolicyUtils.loadAMRMPolicy((String)queue, (FederationAMRMProxyPolicy)this.policyInterpreter, (Configuration)this.getConf(), (FederationStateStoreFacade)this.federationFacade, (SubClusterId)this.homeSubClusterId);
        }
        catch (FederationPolicyInitializationException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        return this.amRegistrationResponse;
    }

    public AllocateResponse allocate(AllocateRequest request) throws YarnException {
        Preconditions.checkArgument((this.policyInterpreter != null ? 1 : 0) != 0, (Object)"Allocate should be called after registerApplicationMaster");
        try {
            Map<SubClusterId, AllocateRequest> requests = this.splitAllocateRequest(request);
            Registrations newRegistrations = this.sendRequestsToSecondaryResourceManagers(requests);
            AllocateResponse homeResponse = AMRMClientUtils.allocateWithReRegister((AllocateRequest)requests.get(this.homeSubClusterId), (ApplicationMasterProtocol)this.homeRM, (RegisterApplicationMasterRequest)this.amRegistrationRequest, (ApplicationAttemptId)this.getApplicationContext().getApplicationAttemptId());
            try {
                this.policyInterpreter.notifyOfResponse(this.homeSubClusterId, homeResponse);
            }
            catch (YarnException e) {
                LOG.warn("notifyOfResponse for policy failed for home sub-cluster " + this.homeSubClusterId, (Throwable)e);
            }
            if (homeResponse.getAMRMToken() != null) {
                LOG.debug("Received new AMRMToken");
                YarnServerSecurityUtils.updateAMRMToken((Token)homeResponse.getAMRMToken(), (UserGroupInformation)this.appOwner, (Configuration)this.getConf());
            }
            homeResponse = this.mergeAllocateResponses(homeResponse);
            if (!FederationInterceptor.isNullOrEmpty(newRegistrations.getSuccessfulRegistrations())) {
                homeResponse = this.mergeRegistrationResponses(homeResponse, newRegistrations.getSuccessfulRegistrations());
            }
            return homeResponse;
        }
        catch (IOException ex) {
            LOG.error("Exception encountered while processing heart beat", (Throwable)ex);
            throw new YarnException((Throwable)ex);
        }
    }

    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        boolean failedToUnRegister = false;
        ExecutorCompletionService<FinishApplicationMasterResponseInfo> compSvc = null;
        Set subClusterIds = this.uamPool.getAllUAMIds();
        if (subClusterIds.size() > 0) {
            final FinishApplicationMasterRequest finishRequest = request;
            compSvc = new ExecutorCompletionService<FinishApplicationMasterResponseInfo>(this.threadpool);
            LOG.info("Sending finish application request to {} sub-cluster RMs", (Object)subClusterIds.size());
            for (final String subClusterId : subClusterIds) {
                compSvc.submit(new Callable<FinishApplicationMasterResponseInfo>(){

                    @Override
                    public FinishApplicationMasterResponseInfo call() throws Exception {
                        LOG.info("Sending finish application request to RM {}", (Object)subClusterId);
                        FinishApplicationMasterResponse uamResponse = null;
                        try {
                            uamResponse = FederationInterceptor.this.uamPool.finishApplicationMaster(subClusterId, finishRequest);
                        }
                        catch (Throwable e) {
                            LOG.warn("Failed to finish unmanaged application master: RM address: " + subClusterId + " ApplicationId: " + FederationInterceptor.this.getApplicationContext().getApplicationAttemptId(), e);
                        }
                        return new FinishApplicationMasterResponseInfo(uamResponse, subClusterId);
                    }
                });
            }
        }
        FinishApplicationMasterResponse homeResponse = AMRMClientUtils.finishAMWithReRegister((FinishApplicationMasterRequest)request, (ApplicationMasterProtocol)this.homeRM, (RegisterApplicationMasterRequest)this.amRegistrationRequest, (ApplicationAttemptId)this.getApplicationContext().getApplicationAttemptId());
        if (subClusterIds.size() > 0) {
            LOG.info("Waiting for finish application response from {} sub-cluster RMs", (Object)subClusterIds.size());
            for (int i = 0; i < subClusterIds.size(); ++i) {
                try {
                    Future future = compSvc.take();
                    FinishApplicationMasterResponseInfo uamResponse = (FinishApplicationMasterResponseInfo)future.get();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received finish application response from RM: " + uamResponse.getSubClusterId());
                    }
                    if (uamResponse.getResponse() != null && uamResponse.getResponse().getIsUnregistered()) continue;
                    failedToUnRegister = true;
                    continue;
                }
                catch (Throwable e) {
                    failedToUnRegister = true;
                    LOG.warn("Failed to finish unmanaged application master:  ApplicationId: " + this.getApplicationContext().getApplicationAttemptId(), e);
                }
            }
        }
        if (failedToUnRegister) {
            homeResponse.setIsUnregistered(false);
        }
        return homeResponse;
    }

    @Override
    public void setNextInterceptor(RequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on FederationInterceptor. It should always be used as the last interceptor in the chain");
    }

    @Override
    public void shutdown() {
        if (this.uamPool != null) {
            this.uamPool.stop();
        }
        if (this.threadpool != null) {
            try {
                this.threadpool.shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.threadpool = null;
        }
        super.shutdown();
    }

    @VisibleForTesting
    protected UnmanagedAMPoolManager createUnmanagedAMPoolManager(ExecutorService threadPool) {
        return new UnmanagedAMPoolManager(threadPool);
    }

    protected ApplicationMasterProtocol createHomeRMProxy(AMRMProxyApplicationContext appContext) {
        try {
            return (ApplicationMasterProtocol)FederationProxyProviderUtil.createRMProxy((Configuration)appContext.getConf(), ApplicationMasterProtocol.class, (SubClusterId)this.homeSubClusterId, (UserGroupInformation)this.appOwner, appContext.getAMRMToken());
        }
        catch (Exception ex) {
            throw new YarnRuntimeException((Throwable)ex);
        }
    }

    private SubClusterId getSubClusterForNode(String nodeName) {
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.subClusterResolver.getSubClusterForNode(nodeName);
        }
        catch (YarnException e) {
            LOG.error("Failed to resolve sub-cluster for node " + nodeName + ", skipping this node", (Throwable)e);
            return null;
        }
        if (subClusterId == null) {
            LOG.error("Failed to resolve sub-cluster for node {}, skipping this node", (Object)nodeName);
            return null;
        }
        return subClusterId;
    }

    private Map<SubClusterId, AllocateRequest> splitAllocateRequest(AllocateRequest request) throws YarnException {
        AllocateRequest newRequest;
        HashMap<SubClusterId, AllocateRequest> requestMap = new HashMap<SubClusterId, AllocateRequest>();
        FederationInterceptor.findOrCreateAllocateRequestForSubCluster(this.homeSubClusterId, request, requestMap);
        Set subClusterIds = this.uamPool.getAllUAMIds();
        for (Object subClusterId2 : subClusterIds) {
            FederationInterceptor.findOrCreateAllocateRequestForSubCluster(SubClusterId.newInstance((String)subClusterId2), request, requestMap);
        }
        if (!FederationInterceptor.isNullOrEmpty(request.getAskList())) {
            Map<SubClusterId, List<ResourceRequest>> asks = this.splitResourceRequests(request.getAskList());
            for (Map.Entry entry : asks.entrySet()) {
                newRequest = FederationInterceptor.findOrCreateAllocateRequestForSubCluster((SubClusterId)entry.getKey(), request, requestMap);
                newRequest.getAskList().addAll((Collection)entry.getValue());
            }
        }
        if (request.getResourceBlacklistRequest() != null && !FederationInterceptor.isNullOrEmpty(request.getResourceBlacklistRequest().getBlacklistAdditions())) {
            for (String resourceName : request.getResourceBlacklistRequest().getBlacklistAdditions()) {
                SubClusterId subClusterId = this.getSubClusterForNode(resourceName);
                if (subClusterId == null) continue;
                newRequest = FederationInterceptor.findOrCreateAllocateRequestForSubCluster(subClusterId, request, requestMap);
                newRequest.getResourceBlacklistRequest().getBlacklistAdditions().add(resourceName);
            }
        }
        if (request.getResourceBlacklistRequest() != null && !FederationInterceptor.isNullOrEmpty(request.getResourceBlacklistRequest().getBlacklistRemovals())) {
            for (String resourceName : request.getResourceBlacklistRequest().getBlacklistRemovals()) {
                SubClusterId subClusterId = this.getSubClusterForNode(resourceName);
                if (subClusterId == null) continue;
                newRequest = FederationInterceptor.findOrCreateAllocateRequestForSubCluster(subClusterId, request, requestMap);
                newRequest.getResourceBlacklistRequest().getBlacklistRemovals().add(resourceName);
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(request.getReleaseList())) {
            for (ContainerId cid : request.getReleaseList()) {
                if (!this.warnIfNotExists(cid, "release")) continue;
                SubClusterId subClusterId = this.containerIdToSubClusterIdMap.get(cid);
                newRequest = (AllocateRequest)requestMap.get(subClusterId);
                newRequest.getReleaseList().add(cid);
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(request.getUpdateRequests())) {
            for (UpdateContainerRequest ucr : request.getUpdateRequests()) {
                if (!this.warnIfNotExists(ucr.getContainerId(), "update")) continue;
                SubClusterId subClusterId = this.containerIdToSubClusterIdMap.get(ucr.getContainerId());
                newRequest = (AllocateRequest)requestMap.get(subClusterId);
                newRequest.getUpdateRequests().add(ucr);
            }
        }
        return requestMap;
    }

    private Registrations sendRequestsToSecondaryResourceManagers(Map<SubClusterId, AllocateRequest> requests) throws YarnException, IOException {
        Registrations registrations = this.registerWithNewSubClusters(requests.keySet());
        for (Map.Entry<SubClusterId, AllocateRequest> entry : requests.entrySet()) {
            final SubClusterId subClusterId = entry.getKey();
            if (subClusterId.equals((Object)this.homeSubClusterId)) continue;
            if (!this.uamPool.hasUAMId(subClusterId.getId())) {
                LOG.warn("Unmanaged AM registration not found for sub-cluster {}", (Object)subClusterId);
                continue;
            }
            this.uamPool.allocateAsync(subClusterId.getId(), entry.getValue(), (AsyncCallback)new AsyncCallback<AllocateResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void callback(AllocateResponse response) {
                    Map map = FederationInterceptor.this.asyncResponseSink;
                    synchronized (map) {
                        List<AllocateResponse> responses = null;
                        if (FederationInterceptor.this.asyncResponseSink.containsKey(subClusterId)) {
                            responses = (List)FederationInterceptor.this.asyncResponseSink.get(subClusterId);
                        } else {
                            responses = new ArrayList();
                            FederationInterceptor.this.asyncResponseSink.put(subClusterId, responses);
                        }
                        responses.add(response);
                    }
                    try {
                        FederationInterceptor.this.policyInterpreter.notifyOfResponse(subClusterId, response);
                    }
                    catch (YarnException e) {
                        LOG.warn("notifyOfResponse for policy failed for home sub-cluster " + subClusterId, (Throwable)e);
                    }
                }
            });
        }
        return registrations;
    }

    private Registrations registerWithNewSubClusters(Set<SubClusterId> subClusterSet) throws IOException {
        ArrayList<SubClusterId> failedRegistrations = new ArrayList<SubClusterId>();
        HashMap<SubClusterId, RegisterApplicationMasterResponse> successfulRegistrations = new HashMap<SubClusterId, RegisterApplicationMasterResponse>();
        ArrayList<String> newSubClusters = new ArrayList<String>();
        for (SubClusterId subClusterId : subClusterSet) {
            if (subClusterId.equals((Object)this.homeSubClusterId) || this.uamPool.hasUAMId(subClusterId.getId())) continue;
            newSubClusters.add(subClusterId.getId());
        }
        if (newSubClusters.size() > 0) {
            final RegisterApplicationMasterRequest registerRequest = this.amRegistrationRequest;
            final AMRMProxyApplicationContext appContext = this.getApplicationContext();
            ExecutorCompletionService<RegisterApplicationMasterResponseInfo> completionService = new ExecutorCompletionService<RegisterApplicationMasterResponseInfo>(this.threadpool);
            for (final String subClusterId : newSubClusters) {
                completionService.submit(new Callable<RegisterApplicationMasterResponseInfo>(){

                    @Override
                    public RegisterApplicationMasterResponseInfo call() throws Exception {
                        YarnConfiguration config = new YarnConfiguration(FederationInterceptor.this.getConf());
                        FederationProxyProviderUtil.updateConfForFederation((Configuration)config, (String)subClusterId);
                        RegisterApplicationMasterResponse uamResponse = null;
                        try {
                            uamResponse = FederationInterceptor.this.uamPool.createAndRegisterNewUAM(subClusterId, registerRequest, (Configuration)config, appContext.getApplicationAttemptId().getApplicationId(), FederationInterceptor.this.amRegistrationResponse.getQueue(), appContext.getUser(), FederationInterceptor.this.homeSubClusterId.toString());
                        }
                        catch (Throwable e) {
                            LOG.error("Failed to register application master: " + subClusterId + " Application: " + appContext.getApplicationAttemptId(), e);
                        }
                        return new RegisterApplicationMasterResponseInfo(uamResponse, SubClusterId.newInstance((String)subClusterId));
                    }
                });
            }
            for (int i = 0; i < newSubClusters.size(); ++i) {
                try {
                    Future future = completionService.take();
                    RegisterApplicationMasterResponseInfo uamResponse = (RegisterApplicationMasterResponseInfo)future.get();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received register application response from RM: " + uamResponse.getSubClusterId());
                    }
                    if (uamResponse.getResponse() == null) {
                        failedRegistrations.add(uamResponse.getSubClusterId());
                        continue;
                    }
                    LOG.info("Successfully registered unmanaged application master: " + uamResponse.getSubClusterId() + " ApplicationId: " + this.getApplicationContext().getApplicationAttemptId());
                    successfulRegistrations.put(uamResponse.getSubClusterId(), uamResponse.getResponse());
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Failed to register unmanaged application master:  ApplicationId: " + this.getApplicationContext().getApplicationAttemptId(), (Throwable)e);
                }
            }
        }
        return new Registrations(successfulRegistrations, failedRegistrations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllocateResponse mergeAllocateResponses(AllocateResponse homeResponse) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Remove containers: " + homeResponse.getCompletedContainersStatuses());
            LOG.debug("Adding containers: " + homeResponse.getAllocatedContainers());
        }
        this.removeFinishedContainersFromCache(homeResponse.getCompletedContainersStatuses());
        this.cacheAllocatedContainers(homeResponse.getAllocatedContainers(), this.homeSubClusterId);
        Map<SubClusterId, List<AllocateResponse>> map = this.asyncResponseSink;
        synchronized (map) {
            for (Map.Entry<SubClusterId, List<AllocateResponse>> entry : this.asyncResponseSink.entrySet()) {
                SubClusterId subClusterId = entry.getKey();
                List<AllocateResponse> responses = entry.getValue();
                if (responses.size() <= 0) continue;
                for (AllocateResponse response : responses) {
                    this.removeFinishedContainersFromCache(response.getCompletedContainersStatuses());
                    this.cacheAllocatedContainers(response.getAllocatedContainers(), subClusterId);
                    this.mergeAllocateResponse(homeResponse, response, subClusterId);
                }
                responses.clear();
            }
        }
        return homeResponse;
    }

    private void removeFinishedContainersFromCache(List<ContainerStatus> finishedContainers) {
        for (ContainerStatus container : finishedContainers) {
            if (!this.containerIdToSubClusterIdMap.containsKey(container.getContainerId())) continue;
            this.containerIdToSubClusterIdMap.remove(container.getContainerId());
        }
    }

    private AllocateResponse mergeRegistrationResponses(AllocateResponse homeResponse, Map<SubClusterId, RegisterApplicationMasterResponse> registrations) {
        for (Map.Entry<SubClusterId, RegisterApplicationMasterResponse> entry : registrations.entrySet()) {
            RegisterApplicationMasterResponse registration = entry.getValue();
            if (!FederationInterceptor.isNullOrEmpty(registration.getContainersFromPreviousAttempts())) {
                List tempContainers = homeResponse.getAllocatedContainers();
                if (!FederationInterceptor.isNullOrEmpty(tempContainers)) {
                    tempContainers.addAll(registration.getContainersFromPreviousAttempts());
                    homeResponse.setAllocatedContainers(tempContainers);
                } else {
                    homeResponse.setAllocatedContainers(registration.getContainersFromPreviousAttempts());
                }
                this.cacheAllocatedContainers(registration.getContainersFromPreviousAttempts(), entry.getKey());
            }
            if (FederationInterceptor.isNullOrEmpty(registration.getNMTokensFromPreviousAttempts())) continue;
            List tempTokens = homeResponse.getNMTokens();
            if (!FederationInterceptor.isNullOrEmpty(tempTokens)) {
                tempTokens.addAll(registration.getNMTokensFromPreviousAttempts());
                homeResponse.setNMTokens(tempTokens);
                continue;
            }
            homeResponse.setNMTokens(registration.getNMTokensFromPreviousAttempts());
        }
        return homeResponse;
    }

    private void mergeAllocateResponse(AllocateResponse homeResponse, AllocateResponse otherResponse, SubClusterId otherRMAddress) {
        if (!FederationInterceptor.isNullOrEmpty(otherResponse.getAllocatedContainers())) {
            if (!FederationInterceptor.isNullOrEmpty(homeResponse.getAllocatedContainers())) {
                homeResponse.getAllocatedContainers().addAll(otherResponse.getAllocatedContainers());
            } else {
                homeResponse.setAllocatedContainers(otherResponse.getAllocatedContainers());
            }
        }
        if (otherResponse.getAvailableResources() != null) {
            if (homeResponse.getAvailableResources() != null) {
                homeResponse.setAvailableResources(Resources.add((Resource)homeResponse.getAvailableResources(), (Resource)otherResponse.getAvailableResources()));
            } else {
                homeResponse.setAvailableResources(otherResponse.getAvailableResources());
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(otherResponse.getCompletedContainersStatuses())) {
            if (!FederationInterceptor.isNullOrEmpty(homeResponse.getCompletedContainersStatuses())) {
                homeResponse.getCompletedContainersStatuses().addAll(otherResponse.getCompletedContainersStatuses());
            } else {
                homeResponse.setCompletedContainersStatuses(otherResponse.getCompletedContainersStatuses());
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(otherResponse.getUpdatedNodes())) {
            if (!FederationInterceptor.isNullOrEmpty(homeResponse.getUpdatedNodes())) {
                homeResponse.getUpdatedNodes().addAll(otherResponse.getUpdatedNodes());
            } else {
                homeResponse.setUpdatedNodes(otherResponse.getUpdatedNodes());
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(otherResponse.getNMTokens())) {
            if (!FederationInterceptor.isNullOrEmpty(homeResponse.getNMTokens())) {
                homeResponse.getNMTokens().addAll(otherResponse.getNMTokens());
            } else {
                homeResponse.setNMTokens(otherResponse.getNMTokens());
            }
        }
        PreemptionMessage homePreempMessage = homeResponse.getPreemptionMessage();
        PreemptionMessage otherPreempMessage = otherResponse.getPreemptionMessage();
        if (homePreempMessage == null && otherPreempMessage != null) {
            homeResponse.setPreemptionMessage(otherPreempMessage);
        }
        if (homePreempMessage != null && otherPreempMessage != null) {
            PreemptionContract par1 = homePreempMessage.getContract();
            PreemptionContract par2 = otherPreempMessage.getContract();
            if (par1 == null && par2 != null) {
                homePreempMessage.setContract(par2);
            }
            if (par1 != null && par2 != null) {
                par1.getResourceRequest().addAll(par2.getResourceRequest());
                par2.getContainers().addAll(par2.getContainers());
            }
            StrictPreemptionContract spar1 = homePreempMessage.getStrictContract();
            StrictPreemptionContract spar2 = otherPreempMessage.getStrictContract();
            if (spar1 == null && spar2 != null) {
                homePreempMessage.setStrictContract(spar2);
            }
            if (spar1 != null && spar2 != null) {
                spar1.getContainers().addAll(spar2.getContainers());
            }
        }
    }

    private void cacheAllocatedContainers(List<Container> containers, SubClusterId subClusterId) {
        for (Container container : containers) {
            if (this.containerIdToSubClusterIdMap.containsKey(container.getId())) {
                SubClusterId existingSubClusterId = this.containerIdToSubClusterIdMap.get(container.getId());
                if (existingSubClusterId.equals((Object)subClusterId)) {
                    LOG.warn("Duplicate containerID: {} found in the allocated containers from same sub-cluster: {}, so ignoring.", (Object)container.getId(), (Object)subClusterId);
                } else {
                    throw new YarnRuntimeException("Duplicate containerID found in the allocated containers. This can happen if the RM epoch is not configured properly. ContainerId: " + container.getId().toString() + " ApplicationId: " + this.getApplicationContext().getApplicationAttemptId() + " From RM: " + subClusterId + " . Previous container was from sub-cluster: " + existingSubClusterId);
                }
            }
            this.containerIdToSubClusterIdMap.put(container.getId(), subClusterId);
        }
    }

    private static AllocateRequest findOrCreateAllocateRequestForSubCluster(SubClusterId subClusterId, AllocateRequest originalAMRequest, Map<SubClusterId, AllocateRequest> requestMap) {
        AllocateRequest newRequest = null;
        if (requestMap.containsKey(subClusterId)) {
            newRequest = requestMap.get(subClusterId);
        } else {
            newRequest = FederationInterceptor.createAllocateRequest();
            newRequest.setResponseId(originalAMRequest.getResponseId());
            newRequest.setProgress(originalAMRequest.getProgress());
            requestMap.put(subClusterId, newRequest);
        }
        return newRequest;
    }

    private static AllocateRequest createAllocateRequest() {
        AllocateRequest request = AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null);
        request.setAskList(new ArrayList());
        request.setReleaseList(new ArrayList());
        ResourceBlacklistRequest blackList = ResourceBlacklistRequest.newInstance(null, null);
        blackList.setBlacklistAdditions(new ArrayList());
        blackList.setBlacklistRemovals(new ArrayList());
        request.setResourceBlacklistRequest(blackList);
        request.setUpdateRequests(new ArrayList());
        return request;
    }

    private boolean warnIfNotExists(ContainerId containerId, String actionName) {
        if (!this.containerIdToSubClusterIdMap.containsKey(containerId)) {
            LOG.error("AM is trying to {} a container {} that does not exist. ", (Object)actionName, (Object)containerId.toString());
            return false;
        }
        return true;
    }

    protected Map<SubClusterId, List<ResourceRequest>> splitResourceRequests(List<ResourceRequest> askList) throws YarnException {
        return this.policyInterpreter.splitResourceRequests(askList);
    }

    @VisibleForTesting
    public int getUnmanagedAMPoolSize() {
        return this.uamPool.getAllUAMIds().size();
    }

    public static <T> boolean isNullOrEmpty(Collection<T> c) {
        return c == null || c.size() == 0;
    }

    public static <T1, T2> boolean isNullOrEmpty(Map<T1, T2> c) {
        return c == null || c.size() == 0;
    }

    private static class Registrations {
        private Map<SubClusterId, RegisterApplicationMasterResponse> successfulRegistrations;
        private List<SubClusterId> failedRegistrations;

        Registrations(Map<SubClusterId, RegisterApplicationMasterResponse> successfulRegistrations, List<SubClusterId> failedRegistrations) {
            this.successfulRegistrations = successfulRegistrations;
            this.failedRegistrations = failedRegistrations;
        }

        public Map<SubClusterId, RegisterApplicationMasterResponse> getSuccessfulRegistrations() {
            return this.successfulRegistrations;
        }

        public List<SubClusterId> getFailedRegistrations() {
            return this.failedRegistrations;
        }
    }

    private static class FinishApplicationMasterResponseInfo {
        private FinishApplicationMasterResponse response;
        private String subClusterId;

        FinishApplicationMasterResponseInfo(FinishApplicationMasterResponse response, String subClusterId) {
            this.response = response;
            this.subClusterId = subClusterId;
        }

        public FinishApplicationMasterResponse getResponse() {
            return this.response;
        }

        public String getSubClusterId() {
            return this.subClusterId;
        }
    }

    private static class RegisterApplicationMasterResponseInfo {
        private RegisterApplicationMasterResponse response;
        private SubClusterId subClusterId;

        RegisterApplicationMasterResponseInfo(RegisterApplicationMasterResponse response, SubClusterId subClusterId) {
            this.response = response;
            this.subClusterId = subClusterId;
        }

        public RegisterApplicationMasterResponse getResponse() {
            return this.response;
        }

        public SubClusterId getSubClusterId() {
            return this.subClusterId;
        }
    }
}

