/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerCommand;

public class DockerInspectCommand
extends DockerCommand {
    private static final String INSPECT_COMMAND = "inspect";
    private String commandArguments;

    public DockerInspectCommand(String containerName) {
        super(INSPECT_COMMAND);
        super.addCommandArguments("name", containerName);
    }

    public DockerInspectCommand getContainerStatus() {
        super.addCommandArguments("format", "{{.State.Status}}");
        this.commandArguments = "--format={{.State.Status}}";
        return this;
    }

    public DockerInspectCommand getIpAndHost() {
        super.addCommandArguments("format", "{{range(.NetworkSettings.Networks)}}{{.IPAddress}},{{end}}{{.Config.Hostname}}");
        this.commandArguments = "--format={{range(.NetworkSettings.Networks)}}{{.IPAddress}},{{end}}{{.Config.Hostname}}";
        return this;
    }

    @Override
    public PrivilegedOperation preparePrivilegedOperation(DockerCommand dockerCommand, String containerName, Map<String, String> env, Configuration conf, Context nmContext) {
        PrivilegedOperation dockerOp = new PrivilegedOperation(PrivilegedOperation.OperationType.INSPECT_DOCKER_CONTAINER);
        dockerOp.appendArgs(this.commandArguments, containerName);
        return dockerOp;
    }
}

