/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerClient;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerCommandExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerInspectCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerKillCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerRmCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerRunCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerStartCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerStopCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerVolumeCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.DockerCommandPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;
import org.apache.hadoop.yarn.util.DockerClientConfigHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DockerLinuxContainerRuntime
implements LinuxContainerRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(DockerLinuxContainerRuntime.class);
    public static final String DOCKER_IMAGE_PATTERN = "^(([a-zA-Z0-9.-]+)(:\\d+)?/)?([a-z0-9_./-]+)(:[\\w.-]+)?$";
    private static final Pattern dockerImagePattern = Pattern.compile("^(([a-zA-Z0-9.-]+)(:\\d+)?/)?([a-z0-9_./-]+)(:[\\w.-]+)?$");
    public static final String HOSTNAME_PATTERN = "^[a-zA-Z0-9][a-zA-Z0-9_.-]+$";
    private static final Pattern hostnamePattern = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9_.-]+$");
    private static final Pattern USER_MOUNT_PATTERN = Pattern.compile("(?<=^|,)([^:\\x00]+):([^:\\x00]+)(:(r[ow]|(r[ow][+])?(r?shared|r?slave|r?private)))?(?:,|$)");
    private static final Pattern TMPFS_MOUNT_PATTERN = Pattern.compile("^/[^:\\x00]+$");
    public static final String PORTS_MAPPING_PATTERN = "^:[0-9]+|^[0-9]+:[0-9]+|^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]):[0-9]+:[0-9]+$";
    private static final int HOST_NAME_LENGTH = 64;
    private static final String DEFAULT_PROCFS = "/proc";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_IMAGE = "YARN_CONTAINER_RUNTIME_DOCKER_IMAGE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_IMAGE_FILE = "YARN_CONTAINER_RUNTIME_DOCKER_IMAGE_FILE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_RUN_OVERRIDE_DISABLE = "YARN_CONTAINER_RUNTIME_DOCKER_RUN_OVERRIDE_DISABLE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_NETWORK = "YARN_CONTAINER_RUNTIME_DOCKER_CONTAINER_NETWORK";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_PID_NAMESPACE = "YARN_CONTAINER_RUNTIME_DOCKER_CONTAINER_PID_NAMESPACE";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_HOSTNAME = "YARN_CONTAINER_RUNTIME_DOCKER_CONTAINER_HOSTNAME";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_RUN_PRIVILEGED_CONTAINER = "YARN_CONTAINER_RUNTIME_DOCKER_RUN_PRIVILEGED_CONTAINER";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_RUN_ENABLE_USER_REMAPPING = "YARN_CONTAINER_RUNTIME_DOCKER_RUN_ENABLE_USER_REMAPPING";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_MOUNTS = "YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_TMPFS_MOUNTS = "YARN_CONTAINER_RUNTIME_DOCKER_TMPFS_MOUNTS";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_DELAYED_REMOVAL = "YARN_CONTAINER_RUNTIME_DOCKER_DELAYED_REMOVAL";
    @InterfaceAudience.Private
    public static final String ENV_DOCKER_CONTAINER_PORTS_MAPPING = "YARN_CONTAINER_RUNTIME_DOCKER_PORTS_MAPPING";
    private Configuration conf;
    private Context nmContext;
    private DockerClient dockerClient;
    private PrivilegedOperationExecutor privilegedOperationExecutor;
    private Set<String> allowedNetworks = new HashSet<String>();
    private String defaultNetwork;
    private CGroupsHandler cGroupsHandler;
    private AccessControlList privilegedContainersAcl;
    private boolean enableUserReMapping;
    private int userRemappingUidThreshold;
    private int userRemappingGidThreshold;
    private Set<String> capabilities;
    private boolean delayedRemovalAllowed;
    private Set<String> defaultROMounts = new HashSet<String>();
    private Set<String> defaultRWMounts = new HashSet<String>();
    private Set<String> defaultTmpfsMounts = new HashSet<String>();

    public static boolean isDockerContainerRequested(Map<String, String> env) {
        if (env == null) {
            return false;
        }
        String type = env.get("YARN_CONTAINER_RUNTIME_TYPE");
        return type != null && type.equals("docker");
    }

    public DockerLinuxContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor) {
        this(privilegedOperationExecutor, ResourceHandlerModule.getCGroupsHandler());
    }

    @VisibleForTesting
    public DockerLinuxContainerRuntime(PrivilegedOperationExecutor privilegedOperationExecutor, CGroupsHandler cGroupsHandler) {
        this.privilegedOperationExecutor = privilegedOperationExecutor;
        if (cGroupsHandler == null) {
            LOG.info("cGroupsHandler is null - cgroups not in use.");
        } else {
            this.cGroupsHandler = cGroupsHandler;
        }
    }

    @Override
    public void initialize(Configuration conf, Context nmContext) throws ContainerExecutionException {
        this.nmContext = nmContext;
        this.conf = conf;
        this.dockerClient = new DockerClient();
        this.allowedNetworks.clear();
        this.defaultROMounts.clear();
        this.defaultRWMounts.clear();
        this.defaultTmpfsMounts.clear();
        this.allowedNetworks.addAll(Arrays.asList(conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.docker.allowed-container-networks", YarnConfiguration.DEFAULT_NM_DOCKER_ALLOWED_CONTAINER_NETWORKS)));
        this.defaultNetwork = conf.getTrimmed("yarn.nodemanager.runtime.linux.docker.default-container-network", "host");
        if (!this.allowedNetworks.contains(this.defaultNetwork)) {
            String message = "Default network: " + this.defaultNetwork + " is not in the set of allowed networks: " + this.allowedNetworks;
            if (LOG.isWarnEnabled()) {
                LOG.warn(message + ". Please check " + "configuration");
            }
            throw new ContainerExecutionException(message);
        }
        this.privilegedContainersAcl = new AccessControlList(conf.getTrimmed("yarn.nodemanager.runtime.linux.docker.privileged-containers.acl", ""));
        this.enableUserReMapping = conf.getBoolean("yarn.nodemanager.runtime.linux.docker.enable-userremapping.allowed", true);
        this.userRemappingUidThreshold = conf.getInt("yarn.nodemanager.runtime.linux.docker.userremapping-uid-threshold", 1);
        this.userRemappingGidThreshold = conf.getInt("yarn.nodemanager.runtime.linux.docker.userremapping-gid-threshold", 1);
        this.capabilities = this.getDockerCapabilitiesFromConf();
        this.delayedRemovalAllowed = conf.getBoolean("yarn.nodemanager.runtime.linux.docker.delayed-removal.allowed", false);
        this.defaultROMounts.addAll(Arrays.asList(conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.docker.default-ro-mounts")));
        this.defaultRWMounts.addAll(Arrays.asList(conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.docker.default-rw-mounts")));
        this.defaultTmpfsMounts.addAll(Arrays.asList(conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.docker.default-tmpfs-mounts")));
    }

    @Override
    public boolean isRuntimeRequested(Map<String, String> env) {
        return DockerLinuxContainerRuntime.isDockerContainerRequested(env);
    }

    private Set<String> getDockerCapabilitiesFromConf() throws ContainerExecutionException {
        Set<String> caps = new HashSet<String>(Arrays.asList(this.conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.docker.capabilities", YarnConfiguration.DEFAULT_NM_DOCKER_CONTAINER_CAPABILITIES)));
        if (caps.contains("none") || caps.contains("NONE")) {
            if (caps.size() > 1) {
                String msg = "Mixing capabilities with the none keyword is not supported";
                throw new ContainerExecutionException(msg);
            }
            caps = Collections.emptySet();
        }
        return caps;
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    private String runDockerVolumeCommand(DockerVolumeCommand dockerVolumeCommand, Container container) throws ContainerExecutionException {
        try {
            String commandFile = this.dockerClient.writeCommandToTempFile(dockerVolumeCommand, container.getContainerId(), this.nmContext);
            PrivilegedOperation privOp = new PrivilegedOperation(PrivilegedOperation.OperationType.RUN_DOCKER_CMD);
            privOp.appendArgs(commandFile);
            String output = this.privilegedOperationExecutor.executePrivilegedOperation(null, privOp, null, null, true, false);
            LOG.info("ContainerId=" + container.getContainerId() + ", docker volume output for " + dockerVolumeCommand + ": " + output);
            return output;
        }
        catch (ContainerExecutionException e) {
            LOG.error("Error when writing command to temp file, command=" + dockerVolumeCommand, (Throwable)((Object)e));
            throw e;
        }
        catch (PrivilegedOperationException e) {
            LOG.error("Error when executing command, command=" + dockerVolumeCommand, (Throwable)((Object)e));
            throw new ContainerExecutionException((Throwable)((Object)e));
        }
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        if (this.nmContext != null && this.nmContext.getResourcePluginManager().getNameToPlugins() != null) {
            for (ResourcePlugin plugin : this.nmContext.getResourcePluginManager().getNameToPlugins().values()) {
                DockerVolumeCommand dockerVolumeCommand;
                DockerCommandPlugin dockerCommandPlugin = plugin.getDockerCommandPluginInstance();
                if (dockerCommandPlugin == null || (dockerVolumeCommand = dockerCommandPlugin.getCreateDockerVolumeCommand(ctx.getContainer())) == null) continue;
                this.runDockerVolumeCommand(dockerVolumeCommand, container);
                if (!dockerVolumeCommand.getSubCommand().equals("create")) continue;
                this.checkDockerVolumeCreated(dockerVolumeCommand, container);
            }
        }
    }

    private void checkDockerVolumeCreated(DockerVolumeCommand dockerVolumeCreationCommand, Container container) throws ContainerExecutionException {
        DockerVolumeCommand dockerVolumeInspectCommand = new DockerVolumeCommand("ls");
        String output = this.runDockerVolumeCommand(dockerVolumeInspectCommand, container);
        String volumeName = dockerVolumeCreationCommand.getVolumeName();
        String driverName = dockerVolumeCreationCommand.getDriverName();
        if (driverName == null) {
            driverName = "local";
        }
        for (String line : output.split("\n")) {
            if (!(line = line.trim()).contains(volumeName) || !line.contains(driverName)) continue;
            LOG.info("Docker volume-name=" + volumeName + " driver-name=" + driverName + " already exists for container=" + container.getContainerId() + ", continue...");
            return;
        }
        String message = " Couldn't find volume=" + volumeName + " driver=" + driverName + " for container=" + container.getContainerId() + ", please check error message in log to understand " + "why this happens.";
        LOG.error(message);
        if (LOG.isDebugEnabled()) {
            LOG.debug("All docker volumes in the system, command=" + dockerVolumeInspectCommand.toString());
        }
        throw new ContainerExecutionException(message);
    }

    private void validateContainerNetworkType(String network) throws ContainerExecutionException {
        if (this.allowedNetworks.contains(network)) {
            return;
        }
        String msg = "Disallowed network:  '" + network + "' specified. Allowed networks: are " + this.allowedNetworks.toString();
        throw new ContainerExecutionException(msg);
    }

    private boolean allowHostPidNamespace(Container container) throws ContainerExecutionException {
        Map environment = container.getLaunchContext().getEnvironment();
        String pidNamespace = (String)environment.get(ENV_DOCKER_CONTAINER_PID_NAMESPACE);
        if (pidNamespace == null) {
            return false;
        }
        if (!pidNamespace.equalsIgnoreCase("host")) {
            LOG.warn("NOT requesting PID namespace. Value of YARN_CONTAINER_RUNTIME_DOCKER_CONTAINER_PID_NAMESPACEis invalid: " + pidNamespace);
            return false;
        }
        boolean hostPidNamespaceEnabled = this.conf.getBoolean("yarn.nodemanager.runtime.linux.docker.host-pid-namespace.allowed", false);
        if (!hostPidNamespaceEnabled) {
            String message = "Host pid namespace being requested but this is not enabled on this cluster";
            LOG.warn(message);
            throw new ContainerExecutionException(message);
        }
        return true;
    }

    public static void validateHostname(String hostname) throws ContainerExecutionException {
        if (hostname != null && !hostname.isEmpty()) {
            if (!hostnamePattern.matcher(hostname).matches()) {
                throw new ContainerExecutionException("Hostname '" + hostname + "' doesn't match docker hostname pattern");
            }
            if (hostname.length() > 64) {
                throw new ContainerExecutionException("Hostname can not be greater than 64 characters: " + hostname);
            }
        }
    }

    private void setHostname(DockerRunCommand runCommand, String containerIdStr, String network, String name) throws ContainerExecutionException {
        if (network.equalsIgnoreCase("host")) {
            if (name != null && !name.isEmpty()) {
                LOG.info("setting hostname in container to: " + name);
                runCommand.setHostname(name);
            }
        } else {
            if (name == null || name.isEmpty()) {
                name = RegistryPathUtils.encodeYarnID((String)containerIdStr);
                String domain = this.conf.get("hadoop.registry.dns.domain-name");
                if (domain != null) {
                    name = name + "." + domain;
                }
                DockerLinuxContainerRuntime.validateHostname(name);
            }
            LOG.info("setting hostname in container to: " + name);
            runCommand.setHostname(name);
        }
    }

    @VisibleForTesting
    protected void addCGroupParentIfRequired(String resourcesOptions, String containerIdStr, DockerRunCommand runCommand) {
        if (this.cGroupsHandler == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("cGroupsHandler is null. cgroups are not in use. nothing to do.");
            }
            return;
        }
        if (resourcesOptions.equals("cgroups=none")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("no resource restrictions specified. not using docker's cgroup options");
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("using docker's cgroups options");
            }
            String cGroupPath = "/" + this.cGroupsHandler.getRelativePathForCGroup(containerIdStr);
            if (LOG.isDebugEnabled()) {
                LOG.debug("using cgroup parent: " + cGroupPath);
            }
            runCommand.setCGroupParent(cGroupPath);
        }
    }

    private boolean allowPrivilegedContainerExecution(Container container) throws ContainerExecutionException {
        if (!this.isContainerRequestedAsPrivileged(container)) {
            return false;
        }
        LOG.info("Privileged container requested for : " + container.getContainerId().toString());
        boolean privilegedContainersEnabledOnCluster = this.conf.getBoolean("yarn.nodemanager.runtime.linux.docker.privileged-containers.allowed", false);
        if (!privilegedContainersEnabledOnCluster) {
            String message = "Privileged container being requested but privileged containers are not enabled on this cluster";
            LOG.warn(message);
            throw new ContainerExecutionException(message);
        }
        String submittingUser = container.getUser();
        UserGroupInformation submitterUgi = UserGroupInformation.createRemoteUser((String)submittingUser);
        if (!this.privilegedContainersAcl.isUserAllowed(submitterUgi)) {
            String message = "Cannot launch privileged container. Submitting user (" + submittingUser + ") fails ACL check.";
            LOG.warn(message);
            throw new ContainerExecutionException(message);
        }
        LOG.info("All checks pass. Launching privileged container for : " + container.getContainerId().toString());
        return true;
    }

    private boolean isContainerRequestedAsPrivileged(Container container) {
        String runPrivilegedContainerEnvVar = (String)container.getLaunchContext().getEnvironment().get(ENV_DOCKER_CONTAINER_RUN_PRIVILEGED_CONTAINER);
        return Boolean.parseBoolean(runPrivilegedContainerEnvVar);
    }

    @VisibleForTesting
    private String mountReadOnlyPath(String mount, Map<Path, List<String>> localizedResources) throws ContainerExecutionException {
        for (Map.Entry<Path, List<String>> resource : localizedResources.entrySet()) {
            if (!resource.getValue().contains(mount)) continue;
            java.nio.file.Path path = Paths.get(resource.getKey().toString(), new String[0]);
            if (!path.isAbsolute()) {
                throw new ContainerExecutionException("Mount must be absolute: " + mount);
            }
            if (Files.isSymbolicLink(path)) {
                throw new ContainerExecutionException("Mount cannot be a symlink: " + mount);
            }
            return path.toString();
        }
        throw new ContainerExecutionException("Mount must be a localized resource: " + mount);
    }

    private String getUserIdInfo(String userName) throws ContainerExecutionException {
        String id = "";
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(new String[]{"id", "-u", userName});
        try {
            shexec.execute();
            id = shexec.getOutput().replaceAll("[^0-9]", "");
        }
        catch (Exception e) {
            throw new ContainerExecutionException(e);
        }
        return id;
    }

    private String[] getGroupIdInfo(String userName) throws ContainerExecutionException {
        String[] id = null;
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(new String[]{"id", "-G", userName});
        try {
            shexec.execute();
            id = shexec.getOutput().replace("\n", "").split(" ");
        }
        catch (Exception e) {
            throw new ContainerExecutionException(e);
        }
        return id;
    }

    private boolean checkUseEntryPoint(Map<String, String> environment) {
        boolean overrideDisable = false;
        String overrideDisableKey = ApplicationConstants.Environment.YARN_CONTAINER_RUNTIME_DOCKER_RUN_OVERRIDE_DISABLE.name();
        String overrideDisableValue = environment.get(overrideDisableKey) != null ? environment.get(overrideDisableKey) : System.getenv(overrideDisableKey);
        overrideDisable = Boolean.parseBoolean(overrideDisableValue);
        return overrideDisable;
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        String dst;
        String runAsUser;
        Container container = ctx.getContainer();
        ContainerId containerId = container.getContainerId();
        Map environment = container.getLaunchContext().getEnvironment();
        String imageName = (String)environment.get(ENV_DOCKER_CONTAINER_IMAGE);
        String network = (String)environment.get(ENV_DOCKER_CONTAINER_NETWORK);
        String hostname = (String)environment.get(ENV_DOCKER_CONTAINER_HOSTNAME);
        boolean useEntryPoint = this.checkUseEntryPoint(environment);
        if (network == null || network.isEmpty()) {
            network = this.defaultNetwork;
        }
        this.validateContainerNetworkType(network);
        DockerLinuxContainerRuntime.validateHostname(hostname);
        DockerLinuxContainerRuntime.validateImageName(imageName);
        String containerIdStr = containerId.toString();
        String dockerRunAsUser = runAsUser = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER);
        Path containerWorkDir = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_WORK_DIR);
        String[] groups = null;
        if (this.enableUserReMapping) {
            String uid = this.getUserIdInfo(runAsUser);
            groups = this.getGroupIdInfo(runAsUser);
            String gid = groups[0];
            if (Integer.parseInt(uid) < this.userRemappingUidThreshold) {
                String message = "uid: " + uid + " below threshold: " + this.userRemappingUidThreshold;
                throw new ContainerExecutionException(message);
            }
            for (int i = 0; i < groups.length; ++i) {
                String group = groups[i];
                if (Integer.parseInt(group) >= this.userRemappingGidThreshold) continue;
                String message = "gid: " + group + " below threshold: " + this.userRemappingGidThreshold;
                throw new ContainerExecutionException(message);
            }
            dockerRunAsUser = !this.allowPrivilegedContainerExecution(container) ? uid + ":" + gid : ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER);
        }
        List filecacheDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.FILECACHE_DIRS);
        List containerLogDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_LOG_DIRS);
        List userFilecacheDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER_FILECACHE_DIRS);
        List applicationLocalDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.APPLICATION_LOCAL_DIRS);
        Map localizedResources = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOCALIZED_RESOURCES);
        DockerRunCommand runCommand = new DockerRunCommand(containerIdStr, dockerRunAsUser, imageName).setNetworkType(network);
        this.setHostname(runCommand, containerIdStr, network, hostname);
        if (environment.containsKey(ENV_DOCKER_CONTAINER_PORTS_MAPPING)) {
            String portsMapping = (String)environment.get(ENV_DOCKER_CONTAINER_PORTS_MAPPING);
            for (String mapping : portsMapping.split(",")) {
                if (!Pattern.matches(PORTS_MAPPING_PATTERN, mapping)) {
                    throw new ContainerExecutionException("Invalid port mappings: " + mapping);
                }
                runCommand.addPortsMapping(mapping);
            }
        }
        runCommand.setCapabilities(this.capabilities);
        runCommand.addAllReadWriteMountLocations(containerLogDirs);
        runCommand.addAllReadWriteMountLocations(applicationLocalDirs);
        runCommand.addAllReadOnlyMountLocations(filecacheDirs);
        runCommand.addAllReadOnlyMountLocations(userFilecacheDirs);
        if (environment.containsKey(ENV_DOCKER_CONTAINER_MOUNTS)) {
            Matcher parsedMounts = USER_MOUNT_PATTERN.matcher((CharSequence)environment.get(ENV_DOCKER_CONTAINER_MOUNTS));
            if (!parsedMounts.find()) {
                throw new ContainerExecutionException("Unable to parse user supplied mount list: " + (String)environment.get(ENV_DOCKER_CONTAINER_MOUNTS));
            }
            parsedMounts.reset();
            long l = 0L;
            while (parsedMounts.find()) {
                ++l;
                String src = parsedMounts.group(1);
                java.nio.file.Path srcPath = Paths.get(src, new String[0]);
                if (!srcPath.isAbsolute()) {
                    src = this.mountReadOnlyPath(src, localizedResources);
                }
                String dst2 = parsedMounts.group(2);
                String mode = parsedMounts.group(4);
                if (mode == null) {
                    mode = "rw";
                } else if (!mode.startsWith("ro") && !mode.startsWith("rw")) {
                    mode = "rw+" + mode;
                }
                runCommand.addMountLocation(src, dst2, mode);
            }
            long commaCount = ((String)environment.get(ENV_DOCKER_CONTAINER_MOUNTS)).chars().filter(c -> c == 44).count();
            if (l != commaCount + 1L) {
                throw new ContainerExecutionException("Unable to parse some mounts in user supplied mount list: " + (String)environment.get(ENV_DOCKER_CONTAINER_MOUNTS));
            }
        }
        if (this.defaultROMounts != null && !this.defaultROMounts.isEmpty()) {
            for (String string : this.defaultROMounts) {
                String[] dir = StringUtils.split((String)string, (char)':');
                if (dir.length != 2) {
                    throw new ContainerExecutionException("Invalid mount : " + string);
                }
                String src = dir[0];
                dst = dir[1];
                runCommand.addReadOnlyMountLocation(src, dst);
            }
        }
        if (this.defaultRWMounts != null && !this.defaultRWMounts.isEmpty()) {
            for (String string : this.defaultRWMounts) {
                String[] dir = StringUtils.split((String)string, (char)':');
                if (dir.length != 2) {
                    throw new ContainerExecutionException("Invalid mount : " + string);
                }
                String src = dir[0];
                dst = dir[1];
                runCommand.addReadWriteMountLocation(src, dst);
            }
        }
        if (environment.containsKey(ENV_DOCKER_CONTAINER_TMPFS_MOUNTS)) {
            String[] tmpfsMounts = ((String)environment.get(ENV_DOCKER_CONTAINER_TMPFS_MOUNTS)).split(",");
            for (String mount : tmpfsMounts) {
                if (!TMPFS_MOUNT_PATTERN.matcher(mount).matches()) {
                    throw new ContainerExecutionException("Invalid tmpfs mount : " + mount);
                }
                runCommand.addTmpfsMount(mount);
            }
        }
        if (this.defaultTmpfsMounts != null && !this.defaultTmpfsMounts.isEmpty()) {
            for (String string : this.defaultTmpfsMounts) {
                if (!TMPFS_MOUNT_PATTERN.matcher(string).matches()) {
                    throw new ContainerExecutionException("Invalid tmpfs mount : " + string);
                }
                runCommand.addTmpfsMount(string);
            }
        }
        if (this.allowHostPidNamespace(container)) {
            runCommand.setPidNamespace("host");
        }
        if (this.allowPrivilegedContainerExecution(container)) {
            runCommand.setPrivileged();
        }
        this.addDockerClientConfigToRunCommand(ctx, runCommand);
        String resourcesOpts = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RESOURCES_OPTIONS);
        this.addCGroupParentIfRequired(resourcesOpts, containerIdStr, runCommand);
        if (useEntryPoint) {
            runCommand.setOverrideDisabled(true);
            runCommand.addEnv(environment);
            runCommand.setOverrideCommandWithArgs(container.getLaunchContext().getCommands());
            runCommand.disableDetach();
            runCommand.setLogDir(container.getLogDir());
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            Path launchDst = new Path(containerWorkDir, ContainerLaunch.CONTAINER_SCRIPT);
            arrayList.add("bash");
            arrayList.add(launchDst.toUri().getPath());
            runCommand.setContainerWorkDir(containerWorkDir.toString());
            runCommand.setOverrideCommandWithArgs(arrayList);
            runCommand.detachOnRun();
        }
        if (this.enableUserReMapping && !this.allowPrivilegedContainerExecution(container)) {
            runCommand.groupAdd(groups);
        }
        if (this.nmContext != null && this.nmContext.getResourcePluginManager().getNameToPlugins() != null) {
            for (ResourcePlugin plugin : this.nmContext.getResourcePluginManager().getNameToPlugins().values()) {
                DockerCommandPlugin dockerCommandPlugin = plugin.getDockerCommandPluginInstance();
                if (dockerCommandPlugin == null) continue;
                dockerCommandPlugin.updateDockerRunCommand(runCommand, container);
            }
        }
        String string = this.dockerClient.writeCommandToTempFile(runCommand, containerId, this.nmContext);
        PrivilegedOperation launchOp = this.buildLaunchOp(ctx, string, runCommand);
        launchOp.disableFailureLogging();
        try {
            this.privilegedOperationExecutor.executePrivilegedOperation(null, launchOp, null, null, false, false);
        }
        catch (PrivilegedOperationException e) {
            throw new ContainerExecutionException("Launch container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void relaunchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        ContainerId containerId = ctx.getContainer().getContainerId();
        String containerIdStr = containerId.toString();
        DockerCommandExecutor.DockerContainerStatus containerStatus = DockerCommandExecutor.getContainerStatus(containerIdStr, this.privilegedOperationExecutor, this.nmContext);
        if (containerStatus != null && DockerCommandExecutor.isStartable(containerStatus)) {
            DockerStartCommand startCommand = new DockerStartCommand(containerIdStr);
            String commandFile = this.dockerClient.writeCommandToTempFile(startCommand, containerId, this.nmContext);
            PrivilegedOperation launchOp = this.buildLaunchOp(ctx, commandFile, startCommand);
            launchOp.disableFailureLogging();
            try {
                this.privilegedOperationExecutor.executePrivilegedOperation(null, launchOp, null, null, false, false);
            }
            catch (PrivilegedOperationException e) {
                throw new ContainerExecutionException("Relaunch container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
            }
        } else {
            throw new ContainerExecutionException("Container is not in a startable state, unable to relaunch: " + containerIdStr);
        }
    }

    @Override
    public void signalContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        ContainerExecutor.Signal signal = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.SIGNAL);
        Map env = ctx.getContainer().getLaunchContext().getEnvironment();
        try {
            if (ContainerExecutor.Signal.NULL.equals((Object)signal)) {
                this.executeLivelinessCheck(ctx);
            } else if (ContainerExecutor.Signal.TERM.equals((Object)signal)) {
                String containerId = ctx.getContainer().getContainerId().toString();
                this.handleContainerStop(containerId, env);
            } else {
                this.handleContainerKill(ctx, env, signal);
            }
        }
        catch (ContainerExecutionException e) {
            throw new ContainerExecutionException("Signal docker container failed", e.getExitCode(), e.getOutput(), e.getErrorOutput());
        }
    }

    @Override
    public void reapContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        this.handleContainerRemove(ctx.getContainer().getContainerId().toString(), ctx.getContainer().getLaunchContext().getEnvironment());
        if (this.nmContext != null && this.nmContext.getResourcePluginManager().getNameToPlugins() != null) {
            for (ResourcePlugin plugin : this.nmContext.getResourcePluginManager().getNameToPlugins().values()) {
                DockerVolumeCommand dockerVolumeCommand;
                DockerCommandPlugin dockerCommandPlugin = plugin.getDockerCommandPluginInstance();
                if (dockerCommandPlugin == null || (dockerVolumeCommand = dockerCommandPlugin.getCleanupDockerVolumesCommand(ctx.getContainer())) == null) continue;
                this.runDockerVolumeCommand(dockerVolumeCommand, ctx.getContainer());
            }
        }
    }

    @Override
    public String[] getIpAndHost(Container container) {
        ContainerId containerId = container.getContainerId();
        String containerIdStr = containerId.toString();
        DockerInspectCommand inspectCommand = new DockerInspectCommand(containerIdStr).getIpAndHost();
        try {
            String commandFile = this.dockerClient.writeCommandToTempFile(inspectCommand, containerId, this.nmContext);
            PrivilegedOperation privOp = new PrivilegedOperation(PrivilegedOperation.OperationType.RUN_DOCKER_CMD);
            privOp.appendArgs(commandFile);
            String output = this.privilegedOperationExecutor.executePrivilegedOperation(null, privOp, null, null, true, false);
            LOG.info("Docker inspect output for " + containerId + ": " + output);
            output = output.replaceAll("['\"]", "");
            int index = output.lastIndexOf(44);
            if (index == -1) {
                LOG.error("Incorrect format for ip and host");
                return null;
            }
            String ips = output.substring(0, index).trim();
            String host = output.substring(index + 1).trim();
            if (ips.equals("")) {
                String network;
                try {
                    network = (String)container.getLaunchContext().getEnvironment().get(ENV_DOCKER_CONTAINER_NETWORK);
                    if (network == null || network.isEmpty()) {
                        network = this.defaultNetwork;
                    }
                }
                catch (NullPointerException e) {
                    network = this.defaultNetwork;
                }
                boolean useHostNetwork = network.equalsIgnoreCase("host");
                if (useHostNetwork) {
                    try {
                        InetAddress address = InetAddress.getLocalHost();
                        ips = address.getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        LOG.error("Can not determine IP for container:" + containerId);
                    }
                }
            }
            String[] ipAndHost = new String[]{ips, host};
            return ipAndHost;
        }
        catch (ContainerExecutionException e) {
            LOG.error("Error when writing command to temp file", (Throwable)((Object)e));
        }
        catch (PrivilegedOperationException e) {
            LOG.error("Error when executing command.", (Throwable)((Object)e));
        }
        return null;
    }

    private PrivilegedOperation buildLaunchOp(ContainerRuntimeContext ctx, String commandFile, DockerCommand command) {
        String runAsUser = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER);
        String containerIdStr = ctx.getContainer().getContainerId().toString();
        Path nmPrivateContainerScriptPath = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_CONTAINER_SCRIPT_PATH);
        Path containerWorkDir = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.CONTAINER_WORK_DIR);
        List localDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOCAL_DIRS);
        List logDirs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.LOG_DIRS);
        PrivilegedOperation launchOp = new PrivilegedOperation(PrivilegedOperation.OperationType.LAUNCH_DOCKER_CONTAINER);
        launchOp.appendArgs(runAsUser, ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.LAUNCH_DOCKER_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.APPID), containerIdStr, containerWorkDir.toString(), nmPrivateContainerScriptPath.toUri().getPath(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_TOKENS_PATH).toUri().getPath(), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID_FILE_PATH).toString(), StringUtils.join((char)'%', (Iterable)localDirs), StringUtils.join((char)'%', (Iterable)logDirs), commandFile);
        String tcCommandFile = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.TC_COMMAND_FILE);
        if (tcCommandFile != null) {
            launchOp.appendArgs(tcCommandFile);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Launching container with cmd: " + command);
        }
        return launchOp;
    }

    public static void validateImageName(String imageName) throws ContainerExecutionException {
        if (imageName == null || imageName.isEmpty()) {
            throw new ContainerExecutionException("YARN_CONTAINER_RUNTIME_DOCKER_IMAGE not set!");
        }
        if (!dockerImagePattern.matcher(imageName).matches()) {
            throw new ContainerExecutionException("Image name '" + imageName + "' doesn't match docker image name pattern");
        }
    }

    private void executeLivelinessCheck(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        String procFs = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PROCFS);
        if (procFs == null || procFs.isEmpty()) {
            procFs = DEFAULT_PROCFS;
        }
        String pid = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID);
        if (!new File(procFs + File.separator + pid).exists()) {
            String msg = "Liveliness check failed for PID: " + pid + ". Container may have already completed.";
            throw new ContainerExecutionException(msg, PrivilegedOperation.ResultCode.INVALID_CONTAINER_PID.getValue());
        }
    }

    private void handleContainerStop(String containerId, Map<String, String> env) throws ContainerExecutionException {
        DockerCommandExecutor.DockerContainerStatus containerStatus = DockerCommandExecutor.getContainerStatus(containerId, this.privilegedOperationExecutor, this.nmContext);
        if (DockerCommandExecutor.isStoppable(containerStatus)) {
            DockerStopCommand dockerStopCommand = new DockerStopCommand(containerId);
            DockerCommandExecutor.executeDockerCommand(dockerStopCommand, containerId, env, this.privilegedOperationExecutor, false, this.nmContext);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Container status is " + containerStatus.getName() + ", skipping stop - " + containerId);
        }
    }

    private void handleContainerKill(ContainerRuntimeContext ctx, Map<String, String> env, ContainerExecutor.Signal signal) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        if (this.isContainerRequestedAsPrivileged(container)) {
            String containerId = container.getContainerId().toString();
            DockerCommandExecutor.DockerContainerStatus containerStatus = DockerCommandExecutor.getContainerStatus(containerId, this.privilegedOperationExecutor, this.nmContext);
            if (DockerCommandExecutor.isKillable(containerStatus)) {
                DockerKillCommand dockerKillCommand = new DockerKillCommand(containerId).setSignal(signal.name());
                DockerCommandExecutor.executeDockerCommand(dockerKillCommand, containerId, env, this.privilegedOperationExecutor, false, this.nmContext);
            } else {
                LOG.debug("Container status is {}, skipping kill - {}", (Object)containerStatus.getName(), (Object)containerId);
            }
        } else {
            PrivilegedOperation privOp = new PrivilegedOperation(PrivilegedOperation.OperationType.SIGNAL_CONTAINER);
            privOp.appendArgs(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.RUN_AS_USER), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.USER), Integer.toString(PrivilegedOperation.RunAsUserCommand.SIGNAL_CONTAINER.getValue()), ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.PID), Integer.toString(ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.SIGNAL).getValue()));
            privOp.disableFailureLogging();
            try {
                this.privilegedOperationExecutor.executePrivilegedOperation(null, privOp, null, null, false, false);
            }
            catch (PrivilegedOperationException e) {
                throw new ContainerExecutionException("Signal container failed using signal: " + signal.name(), e.getExitCode(), e.getOutput(), e.getErrorOutput());
            }
        }
    }

    private void handleContainerRemove(String containerId, Map<String, String> env) throws ContainerExecutionException {
        String delayedRemoval = env.get(ENV_DOCKER_CONTAINER_DELAYED_REMOVAL);
        if (this.delayedRemovalAllowed && delayedRemoval != null && delayedRemoval.equalsIgnoreCase("true")) {
            LOG.info("Delayed removal requested and allowed, skipping removal - " + containerId);
        } else {
            DockerCommandExecutor.DockerContainerStatus containerStatus = DockerCommandExecutor.getContainerStatus(containerId, this.privilegedOperationExecutor, this.nmContext);
            if (DockerCommandExecutor.isRemovable(containerStatus)) {
                DockerRmCommand dockerRmCommand = new DockerRmCommand(containerId, ResourceHandlerModule.getCgroupsRelativeRoot());
                DockerCommandExecutor.executeDockerCommand(dockerRmCommand, containerId, env, this.privilegedOperationExecutor, false, this.nmContext);
            }
        }
    }

    private void addDockerClientConfigToRunCommand(ContainerRuntimeContext ctx, DockerRunCommand dockerRunCommand) throws ContainerExecutionException {
        ByteBuffer tokens = ctx.getContainer().getLaunchContext().getTokens();
        if (tokens != null) {
            tokens.rewind();
            if (tokens.hasRemaining()) {
                Credentials credentials;
                try {
                    credentials = DockerClientConfigHandler.getCredentialsFromTokensByteBuffer((ByteBuffer)tokens);
                }
                catch (IOException e) {
                    throw new ContainerExecutionException("Unable to read tokens.");
                }
                if (credentials.numberOfTokens() > 0) {
                    Path nmPrivateDir = ctx.getExecutionAttribute(LinuxContainerRuntimeConstants.NM_PRIVATE_CONTAINER_SCRIPT_PATH).getParent();
                    File dockerConfigPath = new File(nmPrivateDir + "/config.json");
                    try {
                        if (DockerClientConfigHandler.writeDockerCredentialsToPath((File)dockerConfigPath, (Credentials)credentials)) {
                            dockerRunCommand.setClientConfigDir(dockerConfigPath.getParent());
                        }
                    }
                    catch (IOException e) {
                        throw new ContainerExecutionException("Unable to write Docker client credentials to " + dockerConfigPath);
                    }
                }
            }
        }
    }
}

