/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.fpga.FpgaResourceHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.DockerCommandPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.NodeResourceUpdaterPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.AbstractFpgaVendorPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaDiscoverer;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaNodeResourceUpdateHandler;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.NMResourceInfo;

public class FpgaResourcePlugin
implements ResourcePlugin {
    private static final Log LOG = LogFactory.getLog(FpgaResourcePlugin.class);
    private ResourceHandler fpgaResourceHandler = null;
    private AbstractFpgaVendorPlugin vendorPlugin = null;
    private FpgaNodeResourceUpdateHandler fpgaNodeResourceUpdateHandler = null;

    private AbstractFpgaVendorPlugin createFpgaVendorPlugin(Configuration conf) {
        String vendorPluginClass = conf.get("yarn.nodemanager.resource-plugins.fpga.vendor-plugin.class", "org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.IntelFpgaOpenclPlugin");
        LOG.info((Object)("Using FPGA vendor plugin: " + vendorPluginClass));
        try {
            Class<?> schedulerClazz = Class.forName(vendorPluginClass);
            if (AbstractFpgaVendorPlugin.class.isAssignableFrom(schedulerClazz)) {
                return (AbstractFpgaVendorPlugin)ReflectionUtils.newInstance(schedulerClazz, (Configuration)conf);
            }
            throw new YarnRuntimeException("Class: " + vendorPluginClass + " not instance of " + AbstractFpgaVendorPlugin.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate FPGA vendor plugin: " + vendorPluginClass, (Throwable)e);
        }
    }

    @Override
    public void initialize(Context context) throws YarnException {
        this.vendorPlugin = this.createFpgaVendorPlugin(context.getConf());
        FpgaDiscoverer.getInstance().setResourceHanderPlugin(this.vendorPlugin);
        FpgaDiscoverer.getInstance().initialize(context.getConf());
        this.fpgaNodeResourceUpdateHandler = new FpgaNodeResourceUpdateHandler();
    }

    @Override
    public ResourceHandler createResourceHandler(Context nmContext, CGroupsHandler cGroupsHandler, PrivilegedOperationExecutor privilegedOperationExecutor) {
        if (this.fpgaResourceHandler == null) {
            this.fpgaResourceHandler = new FpgaResourceHandlerImpl(nmContext, cGroupsHandler, privilegedOperationExecutor, this.vendorPlugin);
        }
        return this.fpgaResourceHandler;
    }

    @Override
    public NodeResourceUpdaterPlugin getNodeResourceHandlerInstance() {
        return this.fpgaNodeResourceUpdateHandler;
    }

    @Override
    public void cleanup() throws YarnException {
    }

    @Override
    public DockerCommandPlugin getDockerCommandPluginInstance() {
        return null;
    }

    @Override
    public NMResourceInfo getNMResourceInfo() throws YarnException {
        return null;
    }

    public String toString() {
        return FpgaResourcePlugin.class.getName();
    }
}

