/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.fpga.FpgaResourceAllocator;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.AbstractFpgaVendorPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntelFpgaOpenclPlugin
implements AbstractFpgaVendorPlugin {
    public static final Logger LOG = LoggerFactory.getLogger(IntelFpgaOpenclPlugin.class);
    private boolean initialized = false;
    private Configuration conf;
    private InnerShellExecutor shell = new InnerShellExecutor();
    protected static final String DEFAULT_BINARY_NAME = "aocl";
    protected static final String ALTERAOCLSDKROOT_NAME = "ALTERAOCLSDKROOT";
    private String pathToExecutable = null;
    private Map<String, String> aliasMap;

    public String getDefaultBinaryName() {
        return DEFAULT_BINARY_NAME;
    }

    public String getDefaultPathToExecutable() {
        return System.getenv(ALTERAOCLSDKROOT_NAME);
    }

    public static String getDefaultPathEnvName() {
        return ALTERAOCLSDKROOT_NAME;
    }

    @VisibleForTesting
    public String getPathToExecutable() {
        return this.pathToExecutable;
    }

    public void setPathToExecutable(String pathToExecutable) {
        this.pathToExecutable = pathToExecutable;
    }

    @VisibleForTesting
    public void setShell(InnerShellExecutor shell) {
        this.shell = shell;
    }

    public Map<String, String> getAliasMap() {
        return this.aliasMap;
    }

    @Override
    public boolean initPlugin(Configuration conf) {
        File binaryPath;
        this.aliasMap = new HashMap<String, String>();
        if (this.initialized) {
            return true;
        }
        String pluginDefaultBinaryName = this.getDefaultBinaryName();
        String pathToExecutable = conf.get("yarn.nodemanager.resource-plugins.fpga.path-to-discovery-executables", "");
        if (pathToExecutable.isEmpty()) {
            pathToExecutable = pluginDefaultBinaryName;
        }
        if (!(binaryPath = new File(pathToExecutable)).exists()) {
            LOG.warn("Failed to find FPGA discoverer executable configured in yarn.nodemanager.resource-plugins.fpga.path-to-discovery-executables, please check! Try default path");
            pathToExecutable = pluginDefaultBinaryName;
            String pluginDefaultPreferredPath = this.getDefaultPathToExecutable();
            if (null == pluginDefaultPreferredPath) {
                LOG.warn("Failed to find FPGA discoverer executable from system environment " + IntelFpgaOpenclPlugin.getDefaultPathEnvName() + ", please check your environment!");
            } else {
                binaryPath = new File(pluginDefaultPreferredPath + "/bin", pluginDefaultBinaryName);
                if (binaryPath.exists()) {
                    pathToExecutable = binaryPath.getAbsolutePath();
                    LOG.info("Succeed in finding FPGA discoverer executable: " + pathToExecutable);
                } else {
                    pathToExecutable = pluginDefaultBinaryName;
                    LOG.warn("Failed to find FPGA discoverer executable in " + pluginDefaultPreferredPath + ", file doesn't exists! Use default binary" + pathToExecutable);
                }
            }
        }
        this.setPathToExecutable(pathToExecutable);
        if (!this.diagnose(10000)) {
            LOG.warn("Intel FPGA for OpenCL diagnose failed!");
            this.initialized = false;
        } else {
            this.initialized = true;
        }
        return this.initialized;
    }

    @Override
    public List<FpgaResourceAllocator.FpgaDevice> discover(int timeout) {
        LinkedList<FpgaResourceAllocator.FpgaDevice> list = new LinkedList<FpgaResourceAllocator.FpgaDevice>();
        String output = this.getDiagnoseInfo(timeout);
        if (null == output) {
            return list;
        }
        this.parseDiagnoseInfo(output, list);
        return list;
    }

    public void parseDiagnoseInfo(String output, List<FpgaResourceAllocator.FpgaDevice> list) {
        if (output.contains("DIAGNOSTIC_PASSED")) {
            Matcher headerStartMatcher = Pattern.compile("acl[0-31]").matcher(output);
            Matcher headerEndMatcher = Pattern.compile("(?i)DIAGNOSTIC_PASSED").matcher(output);
            while (headerStartMatcher.find()) {
                int sectionStartIndex = headerStartMatcher.end();
                String section = null;
                String aliasName = headerStartMatcher.group();
                if (headerEndMatcher.find(sectionStartIndex)) {
                    int sectionEndIndex = headerEndMatcher.start();
                    section = output.substring(sectionStartIndex, sectionEndIndex);
                }
                if (null == section) {
                    LOG.warn("Unsupported diagnose output");
                    return;
                }
                String[] fieldRegexes = new String[]{"\\(.*\\)\n", "(?i)bus:slot.func\\s=\\s.*,", "(?i)FPGA temperature\\s=\\s.*", "(?i)Total\\sCard\\sPower\\sUsage\\s=\\s.*"};
                String[] fields = new String[4];
                for (int i = 0; i < fieldRegexes.length; ++i) {
                    Matcher fieldMatcher = Pattern.compile(fieldRegexes[i]).matcher(section);
                    if (!fieldMatcher.find()) {
                        LOG.warn("Couldn't find " + fieldRegexes[i] + " pattern");
                        fields[i] = "";
                        continue;
                    }
                    String tempFieldValue = fieldMatcher.group().trim();
                    if (i == 0) {
                        fields[i] = tempFieldValue.substring(1, tempFieldValue.length() - 1);
                        continue;
                    }
                    String ss = tempFieldValue.split("=")[1].trim();
                    fields[i] = ss.substring(0, ss.length() - 1);
                }
                String majorMinorNumber = this.shell.getMajorAndMinorNumber(fields[0]);
                if (null == majorMinorNumber) continue;
                String[] mmn = majorMinorNumber.split(":");
                this.aliasMap.put(majorMinorNumber, aliasName);
                list.add(new FpgaResourceAllocator.FpgaDevice(this.getFpgaType(), Integer.parseInt(mmn[0]), Integer.parseInt(mmn[1]), null, fields[0], aliasName, fields[1], fields[2], fields[3]));
            }
        }
    }

    public String getDiagnoseInfo(int timeout) {
        return this.shell.runDiagnose(this.pathToExecutable, timeout);
    }

    @Override
    public boolean diagnose(int timeout) {
        String output = this.getDiagnoseInfo(timeout);
        return null != output && output.contains("DIAGNOSTIC_PASSED");
    }

    @Override
    public String getFpgaType() {
        return "IntelOpenCL";
    }

    @Override
    public String downloadIP(String id, String dstDir, Map<Path, List<String>> localizedResources) {
        String r = "";
        LOG.info("Got environment: " + id + ", search IP file in localized resources");
        if (null == id || id.isEmpty()) {
            LOG.warn("IP_ID environment is empty, skip downloading");
            return r;
        }
        if (localizedResources != null) {
            for (Map.Entry<Path, List<String>> resourceEntry : localizedResources.entrySet()) {
                Path path = resourceEntry.getKey();
                LOG.debug("Check:" + path.toUri().toString());
                if (!path.getName().toLowerCase().contains(id.toLowerCase()) || !path.getName().endsWith(".aocx")) continue;
                r = path.toUri().toString();
                LOG.debug("Found: " + r);
                break;
            }
        } else {
            LOG.warn("Localized resource is null!");
        }
        return r;
    }

    @Override
    public boolean configureIP(String ipPath, String majorMinorNumber) {
        String aclName = this.aliasMap.get(majorMinorNumber);
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(new String[]{this.pathToExecutable, "program", aclName, ipPath});
        try {
            shexec.execute();
            if (0 != shexec.getExitCode()) {
                return false;
            }
            LOG.debug(shexec.getOutput());
            LOG.info("Intel aocl program " + ipPath + " to " + aclName + " successfully");
        }
        catch (IOException e) {
            LOG.error("Intel aocl program " + ipPath + " to " + aclName + " failed!");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public static class InnerShellExecutor {
        public String getMajorAndMinorNumber(String devName) {
            String output = null;
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(new String[]{"stat", "-c", "%t:%T", "/dev/" + devName});
            try {
                LOG.debug("Get FPGA major-minor numbers from /dev/" + devName);
                shexec.execute();
                String[] strs = shexec.getOutput().trim().split(":");
                LOG.debug("stat output:" + shexec.getOutput());
                output = Integer.parseInt(strs[0], 16) + ":" + Integer.parseInt(strs[1], 16);
            }
            catch (IOException e) {
                String msg = "Failed to get major-minor number from reading /dev/" + devName;
                LOG.warn(msg);
                LOG.debug("Command output:" + shexec.getOutput() + ", exit code:" + shexec.getExitCode());
            }
            return output;
        }

        public String runDiagnose(String binary, int timeout) {
            String output = null;
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(new String[]{binary, "diagnose"});
            try {
                shexec.execute();
            }
            catch (IOException e) {
                String msg = "Failed to execute " + binary + " diagnose, exception message:" + e.getMessage() + ", output:" + output + ", continue ...";
                LOG.warn(msg);
                LOG.debug(shexec.getOutput());
            }
            return shexec.getOutput();
        }
    }
}

