/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.DiskValidator;
import org.apache.hadoop.util.DiskValidatorFactory;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.DirectoryCollection;
import org.apache.hadoop.yarn.server.nodemanager.health.HealthReporter;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDirsHandlerService
extends AbstractService
implements HealthReporter {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDirsHandlerService.class);
    private static final String diskCapacityExceededErrorMsg = "usable space is below configured utilization percentage/no more usable space";
    @InterfaceAudience.Private
    static final String NM_GOOD_LOCAL_DIRS = "yarn.nodemanager.good-local-dirs";
    @InterfaceAudience.Private
    static final String NM_GOOD_LOG_DIRS = "yarn.nodemanager.good-log-dirs";
    private Timer dirsHandlerScheduler;
    private long diskHealthCheckInterval;
    private boolean isDiskHealthCheckerEnabled;
    private float minNeededHealthyDisksFactor;
    private MonitoringTimerTask monitoringTimerTask;
    private DirectoryCollection localDirs = null;
    private DirectoryCollection logDirs = null;
    private LocalDirAllocator localDirsAllocator;
    private LocalDirAllocator logDirsAllocator;
    private long lastDisksCheckTime;
    private static String FILE_SCHEME = "file";
    private NodeManagerMetrics nodeManagerMetrics = null;

    public LocalDirsHandlerService() {
        this(null);
    }

    public LocalDirsHandlerService(NodeManagerMetrics nodeManagerMetrics) {
        super(LocalDirsHandlerService.class.getName());
        this.nodeManagerMetrics = nodeManagerMetrics;
    }

    protected void serviceInit(Configuration config) throws Exception {
        FileContext localFs;
        Configuration conf = new Configuration(config);
        this.diskHealthCheckInterval = conf.getLong("yarn.nodemanager.disk-health-checker.interval-ms", 120000L);
        this.monitoringTimerTask = new MonitoringTimerTask(conf);
        this.isDiskHealthCheckerEnabled = conf.getBoolean("yarn.nodemanager.disk-health-checker.enable", true);
        this.minNeededHealthyDisksFactor = conf.getFloat("yarn.nodemanager.disk-health-checker.min-healthy-disks", 0.25f);
        this.lastDisksCheckTime = System.currentTimeMillis();
        super.serviceInit(conf);
        try {
            localFs = FileContext.getLocalFSFileContext((Configuration)config);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Unable to get the local filesystem", (Throwable)e);
        }
        FsPermission perm = new FsPermission(493);
        boolean createSucceeded = this.localDirs.createNonExistentDirs(localFs, perm);
        if (!(createSucceeded &= this.logDirs.createNonExistentDirs(localFs, perm))) {
            this.updateDirsAfterTest();
        }
        this.checkDirs();
    }

    protected void serviceStart() throws Exception {
        if (this.isDiskHealthCheckerEnabled) {
            this.dirsHandlerScheduler = new Timer("DiskHealthMonitor-Timer", true);
            this.dirsHandlerScheduler.scheduleAtFixedRate((TimerTask)this.monitoringTimerTask, this.diskHealthCheckInterval, this.diskHealthCheckInterval);
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.dirsHandlerScheduler != null) {
            this.dirsHandlerScheduler.cancel();
        }
        super.serviceStop();
    }

    public void registerLocalDirsChangeListener(DirectoryCollection.DirsChangeListener listener) {
        this.localDirs.registerDirsChangeListener(listener);
    }

    public void registerLogDirsChangeListener(DirectoryCollection.DirsChangeListener listener) {
        this.logDirs.registerDirsChangeListener(listener);
    }

    public void deregisterLocalDirsChangeListener(DirectoryCollection.DirsChangeListener listener) {
        this.localDirs.deregisterDirsChangeListener(listener);
    }

    public void deregisterLogDirsChangeListener(DirectoryCollection.DirsChangeListener listener) {
        this.logDirs.deregisterDirsChangeListener(listener);
    }

    public List<String> getLocalDirs() {
        return this.localDirs.getGoodDirs();
    }

    public List<String> getLogDirs() {
        return this.logDirs.getGoodDirs();
    }

    public List<String> getDiskFullLocalDirs() {
        return this.localDirs.getFullDirs();
    }

    public List<String> getDiskFullLogDirs() {
        return this.logDirs.getFullDirs();
    }

    public List<String> getLocalDirsForRead() {
        return DirectoryCollection.concat(this.localDirs.getGoodDirs(), this.localDirs.getFullDirs());
    }

    public List<String> getLocalDirsForCleanup() {
        return DirectoryCollection.concat(this.localDirs.getGoodDirs(), this.localDirs.getFullDirs());
    }

    public List<String> getLogDirsForRead() {
        return DirectoryCollection.concat(this.logDirs.getGoodDirs(), this.logDirs.getFullDirs());
    }

    public List<String> getLogDirsForCleanup() {
        return DirectoryCollection.concat(this.logDirs.getGoodDirs(), this.logDirs.getFullDirs());
    }

    public String getDisksHealthReport(boolean listGoodDirs) {
        if (!this.isDiskHealthCheckerEnabled) {
            return "";
        }
        StringBuilder report = new StringBuilder();
        List<String> erroredLocalDirsList = this.localDirs.getErroredDirs();
        List<String> erroredLogDirsList = this.logDirs.getErroredDirs();
        List<String> diskFullLocalDirsList = this.localDirs.getFullDirs();
        List<String> diskFullLogDirsList = this.logDirs.getFullDirs();
        List<String> goodLocalDirsList = this.localDirs.getGoodDirs();
        List<String> goodLogDirsList = this.logDirs.getGoodDirs();
        int numLocalDirs = goodLocalDirsList.size() + erroredLocalDirsList.size() + diskFullLocalDirsList.size();
        int numLogDirs = goodLogDirsList.size() + erroredLogDirsList.size() + diskFullLogDirsList.size();
        if (!listGoodDirs) {
            if (!erroredLocalDirsList.isEmpty()) {
                report.append(erroredLocalDirsList.size() + "/" + numLocalDirs + " local-dirs have errors: " + this.buildDiskErrorReport(erroredLocalDirsList, this.localDirs));
            }
            if (!diskFullLocalDirsList.isEmpty()) {
                report.append(diskFullLocalDirsList.size() + "/" + numLocalDirs + " local-dirs " + diskCapacityExceededErrorMsg + this.buildDiskErrorReport(diskFullLocalDirsList, this.localDirs) + "; ");
            }
            if (!erroredLogDirsList.isEmpty()) {
                report.append(erroredLogDirsList.size() + "/" + numLogDirs + " log-dirs have errors: " + this.buildDiskErrorReport(erroredLogDirsList, this.logDirs));
            }
            if (!diskFullLogDirsList.isEmpty()) {
                report.append(diskFullLogDirsList.size() + "/" + numLogDirs + " log-dirs " + diskCapacityExceededErrorMsg + this.buildDiskErrorReport(diskFullLogDirsList, this.logDirs));
            }
        } else {
            report.append(goodLocalDirsList.size() + "/" + numLocalDirs + " local-dirs are good: " + StringUtils.join((CharSequence)",", goodLocalDirsList) + "; ");
            report.append(goodLogDirsList.size() + "/" + numLogDirs + " log-dirs are good: " + StringUtils.join((CharSequence)",", goodLogDirsList));
        }
        return report.toString();
    }

    @Override
    public String getHealthReport() {
        return this.getDisksHealthReport(false);
    }

    public boolean areDisksHealthy() {
        int failedDirs;
        int totalConfiguredDirs;
        if (!this.isDiskHealthCheckerEnabled) {
            return true;
        }
        int goodDirs = this.getLocalDirs().size();
        if ((float)goodDirs / (float)(totalConfiguredDirs = goodDirs + (failedDirs = this.localDirs.getFailedDirs().size())) < this.minNeededHealthyDisksFactor) {
            return false;
        }
        goodDirs = this.getLogDirs().size();
        return !((float)goodDirs / (float)(totalConfiguredDirs = goodDirs + (failedDirs = this.logDirs.getFailedDirs().size())) < this.minNeededHealthyDisksFactor);
    }

    @Override
    public boolean isHealthy() {
        return this.areDisksHealthy();
    }

    public long getLastDisksCheckTime() {
        return this.lastDisksCheckTime;
    }

    @Override
    public long getLastHealthReportTime() {
        return this.getLastDisksCheckTime();
    }

    public boolean isGoodLocalDir(String path) {
        return this.isInGoodDirs(this.getLocalDirs(), path);
    }

    public boolean isGoodLogDir(String path) {
        return this.isInGoodDirs(this.getLogDirs(), path);
    }

    private boolean isInGoodDirs(List<String> goodDirs, String path) {
        for (String goodDir : goodDirs) {
            if (!path.startsWith(goodDir)) continue;
            return true;
        }
        return false;
    }

    private void updateDirsAfterTest() {
        Configuration conf = this.getConfig();
        List<String> localDirs = this.getLocalDirs();
        conf.setStrings(NM_GOOD_LOCAL_DIRS, localDirs.toArray(new String[localDirs.size()]));
        List<String> logDirs = this.getLogDirs();
        conf.setStrings(NM_GOOD_LOG_DIRS, logDirs.toArray(new String[logDirs.size()]));
        if (!this.areDisksHealthy()) {
            LOG.error("Most of the disks failed. " + this.getDisksHealthReport(false));
        }
    }

    private void logDiskStatus(boolean newDiskFailure, boolean diskTurnedGood) {
        String report;
        if (newDiskFailure) {
            report = this.getDisksHealthReport(false);
            LOG.info("Disk(s) failed: " + report);
        }
        if (diskTurnedGood) {
            report = this.getDisksHealthReport(true);
            LOG.info("Disk(s) turned good: " + report);
        }
    }

    @VisibleForTesting
    public void checkDirs() {
        boolean disksStatusChange = false;
        HashSet<String> failedLocalDirsPreCheck = new HashSet<String>(this.localDirs.getFailedDirs());
        HashSet<String> failedLogDirsPreCheck = new HashSet<String>(this.logDirs.getFailedDirs());
        if (this.localDirs.checkDirs()) {
            disksStatusChange = true;
        }
        if (this.logDirs.checkDirs()) {
            disksStatusChange = true;
        }
        HashSet<String> failedLocalDirsPostCheck = new HashSet<String>(this.localDirs.getFailedDirs());
        HashSet<String> failedLogDirsPostCheck = new HashSet<String>(this.logDirs.getFailedDirs());
        boolean disksFailed = false;
        boolean disksTurnedGood = false;
        disksFailed = this.disksTurnedBad(failedLocalDirsPreCheck, failedLocalDirsPostCheck);
        disksTurnedGood = this.disksTurnedGood(failedLocalDirsPreCheck, failedLocalDirsPostCheck);
        if (!disksFailed) {
            disksFailed = this.disksTurnedBad(failedLogDirsPreCheck, failedLogDirsPostCheck);
        }
        if (!disksTurnedGood) {
            disksTurnedGood = this.disksTurnedGood(failedLogDirsPreCheck, failedLogDirsPostCheck);
        }
        this.logDiskStatus(disksFailed, disksTurnedGood);
        if (disksStatusChange) {
            this.updateDirsAfterTest();
        }
        this.updateMetrics();
        this.lastDisksCheckTime = System.currentTimeMillis();
    }

    private boolean disksTurnedBad(Set<String> preCheckFailedDirs, Set<String> postCheckDirs) {
        boolean disksFailed = false;
        for (String dir : postCheckDirs) {
            if (preCheckFailedDirs.contains(dir)) continue;
            disksFailed = true;
            break;
        }
        return disksFailed;
    }

    private boolean disksTurnedGood(Set<String> preCheckDirs, Set<String> postCheckDirs) {
        boolean disksTurnedGood = false;
        for (String dir : preCheckDirs) {
            if (postCheckDirs.contains(dir)) continue;
            disksTurnedGood = true;
            break;
        }
        return disksTurnedGood;
    }

    private Path getPathToRead(String pathStr, List<String> dirs) throws IOException {
        if (pathStr.startsWith("/")) {
            pathStr = pathStr.substring(1);
        }
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)this.getConfig());
        for (String dir : dirs) {
            try {
                Path tmpDir = new Path(dir);
                File tmpFile = tmpDir.isAbsolute() ? new File(localFS.makeQualified(tmpDir).toUri()) : new File(dir);
                Path file = new Path(tmpFile.getPath(), pathStr);
                if (!localFS.exists(file)) continue;
                return file;
            }
            catch (IOException ie) {
                LOG.warn("Failed to find " + pathStr + " at " + dir, (Throwable)ie);
            }
        }
        throw new IOException("Could not find " + pathStr + " in any of the directories");
    }

    public Path getLocalPathForWrite(String pathStr) throws IOException {
        return this.localDirsAllocator.getLocalPathForWrite(pathStr, this.getConfig());
    }

    public Path getLocalPathForWrite(String pathStr, long size, boolean checkWrite) throws IOException {
        return this.localDirsAllocator.getLocalPathForWrite(pathStr, size, this.getConfig(), checkWrite);
    }

    public Path getLocalPathForRead(String pathStr) throws IOException {
        return this.getPathToRead(pathStr, this.getLocalDirsForRead());
    }

    public Iterable<Path> getAllLocalPathsForRead(String pathStr) throws IOException {
        return this.localDirsAllocator.getAllLocalPathsToRead(pathStr, this.getConfig());
    }

    public Path getLogPathForWrite(String pathStr, boolean checkWrite) throws IOException {
        return this.logDirsAllocator.getLocalPathForWrite(pathStr, -1L, this.getConfig(), checkWrite);
    }

    public Path getLogPathToRead(String pathStr) throws IOException {
        return this.getPathToRead(pathStr, this.getLogDirsForRead());
    }

    public static String[] validatePaths(String[] paths) {
        ArrayList<String> validPaths = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            try {
                URI uriPath = new Path(paths[i]).toUri();
                if (uriPath.getScheme() != null && !uriPath.getScheme().equals(FILE_SCHEME)) {
                    LOG.warn(paths[i] + " is not a valid path. Path should be with " + FILE_SCHEME + " scheme or without scheme");
                    throw new YarnRuntimeException(paths[i] + " is not a valid path. Path should be with " + FILE_SCHEME + " scheme or without scheme");
                }
                validPaths.add(new Path(uriPath.getPath()).toString());
                continue;
            }
            catch (IllegalArgumentException e) {
                LOG.warn(e.getMessage());
                throw new YarnRuntimeException(paths[i] + " is not a valid path. Path should be with " + FILE_SCHEME + " scheme or without scheme");
            }
        }
        String[] arrValidPaths = new String[validPaths.size()];
        validPaths.toArray(arrValidPaths);
        return arrValidPaths;
    }

    protected void updateMetrics() {
        if (this.nodeManagerMetrics != null) {
            this.nodeManagerMetrics.setBadLocalDirs(this.localDirs.getFailedDirs().size());
            this.nodeManagerMetrics.setBadLogDirs(this.logDirs.getFailedDirs().size());
            this.nodeManagerMetrics.setGoodLocalDirsDiskUtilizationPerc(this.localDirs.getGoodDirsDiskUtilizationPercentage());
            this.nodeManagerMetrics.setGoodLogDirsDiskUtilizationPerc(this.logDirs.getGoodDirsDiskUtilizationPercentage());
        }
    }

    private String buildDiskErrorReport(List<String> dirs, DirectoryCollection directoryCollection) {
        StringBuilder sb = new StringBuilder();
        sb.append(" [ ");
        for (int i = 0; i < dirs.size(); ++i) {
            String dirName = dirs.get(i);
            if (directoryCollection.isDiskUnHealthy(dirName)) {
                sb.append(dirName + " : " + directoryCollection.getDirectoryErrorInfo((String)dirName).message);
            } else {
                sb.append(dirName + " : Unknown cause for disk error");
            }
            if (i == dirs.size() - 1) continue;
            sb.append(" , ");
        }
        sb.append(" ] ");
        return sb.toString();
    }

    private final class MonitoringTimerTask
    extends TimerTask {
        public MonitoringTimerTask(Configuration conf) throws YarnRuntimeException {
            long lowMinFreeSpacePerDiskMB;
            long highMinFreeSpacePerDiskMB;
            float highUsableSpacePercentagePerDisk = conf.getFloat("yarn.nodemanager.disk-health-checker.max-disk-utilization-per-disk-percentage", 90.0f);
            float lowUsableSpacePercentagePerDisk = conf.getFloat("yarn.nodemanager.disk-health-checker.disk-utilization-watermark-low-per-disk-percentage", highUsableSpacePercentagePerDisk);
            if (lowUsableSpacePercentagePerDisk > highUsableSpacePercentagePerDisk) {
                LOG.warn("Using yarn.nodemanager.disk-health-checker.max-disk-utilization-per-disk-percentage as yarn.nodemanager.disk-health-checker.disk-utilization-watermark-low-per-disk-percentage, because yarn.nodemanager.disk-health-checker.disk-utilization-watermark-low-per-disk-percentage is not configured properly.");
                lowUsableSpacePercentagePerDisk = highUsableSpacePercentagePerDisk;
            }
            if ((highMinFreeSpacePerDiskMB = conf.getLong("yarn.nodemanager.disk-health-checker.min-free-space-per-disk-watermark-high-mb", lowMinFreeSpacePerDiskMB = conf.getLong("yarn.nodemanager.disk-health-checker.min-free-space-per-disk-mb", 0L))) < lowMinFreeSpacePerDiskMB) {
                LOG.warn("Using yarn.nodemanager.disk-health-checker.min-free-space-per-disk-mb as yarn.nodemanager.disk-health-checker.min-free-space-per-disk-watermark-high-mb, because yarn.nodemanager.disk-health-checker.min-free-space-per-disk-watermark-high-mb is not configured properly.");
                highMinFreeSpacePerDiskMB = lowMinFreeSpacePerDiskMB;
            }
            LocalDirsHandlerService.this.localDirs = new DirectoryCollection(LocalDirsHandlerService.validatePaths(conf.getTrimmedStrings("yarn.nodemanager.local-dirs")), highUsableSpacePercentagePerDisk, lowUsableSpacePercentagePerDisk, lowMinFreeSpacePerDiskMB, highMinFreeSpacePerDiskMB);
            LocalDirsHandlerService.this.logDirs = new DirectoryCollection(LocalDirsHandlerService.validatePaths(conf.getTrimmedStrings("yarn.nodemanager.log-dirs")), highUsableSpacePercentagePerDisk, lowUsableSpacePercentagePerDisk, lowMinFreeSpacePerDiskMB, highMinFreeSpacePerDiskMB);
            String local = conf.get("yarn.nodemanager.local-dirs");
            conf.set(LocalDirsHandlerService.NM_GOOD_LOCAL_DIRS, local != null ? local : "");
            String diskValidatorName = conf.get("yarn.nodemanager.disk-validator", "basic");
            try {
                DiskValidator diskValidator = DiskValidatorFactory.getInstance((String)diskValidatorName);
                LocalDirsHandlerService.this.localDirsAllocator = new LocalDirAllocator(LocalDirsHandlerService.NM_GOOD_LOCAL_DIRS, diskValidator);
                String log = conf.get("yarn.nodemanager.log-dirs");
                conf.set(LocalDirsHandlerService.NM_GOOD_LOG_DIRS, log != null ? log : "");
                LocalDirsHandlerService.this.logDirsAllocator = new LocalDirAllocator(LocalDirsHandlerService.NM_GOOD_LOG_DIRS, diskValidator);
            }
            catch (DiskChecker.DiskErrorException e) {
                throw new YarnRuntimeException("Failed to create DiskValidator of type " + diskValidatorName + "!", (Throwable)e);
            }
        }

        @Override
        public void run() {
            try {
                LocalDirsHandlerService.this.checkDirs();
            }
            catch (Throwable t) {
                LOG.warn("Error while checking local directories: ", t);
            }
        }
    }
}

