/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DefaultLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DockerLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.JavaSandboxLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.LinuxContainerRuntimeConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.RuncContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerRuntimeContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerExecContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegatingLinuxContainerRuntime
implements LinuxContainerRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingLinuxContainerRuntime.class);
    private DefaultLinuxContainerRuntime defaultLinuxContainerRuntime;
    private DockerLinuxContainerRuntime dockerLinuxContainerRuntime;
    private RuncContainerRuntime runcContainerRuntime;
    private JavaSandboxLinuxContainerRuntime javaSandboxLinuxContainerRuntime;
    private Set<String> allowedRuntimes = new HashSet<String>();
    private List<LinuxContainerRuntime> pluggableRuntimes = new ArrayList<LinuxContainerRuntime>();

    @Override
    public void initialize(Configuration conf, Context nmContext) throws ContainerExecutionException {
        String[] configuredRuntimes;
        for (String configuredRuntime : configuredRuntimes = conf.getTrimmedStrings("yarn.nodemanager.runtime.linux.allowed-runtimes", YarnConfiguration.DEFAULT_LINUX_CONTAINER_RUNTIME_ALLOWED_RUNTIMES)) {
            String normRuntime = configuredRuntime.toUpperCase();
            this.allowedRuntimes.add(normRuntime);
            if (!this.isPluggableRuntime(normRuntime)) continue;
            LinuxContainerRuntime runtime = this.createPluggableRuntime(conf, configuredRuntime);
            runtime.initialize(conf, nmContext);
            this.pluggableRuntimes.add(runtime);
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.JAVASANDBOX.name())) {
            this.javaSandboxLinuxContainerRuntime = new JavaSandboxLinuxContainerRuntime(PrivilegedOperationExecutor.getInstance(conf));
            this.javaSandboxLinuxContainerRuntime.initialize(conf, nmContext);
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.DOCKER.name())) {
            this.dockerLinuxContainerRuntime = new DockerLinuxContainerRuntime(PrivilegedOperationExecutor.getInstance(conf));
            this.dockerLinuxContainerRuntime.initialize(conf, nmContext);
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.RUNC.name())) {
            this.runcContainerRuntime = new RuncContainerRuntime(PrivilegedOperationExecutor.getInstance(conf));
            this.runcContainerRuntime.initialize(conf, nmContext);
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.DEFAULT.name())) {
            this.defaultLinuxContainerRuntime = new DefaultLinuxContainerRuntime(PrivilegedOperationExecutor.getInstance(conf));
            this.defaultLinuxContainerRuntime.initialize(conf, nmContext);
        }
    }

    @Override
    public boolean isRuntimeRequested(Map<String, String> env) {
        return true;
    }

    @VisibleForTesting
    LinuxContainerRuntime pickContainerRuntime(Map<String, String> environment) throws ContainerExecutionException {
        LinuxContainerRuntime runtime;
        if (this.javaSandboxLinuxContainerRuntime != null && this.javaSandboxLinuxContainerRuntime.isRuntimeRequested(environment)) {
            runtime = this.javaSandboxLinuxContainerRuntime;
        } else if (this.dockerLinuxContainerRuntime != null && this.dockerLinuxContainerRuntime.isRuntimeRequested(environment)) {
            runtime = this.dockerLinuxContainerRuntime;
        } else if (this.runcContainerRuntime != null && this.runcContainerRuntime.isRuntimeRequested(environment)) {
            runtime = this.runcContainerRuntime;
        } else {
            LinuxContainerRuntime pluggableRuntime = this.pickPluggableRuntime(environment);
            if (pluggableRuntime != null) {
                runtime = pluggableRuntime;
            } else if (this.defaultLinuxContainerRuntime != null && this.defaultLinuxContainerRuntime.isRuntimeRequested(environment)) {
                runtime = this.defaultLinuxContainerRuntime;
            } else {
                throw new ContainerExecutionException("Requested runtime not allowed.");
            }
        }
        LOG.debug("Using container runtime: {}", (Object)runtime.getClass().getSimpleName());
        return runtime;
    }

    private LinuxContainerRuntime pickPluggableRuntime(Map<String, String> environment) {
        for (LinuxContainerRuntime runtime : this.pluggableRuntimes) {
            if (!runtime.isRuntimeRequested(environment)) continue;
            return runtime;
        }
        return null;
    }

    private LinuxContainerRuntime pickContainerRuntime(Container container) throws ContainerExecutionException {
        return this.pickContainerRuntime(container.getLaunchContext().getEnvironment());
    }

    @Override
    public void prepareContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        LinuxContainerRuntime runtime = this.pickContainerRuntime(ctx.getContainer());
        runtime.prepareContainer(ctx);
    }

    @Override
    public void launchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.launchContainer(ctx);
    }

    @Override
    public void relaunchContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.relaunchContainer(ctx);
    }

    @Override
    public void signalContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.signalContainer(ctx);
    }

    @Override
    public void reapContainer(ContainerRuntimeContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        runtime.reapContainer(ctx);
    }

    @Override
    public String[] getIpAndHost(Container container) throws ContainerExecutionException {
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        return runtime.getIpAndHost(container);
    }

    @Override
    public String getExposedPorts(Container container) throws ContainerExecutionException {
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        return runtime.getExposedPorts(container);
    }

    private boolean isPluggableRuntime(String runtimeType) {
        for (LinuxContainerRuntimeConstants.RuntimeType type : LinuxContainerRuntimeConstants.RuntimeType.values()) {
            if (!type.name().equalsIgnoreCase(runtimeType)) continue;
            return false;
        }
        return true;
    }

    private LinuxContainerRuntime createPluggableRuntime(Configuration conf, String runtimeType) throws ContainerExecutionException {
        String confKey = String.format("yarn.nodemanager.runtime.linux.%s.class", runtimeType);
        Class clazz = conf.getClass(confKey, null, LinuxContainerRuntime.class);
        if (clazz == null) {
            throw new ContainerExecutionException("Invalid runtime set in yarn.nodemanager.runtime.linux.allowed-runtimes : " + runtimeType + " : Missing configuration " + confKey);
        }
        return (LinuxContainerRuntime)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
    }

    @VisibleForTesting
    boolean isRuntimeAllowed(String runtimeType) {
        return runtimeType != null && this.allowedRuntimes.contains(runtimeType.toUpperCase());
    }

    @Override
    public IOStreamPair execContainer(ContainerExecContext ctx) throws ContainerExecutionException {
        Container container = ctx.getContainer();
        LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
        return runtime.execContainer(ctx);
    }

    @Override
    public Map<String, LocalResource> getLocalResources(Container container) throws IOException {
        try {
            LinuxContainerRuntime runtime = this.pickContainerRuntime(container);
            return runtime.getLocalResources(container);
        }
        catch (ContainerExecutionException e) {
            throw new IOException((Throwable)((Object)e));
        }
    }

    @Override
    public void start() {
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.JAVASANDBOX.name())) {
            this.javaSandboxLinuxContainerRuntime.start();
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.DOCKER.name())) {
            this.dockerLinuxContainerRuntime.start();
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.RUNC.name())) {
            this.runcContainerRuntime.start();
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.DEFAULT.name())) {
            this.defaultLinuxContainerRuntime.start();
        }
    }

    @Override
    public void stop() {
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.JAVASANDBOX.name())) {
            this.javaSandboxLinuxContainerRuntime.stop();
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.DOCKER.name())) {
            this.dockerLinuxContainerRuntime.stop();
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.RUNC.name())) {
            this.runcContainerRuntime.stop();
        }
        if (this.isRuntimeAllowed(LinuxContainerRuntimeConstants.RuntimeType.DEFAULT.name())) {
            this.defaultLinuxContainerRuntime.stop();
        }
    }
}

