/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.runc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.runc.ImageManifest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.runc.RuncManifestToResourcesPlugin;

@InterfaceStability.Unstable
public class HdfsManifestToResourcesPlugin
extends AbstractService
implements RuncManifestToResourcesPlugin {
    private Configuration conf;
    private String layersDir;
    private String configDir;
    private FileSystem fs;
    private LoadingCache<Path, FileStatus> statCache;
    private static final String CONFIG_MEDIA_TYPE = "application/vnd.docker.container.image.v1+json";
    private static final String LAYER_TAR_GZIP_MEDIA_TYPE = "application/vnd.docker.image.rootfs.diff.tar.gzip";
    private static final String SHA_256 = "sha256";
    private static final String CONFIG_HASH_ALGORITHM = "sha256";
    private static final String LAYER_HASH_ALGORITHM = "sha256";
    private static final int SHA256_HASH_LENGTH = 64;
    private static final String ALPHA_NUMERIC = "[a-zA-Z0-9]+";

    public HdfsManifestToResourcesPlugin() {
        super(HdfsManifestToResourcesPlugin.class.getName());
    }

    public void serviceInit(Configuration configuration) {
        this.conf = configuration;
        String toplevelDir = this.conf.get("yarn.nodemanager.runtime.linux.runc.image-toplevel-dir", "/runc-root");
        this.layersDir = toplevelDir + "/layers/";
        this.configDir = toplevelDir + "/config/";
        CacheLoader<Path, FileStatus> cacheLoader = new CacheLoader<Path, FileStatus>(){

            public FileStatus load(@Nonnull Path path) throws Exception {
                return HdfsManifestToResourcesPlugin.this.statBlob(path);
            }
        };
        int statCacheSize = this.conf.getInt("yarn.nodemanager.runtime.linux.runc.hdfs-manifest-to-resources-plugin.stat-cache-size", 500);
        int statCacheTimeout = this.conf.getInt("yarn.nodemanager.runtime.linux.runc.hdfs-manifest-to-resources-plugin.stat-cache-timeout-interval-secs", 3600);
        this.statCache = CacheBuilder.newBuilder().maximumSize((long)statCacheSize).refreshAfterWrite((long)statCacheTimeout, TimeUnit.SECONDS).build((CacheLoader)cacheLoader);
    }

    public void serviceStart() throws IOException {
        Path path = new Path(this.layersDir);
        this.fs = path.getFileSystem(this.conf);
    }

    @Override
    public List<LocalResource> getLayerResources(ImageManifest manifest) throws IOException {
        ArrayList<LocalResource> localRsrcs = new ArrayList<LocalResource>();
        for (ImageManifest.Blob blob : manifest.getLayers()) {
            LocalResource rsrc = this.getResource(blob, this.layersDir, LAYER_TAR_GZIP_MEDIA_TYPE, "sha256", ".sqsh");
            localRsrcs.add(rsrc);
        }
        return localRsrcs;
    }

    @Override
    public LocalResource getConfigResource(ImageManifest manifest) throws IOException {
        ImageManifest.Blob config = manifest.getConfig();
        return this.getResource(config, this.configDir, CONFIG_MEDIA_TYPE, "sha256", "");
    }

    public LocalResource getResource(ImageManifest.Blob blob, String dir, String expectedMediaType, String expectedHashAlgorithm, String resourceSuffix) throws IOException {
        LocalResource rsrc;
        String mediaType = blob.getMediaType();
        if (!mediaType.equals(expectedMediaType)) {
            throw new IOException("Invalid blob mediaType: " + mediaType);
        }
        String[] blobDigest = blob.getDigest().split(":", 2);
        String algorithm = blobDigest[0];
        if (!algorithm.equals(expectedHashAlgorithm)) {
            throw new IOException("Invalid blob digest algorithm: " + algorithm);
        }
        String hash = blobDigest[1];
        if (!hash.matches(ALPHA_NUMERIC) || hash.length() != 64) {
            throw new IOException("Malformed blob digest: " + hash);
        }
        long size = blob.getSize();
        Path path = new Path(dir, hash + resourceSuffix);
        try {
            FileStatus stat = (FileStatus)this.statCache.get((Object)path);
            long timestamp = stat.getModificationTime();
            URL url = URL.fromPath((Path)path);
            rsrc = LocalResource.newInstance((URL)url, (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)size, (long)timestamp);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        return rsrc;
    }

    protected FileStatus statBlob(Path path) throws IOException {
        return this.fs.getFileStatus(path);
    }
}

