/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.ResourceNotFoundException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.Device;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DevicePluginScheduler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceMappingManager {
    static final Logger LOG = LoggerFactory.getLogger(DeviceMappingManager.class);
    private Context nmContext;
    private static final int WAIT_MS_PER_LOOP = 1000;
    private Map<String, DevicePluginScheduler> devicePluginSchedulers = new ConcurrentHashMap<String, DevicePluginScheduler>();
    private Map<String, Set<Device>> allAllowedDevices = new ConcurrentHashMap<String, Set<Device>>();
    private Map<String, Map<Device, ContainerId>> allUsedDevices = new ConcurrentHashMap<String, Map<Device, ContainerId>>();

    public DeviceMappingManager(Context context) {
        this.nmContext = context;
    }

    @VisibleForTesting
    public Map<String, Set<Device>> getAllAllowedDevices() {
        return this.allAllowedDevices;
    }

    @VisibleForTesting
    public Map<String, Map<Device, ContainerId>> getAllUsedDevices() {
        return this.allUsedDevices;
    }

    @VisibleForTesting
    public Map<String, DevicePluginScheduler> getDevicePluginSchedulers() {
        return this.devicePluginSchedulers;
    }

    @VisibleForTesting
    public Set<Device> getAllocatedDevices(String resourceName, ContainerId cId) {
        TreeSet<Device> assigned = new TreeSet<Device>();
        Map<Device, ContainerId> assignedMap = this.getAllUsedDevices().get(resourceName);
        for (Map.Entry<Device, ContainerId> entry : assignedMap.entrySet()) {
            if (!entry.getValue().equals((Object)cId)) continue;
            assigned.add(entry.getKey());
        }
        return assigned;
    }

    public synchronized void addDeviceSet(String resourceName, Set<Device> deviceSet) {
        LOG.info("Adding new resource: type:" + resourceName + "," + deviceSet);
        this.allAllowedDevices.put(resourceName, new TreeSet<Device>(deviceSet));
        this.allUsedDevices.put(resourceName, new TreeMap());
    }

    public DeviceAllocation assignDevices(String resourceName, Container container) throws ResourceHandlerException {
        DeviceAllocation allocation = this.internalAssignDevices(resourceName, container);
        int timeoutMsecs = 120000;
        for (int timeWaiting = 0; allocation == null && timeWaiting < 120000; timeWaiting += 1000) {
            try {
                LOG.info("Container : " + container.getContainerId() + " is waiting for free " + resourceName + " devices.");
                Thread.sleep(1000L);
                allocation = this.internalAssignDevices(resourceName, container);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (allocation == null) {
            String message = "Could not get valid " + resourceName + " device for container '" + container.getContainerId() + "' as some other containers might not releasing them.";
            LOG.warn(message);
            throw new ResourceHandlerException(message);
        }
        return allocation;
    }

    private synchronized DeviceAllocation internalAssignDevices(String resourceName, Container container) throws ResourceHandlerException {
        Resource requestedResource = container.getResource();
        ContainerId containerId = container.getContainerId();
        int requestedDeviceCount = DeviceMappingManager.getRequestedDeviceCount(resourceName, requestedResource);
        LOG.debug("Try allocating {} {}", (Object)requestedDeviceCount, (Object)resourceName);
        if (requestedDeviceCount > 0) {
            if (requestedDeviceCount > this.getAvailableDevices(resourceName) && (long)requestedDeviceCount <= this.getReleasingDevices(resourceName) + (long)this.getAvailableDevices(resourceName)) {
                return null;
            }
            int availableDeviceCount = this.getAvailableDevices(resourceName);
            if (requestedDeviceCount > availableDeviceCount) {
                throw new ResourceHandlerException("Failed to find enough " + resourceName + ", requestor=" + containerId + ", #Requested=" + requestedDeviceCount + ", #available=" + availableDeviceCount);
            }
            TreeSet<Device> assignedDevices = new TreeSet<Device>();
            Map<Device, ContainerId> usedDevices = this.allUsedDevices.get(resourceName);
            Set<Device> allowedDevices = this.allAllowedDevices.get(resourceName);
            DevicePluginScheduler dps = this.devicePluginSchedulers.get(resourceName);
            this.pickAndDoSchedule(allowedDevices, usedDevices, assignedDevices, container, requestedDeviceCount, resourceName, dps);
            if (!assignedDevices.isEmpty()) {
                try {
                    this.nmContext.getNMStateStore().storeAssignedResources(container, resourceName, new ArrayList<Serializable>(assignedDevices));
                }
                catch (IOException e) {
                    this.cleanupAssignedDevices(resourceName, containerId);
                    throw new ResourceHandlerException(e);
                }
            }
            return new DeviceAllocation(resourceName, assignedDevices, (Set<Device>)Sets.difference(allowedDevices, assignedDevices));
        }
        return new DeviceAllocation(resourceName, null, this.allAllowedDevices.get(resourceName));
    }

    public synchronized void recoverAssignedDevices(String resourceName, ContainerId containerId) throws ResourceHandlerException {
        Container c = (Container)this.nmContext.getContainers().get(containerId);
        Map<Device, ContainerId> usedDevices = this.allUsedDevices.get(resourceName);
        Set<Device> allowedDevices = this.allAllowedDevices.get(resourceName);
        if (null == c) {
            throw new ResourceHandlerException("This shouldn't happen, cannot find container with id=" + containerId);
        }
        for (Serializable deviceSerializable : c.getResourceMappings().getAssignedResources(resourceName)) {
            if (!(deviceSerializable instanceof Device)) {
                throw new ResourceHandlerException("Trying to recover device id, however it is not Device instance, this shouldn't happen");
            }
            Device device = (Device)deviceSerializable;
            if (!allowedDevices.contains(device)) {
                throw new ResourceHandlerException("Try to recover device = " + device + " however it is not in allowed device list:" + StringUtils.join((CharSequence)",", allowedDevices));
            }
            if (usedDevices.containsKey(device)) {
                throw new ResourceHandlerException("Try to recover device id = " + device + " however it is already assigned to container=" + usedDevices.get(device) + ", please double check what happened.");
            }
            usedDevices.put(device, containerId);
        }
    }

    public synchronized void cleanupAssignedDevices(String resourceName, ContainerId containerId) {
        Iterator<Map.Entry<Device, ContainerId>> iter = this.allUsedDevices.get(resourceName).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Device, ContainerId> entry = iter.next();
            if (!entry.getValue().equals((Object)containerId)) continue;
            LOG.debug("Recycle devices: {}, type: {} from {}", new Object[]{entry.getKey(), resourceName, containerId});
            iter.remove();
        }
    }

    public static int getRequestedDeviceCount(String resName, Resource requestedResource) {
        try {
            return Long.valueOf(requestedResource.getResourceValue(resName)).intValue();
        }
        catch (ResourceNotFoundException e) {
            return 0;
        }
    }

    public int getAvailableDevices(String resourceName) {
        return this.allAllowedDevices.get(resourceName).size() - this.allUsedDevices.get(resourceName).size();
    }

    private long getReleasingDevices(String resourceName) {
        long releasingDevices = 0L;
        Map<Device, ContainerId> used = this.allUsedDevices.get(resourceName);
        for (ContainerId containerId : ImmutableSet.copyOf(used.values())) {
            Container container = (Container)this.nmContext.getContainers().get(containerId);
            if (container == null || !container.isContainerInFinalStates()) continue;
            releasingDevices += container.getResource().getResourceInformation(resourceName).getValue();
        }
        return releasingDevices;
    }

    private void pickAndDoSchedule(Set<Device> allowed, Map<Device, ContainerId> used, Set<Device> assigned, Container c, int count, String resourceName, DevicePluginScheduler dps) throws ResourceHandlerException {
        ContainerId containerId = c.getContainerId();
        Map env = c.getLaunchContext().getEnvironment();
        if (null == dps) {
            LOG.debug("Customized device plugin scheduler is preferred but not implemented, use default logic");
            this.defaultScheduleAction(allowed, used, assigned, containerId, count);
        } else {
            Set<Device> dpsAllocated;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Customized device plugin implemented,use customized logic");
                LOG.debug("Try to schedule " + count + "(" + resourceName + ") using " + dps.getClass());
            }
            if ((dpsAllocated = dps.allocateDevices((Set<Device>)Sets.difference(allowed, used.keySet()), count, (Map<String, String>)ImmutableMap.copyOf((Map)env))).size() != count) {
                throw new ResourceHandlerException(dps.getClass() + " should allocate " + count + " of " + resourceName + ", but actual: " + assigned.size());
            }
            assigned.addAll(dpsAllocated);
            for (Device device : assigned) {
                used.put(device, containerId);
            }
        }
    }

    private void defaultScheduleAction(Set<Device> allowed, Map<Device, ContainerId> used, Set<Device> assigned, ContainerId containerId, int count) {
        LOG.debug("Using default scheduler. Allowed:" + allowed + ",Used:" + used + ", containerId:" + containerId);
        for (Device device : allowed) {
            if (used.containsKey(device)) continue;
            used.put(device, containerId);
            assigned.add(device);
            if (assigned.size() != count) continue;
            return;
        }
    }

    @VisibleForTesting
    public synchronized void addDevicePluginScheduler(String resourceName, DevicePluginScheduler s) {
        this.devicePluginSchedulers.put(resourceName, Objects.requireNonNull(s));
    }

    static class DeviceAllocation {
        private String resourceName;
        private Set<Device> allowed = Collections.emptySet();
        private Set<Device> denied = Collections.emptySet();

        DeviceAllocation(String resName, Set<Device> a, Set<Device> d) {
            this.resourceName = resName;
            if (a != null) {
                this.allowed = ImmutableSet.copyOf(a);
            }
            if (d != null) {
                this.denied = ImmutableSet.copyOf(d);
            }
        }

        public Set<Device> getAllowed() {
            return this.allowed;
        }

        public Set<Device> getDenied() {
            return this.denied;
        }

        public String toString() {
            return "ResourceType: " + this.resourceName + ", Allowed Devices: " + this.allowed + ", Denied Devices: " + this.denied;
        }
    }
}

