/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ResourceMappings;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.gpu.GpuResourceAllocator;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerRunCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerVolumeCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.DockerCommandPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvidiaDockerV2CommandPlugin
implements DockerCommandPlugin {
    static final Logger LOG = LoggerFactory.getLogger(NvidiaDockerV2CommandPlugin.class);
    private String nvidiaRuntime = "nvidia";
    private String nvidiaVisibleDevices = "NVIDIA_VISIBLE_DEVICES";

    private Set<GpuDevice> getAssignedGpus(Container container) {
        ResourceMappings resourceMappings = container.getResourceMappings();
        HashSet<GpuDevice> assignedResources = null;
        if (resourceMappings != null) {
            assignedResources = new HashSet<GpuDevice>();
            for (Serializable s : resourceMappings.getAssignedResources("yarn.io/gpu")) {
                assignedResources.add((GpuDevice)s);
            }
        }
        if (assignedResources == null || assignedResources.isEmpty()) {
            return Collections.emptySet();
        }
        return assignedResources;
    }

    @VisibleForTesting
    protected boolean requestsGpu(Container container) {
        return GpuResourceAllocator.getRequestedGpus(container.getResource()) > 0;
    }

    @Override
    public synchronized void updateDockerRunCommand(DockerRunCommand dockerRunCommand, Container container) throws ContainerExecutionException {
        if (!this.requestsGpu(container)) {
            return;
        }
        Set<GpuDevice> assignedResources = this.getAssignedGpus(container);
        if (assignedResources == null || assignedResources.isEmpty()) {
            return;
        }
        HashMap<String, String> environment = new HashMap<String, String>();
        String gpuIndexList = "";
        for (GpuDevice gpuDevice : assignedResources) {
            gpuIndexList = gpuIndexList + gpuDevice.getIndex() + ",";
            LOG.info("nvidia docker2 assigned gpu index: " + gpuDevice.getIndex());
        }
        dockerRunCommand.addRuntime(this.nvidiaRuntime);
        environment.put(this.nvidiaVisibleDevices, gpuIndexList.substring(0, gpuIndexList.length() - 1));
        dockerRunCommand.addEnv(environment);
    }

    @Override
    public DockerVolumeCommand getCreateDockerVolumeCommand(Container container) throws ContainerExecutionException {
        return null;
    }

    @Override
    public DockerVolumeCommand getCleanupDockerVolumesCommand(Container container) throws ContainerExecutionException {
        return null;
    }
}

