/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.com.nec;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.Device;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.com.nec.UdevUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VEDeviceDiscoverer {
    private static final String STATE_TERMINATING = "TERMINATING";
    private static final String STATE_INITIALIZING = "INITIALIZING";
    private static final String STATE_OFFLINE = "OFFLINE";
    private static final String STATE_ONLINE = "ONLINE";
    private static final Logger LOG = LoggerFactory.getLogger(VEDeviceDiscoverer.class);
    private static final String[] DEVICE_STATE = new String[]{"ONLINE", "OFFLINE", "INITIALIZING", "TERMINATING"};
    private UdevUtil udev;
    private Function<String[], Shell.CommandExecutor> commandExecutorProvider = this::createCommandExecutor;

    VEDeviceDiscoverer(UdevUtil udevUtil) {
        this.udev = udevUtil;
    }

    public Set<Device> getDevicesFromPath(String path) throws IOException {
        MutableInt counter = new MutableInt(0);
        return Files.walk(Paths.get(path, new String[0]), 1, new FileVisitOption[0]).filter(p -> p.toFile().getName().startsWith("veslot")).map(p -> this.toDevice((Path)p, counter)).collect(Collectors.toSet());
    }

    private Device toDevice(Path p, MutableInt counter) {
        Shell.CommandExecutor executor = this.commandExecutorProvider.apply(new String[]{"stat", "-L", "-c", "%t:%T:%F", p.toString()});
        try {
            LOG.info("Checking device file: {}", (Object)p);
            executor.execute();
            String statOutput = executor.getOutput();
            String[] stat = statOutput.trim().split(":");
            int major = Integer.parseInt(stat[0], 16);
            int minor = Integer.parseInt(stat[1], 16);
            char devType = this.getDevType(p, stat[2]);
            int deviceNumber = this.makeDev(major, minor);
            LOG.info("Device: major: {}, minor: {}, devNo: {}, type: {}", new Object[]{major, minor, deviceNumber, Character.valueOf(devType)});
            String sysPath = this.udev.getSysPath(deviceNumber, devType);
            LOG.info("Device syspath: {}", (Object)sysPath);
            String deviceState = this.getDeviceState(sysPath);
            Device.Builder builder = Device.Builder.newInstance();
            builder.setId(counter.getAndIncrement()).setMajorNumber(major).setMinorNumber(minor).setHealthy(STATE_ONLINE.equalsIgnoreCase(deviceState)).setStatus(deviceState).setDevPath(p.toAbsolutePath().toString());
            return builder.build();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot execute stat command", e);
        }
    }

    private int makeDev(int major, int minor) {
        return major * 256 + minor;
    }

    private char getDevType(Path p, String fromStat) {
        if (fromStat.contains("character")) {
            return 'c';
        }
        if (fromStat.contains("block")) {
            return 'b';
        }
        throw new IllegalArgumentException("File is neither a char nor block device: " + p);
    }

    private String getDeviceState(String sysPath) throws IOException {
        Path statePath = Paths.get(sysPath, "os_state");
        try (FileInputStream fis = new FileInputStream(statePath.toString());){
            byte state = (byte)fis.read();
            if (state < 0 || DEVICE_STATE.length <= state) {
                String string = String.format("Unknown (%d)", state);
                return string;
            }
            String string = DEVICE_STATE[state];
            return string;
        }
    }

    private Shell.CommandExecutor createCommandExecutor(String[] command) {
        return new Shell.ShellCommandExecutor(command);
    }

    @VisibleForTesting
    void setCommandExecutorProvider(Function<String[], Shell.CommandExecutor> provider) {
        this.commandExecutorProvider = provider;
    }
}

