/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.ReservationACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ReservationQueueConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

public class AllocationConfiguration
extends ReservationSchedulerConfiguration {
    private static final Log LOG = LogFactory.getLog((String)FSQueue.class.getName());
    private static final AccessControlList EVERYBODY_ACL = new AccessControlList("*");
    private static final AccessControlList NOBODY_ACL = new AccessControlList(" ");
    private final Map<String, Resource> minQueueResources;
    @VisibleForTesting
    final Map<String, ConfigurableResource> maxQueueResources;
    private final Map<String, ConfigurableResource> maxChildQueueResources;
    private final Map<String, ResourceWeights> queueWeights;
    @VisibleForTesting
    final Map<String, Integer> queueMaxApps;
    @VisibleForTesting
    final Map<String, Integer> userMaxApps;
    private final int userMaxAppsDefault;
    private final int queueMaxAppsDefault;
    private final ConfigurableResource queueMaxResourcesDefault;
    final Map<String, Float> queueMaxAMShares;
    private final float queueMaxAMShareDefault;
    private final Map<String, Map<AccessType, AccessControlList>> queueAcls;
    private final Map<String, Map<ReservationACL, AccessControlList>> resAcls;
    private final Map<String, Long> minSharePreemptionTimeouts;
    private final Map<String, Long> fairSharePreemptionTimeouts;
    private final Map<String, Float> fairSharePreemptionThresholds;
    private final Set<String> reservableQueues;
    private final Map<String, SchedulingPolicy> schedulingPolicies;
    private final SchedulingPolicy defaultSchedulingPolicy;
    @VisibleForTesting
    QueuePlacementPolicy placementPolicy;
    @VisibleForTesting
    Map<FSQueueType, Set<String>> configuredQueues;
    private ReservationQueueConfiguration globalReservationQueueConfig;
    private final Set<String> nonPreemptableQueues;

    public AllocationConfiguration(Map<String, Resource> minQueueResources, Map<String, ConfigurableResource> maxQueueResources, Map<String, ConfigurableResource> maxChildQueueResources, Map<String, Integer> queueMaxApps, Map<String, Integer> userMaxApps, Map<String, ResourceWeights> queueWeights, Map<String, Float> queueMaxAMShares, int userMaxAppsDefault, int queueMaxAppsDefault, ConfigurableResource queueMaxResourcesDefault, float queueMaxAMShareDefault, Map<String, SchedulingPolicy> schedulingPolicies, SchedulingPolicy defaultSchedulingPolicy, Map<String, Long> minSharePreemptionTimeouts, Map<String, Long> fairSharePreemptionTimeouts, Map<String, Float> fairSharePreemptionThresholds, Map<String, Map<AccessType, AccessControlList>> queueAcls, Map<String, Map<ReservationACL, AccessControlList>> resAcls, QueuePlacementPolicy placementPolicy, Map<FSQueueType, Set<String>> configuredQueues, ReservationQueueConfiguration globalReservationQueueConfig, Set<String> reservableQueues, Set<String> nonPreemptableQueues) {
        this.minQueueResources = minQueueResources;
        this.maxQueueResources = maxQueueResources;
        this.maxChildQueueResources = maxChildQueueResources;
        this.queueMaxApps = queueMaxApps;
        this.userMaxApps = userMaxApps;
        this.queueMaxAMShares = queueMaxAMShares;
        this.queueWeights = queueWeights;
        this.userMaxAppsDefault = userMaxAppsDefault;
        this.queueMaxResourcesDefault = queueMaxResourcesDefault;
        this.queueMaxAppsDefault = queueMaxAppsDefault;
        this.queueMaxAMShareDefault = queueMaxAMShareDefault;
        this.defaultSchedulingPolicy = defaultSchedulingPolicy;
        this.schedulingPolicies = schedulingPolicies;
        this.minSharePreemptionTimeouts = minSharePreemptionTimeouts;
        this.fairSharePreemptionTimeouts = fairSharePreemptionTimeouts;
        this.fairSharePreemptionThresholds = fairSharePreemptionThresholds;
        this.queueAcls = queueAcls;
        this.resAcls = resAcls;
        this.reservableQueues = reservableQueues;
        this.globalReservationQueueConfig = globalReservationQueueConfig;
        this.placementPolicy = placementPolicy;
        this.configuredQueues = configuredQueues;
        this.nonPreemptableQueues = nonPreemptableQueues;
    }

    public AllocationConfiguration(Configuration conf) {
        this.minQueueResources = new HashMap<String, Resource>();
        this.maxChildQueueResources = new HashMap<String, ConfigurableResource>();
        this.maxQueueResources = new HashMap<String, ConfigurableResource>();
        this.queueWeights = new HashMap<String, ResourceWeights>();
        this.queueMaxApps = new HashMap<String, Integer>();
        this.userMaxApps = new HashMap<String, Integer>();
        this.queueMaxAMShares = new HashMap<String, Float>();
        this.userMaxAppsDefault = Integer.MAX_VALUE;
        this.queueMaxAppsDefault = Integer.MAX_VALUE;
        this.queueMaxResourcesDefault = new ConfigurableResource(Resources.unbounded());
        this.queueMaxAMShareDefault = 0.5f;
        this.queueAcls = new HashMap<String, Map<AccessType, AccessControlList>>();
        this.resAcls = new HashMap<String, Map<ReservationACL, AccessControlList>>();
        this.minSharePreemptionTimeouts = new HashMap<String, Long>();
        this.fairSharePreemptionTimeouts = new HashMap<String, Long>();
        this.fairSharePreemptionThresholds = new HashMap<String, Float>();
        this.schedulingPolicies = new HashMap<String, SchedulingPolicy>();
        this.defaultSchedulingPolicy = SchedulingPolicy.DEFAULT_POLICY;
        this.reservableQueues = new HashSet<String>();
        this.configuredQueues = new HashMap<FSQueueType, Set<String>>();
        for (FSQueueType queueType : FSQueueType.values()) {
            this.configuredQueues.put(queueType, new HashSet());
        }
        this.placementPolicy = QueuePlacementPolicy.fromConfiguration(conf, this.configuredQueues);
        this.nonPreemptableQueues = new HashSet<String>();
    }

    public AccessControlList getQueueAcl(String queue, QueueACL operation) {
        AccessControlList operationAcl;
        Map<AccessType, AccessControlList> acls = this.queueAcls.get(queue);
        if (acls != null && (operationAcl = acls.get(SchedulerUtils.toAccessType(operation))) != null) {
            return operationAcl;
        }
        return queue.equals("root") ? EVERYBODY_ACL : NOBODY_ACL;
    }

    public Map<String, Map<AccessType, AccessControlList>> getQueueAcls() {
        return Collections.unmodifiableMap(this.queueAcls);
    }

    @Override
    public Map<ReservationACL, AccessControlList> getReservationAcls(String queue) {
        return this.resAcls.get(queue);
    }

    public long getMinSharePreemptionTimeout(String queueName) {
        Long minSharePreemptionTimeout = this.minSharePreemptionTimeouts.get(queueName);
        return minSharePreemptionTimeout == null ? -1L : minSharePreemptionTimeout;
    }

    public long getFairSharePreemptionTimeout(String queueName) {
        Long fairSharePreemptionTimeout = this.fairSharePreemptionTimeouts.get(queueName);
        return fairSharePreemptionTimeout == null ? -1L : fairSharePreemptionTimeout;
    }

    public float getFairSharePreemptionThreshold(String queueName) {
        Float fairSharePreemptionThreshold = this.fairSharePreemptionThresholds.get(queueName);
        return fairSharePreemptionThreshold == null ? -1.0f : fairSharePreemptionThreshold.floatValue();
    }

    public boolean isPreemptable(String queueName) {
        return !this.nonPreemptableQueues.contains(queueName);
    }

    private ResourceWeights getQueueWeight(String queue) {
        ResourceWeights weight = this.queueWeights.get(queue);
        return weight == null ? ResourceWeights.NEUTRAL : weight;
    }

    public int getUserMaxApps(String user) {
        Integer maxApps = this.userMaxApps.get(user);
        return maxApps == null ? this.userMaxAppsDefault : maxApps;
    }

    @VisibleForTesting
    int getQueueMaxApps(String queue) {
        Integer maxApps = this.queueMaxApps.get(queue);
        return maxApps == null ? this.queueMaxAppsDefault : maxApps;
    }

    @VisibleForTesting
    float getQueueMaxAMShare(String queue) {
        Float maxAMShare = this.queueMaxAMShares.get(queue);
        return maxAMShare == null ? this.queueMaxAMShareDefault : maxAMShare.floatValue();
    }

    @VisibleForTesting
    Resource getMinResources(String queue) {
        Resource minQueueResource = this.minQueueResources.get(queue);
        return minQueueResource == null ? Resources.none() : minQueueResource;
    }

    @VisibleForTesting
    ConfigurableResource getMaxResources(String queue) {
        ConfigurableResource maxQueueResource = this.maxQueueResources.get(queue);
        if (maxQueueResource == null) {
            maxQueueResource = this.queueMaxResourcesDefault;
        }
        return maxQueueResource;
    }

    @VisibleForTesting
    ConfigurableResource getMaxChildResources(String queue) {
        return this.maxChildQueueResources.get(queue);
    }

    @VisibleForTesting
    SchedulingPolicy getSchedulingPolicy(String queueName) {
        SchedulingPolicy policy = this.schedulingPolicies.get(queueName);
        return policy == null ? this.defaultSchedulingPolicy : policy;
    }

    public SchedulingPolicy getDefaultSchedulingPolicy() {
        return this.defaultSchedulingPolicy;
    }

    public Map<FSQueueType, Set<String>> getConfiguredQueues() {
        return this.configuredQueues;
    }

    public QueuePlacementPolicy getPlacementPolicy() {
        return this.placementPolicy;
    }

    @Override
    public boolean isReservable(String queue) {
        return this.reservableQueues.contains(queue);
    }

    @Override
    public long getReservationWindow(String queue) {
        return this.globalReservationQueueConfig.getReservationWindowMsec();
    }

    @Override
    public float getAverageCapacity(String queue) {
        return this.globalReservationQueueConfig.getAvgOverTimeMultiplier() * 100.0f;
    }

    @Override
    public float getInstantaneousMaxCapacity(String queue) {
        return this.globalReservationQueueConfig.getMaxOverTimeMultiplier() * 100.0f;
    }

    @Override
    public String getReservationAdmissionPolicy(String queue) {
        return this.globalReservationQueueConfig.getReservationAdmissionPolicy();
    }

    @Override
    public String getReservationAgent(String queue) {
        return this.globalReservationQueueConfig.getReservationAgent();
    }

    @Override
    public boolean getShowReservationAsQueues(String queue) {
        return this.globalReservationQueueConfig.shouldShowReservationAsQueues();
    }

    @Override
    public String getReplanner(String queue) {
        return this.globalReservationQueueConfig.getPlanner();
    }

    @Override
    public boolean getMoveOnExpiry(String queue) {
        return this.globalReservationQueueConfig.shouldMoveOnExpiry();
    }

    @Override
    public long getEnforcementWindow(String queue) {
        return this.globalReservationQueueConfig.getEnforcementWindowMsec();
    }

    @VisibleForTesting
    public void setReservationWindow(long window) {
        this.globalReservationQueueConfig.setReservationWindow(window);
    }

    @VisibleForTesting
    public void setAverageCapacity(int avgCapacity) {
        this.globalReservationQueueConfig.setAverageCapacity(avgCapacity);
    }

    public void initFSQueue(FSQueue queue) {
        String name = queue.getName();
        queue.setWeights(this.getQueueWeight(name));
        queue.setMinShare(this.getMinResources(name));
        queue.setMaxShare(this.getMaxResources(name));
        queue.setMaxRunningApps(this.getQueueMaxApps(name));
        queue.setMaxAMShare(this.getQueueMaxAMShare(name));
        queue.setMaxChildQueueResource(this.getMaxChildResources(name));
        queue.getMetrics().setMinShare(queue.getMinShare());
        queue.getMetrics().setMaxShare(queue.getMaxShare());
        queue.getMetrics().setMaxApps(queue.getMaxRunningApps());
        queue.getMetrics().setSchedulingPolicy(this.getSchedulingPolicy(name).getName());
    }
}

