/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;

/*
 * Exception performing whole class analysis ignored.
 */
public class MockNodes {
    private static int NODE_ID = 0;
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public static List<RMNode> newNodes(int racks, int nodesPerRack, Resource perNode) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < racks; ++i) {
            for (int j = 0; j < nodesPerRack; ++j) {
                if (j == nodesPerRack - 1) {
                    list.add(MockNodes.nodeInfo((int)i, (Resource)perNode, (NodeState)NodeState.UNHEALTHY));
                }
                list.add(MockNodes.newNodeInfo((int)i, (Resource)perNode));
            }
        }
        return list;
    }

    public static List<RMNode> deactivatedNodes(int racks, int nodesPerRack, Resource perNode) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < racks; ++i) {
            for (int j = 0; j < nodesPerRack; ++j) {
                NodeState[] allStates = NodeState.values();
                list.add(MockNodes.nodeInfo((int)i, (Resource)perNode, (NodeState)allStates[j % allStates.length]));
            }
        }
        return list;
    }

    public static Resource newResource(int mem) {
        Resource rs = (Resource)recordFactory.newRecordInstance(Resource.class);
        rs.setMemory(mem);
        return rs;
    }

    public static Resource newUsedResource(Resource total) {
        Resource rs = (Resource)recordFactory.newRecordInstance(Resource.class);
        rs.setMemory((int)(Math.random() * (double)total.getMemory()));
        return rs;
    }

    public static Resource newAvailResource(Resource total, Resource used) {
        Resource rs = (Resource)recordFactory.newRecordInstance(Resource.class);
        rs.setMemory(total.getMemory() - used.getMemory());
        return rs;
    }

    private static RMNode buildRMNode(int rack, Resource perNode, NodeState state, String httpAddr) {
        return MockNodes.buildRMNode((int)rack, (Resource)perNode, (NodeState)state, (String)httpAddr, (int)NODE_ID++, null, (int)123);
    }

    private static RMNode buildRMNode(int rack, Resource perNode, NodeState state, String httpAddr, int hostnum, String hostName, int port) {
        String rackName = "rack" + rack;
        int nid = hostnum;
        String nodeAddr = hostName + ":" + nid;
        if (hostName == null) {
            hostName = "host" + nid;
        }
        NodeId nodeID = NodeId.newInstance((String)hostName, (int)port);
        String httpAddress = httpAddr;
        String healthReport = state == NodeState.UNHEALTHY ? null : "HealthyMe";
        return new MockRMNodeImpl(nodeID, nodeAddr, httpAddress, ResourceOption.newInstance((Resource)perNode, (int)-1), rackName, healthReport, 0L, nid, hostName, state);
    }

    public static RMNode nodeInfo(int rack, Resource perNode, NodeState state) {
        return MockNodes.buildRMNode((int)rack, (Resource)perNode, (NodeState)state, (String)"N/A");
    }

    public static RMNode newNodeInfo(int rack, Resource perNode) {
        return MockNodes.buildRMNode((int)rack, (Resource)perNode, (NodeState)NodeState.RUNNING, (String)"localhost:0");
    }

    public static RMNode newNodeInfo(int rack, Resource perNode, int hostnum) {
        return MockNodes.buildRMNode((int)rack, (Resource)perNode, null, (String)"localhost:0", (int)hostnum, null, (int)123);
    }

    public static RMNode newNodeInfo(int rack, Resource perNode, int hostnum, String hostName) {
        return MockNodes.buildRMNode((int)rack, (Resource)perNode, null, (String)"localhost:0", (int)hostnum, (String)hostName, (int)123);
    }

    public static RMNode newNodeInfo(int rack, Resource perNode, int hostnum, String hostName, int port) {
        return MockNodes.buildRMNode((int)rack, (Resource)perNode, null, (String)"localhost:0", (int)hostnum, (String)hostName, (int)port);
    }
}

