/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.resourcetracker;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.resourcetracker.TestNMReconnect;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNMReconnect {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private RMNodeEvent rmNodeEvent = null;
    ResourceTrackerService resourceTrackerService;

    @Before
    public void setUp() {
        Configuration conf = new Configuration();
        InlineDispatcher dispatcher = new InlineDispatcher();
        dispatcher.register(RMNodeEventType.class, (EventHandler)new TestRMNodeEventDispatcher(this, null));
        RMContextImpl context = new RMContextImpl((Dispatcher)dispatcher, null, null, null, null, null, null, null, null, null);
        dispatcher.register(SchedulerEventType.class, (EventHandler)new InlineDispatcher.EmptyEventHandler());
        dispatcher.register(RMNodeEventType.class, (EventHandler)new ResourceManager.NodeEventDispatcher((RMContext)context));
        NMLivelinessMonitor nmLivelinessMonitor = new NMLivelinessMonitor((Dispatcher)dispatcher);
        nmLivelinessMonitor.init(conf);
        nmLivelinessMonitor.start();
        NodesListManager nodesListManager = new NodesListManager((RMContext)context);
        nodesListManager.init(conf);
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager(conf);
        containerTokenSecretManager.start();
        NMTokenSecretManagerInRM nmTokenSecretManager = new NMTokenSecretManagerInRM(conf);
        nmTokenSecretManager.start();
        this.resourceTrackerService = new ResourceTrackerService((RMContext)context, nodesListManager, nmLivelinessMonitor, containerTokenSecretManager, nmTokenSecretManager);
        this.resourceTrackerService.init(conf);
        this.resourceTrackerService.start();
    }

    @Test
    public void testReconnect() throws Exception {
        String hostname1 = "localhost1";
        Resource capability = BuilderUtils.newResource((int)1024, (int)1);
        RegisterNodeManagerRequest request1 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        NodeId nodeId1 = NodeId.newInstance((String)hostname1, (int)0);
        request1.setNodeId(nodeId1);
        request1.setHttpPort(0);
        request1.setResource(capability);
        this.resourceTrackerService.registerNodeManager(request1);
        Assert.assertEquals((Object)RMNodeEventType.STARTED, (Object)this.rmNodeEvent.getType());
        this.rmNodeEvent = null;
        this.resourceTrackerService.registerNodeManager(request1);
        Assert.assertEquals((Object)RMNodeEventType.RECONNECTED, (Object)this.rmNodeEvent.getType());
        this.rmNodeEvent = null;
        this.resourceTrackerService.registerNodeManager(request1);
        capability = BuilderUtils.newResource((int)1024, (int)2);
        request1.setResource(capability);
        Assert.assertEquals((Object)RMNodeEventType.RECONNECTED, (Object)this.rmNodeEvent.getType());
    }

    static /* synthetic */ RMNodeEvent access$002(TestNMReconnect x0, RMNodeEvent x1) {
        x0.rmNodeEvent = x1;
        return x0.rmNodeEvent;
    }
}

