/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AppSchedulingInfo {
    private static final Log LOG = LogFactory.getLog(AppSchedulingInfo.class);
    private final ApplicationAttemptId applicationAttemptId;
    final ApplicationId applicationId;
    private final String queueName;
    Queue queue;
    final String user;
    private final AtomicInteger containerIdCounter;
    private final int EPOCH_BIT_MASK = 1023;
    private final int EPOCH_BIT_SHIFT = 22;
    final Set<Priority> priorities = new TreeSet(new Priority.Comparator());
    final Map<Priority, Map<String, ResourceRequest>> requests = new HashMap();
    private Set<String> blacklist = new HashSet();
    private ActiveUsersManager activeUsersManager;
    boolean pending = true;

    public AppSchedulingInfo(ApplicationAttemptId appAttemptId, String user, Queue queue, ActiveUsersManager activeUsersManager, int epoch) {
        this.applicationAttemptId = appAttemptId;
        this.applicationId = appAttemptId.getApplicationId();
        this.queue = queue;
        this.queueName = queue.getQueueName();
        this.user = user;
        this.activeUsersManager = activeUsersManager;
        this.containerIdCounter = new AtomicInteger((epoch & 0x3FF) << 22);
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getUser() {
        return this.user;
    }

    public synchronized boolean isPending() {
        return this.pending;
    }

    private synchronized void clearRequests() {
        this.priorities.clear();
        this.requests.clear();
        LOG.info((Object)("Application " + this.applicationId + " requests cleared"));
    }

    public int getNewContainerId() {
        return this.containerIdCounter.incrementAndGet();
    }

    public synchronized void updateResourceRequests(List<ResourceRequest> requests, boolean recoverPreemptedRequest) {
        QueueMetrics metrics = this.queue.getMetrics();
        for (ResourceRequest request : requests) {
            HashMap<String, ResourceRequest> asks;
            Priority priority = request.getPriority();
            String resourceName = request.getResourceName();
            boolean updatePendingResources = false;
            ResourceRequest lastRequest = null;
            if (resourceName.equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("update: application=" + this.applicationId + " request=" + request));
                }
                updatePendingResources = true;
                if (request.getNumContainers() > 0) {
                    this.activeUsersManager.activateApplication(this.user, this.applicationId);
                }
            }
            if ((asks = (HashMap<String, ResourceRequest>)this.requests.get(priority)) == null) {
                asks = new HashMap<String, ResourceRequest>();
                this.requests.put(priority, asks);
                this.priorities.add(priority);
            }
            lastRequest = (ResourceRequest)asks.get(resourceName);
            if (recoverPreemptedRequest && lastRequest != null) {
                request.setNumContainers(lastRequest.getNumContainers() + 1);
            }
            asks.put(resourceName, request);
            if (!updatePendingResources) continue;
            if (request.getNumContainers() <= 0) {
                LOG.info((Object)"checking for deactivate... ");
                this.checkForDeactivation();
            }
            int lastRequestContainers = lastRequest != null ? lastRequest.getNumContainers() : 0;
            Resource lastRequestCapability = lastRequest != null ? lastRequest.getCapability() : Resources.none();
            metrics.incrPendingResources(this.user, request.getNumContainers(), request.getCapability());
            metrics.decrPendingResources(this.user, lastRequestContainers, lastRequestCapability);
        }
    }

    public synchronized void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        if (blacklistAdditions != null) {
            this.blacklist.addAll(blacklistAdditions);
        }
        if (blacklistRemovals != null) {
            this.blacklist.removeAll(blacklistRemovals);
        }
    }

    public synchronized Collection<Priority> getPriorities() {
        return this.priorities;
    }

    public synchronized Map<String, ResourceRequest> getResourceRequests(Priority priority) {
        return (Map)this.requests.get(priority);
    }

    public synchronized List<ResourceRequest> getAllResourceRequests() {
        ArrayList<ResourceRequest> ret = new ArrayList<ResourceRequest>();
        for (Map r : this.requests.values()) {
            ret.addAll(r.values());
        }
        return ret;
    }

    public synchronized ResourceRequest getResourceRequest(Priority priority, String resourceName) {
        Map nodeRequests = (Map)this.requests.get(priority);
        return nodeRequests == null ? null : (ResourceRequest)nodeRequests.get(resourceName);
    }

    public synchronized Resource getResource(Priority priority) {
        ResourceRequest request = this.getResourceRequest(priority, "*");
        return request.getCapability();
    }

    public synchronized boolean isBlacklisted(String resourceName) {
        return this.blacklist.contains(resourceName);
    }

    public synchronized List<ResourceRequest> allocate(NodeType type, SchedulerNode node, Priority priority, ResourceRequest request, Container container) {
        ArrayList<ResourceRequest> resourceRequests = new ArrayList<ResourceRequest>();
        if (type == NodeType.NODE_LOCAL) {
            this.allocateNodeLocal(node, priority, request, container, resourceRequests);
        } else if (type == NodeType.RACK_LOCAL) {
            this.allocateRackLocal(node, priority, request, container, resourceRequests);
        } else {
            this.allocateOffSwitch(node, priority, request, container, resourceRequests);
        }
        QueueMetrics metrics = this.queue.getMetrics();
        if (this.pending) {
            this.pending = false;
            metrics.runAppAttempt(this.applicationId, this.user);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allocate: applicationId=" + this.applicationId + " container=" + container.getId() + " host=" + container.getNodeId().toString() + " user=" + this.user + " resource=" + request.getCapability()));
        }
        metrics.allocateResources(this.user, 1, request.getCapability(), true);
        return resourceRequests;
    }

    private synchronized void allocateNodeLocal(SchedulerNode node, Priority priority, ResourceRequest nodeLocalRequest, Container container, List<ResourceRequest> resourceRequests) {
        nodeLocalRequest.setNumContainers(nodeLocalRequest.getNumContainers() - 1);
        if (nodeLocalRequest.getNumContainers() == 0) {
            ((Map)this.requests.get(priority)).remove(node.getNodeName());
        }
        ResourceRequest rackLocalRequest = (ResourceRequest)((Map)this.requests.get(priority)).get(node.getRackName());
        rackLocalRequest.setNumContainers(rackLocalRequest.getNumContainers() - 1);
        if (rackLocalRequest.getNumContainers() == 0) {
            ((Map)this.requests.get(priority)).remove(node.getRackName());
        }
        ResourceRequest offRackRequest = (ResourceRequest)((Map)this.requests.get(priority)).get("*");
        this.decrementOutstanding(offRackRequest);
        resourceRequests.add(this.cloneResourceRequest(nodeLocalRequest));
        resourceRequests.add(this.cloneResourceRequest(rackLocalRequest));
        resourceRequests.add(this.cloneResourceRequest(offRackRequest));
    }

    private synchronized void allocateRackLocal(SchedulerNode node, Priority priority, ResourceRequest rackLocalRequest, Container container, List<ResourceRequest> resourceRequests) {
        rackLocalRequest.setNumContainers(rackLocalRequest.getNumContainers() - 1);
        if (rackLocalRequest.getNumContainers() == 0) {
            ((Map)this.requests.get(priority)).remove(node.getRackName());
        }
        ResourceRequest offRackRequest = (ResourceRequest)((Map)this.requests.get(priority)).get("*");
        this.decrementOutstanding(offRackRequest);
        resourceRequests.add(this.cloneResourceRequest(rackLocalRequest));
        resourceRequests.add(this.cloneResourceRequest(offRackRequest));
    }

    private synchronized void allocateOffSwitch(SchedulerNode node, Priority priority, ResourceRequest offSwitchRequest, Container container, List<ResourceRequest> resourceRequests) {
        this.decrementOutstanding(offSwitchRequest);
        resourceRequests.add(this.cloneResourceRequest(offSwitchRequest));
    }

    private synchronized void decrementOutstanding(ResourceRequest offSwitchRequest) {
        int numOffSwitchContainers = offSwitchRequest.getNumContainers() - 1;
        offSwitchRequest.setNumContainers(numOffSwitchContainers);
        if (numOffSwitchContainers == 0) {
            this.checkForDeactivation();
        }
    }

    private synchronized void checkForDeactivation() {
        boolean deactivate = true;
        for (Priority priority : this.getPriorities()) {
            ResourceRequest request = this.getResourceRequest(priority, "*");
            if (request.getNumContainers() <= 0) continue;
            deactivate = false;
            break;
        }
        if (deactivate) {
            this.activeUsersManager.deactivateApplication(this.user, this.applicationId);
        }
    }

    public synchronized void move(Queue newQueue) {
        QueueMetrics oldMetrics = this.queue.getMetrics();
        QueueMetrics newMetrics = newQueue.getMetrics();
        for (Map asks : this.requests.values()) {
            ResourceRequest request = (ResourceRequest)asks.get("*");
            if (request == null) continue;
            oldMetrics.decrPendingResources(this.user, request.getNumContainers(), request.getCapability());
            newMetrics.incrPendingResources(this.user, request.getNumContainers(), request.getCapability());
        }
        oldMetrics.moveAppFrom(this);
        newMetrics.moveAppTo(this);
        this.activeUsersManager.deactivateApplication(this.user, this.applicationId);
        this.activeUsersManager = newQueue.getActiveUsersManager();
        this.activeUsersManager.activateApplication(this.user, this.applicationId);
        this.queue = newQueue;
    }

    public synchronized void stop(RMAppAttemptState rmAppAttemptFinalState) {
        QueueMetrics metrics = this.queue.getMetrics();
        for (Map asks : this.requests.values()) {
            ResourceRequest request = (ResourceRequest)asks.get("*");
            if (request == null) continue;
            metrics.decrPendingResources(this.user, request.getNumContainers(), request.getCapability());
        }
        metrics.finishAppAttempt(this.applicationId, this.pending, this.user);
        this.clearRequests();
    }

    public synchronized void setQueue(Queue queue) {
        this.queue = queue;
    }

    public synchronized Set<String> getBlackList() {
        return this.blacklist;
    }

    public synchronized void transferStateFromPreviousAppSchedulingInfo(AppSchedulingInfo appInfo) {
        this.blacklist = appInfo.getBlackList();
    }

    public synchronized void recoverContainer(RMContainer rmContainer) {
        QueueMetrics metrics = this.queue.getMetrics();
        if (this.pending) {
            this.pending = false;
            metrics.runAppAttempt(this.applicationId, this.user);
        }
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        metrics.allocateResources(this.user, 1, rmContainer.getAllocatedResource(), false);
    }

    public ResourceRequest cloneResourceRequest(ResourceRequest request) {
        ResourceRequest newRequest = ResourceRequest.newInstance((Priority)request.getPriority(), (String)request.getResourceName(), (Resource)request.getCapability(), (int)1, (boolean)request.getRelaxLocality());
        return newRequest;
    }
}

