/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtilTestHelper;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.TestFifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestContainerAllocation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestContainerAllocation {
    private static final Log LOG = LogFactory.getLog(TestFifoScheduler.class);
    private final int GB = 1024;
    private YarnConfiguration conf;
    private volatile int numRetries = 0;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
    }

    @Test(timeout=3000000L)
    public void testExcessReservationThanNodeManagerCapacity() throws Exception {
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 2048, 4);
        MockNM nm2 = rm.registerNode("127.0.0.1:2234", 3072, 4);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        int waitCount = 20;
        int size = rm.getRMContext().getRMNodes().size();
        while ((size = rm.getRMContext().getRMNodes().size()) != 2 && waitCount-- > 0) {
            LOG.info((Object)("Waiting for node managers to register : " + size));
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)2L, (long)rm.getRMContext().getRMNodes().size());
        RMApp app1 = rm.submitApp(128);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        LOG.info((Object)"sending container requests ");
        am1.addRequests(new String[]{"*"}, 3072, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        nm1.nodeHeartbeat(true);
        int waitCounter = 20;
        LOG.info((Object)"heartbeating nm1");
        while (alloc1Response.getAllocatedContainers().size() < 1 && waitCounter-- > 0) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(500L);
            alloc1Response = am1.schedule();
        }
        LOG.info((Object)("received container : " + alloc1Response.getAllocatedContainers().size()));
        Assert.assertTrue((alloc1Response.getAllocatedContainers().size() == 0 ? 1 : 0) != 0);
        LOG.info((Object)"heartbeating nm2");
        waitCounter = 20;
        nm2.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1 && waitCounter-- > 0) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(500L);
            alloc1Response = am1.schedule();
        }
        LOG.info((Object)("received container : " + alloc1Response.getAllocatedContainers().size()));
        Assert.assertTrue((alloc1Response.getAllocatedContainers().size() == 1 ? 1 : 0) != 0);
        rm.stop();
    }

    @Test
    public void testContainerTokenGeneratedOnPullRequest() throws Exception {
        MockRM rm1 = new MockRM((Configuration)this.conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("127.0.0.1:1234", 8000);
        RMApp app1 = rm1.submitApp(200);
        MockAM am1 = MockRM.launchAndRegisterAM((RMApp)app1, (MockRM)rm1, (MockNM)nm1);
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList());
        ContainerId containerId2 = ContainerId.newInstance((ApplicationAttemptId)am1.getApplicationAttemptId(), (int)2);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        RMContainer container = rm1.getResourceScheduler().getRMContainer(containerId2);
        Assert.assertEquals((Object)containerId2, (Object)container.getContainerId());
        Assert.assertNull((Object)container.getContainer().getContainerToken());
        List containers = am1.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers();
        Assert.assertEquals((Object)containerId2, (Object)((Container)containers.get(0)).getId());
        Assert.assertNotNull((Object)((Container)containers.get(0)).getContainerToken());
        rm1.stop();
    }

    @Test
    public void testNormalContainerAllocationWhenDNSUnavailable() throws Exception {
        MockRM rm1 = new MockRM((Configuration)this.conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("unknownhost:1234", 8000);
        RMApp app1 = rm1.submitApp(200);
        MockAM am1 = MockRM.launchAndRegisterAM((RMApp)app1, (MockRM)rm1, (MockNM)nm1);
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList());
        ContainerId containerId2 = ContainerId.newInstance((ApplicationAttemptId)am1.getApplicationAttemptId(), (int)2);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
        List containers = am1.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers();
        Assert.assertEquals((long)0L, (long)containers.size());
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)false);
        containers = am1.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)containers.size());
    }

    @Test(timeout=20000L)
    public void testAMContainerAllocationWhenDNSUnavailable() throws Exception {
        1 rm1 = new /* Unavailable Anonymous Inner Class!! */;
        rm1.start();
        MockNM nm1 = rm1.registerNode("unknownhost:1234", 8000);
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
        RMApp app1 = rm1.submitApp(200);
        RMAppAttempt attempt = app1.getCurrentAppAttempt();
        nm1.nodeHeartbeat(true);
        while (this.numRetries <= 5) {
            nm1.nodeHeartbeat(true);
            Thread.sleep(1000L);
            Assert.assertEquals((Object)RMAppAttemptState.SCHEDULED, (Object)attempt.getAppAttemptState());
            System.out.println("Waiting for am container to be allocated.");
        }
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)false);
        rm1.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.ALLOCATED);
        MockRM.launchAndRegisterAM((RMApp)app1, (MockRM)rm1, (MockNM)nm1);
    }

    static /* synthetic */ int access$008(TestContainerAllocation x0) {
        return x0.numRetries++;
    }

    static /* synthetic */ YarnConfiguration access$100(TestContainerAllocation x0) {
        return x0.conf;
    }
}

