/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FakeSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.ComputeFairShares;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestComputeFairShares {
    private List<Schedulable> scheds;

    @Before
    public void setUp() throws Exception {
        this.scheds = new ArrayList();
    }

    @Test
    public void testEqualSharing() {
        this.scheds.add(new FakeSchedulable());
        this.scheds.add(new FakeSchedulable());
        this.scheds.add(new FakeSchedulable());
        this.scheds.add(new FakeSchedulable());
        ComputeFairShares.computeShares((Collection)this.scheds, (Resource)Resources.createResource((int)40), (ResourceType)ResourceType.MEMORY);
        this.verifyMemoryShares(new int[]{10, 10, 10, 10});
    }

    @Test
    public void testLowMaxShares() {
        this.scheds.add(new FakeSchedulable(0, 100));
        this.scheds.add(new FakeSchedulable(0, 50));
        this.scheds.add(new FakeSchedulable(0, 11));
        this.scheds.add(new FakeSchedulable(0, 3));
        ComputeFairShares.computeShares((Collection)this.scheds, (Resource)Resources.createResource((int)40), (ResourceType)ResourceType.MEMORY);
        this.verifyMemoryShares(new int[]{13, 13, 11, 3});
    }

    @Test
    public void testMinShares() {
        this.scheds.add(new FakeSchedulable(20));
        this.scheds.add(new FakeSchedulable(18));
        this.scheds.add(new FakeSchedulable(0));
        this.scheds.add(new FakeSchedulable(2));
        ComputeFairShares.computeShares((Collection)this.scheds, (Resource)Resources.createResource((int)40), (ResourceType)ResourceType.MEMORY);
        this.verifyMemoryShares(new int[]{20, 18, 0, 2});
    }

    @Test
    public void testWeightedSharing() {
        this.scheds.add(new FakeSchedulable(0, 2.0));
        this.scheds.add(new FakeSchedulable(0, 1.0));
        this.scheds.add(new FakeSchedulable(0, 1.0));
        this.scheds.add(new FakeSchedulable(0, 0.5));
        ComputeFairShares.computeShares((Collection)this.scheds, (Resource)Resources.createResource((int)45), (ResourceType)ResourceType.MEMORY);
        this.verifyMemoryShares(new int[]{20, 10, 10, 5});
    }

    @Test
    public void testWeightedSharingWithMaxShares() {
        this.scheds.add(new FakeSchedulable(0, 10, 2.0));
        this.scheds.add(new FakeSchedulable(0, 11, 1.0));
        this.scheds.add(new FakeSchedulable(0, 30, 1.0));
        this.scheds.add(new FakeSchedulable(0, 20, 0.5));
        ComputeFairShares.computeShares((Collection)this.scheds, (Resource)Resources.createResource((int)45), (ResourceType)ResourceType.MEMORY);
        this.verifyMemoryShares(new int[]{10, 11, 16, 8});
    }

    @Test
    public void testWeightedSharingWithMinShares() {
        this.scheds.add(new FakeSchedulable(20, 2.0));
        this.scheds.add(new FakeSchedulable(0, 1.0));
        this.scheds.add(new FakeSchedulable(5, 1.0));
        this.scheds.add(new FakeSchedulable(15, 0.5));
        ComputeFairShares.computeShares((Collection)this.scheds, (Resource)Resources.createResource((int)45), (ResourceType)ResourceType.MEMORY);
        this.verifyMemoryShares(new int[]{20, 5, 5, 15});
    }

    @Test
    public void testLargeShares() {
        int million = 1000000;
        this.scheds.add(new FakeSchedulable());
        this.scheds.add(new FakeSchedulable());
        this.scheds.add(new FakeSchedulable());
        this.scheds.add(new FakeSchedulable());
        ComputeFairShares.computeShares((Collection)this.scheds, (Resource)Resources.createResource((int)(40 * million)), (ResourceType)ResourceType.MEMORY);
        this.verifyMemoryShares(new int[]{10 * million, 10 * million, 10 * million, 10 * million});
    }

    @Test
    public void testEmptyList() {
        ComputeFairShares.computeShares((Collection)this.scheds, (Resource)Resources.createResource((int)40), (ResourceType)ResourceType.MEMORY);
        this.verifyMemoryShares(new int[0]);
    }

    @Test
    public void testCPU() {
        this.scheds.add(new FakeSchedulable(Resources.createResource((int)0, (int)20), new ResourceWeights(2.0f)));
        this.scheds.add(new FakeSchedulable(Resources.createResource((int)0, (int)0), new ResourceWeights(1.0f)));
        this.scheds.add(new FakeSchedulable(Resources.createResource((int)0, (int)5), new ResourceWeights(1.0f)));
        this.scheds.add(new FakeSchedulable(Resources.createResource((int)0, (int)15), new ResourceWeights(0.5f)));
        ComputeFairShares.computeShares((Collection)this.scheds, (Resource)Resources.createResource((int)0, (int)45), (ResourceType)ResourceType.CPU);
        this.verifyCPUShares(new int[]{20, 5, 5, 15});
    }

    private void verifyMemoryShares(int ... shares) {
        Assert.assertEquals((long)this.scheds.size(), (long)shares.length);
        for (int i = 0; i < shares.length; ++i) {
            Assert.assertEquals((long)shares[i], (long)((Schedulable)this.scheds.get(i)).getFairShare().getMemory());
        }
    }

    private void verifyCPUShares(int ... shares) {
        Assert.assertEquals((long)this.scheds.size(), (long)shares.length);
        for (int i = 0; i < shares.length; ++i) {
            Assert.assertEquals((long)shares[i], (long)((Schedulable)this.scheds.get(i)).getFairShare().getVirtualCores());
        }
    }
}

