/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.TestFairSchedulerPreemption;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFairSchedulerPreemption
extends FairSchedulerTestBase {
    private static final String ALLOC_FILE = new File(TEST_DIR, TestFairSchedulerPreemption.class.getName() + ".xml").getAbsolutePath();
    private FairSchedulerTestBase.MockClock clock;

    protected Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", StubbedFairScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.scheduler.fair.preemption", true);
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        return conf;
    }

    @Before
    public void setup() throws IOException {
        this.conf = this.createConfiguration();
        this.clock = new FairSchedulerTestBase.MockClock();
    }

    @After
    public void teardown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
        this.conf = null;
    }

    private void startResourceManager(float utilizationThreshold) {
        this.conf.setFloat("yarn.scheduler.fair.preemption.cluster-utilization-threshold", utilizationThreshold);
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        Assert.assertTrue((boolean)(this.resourceManager.getResourceScheduler() instanceof StubbedFairScheduler));
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        this.scheduler.setClock((Clock)this.clock);
        this.scheduler.UPDATE_INTERVAL = 60000L;
    }

    private void registerNodeAndSubmitApp(int memory, int vcores, int appContainers, int appMemory) {
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)memory, (int)vcores), (int)1, (String)"node1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        Assert.assertEquals((String)"Incorrect amount of resources in the cluster", (long)memory, (long)this.scheduler.rootMetrics.getAvailableMB());
        Assert.assertEquals((String)"Incorrect amount of resources in the cluster", (long)vcores, (long)this.scheduler.rootMetrics.getAvailableVirtualCores());
        this.createSchedulingRequest(appMemory, "queueA", "user1", appContainers);
        this.scheduler.update();
        for (int i = 0; i < 3; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
        }
        Assert.assertEquals((String)"app1's request is not met", (long)(memory - appContainers * appMemory), (long)this.scheduler.rootMetrics.getAvailableMB());
    }

    @Test
    public void testPreemptionWithFreeResources() throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("<maxResources>0mb,0vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>1</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>1</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.print("<defaultMinSharePreemptionTimeout>5</defaultMinSharePreemptionTimeout>");
        out.print("<fairSharePreemptionTimeout>10</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        this.startResourceManager(0.0f);
        this.registerNodeAndSubmitApp(4096, 4, 2, 1024);
        this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        this.scheduler.update();
        this.clock.tick(6);
        ((StubbedFairScheduler)this.scheduler).resetLastPreemptResources();
        this.scheduler.preemptTasksIfNecessary();
        Assert.assertEquals((String)"preemptResources() should have been called", (long)1024L, (long)((StubbedFairScheduler)this.scheduler).lastPreemptMemory);
        this.resourceManager.stop();
        this.startResourceManager(0.8f);
        this.registerNodeAndSubmitApp(4096, 4, 3, 1024);
        this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        this.scheduler.update();
        this.clock.tick(6);
        ((StubbedFairScheduler)this.scheduler).resetLastPreemptResources();
        this.scheduler.preemptTasksIfNecessary();
        Assert.assertEquals((String)"preemptResources() should not have been called", (long)-1L, (long)((StubbedFairScheduler)this.scheduler).lastPreemptMemory);
        this.resourceManager.stop();
        this.startResourceManager(0.7f);
        this.registerNodeAndSubmitApp(4096, 4, 3, 1024);
        this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        this.scheduler.update();
        this.clock.tick(6);
        ((StubbedFairScheduler)this.scheduler).resetLastPreemptResources();
        this.scheduler.preemptTasksIfNecessary();
        Assert.assertEquals((String)"preemptResources() should have been called", (long)1024L, (long)((StubbedFairScheduler)this.scheduler).lastPreemptMemory);
    }
}

