/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegationTokenRenewer
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(DelegationTokenRenewer.class);
    public static final String SCHEME = "hdfs";
    private Timer renewalTimer;
    private RMContext rmContext;
    private DelegationTokenCancelThread dtCancelThread = new DelegationTokenCancelThread();
    private ThreadPoolExecutor renewerService;
    private Set<DelegationTokenToRenew> delegationTokens = Collections.synchronizedSet(new HashSet());
    private final ConcurrentMap<ApplicationId, Long> delayedRemovalMap = new ConcurrentHashMap();
    private long tokenRemovalDelayMs;
    private Thread delayedRemovalThread;
    private ReadWriteLock serviceStateLock = new ReentrantReadWriteLock();
    private volatile boolean isServiceStarted;
    private LinkedBlockingQueue<DelegationTokenRenewerEvent> pendingEventQueue;
    private boolean tokenKeepAliveEnabled;

    public DelegationTokenRenewer() {
        super(DelegationTokenRenewer.class.getName());
    }

    protected synchronized void serviceInit(Configuration conf) throws Exception {
        this.tokenKeepAliveEnabled = conf.getBoolean("yarn.log-aggregation-enable", false);
        this.tokenRemovalDelayMs = conf.getInt("yarn.nm.liveness-monitor.expiry-interval-ms", 600000);
        this.setLocalSecretManagerAndServiceAddr();
        this.renewerService = this.createNewThreadPoolService(conf);
        this.pendingEventQueue = new LinkedBlockingQueue();
        this.renewalTimer = new Timer(true);
        super.serviceInit(conf);
    }

    protected ThreadPoolExecutor createNewThreadPoolService(Configuration conf) {
        int nThreads = conf.getInt("yarn.resourcemanager.delegation-token-renewer.thread-count", 50);
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("DelegationTokenRenewer #%d").build();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(5 < nThreads ? 5 : nThreads, nThreads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        pool.setThreadFactory(tf);
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private void setLocalSecretManagerAndServiceAddr() {
        RMDelegationTokenIdentifier.Renewer.setSecretManager((AbstractDelegationTokenSecretManager)this.rmContext.getRMDelegationTokenSecretManager(), (InetSocketAddress)this.rmContext.getClientRMService().getBindAddress());
    }

    protected void serviceStart() throws Exception {
        this.dtCancelThread.start();
        if (this.tokenKeepAliveEnabled) {
            this.delayedRemovalThread = new Thread((Runnable)new DelayedTokenRemovalRunnable(this, this.getConfig()), "DelayedTokenCanceller");
            this.delayedRemovalThread.start();
        }
        this.setLocalSecretManagerAndServiceAddr();
        this.serviceStateLock.writeLock().lock();
        this.isServiceStarted = true;
        this.serviceStateLock.writeLock().unlock();
        while (!this.pendingEventQueue.isEmpty()) {
            this.processDelegationTokenRenewerEvent((DelegationTokenRenewerEvent)this.pendingEventQueue.take());
        }
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDelegationTokenRenewerEvent(DelegationTokenRenewerEvent evt) {
        this.serviceStateLock.readLock().lock();
        try {
            if (this.isServiceStarted) {
                this.renewerService.execute((Runnable)new DelegationTokenRenewerRunnable(this, evt));
            } else {
                this.pendingEventQueue.add(evt);
            }
        }
        finally {
            this.serviceStateLock.readLock().unlock();
        }
    }

    protected void serviceStop() {
        if (this.renewalTimer != null) {
            this.renewalTimer.cancel();
        }
        this.delegationTokens.clear();
        this.renewerService.shutdown();
        this.dtCancelThread.interrupt();
        try {
            this.dtCancelThread.join(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.tokenKeepAliveEnabled && this.delayedRemovalThread != null) {
            this.delayedRemovalThread.interrupt();
            try {
                this.delayedRemovalThread.join(1000L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Interrupted while joining on delayed removal thread.", (Throwable)e);
            }
        }
    }

    private void addTokenToList(DelegationTokenToRenew t) {
        this.delegationTokens.add(t);
    }

    @VisibleForTesting
    public Set<Token<?>> getDelegationTokens() {
        HashSet tokens = new HashSet();
        for (DelegationTokenToRenew delegationToken : this.delegationTokens) {
            tokens.add(delegationToken.token);
        }
        return tokens;
    }

    public void addApplicationAsync(ApplicationId applicationId, Credentials ts, boolean shouldCancelAtEnd) {
        this.processDelegationTokenRenewerEvent((DelegationTokenRenewerEvent)new DelegationTokenRenewerAppSubmitEvent(applicationId, ts, shouldCancelAtEnd));
    }

    public void addApplicationSync(ApplicationId applicationId, Credentials ts, boolean shouldCancelAtEnd) throws IOException {
        this.handleAppSubmitEvent(new DelegationTokenRenewerAppSubmitEvent(applicationId, ts, shouldCancelAtEnd));
    }

    private void handleAppSubmitEvent(DelegationTokenRenewerAppSubmitEvent evt) throws IOException {
        ApplicationId applicationId = evt.getApplicationId();
        Credentials ts = evt.getCredentials();
        boolean shouldCancelAtEnd = evt.shouldCancelAtEnd();
        if (ts == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering tokens for renewal for: appId = " + applicationId));
        }
        Collection tokens = ts.getAllTokens();
        long now = System.currentTimeMillis();
        ArrayList<DelegationTokenToRenew> tokenList = new ArrayList<DelegationTokenToRenew>();
        for (Token token : tokens) {
            if (!token.isManaged()) continue;
            tokenList.add(new DelegationTokenToRenew(applicationId, token, this.getConfig(), now, shouldCancelAtEnd));
        }
        if (!tokenList.isEmpty()) {
            for (DelegationTokenToRenew dtr : tokenList) {
                this.renewToken(dtr);
            }
            for (DelegationTokenToRenew dtr : tokenList) {
                this.addTokenToList(dtr);
                this.setTimerForTokenRenewal(dtr);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Registering token for renewal for: service = " + dtr.token.getService() + " for appId = " + dtr.applicationId));
            }
        }
    }

    @VisibleForTesting
    protected void setTimerForTokenRenewal(DelegationTokenToRenew token) throws IOException {
        long expiresIn = token.expirationDate - System.currentTimeMillis();
        long renewIn = token.expirationDate - expiresIn / 10L;
        RenewalTimerTask tTask = new RenewalTimerTask(this, token);
        token.setTimerTask((TimerTask)tTask);
        this.renewalTimer.schedule(token.timerTask, new Date(renewIn));
    }

    @VisibleForTesting
    protected void renewToken(DelegationTokenToRenew dttr) throws IOException {
        try {
            dttr.expirationDate = (Long)UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void cancelToken(DelegationTokenToRenew t) {
        if (t.shouldCancelAtEnd) {
            this.dtCancelThread.cancelToken(t.token, t.conf);
        } else {
            LOG.info((Object)("Did not cancel " + t));
        }
    }

    private void removeFailedDelegationToken(DelegationTokenToRenew t) {
        ApplicationId applicationId = t.applicationId;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing failed delegation token for appid=" + applicationId + ";t=" + t.token.getService()));
        }
        this.delegationTokens.remove(t);
        if (t.timerTask != null) {
            t.timerTask.cancel();
        }
    }

    public void applicationFinished(ApplicationId applicationId) {
        this.processDelegationTokenRenewerEvent(new DelegationTokenRenewerEvent(applicationId, DelegationTokenRenewerEventType.FINISH_APPLICATION));
    }

    private void handleAppFinishEvent(DelegationTokenRenewerEvent evt) {
        if (!this.tokenKeepAliveEnabled) {
            this.removeApplicationFromRenewal(evt.getApplicationId());
        } else {
            this.delayedRemovalMap.put(evt.getApplicationId(), System.currentTimeMillis() + this.tokenRemovalDelayMs);
        }
    }

    public void updateKeepAliveApplications(List<ApplicationId> appIds) {
        if (this.tokenKeepAliveEnabled && appIds != null && appIds.size() > 0) {
            for (ApplicationId appId : appIds) {
                this.delayedRemovalMap.put(appId, System.currentTimeMillis() + this.tokenRemovalDelayMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeApplicationFromRenewal(ApplicationId applicationId) {
        Set set = this.delegationTokens;
        synchronized (set) {
            Iterator it = this.delegationTokens.iterator();
            while (it.hasNext()) {
                DelegationTokenToRenew dttr = (DelegationTokenToRenew)it.next();
                if (!dttr.applicationId.equals((Object)applicationId)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Removing delegation token for appId=" + applicationId + "; token=" + dttr.token.getService()));
                }
                if (dttr.timerTask != null) {
                    dttr.timerTask.cancel();
                }
                this.cancelToken(dttr);
                it.remove();
            }
        }
    }

    public void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ void access$100(DelegationTokenRenewer x0, DelegationTokenToRenew x1) {
        x0.removeFailedDelegationToken(x1);
    }

    static /* synthetic */ ConcurrentMap access$200(DelegationTokenRenewer x0) {
        return x0.delayedRemovalMap;
    }

    static /* synthetic */ void access$300(DelegationTokenRenewer x0, ApplicationId x1) {
        x0.removeApplicationFromRenewal(x1);
    }

    static /* synthetic */ void access$400(DelegationTokenRenewer x0, DelegationTokenRenewerEvent x1) {
        x0.handleAppFinishEvent(x1);
    }

    static /* synthetic */ void access$500(DelegationTokenRenewer x0, DelegationTokenRenewerAppSubmitEvent x1) throws IOException {
        x0.handleAppSubmitEvent(x1);
    }

    static /* synthetic */ RMContext access$600(DelegationTokenRenewer x0) {
        return x0.rmContext;
    }
}

