/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import javax.ws.rs.core.MediaType;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesFairScheduler;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestRMWebServicesFairScheduler
extends JerseyTest {
    private static MockRM rm;
    private YarnConfiguration conf;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});

    public TestRMWebServicesFairScheduler() {
        super((AppDescriptor)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testClusterScheduler() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterScheduler(json);
    }

    @Test
    public void testClusterSchedulerSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterScheduler(json);
    }

    private void verifyClusterScheduler(JSONObject json) throws JSONException, Exception {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject info = json.getJSONObject("scheduler");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)info.length());
        info = info.getJSONObject("schedulerInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)info.length());
        JSONObject rootQueue = info.getJSONObject("rootQueue");
        Assert.assertEquals((Object)"root", (Object)rootQueue.getString("queueName"));
    }

    static /* synthetic */ YarnConfiguration access$002(TestRMWebServicesFairScheduler x0, YarnConfiguration x1) {
        x0.conf = x1;
        return x0.conf;
    }

    static /* synthetic */ YarnConfiguration access$000(TestRMWebServicesFairScheduler x0) {
        return x0.conf;
    }

    static /* synthetic */ MockRM access$102(MockRM x0) {
        rm = x0;
        return rm;
    }

    static /* synthetic */ MockRM access$100() {
        return rm;
    }

    static /* synthetic */ Injector access$200(TestRMWebServicesFairScheduler x0) {
        return x0.injector;
    }
}

