/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSSchedulerNode
extends SchedulerNode {
    private static final Log LOG = LogFactory.getLog(FSSchedulerNode.class);
    private AppSchedulable reservedAppSchedulable;

    public FSSchedulerNode(RMNode node, boolean usePortForNodeName) {
        super(node, usePortForNodeName);
    }

    @Override
    public synchronized void reserveResource(SchedulerApplicationAttempt application, Priority priority, RMContainer container) {
        RMContainer reservedContainer = this.getReservedContainer();
        if (reservedContainer != null) {
            if (!container.getContainer().getNodeId().equals((Object)this.getNodeID())) {
                throw new IllegalStateException("Trying to reserve container " + container + " on node " + container.getReservedNode() + " when currently" + " reserved resource " + reservedContainer + " on node " + reservedContainer.getReservedNode());
            }
            if (!reservedContainer.getContainer().getId().getApplicationAttemptId().equals((Object)container.getContainer().getId().getApplicationAttemptId())) {
                throw new IllegalStateException("Trying to reserve container " + container + " for application " + application.getApplicationId() + " when currently" + " reserved container " + reservedContainer + " on node " + this);
            }
            LOG.info((Object)("Updated reserved container " + container.getContainer().getId() + " on node " + this + " for application " + application));
        } else {
            LOG.info((Object)("Reserved container " + container.getContainer().getId() + " on node " + this + " for application " + application));
        }
        this.setReservedContainer(container);
        this.reservedAppSchedulable = ((FSSchedulerApp)application).getAppSchedulable();
    }

    @Override
    public synchronized void unreserveResource(SchedulerApplicationAttempt application) {
        ApplicationAttemptId reservedApplication = this.getReservedContainer().getContainer().getId().getApplicationAttemptId();
        if (!reservedApplication.equals((Object)application.getApplicationAttemptId())) {
            throw new IllegalStateException("Trying to unreserve  for application " + application.getApplicationId() + " when currently reserved " + " for application " + reservedApplication.getApplicationId() + " on node " + this);
        }
        this.setReservedContainer(null);
        this.reservedAppSchedulable = null;
    }

    public synchronized AppSchedulable getReservedAppSchedulable() {
        return this.reservedAppSchedulable;
    }
}

