/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.xml.sax.SAXException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class QueueManager {
    public static final Log LOG = LogFactory.getLog((String)QueueManager.class.getName());
    public static final String ROOT_QUEUE = "root";
    private final FairScheduler scheduler;
    private final Collection<FSLeafQueue> leafQueues = new CopyOnWriteArrayList<FSLeafQueue>();
    private final Map<String, FSQueue> queues = new HashMap<String, FSQueue>();
    private FSParentQueue rootQueue;

    public QueueManager(FairScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public FSParentQueue getRootQueue() {
        return this.rootQueue;
    }

    public void initialize(Configuration conf) throws IOException, SAXException, AllocationConfigurationException, ParserConfigurationException {
        this.rootQueue = new FSParentQueue(ROOT_QUEUE, this.scheduler, null);
        this.queues.put(this.rootQueue.getName(), this.rootQueue);
        this.getLeafQueue("default", true);
    }

    public FSLeafQueue getLeafQueue(String name, boolean create) {
        FSQueue queue = this.getQueue(name, create, FSQueueType.LEAF);
        if (queue instanceof FSParentQueue) {
            return null;
        }
        return (FSLeafQueue)queue;
    }

    public FSParentQueue getParentQueue(String name, boolean create) {
        FSQueue queue = this.getQueue(name, create, FSQueueType.PARENT);
        if (queue instanceof FSLeafQueue) {
            return null;
        }
        return (FSParentQueue)queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSQueue getQueue(String name, boolean create, FSQueueType queueType) {
        name = this.ensureRootPrefix(name);
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            FSQueue queue = this.queues.get(name);
            if (queue == null && create) {
                queue = this.createQueue(name, queueType);
            }
            return queue;
        }
    }

    private FSQueue createQueue(String name, FSQueueType queueType) {
        ArrayList<String> newQueueNames = new ArrayList<String>();
        newQueueNames.add(name);
        int sepIndex = name.length();
        FSParentQueue parent = null;
        while (sepIndex != -1) {
            sepIndex = name.lastIndexOf(46, sepIndex - 1);
            String curName = null;
            curName = name.substring(0, sepIndex);
            FSQueue queue = this.queues.get(curName);
            if (queue == null) {
                newQueueNames.add(curName);
                continue;
            }
            if (queue instanceof FSParentQueue) {
                parent = (FSParentQueue)queue;
                break;
            }
            return null;
        }
        AllocationConfiguration queueConf = this.scheduler.getAllocationConfiguration();
        FSLeafQueue leafQueue = null;
        for (int i = newQueueNames.size() - 1; i >= 0; --i) {
            String queueName = (String)newQueueNames.get(i);
            if (i == 0 && queueType != FSQueueType.PARENT) {
                leafQueue = new FSLeafQueue(name, this.scheduler, parent);
                try {
                    leafQueue.setPolicy(queueConf.getDefaultSchedulingPolicy());
                }
                catch (AllocationConfigurationException ex) {
                    LOG.warn((Object)("Failed to set default scheduling policy " + queueConf.getDefaultSchedulingPolicy() + " on new leaf queue."), (Throwable)ex);
                }
                parent.addChildQueue(leafQueue);
                this.queues.put(leafQueue.getName(), leafQueue);
                this.leafQueues.add(leafQueue);
                return leafQueue;
            }
            FSParentQueue newParent = new FSParentQueue(queueName, this.scheduler, parent);
            try {
                newParent.setPolicy(queueConf.getDefaultSchedulingPolicy());
            }
            catch (AllocationConfigurationException ex) {
                LOG.warn((Object)("Failed to set default scheduling policy " + queueConf.getDefaultSchedulingPolicy() + " on new parent queue."), (Throwable)ex);
            }
            parent.addChildQueue(newParent);
            this.queues.put(newParent.getName(), newParent);
            parent = newParent;
        }
        return parent;
    }

    private boolean removeEmptyIncompatibleQueues(String queueToCreate, FSQueueType queueType) {
        if ((queueToCreate = this.ensureRootPrefix(queueToCreate)).equals(ROOT_QUEUE) || queueToCreate.startsWith("root.default.")) {
            return false;
        }
        FSQueue queue = this.queues.get(queueToCreate);
        if (queue != null) {
            if (queue instanceof FSLeafQueue) {
                if (queueType == FSQueueType.LEAF) {
                    return true;
                }
                return this.removeQueueIfEmpty(queue);
            }
            if (queueType == FSQueueType.PARENT) {
                return true;
            }
            return this.removeQueueIfEmpty(queue);
        }
        int sepIndex = queueToCreate.length();
        sepIndex = queueToCreate.lastIndexOf(46, sepIndex - 1);
        while (sepIndex != -1) {
            String prefixString = queueToCreate.substring(0, sepIndex);
            FSQueue prefixQueue = this.queues.get(prefixString);
            if (prefixQueue != null && prefixQueue instanceof FSLeafQueue) {
                return this.removeQueueIfEmpty(prefixQueue);
            }
            sepIndex = queueToCreate.lastIndexOf(46, sepIndex - 1);
        }
        return true;
    }

    private boolean removeQueueIfEmpty(FSQueue queue) {
        if (this.isEmpty(queue)) {
            this.removeQueue(queue);
            return true;
        }
        return false;
    }

    private void removeQueue(FSQueue queue) {
        if (queue instanceof FSLeafQueue) {
            this.leafQueues.remove(queue);
        } else {
            List<FSQueue> childQueues = queue.getChildQueues();
            while (!childQueues.isEmpty()) {
                this.removeQueue(childQueues.get(0));
            }
        }
        this.queues.remove(queue.getName());
        queue.getParent().getChildQueues().remove(queue);
    }

    protected boolean isEmpty(FSQueue queue) {
        if (queue instanceof FSLeafQueue) {
            FSLeafQueue leafQueue = (FSLeafQueue)queue;
            return queue.getNumRunnableApps() == 0 && leafQueue.getNonRunnableAppSchedulables().isEmpty();
        }
        for (FSQueue child : queue.getChildQueues()) {
            if (this.isEmpty(child)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSQueue getQueue(String name) {
        name = this.ensureRootPrefix(name);
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return this.queues.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String name) {
        name = this.ensureRootPrefix(name);
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return this.queues.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FSLeafQueue> getLeafQueues() {
        Map<String, FSQueue> map = this.queues;
        synchronized (map) {
            return this.leafQueues;
        }
    }

    public Collection<FSQueue> getQueues() {
        return this.queues.values();
    }

    private String ensureRootPrefix(String name) {
        if (!name.startsWith("root.") && !name.equals(ROOT_QUEUE)) {
            name = "root." + name;
        }
        return name;
    }

    public void updateAllocationConfiguration(AllocationConfiguration queueConf) {
        for (String name : queueConf.getConfiguredQueues().get((Object)FSQueueType.LEAF)) {
            if (!this.removeEmptyIncompatibleQueues(name, FSQueueType.LEAF)) continue;
            this.getLeafQueue(name, true);
        }
        for (String name : queueConf.getConfiguredQueues().get((Object)FSQueueType.PARENT)) {
            if (!this.removeEmptyIncompatibleQueues(name, FSQueueType.PARENT)) continue;
            this.getParentQueue(name, true);
        }
        for (FSQueue queue : this.queues.values()) {
            FSQueueMetrics queueMetrics = queue.getMetrics();
            queueMetrics.setMinShare(queue.getMinShare());
            queueMetrics.setMaxShare(queue.getMaxShare());
            try {
                SchedulingPolicy policy = queueConf.getSchedulingPolicy(queue.getName());
                policy.initialize(this.scheduler.getClusterResource());
                queue.setPolicy(policy);
            }
            catch (AllocationConfigurationException ex) {
                LOG.warn((Object)("Cannot apply configured scheduling policy to queue " + queue.getName()), (Throwable)ex);
            }
        }
    }
}

