/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;

public class AMRMTokenSecretManager
extends SecretManager<AMRMTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(AMRMTokenSecretManager.class);
    private SecretKey masterKey;
    private final Timer timer;
    private final long rollingInterval;
    private final Map<ApplicationAttemptId, byte[]> passwords = new HashMap<ApplicationAttemptId, byte[]>();

    public AMRMTokenSecretManager(Configuration conf) {
        this.rollMasterKey();
        this.timer = new Timer();
        this.rollingInterval = conf.getLong("yarn.resourcemanager.am-rm-tokens.master-key-rolling-interval-secs", 86400L) * 1000L;
    }

    public void start() {
        this.timer.scheduleAtFixedRate((TimerTask)new MasterKeyRoller(), 0L, this.rollingInterval);
    }

    public void stop() {
        this.timer.cancel();
    }

    public synchronized void applicationMasterFinished(ApplicationAttemptId appAttemptId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Application finished, removing password for " + appAttemptId));
        }
        this.passwords.remove(appAttemptId);
    }

    @InterfaceAudience.Private
    public synchronized void setMasterKey(SecretKey masterKey) {
        this.masterKey = masterKey;
    }

    @InterfaceAudience.Private
    public synchronized SecretKey getMasterKey() {
        return this.masterKey;
    }

    @InterfaceAudience.Private
    synchronized void rollMasterKey() {
        LOG.info((Object)"Rolling master-key for amrm-tokens");
        this.masterKey = this.generateSecret();
    }

    public synchronized byte[] createPassword(AMRMTokenIdentifier identifier) {
        ApplicationAttemptId applicationAttemptId = identifier.getApplicationAttemptId();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating password for " + applicationAttemptId));
        }
        byte[] password = AMRMTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)this.masterKey);
        this.passwords.put(applicationAttemptId, password);
        return password;
    }

    public synchronized void addPersistedPassword(Token<AMRMTokenIdentifier> token) throws IOException {
        AMRMTokenIdentifier identifier = (AMRMTokenIdentifier)token.decodeIdentifier();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding password for " + identifier.getApplicationAttemptId()));
        }
        this.passwords.put(identifier.getApplicationAttemptId(), token.getPassword());
    }

    public synchronized byte[] retrievePassword(AMRMTokenIdentifier identifier) throws SecretManager.InvalidToken {
        byte[] password;
        ApplicationAttemptId applicationAttemptId = identifier.getApplicationAttemptId();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to retrieve password for " + applicationAttemptId));
        }
        if ((password = this.passwords.get(applicationAttemptId)) == null) {
            throw new SecretManager.InvalidToken("Password not found for ApplicationAttempt " + applicationAttemptId);
        }
        return password;
    }

    public AMRMTokenIdentifier createIdentifier() {
        return new AMRMTokenIdentifier();
    }

    private class MasterKeyRoller
    extends TimerTask {
        private MasterKeyRoller() {
        }

        @Override
        public void run() {
            AMRMTokenSecretManager.this.rollMasterKey();
        }
    }
}

