/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSLeafQueue
extends FSQueue {
    private static final Log LOG = LogFactory.getLog((String)FSLeafQueue.class.getName());
    private final List<FSAppAttempt> runnableApps = new ArrayList<FSAppAttempt>();
    private final List<FSAppAttempt> nonRunnableApps = new ArrayList<FSAppAttempt>();
    private final ReadWriteLock rwl = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();
    private Resource demand = Resources.createResource((int)0);
    private long lastTimeAtMinShare;
    private long lastTimeAtFairShareThreshold;
    private Resource amResourceUsage;
    private final ActiveUsersManager activeUsersManager;

    public FSLeafQueue(String name, FairScheduler scheduler, FSParentQueue parent) {
        super(name, scheduler, parent);
        this.lastTimeAtMinShare = scheduler.getClock().getTime();
        this.lastTimeAtFairShareThreshold = scheduler.getClock().getTime();
        this.activeUsersManager = new ActiveUsersManager(this.getMetrics());
        this.amResourceUsage = Resource.newInstance((int)0, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApp(FSAppAttempt app, boolean runnable) {
        this.writeLock.lock();
        try {
            if (runnable) {
                this.runnableApps.add(app);
            } else {
                this.nonRunnableApps.add(app);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAppSchedulable(FSAppAttempt appSched) {
        this.writeLock.lock();
        try {
            this.runnableApps.add(appSched);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeApp(FSAppAttempt app) {
        boolean runnable;
        block6: {
            runnable = false;
            this.writeLock.lock();
            try {
                if (this.runnableApps.remove(app)) {
                    runnable = true;
                    break block6;
                }
                if (this.nonRunnableApps.remove(app)) {
                    runnable = false;
                    break block6;
                }
                throw new IllegalStateException("Given app to remove " + app + " does not exist in queue " + this);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        if (runnable && app.isAmRunning() && app.getAMResource() != null) {
            Resources.subtractFrom((Resource)this.amResourceUsage, (Resource)app.getAMResource());
        }
        return runnable;
    }

    public Collection<FSAppAttempt> getRunnableAppSchedulables() {
        return this.runnableApps;
    }

    public List<FSAppAttempt> getNonRunnableAppSchedulables() {
        return this.nonRunnableApps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        this.readLock.lock();
        try {
            for (FSAppAttempt appSched : this.runnableApps) {
                apps.add(appSched.getApplicationAttemptId());
            }
            for (FSAppAttempt appSched : this.nonRunnableApps) {
                apps.add(appSched.getApplicationAttemptId());
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setPolicy(SchedulingPolicy policy) throws AllocationConfigurationException {
        if (!SchedulingPolicy.isApplicableTo(policy, (byte)1)) {
            this.throwPolicyDoesnotApplyException(policy);
        }
        this.policy = policy;
    }

    @Override
    public void recomputeShares() {
        this.policy.computeShares(this.getRunnableAppSchedulables(), this.getFairShare());
    }

    @Override
    public Resource getDemand() {
        return this.demand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getResourceUsage() {
        Resource usage = Resources.createResource((int)0);
        this.readLock.lock();
        try {
            for (FSAppAttempt app : this.runnableApps) {
                Resources.addTo((Resource)usage, (Resource)app.getResourceUsage());
            }
            for (FSAppAttempt app : this.nonRunnableApps) {
                Resources.addTo((Resource)usage, (Resource)app.getResourceUsage());
            }
        }
        finally {
            this.readLock.unlock();
        }
        return usage;
    }

    public Resource getAmResourceUsage() {
        return this.amResourceUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDemand() {
        Resource maxRes = this.scheduler.getAllocationConfiguration().getMaxResources(this.getName());
        this.demand = Resources.createResource((int)0);
        this.readLock.lock();
        try {
            for (FSAppAttempt sched : this.runnableApps) {
                if (Resources.equals((Resource)this.demand, (Resource)maxRes)) break;
                this.updateDemandForApp(sched, maxRes);
            }
            for (FSAppAttempt sched : this.nonRunnableApps) {
                if (Resources.equals((Resource)this.demand, (Resource)maxRes)) {
                    break;
                }
                this.updateDemandForApp(sched, maxRes);
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The updated demand for " + this.getName() + " is " + this.demand + "; the max is " + maxRes));
        }
    }

    private void updateDemandForApp(FSAppAttempt sched, Resource maxRes) {
        sched.updateDemand();
        Resource toAdd = sched.getDemand();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Counting resource from " + sched.getName() + " " + toAdd + "; Total resource consumption for " + this.getName() + " now " + this.demand));
        }
        this.demand = Resources.add((Resource)this.demand, (Resource)toAdd);
        this.demand = Resources.componentwiseMin((Resource)this.demand, (Resource)maxRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource assignContainer(FSSchedulerNode node) {
        Resource assigned = Resources.none();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node " + node.getNodeName() + " offered to queue: " + this.getName()));
        }
        if (!this.assignContainerPreCheck(node)) {
            return assigned;
        }
        Comparator<Schedulable> comparator = this.policy.getComparator();
        this.writeLock.lock();
        try {
            Collections.sort(this.runnableApps, comparator);
        }
        finally {
            this.writeLock.unlock();
        }
        this.readLock.lock();
        try {
            for (FSAppAttempt sched : this.runnableApps) {
                if (SchedulerAppUtils.isBlacklisted(sched, node, LOG) || (assigned = sched.assignContainer(node)).equals((Object)Resources.none())) continue;
                break;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return assigned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMContainer preemptContainer() {
        RMContainer toBePreempted = null;
        if (!this.preemptContainerPreCheck()) {
            return toBePreempted;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Queue " + this.getName() + " is going to preempt a container " + "from its applications."));
        }
        Comparator<Schedulable> comparator = this.policy.getComparator();
        FSAppAttempt candidateSched = null;
        this.readLock.lock();
        try {
            for (FSAppAttempt sched : this.runnableApps) {
                if (candidateSched != null && comparator.compare(sched, candidateSched) <= 0) continue;
                candidateSched = sched;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (candidateSched != null) {
            toBePreempted = candidateSched.preemptContainer();
        }
        return toBePreempted;
    }

    @Override
    public List<FSQueue> getChildQueues() {
        return new ArrayList<FSQueue>(1);
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return Collections.singletonList(userAclInfo);
    }

    public long getLastTimeAtMinShare() {
        return this.lastTimeAtMinShare;
    }

    private void setLastTimeAtMinShare(long lastTimeAtMinShare) {
        this.lastTimeAtMinShare = lastTimeAtMinShare;
    }

    public long getLastTimeAtFairShareThreshold() {
        return this.lastTimeAtFairShareThreshold;
    }

    private void setLastTimeAtFairShareThreshold(long lastTimeAtFairShareThreshold) {
        this.lastTimeAtFairShareThreshold = lastTimeAtFairShareThreshold;
    }

    @Override
    public int getNumRunnableApps() {
        return this.runnableApps.size();
    }

    @Override
    public ActiveUsersManager getActiveUsersManager() {
        return this.activeUsersManager;
    }

    public boolean canRunAppAM(Resource amResource) {
        float maxAMShare = this.scheduler.getAllocationConfiguration().getQueueMaxAMShare(this.getName());
        if ((double)Math.abs(maxAMShare - -1.0f) < 1.0E-4) {
            return true;
        }
        Resource maxAMResource = Resources.multiply((Resource)this.getFairShare(), (double)maxAMShare);
        Resource ifRunAMResource = Resources.add((Resource)this.amResourceUsage, (Resource)amResource);
        return !this.policy.checkIfAMResourceUsageOverLimit(ifRunAMResource, maxAMResource);
    }

    public void addAMResourceUsage(Resource amResource) {
        if (amResource != null) {
            Resources.addTo((Resource)this.amResourceUsage, (Resource)amResource);
        }
    }

    @Override
    public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt schedulerAttempt, RMContainer rmContainer) {
    }

    public void updateStarvationStats() {
        long now = this.scheduler.getClock().getTime();
        if (!this.isStarvedForMinShare()) {
            this.setLastTimeAtMinShare(now);
        }
        if (!this.isStarvedForFairShare()) {
            this.setLastTimeAtFairShareThreshold(now);
        }
    }

    private boolean preemptContainerPreCheck() {
        return this.parent.getPolicy().checkIfUsageOverFairShare(this.getResourceUsage(), this.getFairShare());
    }

    @VisibleForTesting
    boolean isStarvedForMinShare() {
        return this.isStarved(this.getMinShare());
    }

    @VisibleForTesting
    boolean isStarvedForFairShare() {
        return this.isStarved(Resources.multiply((Resource)this.getFairShare(), (double)this.getFairSharePreemptionThreshold()));
    }

    private boolean isStarved(Resource share) {
        Resource desiredShare = Resources.min((ResourceCalculator)FairScheduler.getResourceCalculator(), (Resource)this.scheduler.getClusterResource(), (Resource)share, (Resource)this.getDemand());
        return Resources.lessThan((ResourceCalculator)FairScheduler.getResourceCalculator(), (Resource)this.scheduler.getClusterResource(), (Resource)this.getResourceUsage(), (Resource)desiredShare);
    }
}

