/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFifoScheduler {
    private static final Log LOG = LogFactory.getLog(TestFifoScheduler.class);
    private final int GB = 1024;
    private static YarnConfiguration conf;

    @BeforeClass
    public static void setup() {
        conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
    }

    @Test(timeout=30000L)
    public void testConfValidation() throws Exception {
        FifoScheduler scheduler = new FifoScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 2048);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 1024);
        try {
            scheduler.serviceInit((Configuration)conf);
            Assert.fail((String)"Exception is expected because the min memory allocation is larger than the max memory allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler memory"));
        }
    }

    @Test
    public void testAllocateContainerOnNodeWithoutOffSwitchSpecified() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        ArrayList<ResourceRequest> requests = new ArrayList<ResourceRequest>();
        requests.add(am1.createResourceReq("127.0.0.1", 1024, 1, 1));
        requests.add(am1.createResourceReq("/default-rack", 1024, 1, 1));
        am1.allocate(requests, null);
        try {
            nm1.nodeHeartbeat(true);
        }
        catch (NullPointerException e) {
            Assert.fail((String)"NPE when allocating container on node but forget to set off-switch request should be handled");
        }
    }

    @Test
    public void test() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        MockNM nm2 = rm.registerNode("127.0.0.2:5678", 4096);
        RMApp app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        SchedulerNodeReport report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)2048L, (long)report_nm1.getUsedResource().getMemory());
        RMApp app2 = rm.submitApp(2048);
        nm2.nodeHeartbeat(true);
        RMAppAttempt attempt2 = app2.getCurrentAppAttempt();
        MockAM am2 = rm.sendAMLaunched(attempt2.getAppAttemptId());
        am2.registerAppAttempt();
        SchedulerNodeReport report_nm2 = rm.getResourceScheduler().getNodeReport(nm2.getNodeId());
        Assert.assertEquals((long)2048L, (long)report_nm2.getUsedResource().getMemory());
        am1.addRequests(new String[]{"127.0.0.1", "127.0.0.2"}, 1024, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        am2.addRequests(new String[]{"127.0.0.1", "127.0.0.2"}, 3072, 0, 1);
        AllocateResponse alloc2Response = am2.schedule();
        nm1.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(1000L);
            alloc1Response = am1.schedule();
        }
        while (alloc2Response.getAllocatedContainers().size() < 1) {
            LOG.info((Object)"Waiting for containers to be created for app 2...");
            Thread.sleep(1000L);
            alloc2Response = am2.schedule();
        }
        nm2.nodeHeartbeat(true);
        List allocated1 = alloc1Response.getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)allocated1.size());
        Assert.assertEquals((long)1024L, (long)((Container)allocated1.get(0)).getResource().getMemory());
        Assert.assertEquals((Object)nm1.getNodeId(), (Object)((Container)allocated1.get(0)).getNodeId());
        List allocated2 = alloc2Response.getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)allocated2.size());
        Assert.assertEquals((long)3072L, (long)((Container)allocated2.get(0)).getResource().getMemory());
        Assert.assertEquals((Object)nm1.getNodeId(), (Object)((Container)allocated2.get(0)).getNodeId());
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        report_nm2 = rm.getResourceScheduler().getNodeReport(nm2.getNodeId());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getMemory());
        Assert.assertEquals((long)2048L, (long)report_nm2.getAvailableResource().getMemory());
        Assert.assertEquals((long)6144L, (long)report_nm1.getUsedResource().getMemory());
        Assert.assertEquals((long)2048L, (long)report_nm2.getUsedResource().getMemory());
        Container c1 = (Container)allocated1.get(0);
        Assert.assertEquals((long)1024L, (long)c1.getResource().getMemory());
        ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)c1.getId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)0);
        nm1.containerStatus(containerStatus);
        int waitCount = 0;
        while (attempt1.getJustFinishedContainers().size() < 1 && waitCount++ != 20) {
            LOG.info((Object)("Waiting for containers to be finished for app 1... Tried " + waitCount + " times already.."));
            Thread.sleep(1000L);
        }
        Assert.assertEquals((long)1L, (long)attempt1.getJustFinishedContainers().size());
        Assert.assertEquals((long)1L, (long)am1.schedule().getCompletedContainersStatuses().size());
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)5120L, (long)report_nm1.getUsedResource().getMemory());
        rm.stop();
    }

    @Test
    public void testNodeUpdateBeforeAppAttemptInit() throws Exception {
        FifoScheduler scheduler = new FifoScheduler();
        MockRM rm = new MockRM((Configuration)conf);
        scheduler.setRMContext(rm.getRMContext());
        scheduler.init((Configuration)conf);
        scheduler.start();
        scheduler.reinitialize((Configuration)conf, rm.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)4), 1, "127.0.0.1");
        scheduler.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        scheduler.addApplication(appId, "queue1", "user1", false);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        try {
            scheduler.handle((SchedulerEvent)updateEvent);
        }
        catch (NullPointerException e) {
            Assert.fail();
        }
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        scheduler.addApplicationAttempt(attId, false, false);
        rm.stop();
    }

    private void testMinimumAllocation(YarnConfiguration conf, int testAlloc) throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = rm.submitApp(testAlloc);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        SchedulerNodeReport report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        int checkAlloc = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        Assert.assertEquals((long)checkAlloc, (long)report_nm1.getUsedResource().getMemory());
        rm.stop();
    }

    @Test
    public void testDefaultMinimumAllocation() throws Exception {
        this.testMinimumAllocation(new YarnConfiguration((Configuration)conf), 512);
    }

    @Test
    public void testNonDefaultMinimumAllocation() throws Exception {
        int allocMB = 1536;
        YarnConfiguration conf = new YarnConfiguration((Configuration)TestFifoScheduler.conf);
        conf.setInt("yarn.scheduler.minimum-allocation-mb", allocMB);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", allocMB * 10);
        this.testMinimumAllocation(conf, allocMB / 2);
    }

    @Test(timeout=50000L)
    public void testReconnectedNode() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.setQueues("default", new String[]{"default"});
        conf.setCapacity("default", 100.0f);
        FifoScheduler fs = new FifoScheduler();
        fs.init((Configuration)conf);
        fs.start();
        RMContext context = (RMContext)Mockito.mock(RMContext.class);
        fs.reinitialize((Configuration)conf, null);
        fs.setRMContext(context);
        RMNode n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, "127.0.0.2");
        RMNode n2 = MockNodes.newNodeInfo(0, MockNodes.newResource(2048), 2, "127.0.0.3");
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n2));
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n1));
        Assert.assertEquals((long)6144L, (long)fs.getRootQueueMetrics().getAvailableMB());
        n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(2048), 1, "127.0.0.2");
        fs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n1));
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n1));
        Assert.assertEquals((long)4096L, (long)fs.getRootQueueMetrics().getAvailableMB());
        fs.stop();
    }

    @Test(timeout=50000L)
    public void testBlackListNodes() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        FifoScheduler fs = (FifoScheduler)rm.getResourceScheduler();
        int rack_num_0 = 0;
        int rack_num_1 = 1;
        String host_0_0 = "127.0.0.1";
        RMNode n1 = MockNodes.newNodeInfo(rack_num_0, MockNodes.newResource(4096), 1, host_0_0);
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        String host_0_1 = "127.0.0.2";
        RMNode n2 = MockNodes.newNodeInfo(rack_num_0, MockNodes.newResource(4096), 1, host_0_1);
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n2));
        String host_1_0 = "127.0.0.3";
        RMNode n3 = MockNodes.newNodeInfo(rack_num_1, MockNodes.newResource(4096), 1, host_1_0);
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n3));
        String host_1_1 = "127.0.0.4";
        RMNode n4 = MockNodes.newNodeInfo(rack_num_1, MockNodes.newResource(4096), 1, host_1_1);
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n4));
        ApplicationId appId1 = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId1 = BuilderUtils.newApplicationAttemptId((ApplicationId)appId1, (int)1);
        AppAddedSchedulerEvent appEvent = new AppAddedSchedulerEvent(appId1, "queue", "user");
        fs.handle((SchedulerEvent)appEvent);
        AppAttemptAddedSchedulerEvent attemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId1, false);
        fs.handle((SchedulerEvent)attemptEvent);
        ArrayList emptyId = new ArrayList();
        ArrayList emptyAsk = new ArrayList();
        ArrayList<ResourceRequest> ask1 = new ArrayList<ResourceRequest>();
        ask1.add(BuilderUtils.newResourceRequest((Priority)BuilderUtils.newPriority((int)0), (String)"rack1", (Resource)BuilderUtils.newResource((int)1024, (int)1), (int)1));
        ask1.add(BuilderUtils.newResourceRequest((Priority)BuilderUtils.newPriority((int)0), (String)"*", (Resource)BuilderUtils.newResource((int)1024, (int)1), (int)1));
        fs.allocate(appAttemptId1, ask1, emptyId, Collections.singletonList(host_1_0), null);
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n3));
        Allocation allocation1 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null);
        Assert.assertEquals((String)"allocation1", (long)0L, (long)allocation1.getContainers().size());
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n4));
        Allocation allocation2 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null);
        Assert.assertEquals((String)"allocation2", (long)1L, (long)allocation2.getContainers().size());
        List containerList = allocation2.getContainers();
        for (Container container : containerList) {
            Assert.assertEquals((String)"Container is allocated on n4", (Object)container.getNodeId(), (Object)n4.getNodeID());
        }
        ArrayList<ResourceRequest> ask2 = new ArrayList<ResourceRequest>();
        ask2.add(BuilderUtils.newResourceRequest((Priority)BuilderUtils.newPriority((int)0), (String)"*", (Resource)BuilderUtils.newResource((int)1024, (int)1), (int)1));
        fs.allocate(appAttemptId1, ask2, emptyId, Collections.singletonList("rack0"), null);
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n1));
        Allocation allocation3 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null);
        Assert.assertEquals((String)"allocation3", (long)0L, (long)allocation3.getContainers().size());
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n2));
        Allocation allocation4 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null);
        Assert.assertEquals((String)"allocation4", (long)0L, (long)allocation4.getContainers().size());
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n3));
        Allocation allocation5 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null);
        Assert.assertEquals((String)"allocation5", (long)0L, (long)allocation5.getContainers().size());
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n4));
        Allocation allocation6 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null);
        Assert.assertEquals((String)"allocation6", (long)1L, (long)allocation6.getContainers().size());
        containerList = allocation6.getContainers();
        for (Container container : containerList) {
            Assert.assertEquals((String)"Container is allocated on n4", (Object)container.getNodeId(), (Object)n4.getNodeID());
        }
        rm.stop();
    }

    @Test(timeout=50000L)
    public void testHeadroom() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        FifoScheduler fs = (FifoScheduler)rm.getResourceScheduler();
        RMNode n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, "127.0.0.2");
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        ApplicationId appId1 = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId1 = BuilderUtils.newApplicationAttemptId((ApplicationId)appId1, (int)1);
        AppAddedSchedulerEvent appEvent = new AppAddedSchedulerEvent(appId1, "queue", "user");
        fs.handle((SchedulerEvent)appEvent);
        AppAttemptAddedSchedulerEvent attemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId1, false);
        fs.handle((SchedulerEvent)attemptEvent);
        ApplicationId appId2 = BuilderUtils.newApplicationId((long)200L, (int)2);
        ApplicationAttemptId appAttemptId2 = BuilderUtils.newApplicationAttemptId((ApplicationId)appId2, (int)1);
        AppAddedSchedulerEvent appEvent2 = new AppAddedSchedulerEvent(appId2, "queue", "user");
        fs.handle((SchedulerEvent)appEvent2);
        AppAttemptAddedSchedulerEvent attemptEvent2 = new AppAttemptAddedSchedulerEvent(appAttemptId2, false);
        fs.handle((SchedulerEvent)attemptEvent2);
        ArrayList emptyId = new ArrayList();
        ArrayList emptyAsk = new ArrayList();
        ArrayList<ResourceRequest> ask1 = new ArrayList<ResourceRequest>();
        ask1.add(BuilderUtils.newResourceRequest((Priority)BuilderUtils.newPriority((int)0), (String)"*", (Resource)BuilderUtils.newResource((int)1024, (int)1), (int)1));
        fs.allocate(appAttemptId1, ask1, emptyId, null, null);
        ArrayList<ResourceRequest> ask2 = new ArrayList<ResourceRequest>();
        ask2.add(BuilderUtils.newResourceRequest((Priority)BuilderUtils.newPriority((int)0), (String)"*", (Resource)BuilderUtils.newResource((int)2048, (int)1), (int)1));
        fs.allocate(appAttemptId2, ask2, emptyId, null, null);
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n1));
        Allocation allocation1 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null);
        Assert.assertEquals((String)"Allocation headroom", (long)1024L, (long)allocation1.getResourceLimit().getMemory());
        Allocation allocation2 = fs.allocate(appAttemptId2, emptyAsk, emptyId, null, null);
        Assert.assertEquals((String)"Allocation headroom", (long)1024L, (long)allocation2.getResourceLimit().getMemory());
        rm.stop();
    }

    @Test
    public void testResourceOverCommit() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
        RMApp app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        SchedulerNodeReport report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)2048L, (long)report_nm1.getUsedResource().getMemory());
        Assert.assertEquals((long)2048L, (long)report_nm1.getAvailableResource().getMemory());
        am1.addRequests(new String[]{"127.0.0.1", "127.0.0.2"}, 2048, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        nm1.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(1000L);
            alloc1Response = am1.schedule();
        }
        List allocated1 = alloc1Response.getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)allocated1.size());
        Assert.assertEquals((long)2048L, (long)((Container)allocated1.get(0)).getResource().getMemory());
        Assert.assertEquals((Object)nm1.getNodeId(), (Object)((Container)allocated1.get(0)).getNodeId());
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getMemory());
        Assert.assertEquals((long)4096L, (long)report_nm1.getUsedResource().getMemory());
        Container c1 = (Container)allocated1.get(0);
        Assert.assertEquals((long)2048L, (long)c1.getResource().getMemory());
        HashMap<NodeId, ResourceOption> nodeResourceMap = new HashMap<NodeId, ResourceOption>();
        nodeResourceMap.put(nm1.getNodeId(), ResourceOption.newInstance((Resource)Resource.newInstance((int)2048, (int)1), (int)-1));
        UpdateNodeResourceRequest request = UpdateNodeResourceRequest.newInstance(nodeResourceMap);
        AdminService as = rm.adminService;
        as.updateNodeResource(request);
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)4096L, (long)report_nm1.getUsedResource().getMemory());
        Assert.assertEquals((long)-2048L, (long)report_nm1.getAvailableResource().getMemory());
        ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)c1.getId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)0);
        nm1.containerStatus(containerStatus);
        int waitCount = 0;
        while (attempt1.getJustFinishedContainers().size() < 1 && waitCount++ != 20) {
            LOG.info((Object)("Waiting for containers to be finished for app 1... Tried " + waitCount + " times already.."));
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)attempt1.getJustFinishedContainers().size());
        Assert.assertEquals((long)1L, (long)am1.schedule().getCompletedContainersStatuses().size());
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)2048L, (long)report_nm1.getUsedResource().getMemory());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getMemory());
        rm.stop();
    }

    public static void main(String[] args) throws Exception {
        TestFifoScheduler t = new TestFifoScheduler();
        t.test();
        t.testDefaultMinimumAllocation();
        t.testNonDefaultMinimumAllocation();
        t.testReconnectedNode();
    }
}

