/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationDefinitionPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationRequestsPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityOverTimePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.GreedyReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mortbay.log.Log;

public class TestGreedyReservationAgent {
    ReservationAgent agent;
    InMemoryPlan plan;
    Resource minAlloc = Resource.newInstance((int)1024, (int)1);
    ResourceCalculator res = new DefaultResourceCalculator();
    Resource maxAlloc = Resource.newInstance((int)8192, (int)8);
    Random rand = new Random();
    long step;

    @Before
    public void setup() throws Exception {
        long seed = this.rand.nextLong();
        this.rand.setSeed(seed);
        Log.info((String)("Running with seed: " + seed));
        long timeWindow = 1000000L;
        Resource clusterCapacity = Resource.newInstance((int)102400, (int)100);
        this.step = 1000L;
        ReservationSystemTestUtil testUtil = new ReservationSystemTestUtil();
        CapacityScheduler scheduler = testUtil.mockCapacityScheduler(125);
        String reservationQ = testUtil.getFullReservationQueueName();
        CapacitySchedulerConfiguration capConf = scheduler.getConfiguration();
        capConf.setReservationWindow(reservationQ, timeWindow);
        capConf.setMaximumCapacity(reservationQ, 100.0f);
        capConf.setAverageCapacity(reservationQ, 100.0f);
        CapacityOverTimePolicy policy = new CapacityOverTimePolicy();
        policy.init(reservationQ, (Configuration)capConf);
        this.agent = new GreedyReservationAgent();
        QueueMetrics queueMetrics = QueueMetrics.forQueue((String)"dedicated", (Queue)((Queue)Mockito.mock(ParentQueue.class)), (boolean)false, (Configuration)capConf);
        this.plan = new InMemoryPlan(queueMetrics, (SharingPolicy)policy, this.agent, clusterCapacity, this.step, this.res, this.minAlloc, this.maxAlloc, "dedicated", null, true);
    }

    @Test
    public void testSimple() throws PlanningException {
        this.prepareBasicPlan();
        ReservationDefinitionPBImpl rr = new ReservationDefinitionPBImpl();
        rr.setArrival(5L * this.step);
        rr.setDeadline(20L * this.step);
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)2048, (int)2), (int)10, (int)5, (long)(10L * this.step));
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setReservationResources(Collections.singletonList(r));
        rr.setReservationRequests((ReservationRequests)reqs);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        this.agent.createReservation(reservationID, "u1", (Plan)this.plan, (ReservationDefinition)rr);
        Assert.assertTrue((String)"Agent-based allocation failed", (reservationID != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Agent-based allocation failed", (this.plan.getAllReservations().size() == 3 ? 1 : 0) != 0);
        ReservationAllocation cs = this.plan.getReservationById(reservationID);
        System.out.println("--------AFTER SIMPLE ALLOCATION (queue: " + reservationID + ")----------");
        System.out.println(this.plan.toString());
        System.out.println(this.plan.toCumulativeString());
        for (long i = 10L * this.step; i < 20L * this.step; ++i) {
            Assert.assertTrue((String)"Agent-based allocation unexpected", (boolean)Resources.equals((Resource)cs.getResourcesAtTime(i), (Resource)Resource.newInstance((int)20480, (int)20)));
        }
    }

    @Test
    public void testOrder() throws PlanningException {
        this.prepareBasicPlan();
        int[] f = new int[]{100, 100};
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), null, "u1", "dedicated", 30L * this.step, 30L * this.step + (long)f.length * this.step, ReservationSystemTestUtil.generateAllocation(30L * this.step, this.step, f), this.res, this.minAlloc)));
        ReservationDefinitionPBImpl rr = new ReservationDefinitionPBImpl();
        rr.setArrival(0L * this.step);
        rr.setDeadline(70L * this.step);
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setInterpreter(ReservationRequestInterpreter.R_ORDER);
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)2048, (int)2), (int)10, (int)1, (long)(10L * this.step));
        ReservationRequest r2 = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)10, (int)10, (long)(20L * this.step));
        ArrayList<ReservationRequest> list = new ArrayList<ReservationRequest>();
        list.add(r);
        list.add(r2);
        list.add(r);
        list.add(r2);
        reqs.setReservationResources(list);
        rr.setReservationRequests((ReservationRequests)reqs);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        this.agent.createReservation(reservationID, "u1", (Plan)this.plan, (ReservationDefinition)rr);
        Assert.assertTrue((String)"Agent-based allocation failed", (reservationID != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Agent-based allocation failed", (this.plan.getAllReservations().size() == 4 ? 1 : 0) != 0);
        ReservationAllocation cs = this.plan.getReservationById(reservationID);
        Assert.assertTrue((String)cs.toString(), (boolean)this.check(cs, 0L * this.step, 10L * this.step, 20, 1024, 1));
        Assert.assertTrue((String)cs.toString(), (boolean)this.check(cs, 10L * this.step, 30L * this.step, 10, 1024, 1));
        Assert.assertTrue((String)cs.toString(), (boolean)this.check(cs, 40L * this.step, 50L * this.step, 20, 1024, 1));
        Assert.assertTrue((String)cs.toString(), (boolean)this.check(cs, 50L * this.step, 70L * this.step, 10, 1024, 1));
        System.out.println("--------AFTER ORDER ALLOCATION (queue: " + reservationID + ")----------");
        System.out.println(this.plan.toString());
        System.out.println(this.plan.toCumulativeString());
    }

    @Test
    public void testOrderNoGapImpossible() throws PlanningException {
        this.prepareBasicPlan();
        int[] f = new int[]{100, 100};
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), null, "u1", "dedicated", 30L * this.step, 30L * this.step + (long)f.length * this.step, ReservationSystemTestUtil.generateAllocation(30L * this.step, this.step, f), this.res, this.minAlloc)));
        ReservationDefinitionPBImpl rr = new ReservationDefinitionPBImpl();
        rr.setArrival(0L);
        rr.setDeadline(70L);
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setInterpreter(ReservationRequestInterpreter.R_ORDER_NO_GAP);
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)2048, (int)2), (int)10, (int)1, (long)10L);
        ReservationRequest r2 = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)10, (int)10, (long)20L);
        ArrayList<ReservationRequest> list = new ArrayList<ReservationRequest>();
        list.add(r);
        list.add(r2);
        list.add(r);
        list.add(r2);
        reqs.setReservationResources(list);
        rr.setReservationRequests((ReservationRequests)reqs);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        boolean result = false;
        try {
            result = this.agent.createReservation(reservationID, "u1", (Plan)this.plan, (ReservationDefinition)rr);
            Assert.fail();
        }
        catch (PlanningException p) {
            // empty catch block
        }
        Assert.assertFalse((String)"Agent-based allocation should have failed", (boolean)result);
        Assert.assertTrue((String)"Agent-based allocation should have failed", (this.plan.getAllReservations().size() == 3 ? 1 : 0) != 0);
        System.out.println("--------AFTER ORDER_NO_GAP IMPOSSIBLE ALLOCATION (queue: " + reservationID + ")----------");
        System.out.println(this.plan.toString());
        System.out.println(this.plan.toCumulativeString());
    }

    @Test
    public void testOrderNoGap() throws PlanningException {
        this.prepareBasicPlan();
        ReservationDefinitionPBImpl rr = new ReservationDefinitionPBImpl();
        rr.setArrival(0L * this.step);
        rr.setDeadline(60L * this.step);
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setInterpreter(ReservationRequestInterpreter.R_ORDER_NO_GAP);
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)2048, (int)2), (int)10, (int)1, (long)(10L * this.step));
        ReservationRequest r2 = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)10, (int)10, (long)(20L * this.step));
        ArrayList<ReservationRequest> list = new ArrayList<ReservationRequest>();
        list.add(r);
        list.add(r2);
        list.add(r);
        list.add(r2);
        reqs.setReservationResources(list);
        rr.setReservationRequests((ReservationRequests)reqs);
        rr.setReservationRequests((ReservationRequests)reqs);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        this.agent.createReservation(reservationID, "u1", (Plan)this.plan, (ReservationDefinition)rr);
        System.out.println("--------AFTER ORDER ALLOCATION (queue: " + reservationID + ")----------");
        System.out.println(this.plan.toString());
        System.out.println(this.plan.toCumulativeString());
        Assert.assertTrue((String)"Agent-based allocation failed", (reservationID != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Agent-based allocation failed", (this.plan.getAllReservations().size() == 3 ? 1 : 0) != 0);
        ReservationAllocation cs = this.plan.getReservationById(reservationID);
        Assert.assertTrue((String)cs.toString(), (boolean)this.check(cs, 0L * this.step, 10L * this.step, 20, 1024, 1));
        Assert.assertTrue((String)cs.toString(), (boolean)this.check(cs, 10L * this.step, 30L * this.step, 10, 1024, 1));
        Assert.assertTrue((String)cs.toString(), (boolean)this.check(cs, 30L * this.step, 40L * this.step, 20, 1024, 1));
        Assert.assertTrue((String)cs.toString(), (boolean)this.check(cs, 40L * this.step, 60L * this.step, 10, 1024, 1));
    }

    @Test
    public void testSingleSliding() throws PlanningException {
        this.prepareBasicPlan();
        ReservationDefinitionPBImpl rr = new ReservationDefinitionPBImpl();
        rr.setArrival(100L * this.step);
        rr.setDeadline(120L * this.step);
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setInterpreter(ReservationRequestInterpreter.R_ALL);
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)200, (int)10, (long)(10L * this.step));
        ArrayList<ReservationRequest> list = new ArrayList<ReservationRequest>();
        list.add(r);
        reqs.setReservationResources(list);
        rr.setReservationRequests((ReservationRequests)reqs);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        this.agent.createReservation(reservationID, "u1", (Plan)this.plan, (ReservationDefinition)rr);
        Assert.assertTrue((String)"Agent-based allocation failed", (reservationID != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Agent-based allocation failed", (this.plan.getAllReservations().size() == 3 ? 1 : 0) != 0);
        ReservationAllocation cs = this.plan.getReservationById(reservationID);
        Assert.assertTrue((String)cs.toString(), (boolean)this.check(cs, 100L * this.step, 120L * this.step, 100, 1024, 1));
        System.out.println("--------AFTER packed ALLOCATION (queue: " + reservationID + ")----------");
        System.out.println(this.plan.toString());
        System.out.println(this.plan.toCumulativeString());
    }

    @Test
    public void testAny() throws PlanningException {
        this.prepareBasicPlan();
        ReservationDefinitionPBImpl rr = new ReservationDefinitionPBImpl();
        rr.setArrival(100L * this.step);
        rr.setDeadline(120L * this.step);
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setInterpreter(ReservationRequestInterpreter.R_ANY);
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)5, (int)5, (long)(10L * this.step));
        ReservationRequest r2 = ReservationRequest.newInstance((Resource)Resource.newInstance((int)2048, (int)2), (int)10, (int)5, (long)(10L * this.step));
        ReservationRequest r3 = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)110, (int)110, (long)(10L * this.step));
        ArrayList<ReservationRequest> list = new ArrayList<ReservationRequest>();
        list.add(r);
        list.add(r2);
        list.add(r3);
        reqs.setReservationResources(list);
        rr.setReservationRequests((ReservationRequests)reqs);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        boolean res = this.agent.createReservation(reservationID, "u1", (Plan)this.plan, (ReservationDefinition)rr);
        Assert.assertTrue((String)"Agent-based allocation failed", (boolean)res);
        Assert.assertTrue((String)"Agent-based allocation failed", (this.plan.getAllReservations().size() == 3 ? 1 : 0) != 0);
        ReservationAllocation cs = this.plan.getReservationById(reservationID);
        Assert.assertTrue((String)cs.toString(), (boolean)this.check(cs, 110L * this.step, 120L * this.step, 20, 1024, 1));
        System.out.println("--------AFTER ANY ALLOCATION (queue: " + reservationID + ")----------");
        System.out.println(this.plan.toString());
        System.out.println(this.plan.toCumulativeString());
    }

    @Test
    public void testAnyImpossible() throws PlanningException {
        this.prepareBasicPlan();
        ReservationDefinitionPBImpl rr = new ReservationDefinitionPBImpl();
        rr.setArrival(100L);
        rr.setDeadline(120L);
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setInterpreter(ReservationRequestInterpreter.R_ANY);
        ReservationRequest r1 = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)35, (int)5, (long)30L);
        ReservationRequest r2 = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)110, (int)110, (long)10L);
        ArrayList<ReservationRequest> list = new ArrayList<ReservationRequest>();
        list.add(r1);
        list.add(r2);
        reqs.setReservationResources(list);
        rr.setReservationRequests((ReservationRequests)reqs);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        boolean result = false;
        try {
            result = this.agent.createReservation(reservationID, "u1", (Plan)this.plan, (ReservationDefinition)rr);
            Assert.fail();
        }
        catch (PlanningException p) {
            // empty catch block
        }
        Assert.assertFalse((String)"Agent-based allocation should have failed", (boolean)result);
        Assert.assertTrue((String)"Agent-based allocation should have failed", (this.plan.getAllReservations().size() == 2 ? 1 : 0) != 0);
        System.out.println("--------AFTER ANY IMPOSSIBLE ALLOCATION (queue: " + reservationID + ")----------");
        System.out.println(this.plan.toString());
        System.out.println(this.plan.toCumulativeString());
    }

    @Test
    public void testAll() throws PlanningException {
        this.prepareBasicPlan();
        ReservationDefinitionPBImpl rr = new ReservationDefinitionPBImpl();
        rr.setArrival(100L * this.step);
        rr.setDeadline(120L * this.step);
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setInterpreter(ReservationRequestInterpreter.R_ALL);
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)5, (int)5, (long)(10L * this.step));
        ReservationRequest r2 = ReservationRequest.newInstance((Resource)Resource.newInstance((int)2048, (int)2), (int)10, (int)10, (long)(20L * this.step));
        ArrayList<ReservationRequest> list = new ArrayList<ReservationRequest>();
        list.add(r);
        list.add(r2);
        reqs.setReservationResources(list);
        rr.setReservationRequests((ReservationRequests)reqs);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        this.agent.createReservation(reservationID, "u1", (Plan)this.plan, (ReservationDefinition)rr);
        Assert.assertTrue((String)"Agent-based allocation failed", (reservationID != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Agent-based allocation failed", (this.plan.getAllReservations().size() == 3 ? 1 : 0) != 0);
        ReservationAllocation cs = this.plan.getReservationById(reservationID);
        Assert.assertTrue((String)cs.toString(), (boolean)this.check(cs, 100L * this.step, 110L * this.step, 20, 1024, 1));
        Assert.assertTrue((String)cs.toString(), (boolean)this.check(cs, 110L * this.step, 120L * this.step, 25, 1024, 1));
        System.out.println("--------AFTER ALL ALLOCATION (queue: " + reservationID + ")----------");
        System.out.println(this.plan.toString());
        System.out.println(this.plan.toCumulativeString());
    }

    @Test
    public void testAllImpossible() throws PlanningException {
        this.prepareBasicPlan();
        ReservationDefinitionPBImpl rr = new ReservationDefinitionPBImpl();
        rr.setArrival(100L);
        rr.setDeadline(120L);
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setInterpreter(ReservationRequestInterpreter.R_ALL);
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)55, (int)5, (long)10L);
        ReservationRequest r2 = ReservationRequest.newInstance((Resource)Resource.newInstance((int)2048, (int)2), (int)55, (int)5, (long)20L);
        ArrayList<ReservationRequest> list = new ArrayList<ReservationRequest>();
        list.add(r);
        list.add(r2);
        reqs.setReservationResources(list);
        rr.setReservationRequests((ReservationRequests)reqs);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        boolean result = false;
        try {
            result = this.agent.createReservation(reservationID, "u1", (Plan)this.plan, (ReservationDefinition)rr);
            Assert.fail();
        }
        catch (PlanningException p) {
            // empty catch block
        }
        Assert.assertFalse((String)"Agent-based allocation failed", (boolean)result);
        Assert.assertTrue((String)"Agent-based allocation failed", (this.plan.getAllReservations().size() == 2 ? 1 : 0) != 0);
        System.out.println("--------AFTER ALL IMPOSSIBLE ALLOCATION (queue: " + reservationID + ")----------");
        System.out.println(this.plan.toString());
        System.out.println(this.plan.toCumulativeString());
    }

    private void prepareBasicPlan() throws PlanningException {
        int[] f = new int[]{10, 10, 20, 20, 20, 10, 10};
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), null, "u1", "dedicated", 0L, 0L + (long)f.length * this.step, ReservationSystemTestUtil.generateAllocation(0L, this.step, f), this.res, this.minAlloc)));
        int[] f2 = new int[]{5, 5, 5, 5, 5, 5, 5};
        Map<ReservationInterval, ReservationRequest> alloc = ReservationSystemTestUtil.generateAllocation(5000L, this.step, f2);
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), null, "u1", "dedicated", 5000L, 5000L + (long)f2.length * this.step, alloc, this.res, this.minAlloc)));
        System.out.println("--------BEFORE AGENT----------");
        System.out.println(this.plan.toString());
        System.out.println(this.plan.toCumulativeString());
    }

    private boolean check(ReservationAllocation cs, long start, long end, int containers, int mem, int cores) {
        boolean res = true;
        for (long i = start; i < end; ++i) {
            res = res && Resources.equals((Resource)cs.getResourcesAtTime(i), (Resource)Resource.newInstance((int)(mem * containers), (int)(cores * containers)));
        }
        return res;
    }

    public void testStress(int numJobs) throws PlanningException, IOException {
        long timeWindow = 1000000L;
        Resource clusterCapacity = Resource.newInstance((int)51200000, (int)16000);
        this.step = 1000L;
        ReservationSystemTestUtil testUtil = new ReservationSystemTestUtil();
        CapacityScheduler scheduler = testUtil.mockCapacityScheduler(50000);
        String reservationQ = testUtil.getFullReservationQueueName();
        CapacitySchedulerConfiguration capConf = scheduler.getConfiguration();
        capConf.setReservationWindow(reservationQ, timeWindow);
        capConf.setMaximumCapacity(reservationQ, 100.0f);
        capConf.setAverageCapacity(reservationQ, 100.0f);
        CapacityOverTimePolicy policy = new CapacityOverTimePolicy();
        policy.init(reservationQ, (Configuration)capConf);
        this.plan = new InMemoryPlan(scheduler.getRootQueueMetrics(), (SharingPolicy)policy, this.agent, clusterCapacity, this.step, this.res, this.minAlloc, this.maxAlloc, "dedicated", null, true);
        int acc = 0;
        ArrayList<ReservationDefinition> list = new ArrayList<ReservationDefinition>();
        for (long i = 0L; i < (long)numJobs; ++i) {
            list.add(ReservationSystemTestUtil.generateRandomRR(this.rand, i));
        }
        long start = System.currentTimeMillis();
        for (int i = 0; i < numJobs; ++i) {
            try {
                if (!this.agent.createReservation(ReservationSystemTestUtil.getNewReservationId(), "u" + i % 100, (Plan)this.plan, (ReservationDefinition)list.get(i))) continue;
                ++acc;
                continue;
            }
            catch (PlanningException p) {
                // empty catch block
            }
        }
        long end = System.currentTimeMillis();
        System.out.println("Submitted " + numJobs + " jobs " + " accepted " + acc + " in " + (end - start) + "ms");
    }

    public static void main(String[] arg) {
        int numJobs = 1000;
        if (arg.length > 0) {
            numJobs = Integer.parseInt(arg[0]);
        }
        try {
            TestGreedyReservationAgent test = new TestGreedyReservationAgent();
            test.setup();
            test.testStress(numJobs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

