/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityHeadroomProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LeafQueue
extends AbstractCSQueue {
    private static final Log LOG = LogFactory.getLog(LeafQueue.class);
    private float absoluteUsedCapacity = 0.0f;
    private int userLimit;
    private float userLimitFactor;
    protected int maxApplications;
    protected int maxApplicationsPerUser;
    private float maxAMResourcePerQueuePercent;
    private int nodeLocalityDelay;
    Set<FiCaSchedulerApp> activeApplications;
    Map<ApplicationAttemptId, FiCaSchedulerApp> applicationAttemptMap = new HashMap<ApplicationAttemptId, FiCaSchedulerApp>();
    Set<FiCaSchedulerApp> pendingApplications;
    private float minimumAllocationFactor;
    private Map<String, User> users = new HashMap<String, User>();
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private CapacitySchedulerContext scheduler;
    private final ActiveUsersManager activeUsersManager;
    private Resource lastClusterResource = Resources.none();
    private Resource absoluteCapacityResource = Resources.none();
    private final QueueHeadroomInfo queueHeadroomInfo = new QueueHeadroomInfo();
    private volatile float absoluteMaxAvailCapacity;
    private static final CSAssignment NULL_ASSIGNMENT = new CSAssignment(Resources.createResource((int)0, (int)0), NodeType.NODE_LOCAL);
    private static final CSAssignment SKIP_ASSIGNMENT = new CSAssignment(true);

    public LeafQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        super(cs, queueName, parent, old);
        this.scheduler = cs;
        this.activeUsersManager = new ActiveUsersManager(this.metrics);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("LeafQueue: name=" + queueName + ", fullname=" + this.getQueuePath()));
        }
        Comparator<FiCaSchedulerApp> applicationComparator = cs.getApplicationComparator();
        this.pendingApplications = new TreeSet<FiCaSchedulerApp>(applicationComparator);
        this.activeApplications = new TreeSet<FiCaSchedulerApp>(applicationComparator);
        this.setupQueueConfigs(cs.getClusterResource());
    }

    @Override
    protected synchronized void setupQueueConfigs(Resource clusterResource) throws IOException {
        super.setupQueueConfigs(clusterResource);
        this.lastClusterResource = clusterResource;
        this.updateAbsoluteCapacityResource(clusterResource);
        this.updateHeadroomInfo(clusterResource, this.queueCapacities.getAbsoluteMaximumCapacity());
        CapacitySchedulerConfiguration conf = this.csContext.getConfiguration();
        this.userLimit = conf.getUserLimit(this.getQueuePath());
        this.userLimitFactor = conf.getUserLimitFactor(this.getQueuePath());
        this.absoluteMaxAvailCapacity = this.queueCapacities.getAbsoluteMaximumCapacity();
        this.maxApplications = conf.getMaximumApplicationsPerQueue(this.getQueuePath());
        if (this.maxApplications < 0) {
            int maxSystemApps = conf.getMaximumSystemApplications();
            this.maxApplications = (int)((float)maxSystemApps * this.queueCapacities.getAbsoluteCapacity());
        }
        this.maxApplicationsPerUser = (int)((float)this.maxApplications * ((float)this.userLimit / 100.0f) * this.userLimitFactor);
        this.maxAMResourcePerQueuePercent = conf.getMaximumApplicationMasterResourcePerQueuePercent(this.getQueuePath());
        if (!SchedulerUtils.checkQueueLabelExpression(this.accessibleLabels, this.defaultLabelExpression, null)) {
            throw new IOException("Invalid default label expression of  queue=" + this.getQueueName() + " doesn't have permission to access all labels " + "in default label expression. labelExpression of resource request=" + (this.defaultLabelExpression == null ? "" : this.defaultLabelExpression) + ". Queue labels=" + (this.getAccessibleNodeLabels() == null ? "" : StringUtils.join(this.getAccessibleNodeLabels().iterator(), (char)',')));
        }
        this.nodeLocalityDelay = conf.getNodeLocalityDelay();
        this.minimumAllocationFactor = Resources.ratio((ResourceCalculator)this.resourceCalculator, (Resource)Resources.subtract((Resource)this.maximumAllocation, (Resource)this.minimumAllocation), (Resource)this.maximumAllocation);
        StringBuilder aclsString = new StringBuilder();
        for (Map.Entry e : this.acls.entrySet()) {
            aclsString.append(e.getKey() + ":" + ((AccessControlList)e.getValue()).getAclString());
        }
        StringBuilder labelStrBuilder = new StringBuilder();
        if (this.accessibleLabels != null) {
            for (String s : this.accessibleLabels) {
                labelStrBuilder.append(s);
                labelStrBuilder.append(",");
            }
        }
        LOG.info((Object)("Initializing " + this.queueName + "\n" + "capacity = " + this.queueCapacities.getCapacity() + " [= (float) configuredCapacity / 100 ]" + "\n" + "asboluteCapacity = " + this.queueCapacities.getAbsoluteCapacity() + " [= parentAbsoluteCapacity * capacity ]" + "\n" + "maxCapacity = " + this.queueCapacities.getMaximumCapacity() + " [= configuredMaxCapacity ]" + "\n" + "absoluteMaxCapacity = " + this.queueCapacities.getAbsoluteMaximumCapacity() + " [= 1.0 maximumCapacity undefined, " + "(parentAbsoluteMaxCapacity * maximumCapacity) / 100 otherwise ]" + "\n" + "userLimit = " + this.userLimit + " [= configuredUserLimit ]" + "\n" + "userLimitFactor = " + this.userLimitFactor + " [= configuredUserLimitFactor ]" + "\n" + "maxApplications = " + this.maxApplications + " [= configuredMaximumSystemApplicationsPerQueue or" + " (int)(configuredMaximumSystemApplications * absoluteCapacity)]" + "\n" + "maxApplicationsPerUser = " + this.maxApplicationsPerUser + " [= (int)(maxApplications * (userLimit / 100.0f) * " + "userLimitFactor) ]" + "\n" + "usedCapacity = " + this.queueCapacities.getUsedCapacity() + " [= usedResourcesMemory / " + "(clusterResourceMemory * absoluteCapacity)]" + "\n" + "absoluteUsedCapacity = " + this.absoluteUsedCapacity + " [= usedResourcesMemory / clusterResourceMemory]" + "\n" + "maxAMResourcePerQueuePercent = " + this.maxAMResourcePerQueuePercent + " [= configuredMaximumAMResourcePercent ]" + "\n" + "minimumAllocationFactor = " + this.minimumAllocationFactor + " [= (float)(maximumAllocationMemory - minimumAllocationMemory) / " + "maximumAllocationMemory ]" + "\n" + "numContainers = " + this.numContainers + " [= currentNumContainers ]" + "\n" + "state = " + this.state + " [= configuredState ]" + "\n" + "acls = " + aclsString + " [= configuredAcls ]" + "\n" + "nodeLocalityDelay = " + this.nodeLocalityDelay + "\n" + "labels=" + labelStrBuilder.toString() + "\n" + "nodeLocalityDelay = " + this.nodeLocalityDelay + "\n" + "reservationsContinueLooking = " + this.reservationsContinueLooking + "\n"));
    }

    @Override
    public String getQueuePath() {
        return this.getParent().getQueuePath() + "." + this.getQueueName();
    }

    @InterfaceAudience.Private
    public float getMinimumAllocationFactor() {
        return this.minimumAllocationFactor;
    }

    @InterfaceAudience.Private
    public float getMaxAMResourcePerQueuePercent() {
        return this.maxAMResourcePerQueuePercent;
    }

    public int getMaxApplications() {
        return this.maxApplications;
    }

    public synchronized int getMaxApplicationsPerUser() {
        return this.maxApplicationsPerUser;
    }

    @Override
    public ActiveUsersManager getActiveUsersManager() {
        return this.activeUsersManager;
    }

    @Override
    public List<CSQueue> getChildQueues() {
        return null;
    }

    synchronized void setUserLimit(int userLimit) {
        this.userLimit = userLimit;
    }

    synchronized void setUserLimitFactor(float userLimitFactor) {
        this.userLimitFactor = userLimitFactor;
    }

    @Override
    public synchronized int getNumApplications() {
        return this.getNumPendingApplications() + this.getNumActiveApplications();
    }

    public synchronized int getNumPendingApplications() {
        return this.pendingApplications.size();
    }

    public synchronized int getNumActiveApplications() {
        return this.activeApplications.size();
    }

    @InterfaceAudience.Private
    public synchronized int getNumApplications(String user) {
        return this.getUser(user).getTotalApplications();
    }

    @InterfaceAudience.Private
    public synchronized int getNumPendingApplications(String user) {
        return this.getUser(user).getPendingApplications();
    }

    @InterfaceAudience.Private
    public synchronized int getNumActiveApplications(String user) {
        return this.getUser(user).getActiveApplications();
    }

    @Override
    public synchronized int getNumContainers() {
        return this.numContainers;
    }

    @Override
    public synchronized QueueState getState() {
        return this.state;
    }

    @InterfaceAudience.Private
    public synchronized int getUserLimit() {
        return this.userLimit;
    }

    @InterfaceAudience.Private
    public synchronized float getUserLimitFactor() {
        return this.userLimitFactor;
    }

    @Override
    public synchronized QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        QueueInfo queueInfo = this.getQueueInfo();
        return queueInfo;
    }

    @Override
    public synchronized List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return Collections.singletonList(userAclInfo);
    }

    @InterfaceAudience.Private
    public int getNodeLocalityDelay() {
        return this.nodeLocalityDelay;
    }

    public String toString() {
        return this.queueName + ": " + "capacity=" + this.queueCapacities.getCapacity() + ", " + "absoluteCapacity=" + this.queueCapacities.getAbsoluteCapacity() + ", " + "usedResources=" + this.queueUsage.getUsed() + ", " + "usedCapacity=" + this.getUsedCapacity() + ", " + "absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + ", " + "numApps=" + this.getNumApplications() + ", " + "numContainers=" + this.getNumContainers();
    }

    @VisibleForTesting
    public synchronized void setNodeLabelManager(RMNodeLabelsManager mgr) {
        this.labelManager = mgr;
    }

    @VisibleForTesting
    public synchronized User getUser(String userName) {
        User user = this.users.get(userName);
        if (user == null) {
            user = new User();
            this.users.put(userName, user);
        }
        return user;
    }

    public synchronized ArrayList<UserInfo> getUsers() {
        ArrayList<UserInfo> usersToReturn = new ArrayList<UserInfo>();
        for (Map.Entry<String, User> entry : this.users.entrySet()) {
            usersToReturn.add(new UserInfo(entry.getKey(), Resources.clone((Resource)entry.getValue().getUsed()), entry.getValue().getActiveApplications(), entry.getValue().getPendingApplications()));
        }
        return usersToReturn;
    }

    @Override
    public synchronized void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        if (!(newlyParsedQueue instanceof LeafQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
            throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
        }
        this.setupQueueConfigs(clusterResource);
        this.activateApplications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplicationAttempt(FiCaSchedulerApp application, String userName) {
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            User user = this.getUser(userName);
            this.addApplicationAttempt(application, user);
        }
        if (application.isPending()) {
            this.metrics.submitAppAttempt(userName);
        }
        this.getParent().submitApplicationAttempt(application, userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplication(ApplicationId applicationId, String userName, String queue) throws AccessControlException {
        UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)userName);
        if (!this.hasAccess(QueueACL.SUBMIT_APPLICATIONS, userUgi) && !this.hasAccess(QueueACL.ADMINISTER_QUEUE, userUgi)) {
            throw new AccessControlException("User " + userName + " cannot submit" + " applications to queue " + this.getQueuePath());
        }
        User user = null;
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            if (this.getState() != QueueState.RUNNING) {
                String msg = "Queue " + this.getQueuePath() + " is STOPPED. Cannot accept submission of application: " + applicationId;
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            if (this.getNumApplications() >= this.getMaxApplications()) {
                String msg = "Queue " + this.getQueuePath() + " already has " + this.getNumApplications() + " applications," + " cannot accept submission of application: " + applicationId;
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            user = this.getUser(userName);
            if (user.getTotalApplications() >= this.getMaxApplicationsPerUser()) {
                String msg = "Queue " + this.getQueuePath() + " already has " + user.getTotalApplications() + " applications from user " + userName + " cannot accept submission of application: " + applicationId;
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
        }
        try {
            this.getParent().submitApplication(applicationId, userName, queue);
        }
        catch (AccessControlException ace) {
            LOG.info((Object)("Failed to submit application to parent-queue: " + this.getParent().getQueuePath()), (Throwable)ace);
            throw ace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Resource getAMResourceLimit() {
        Resource queueMaxCap;
        QueueHeadroomInfo queueHeadroomInfo = this.queueHeadroomInfo;
        synchronized (queueHeadroomInfo) {
            queueMaxCap = this.queueHeadroomInfo.getQueueMaxCap();
        }
        Resource queueCap = Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)this.absoluteCapacityResource, (Resource)queueMaxCap);
        return Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)queueCap, (double)this.maxAMResourcePerQueuePercent, (Resource)this.minimumAllocation);
    }

    public synchronized Resource getUserAMResourceLimit() {
        float effectiveUserLimit = Math.max((float)this.userLimit / 100.0f, 1.0f / (float)Math.max(this.getActiveUsersManager().getNumActiveUsers(), 1));
        return Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)this.absoluteCapacityResource, (double)(this.maxAMResourcePerQueuePercent * effectiveUserLimit * this.userLimitFactor), (Resource)this.minimumAllocation);
    }

    private synchronized void activateApplications() {
        Resource amLimit = this.getAMResourceLimit();
        Resource userAMLimit = this.getUserAMResourceLimit();
        Iterator<FiCaSchedulerApp> i = this.pendingApplications.iterator();
        while (i.hasNext()) {
            FiCaSchedulerApp application = i.next();
            Resource amIfStarted = Resources.add((Resource)application.getAMResource(), (Resource)this.queueUsage.getAMUsed());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("application AMResource " + application.getAMResource() + " maxAMResourcePerQueuePercent " + this.maxAMResourcePerQueuePercent + " amLimit " + amLimit + " lastClusterResource " + this.lastClusterResource + " amIfStarted " + amIfStarted));
            }
            if (!Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)amIfStarted, (Resource)amLimit)) {
                if (this.getNumActiveApplications() < 1) {
                    LOG.warn((Object)"maximum-am-resource-percent is insufficient to start a single application in queue, it is likely set too low. skipping enforcement to allow at least one application to start");
                } else {
                    LOG.info((Object)"not starting application as amIfStarted exceeds amLimit");
                    continue;
                }
            }
            User user = this.getUser(application.getUser());
            Resource userAmIfStarted = Resources.add((Resource)application.getAMResource(), (Resource)user.getConsumedAMResources());
            if (!Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)userAmIfStarted, (Resource)userAMLimit)) {
                if (this.getNumActiveApplications() < 1) {
                    LOG.warn((Object)"maximum-am-resource-percent is insufficient to start a single application in queue for user, it is likely set too low. skipping enforcement to allow at least one application to start");
                } else {
                    LOG.info((Object)"not starting application as amIfStarted exceeds userAmLimit");
                    continue;
                }
            }
            user.activateApplication();
            this.activeApplications.add(application);
            this.queueUsage.incAMUsed(application.getAMResource());
            user.getResourceUsage().incAMUsed(application.getAMResource());
            i.remove();
            LOG.info((Object)("Application " + application.getApplicationId() + " from user: " + application.getUser() + " activated in queue: " + this.getQueueName()));
        }
    }

    private synchronized void addApplicationAttempt(FiCaSchedulerApp application, User user) {
        user.submitApplication();
        this.pendingApplications.add(application);
        this.applicationAttemptMap.put(application.getApplicationAttemptId(), application);
        this.activateApplications();
        LOG.info((Object)("Application added - appId: " + application.getApplicationId() + " user: " + user + "," + " leaf-queue: " + this.getQueueName() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications()));
    }

    @Override
    public void finishApplication(ApplicationId application, String user) {
        this.activeUsersManager.deactivateApplication(user, application);
        this.getParent().finishApplication(application, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishApplicationAttempt(FiCaSchedulerApp application, String queue) {
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            this.removeApplicationAttempt(application, this.getUser(application.getUser()));
        }
        this.getParent().finishApplicationAttempt(application, queue);
    }

    public synchronized void removeApplicationAttempt(FiCaSchedulerApp application, User user) {
        boolean wasActive = this.activeApplications.remove(application);
        if (!wasActive) {
            this.pendingApplications.remove(application);
        } else {
            this.queueUsage.decAMUsed(application.getAMResource());
            user.getResourceUsage().decAMUsed(application.getAMResource());
        }
        this.applicationAttemptMap.remove(application.getApplicationAttemptId());
        user.finishApplication(wasActive);
        if (user.getTotalApplications() == 0) {
            this.users.remove(application.getUser());
        }
        this.activateApplications();
        LOG.info((Object)("Application removed - appId: " + application.getApplicationId() + " user: " + application.getUser() + " queue: " + this.getQueueName() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications()));
    }

    private synchronized FiCaSchedulerApp getApplication(ApplicationAttemptId applicationAttemptId) {
        return this.applicationAttemptMap.get(applicationAttemptId);
    }

    private static Set<String> getRequestLabelSetByExpression(String labelExpression) {
        HashSet<String> labels = new HashSet<String>();
        if (null == labelExpression) {
            return labels;
        }
        for (String l : labelExpression.split("&&")) {
            if (l.trim().isEmpty()) continue;
            labels.add(l.trim());
        }
        return labels;
    }

    @Override
    public CSAssignment assignContainers(Resource clusterResource, FiCaSchedulerNode node, boolean needToUnreserve) {
        this.absoluteMaxAvailCapacity = CSQueueUtils.getAbsoluteMaxAvailCapacity(this.resourceCalculator, clusterResource, this);
        return this.assignContainersInternal(clusterResource, node, needToUnreserve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized CSAssignment assignContainersInternal(Resource clusterResource, FiCaSchedulerNode node, boolean needToUnreserve) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("assignContainers: node=" + node.getNodeName() + " #applications=" + this.activeApplications.size()));
        }
        if (!SchedulerUtils.checkQueueAccessToNode(this.accessibleLabels, node.getLabels())) {
            return NULL_ASSIGNMENT;
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            FiCaSchedulerApp application;
            FiCaSchedulerApp fiCaSchedulerApp = application = this.getApplication(reservedContainer.getApplicationAttemptId());
            synchronized (fiCaSchedulerApp) {
                return this.assignReservedContainer(application, node, reservedContainer, clusterResource);
            }
        }
        for (FiCaSchedulerApp application : this.activeApplications) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("pre-assignContainers for application " + application.getApplicationId()));
                application.showRequests();
            }
            FiCaSchedulerApp fiCaSchedulerApp = application;
            synchronized (fiCaSchedulerApp) {
                if (SchedulerAppUtils.isBlacklisted(application, node, LOG)) {
                    continue;
                }
                for (Priority priority : application.getPriorities()) {
                    ResourceRequest anyRequest = application.getResourceRequest(priority, "*");
                    if (null == anyRequest) continue;
                    Resource required = anyRequest.getCapability();
                    if (application.getTotalRequiredResources(priority) <= 0) continue;
                    if (!this.reservationsContinueLooking && !this.needContainers(application, priority, required)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)"doesn't need containers based on reservation algo!");
                        continue;
                    }
                    Set<String> requestedNodeLabels = LeafQueue.getRequestLabelSetByExpression(anyRequest.getNodeLabelExpression());
                    Resource userLimit = this.computeUserLimitAndSetHeadroom(application, clusterResource, required, requestedNodeLabels);
                    if (!this.canAssignToThisQueue(clusterResource, required, node.getLabels(), application, true)) {
                        return NULL_ASSIGNMENT;
                    }
                    if (!this.assignToUser(clusterResource, application.getUser(), userLimit, application, true, requestedNodeLabels)) break;
                    application.addSchedulingOpportunity(priority);
                    CSAssignment assignment = this.assignContainersOnNode(clusterResource, node, application, priority, null, needToUnreserve);
                    if (assignment.getSkipped()) {
                        application.subtractSchedulingOpportunity(priority);
                        continue;
                    }
                    Resource assigned = assignment.getResource();
                    if (!Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)assigned, (Resource)Resources.none())) break;
                    this.allocateResource(clusterResource, application, assigned, node.getLabels());
                    if (assignment.getType() != NodeType.OFF_SWITCH) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Resetting scheduling opportunities");
                        }
                        application.resetSchedulingOpportunities(priority);
                    }
                    return assignment;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("post-assignContainers for application " + application.getApplicationId()));
            }
            application.showRequests();
        }
        return NULL_ASSIGNMENT;
    }

    private synchronized CSAssignment assignReservedContainer(FiCaSchedulerApp application, FiCaSchedulerNode node, RMContainer rmContainer, Resource clusterResource) {
        Priority priority = rmContainer.getReservedPriority();
        if (application.getTotalRequiredResources(priority) == 0) {
            return new CSAssignment(application, rmContainer);
        }
        this.assignContainersOnNode(clusterResource, node, application, priority, rmContainer, false);
        return new CSAssignment(Resources.none(), NodeType.NODE_LOCAL);
    }

    protected Resource getHeadroom(User user, Resource queueMaxCap, Resource clusterResource, FiCaSchedulerApp application, Resource required) {
        return this.getHeadroom(user, queueMaxCap, clusterResource, this.computeUserLimit(application, clusterResource, required, user, null));
    }

    private Resource getHeadroom(User user, Resource queueMaxCap, Resource clusterResource, Resource userLimit) {
        Resource headroom = Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.subtract((Resource)userLimit, (Resource)user.getUsed()), (Resource)Resources.subtract((Resource)queueMaxCap, (Resource)this.queueUsage.getUsed()));
        return headroom;
    }

    synchronized boolean canAssignToThisQueue(Resource clusterResource, Resource required, Set<String> nodeLabels, FiCaSchedulerApp application, boolean checkReservations) {
        HashSet<String> labelCanAccess;
        if (null == nodeLabels || nodeLabels.isEmpty()) {
            labelCanAccess = new HashSet<String>();
            labelCanAccess.add("");
        } else {
            labelCanAccess = new HashSet(Sets.intersection((Set)this.accessibleLabels, nodeLabels));
        }
        boolean canAssign = true;
        for (String label : labelCanAccess) {
            float potentialNewWithoutReservedCapacity;
            Resource potentialTotalCapacity = Resources.add((Resource)this.queueUsage.getUsed(label), (Resource)required);
            float potentialNewCapacity = Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)potentialTotalCapacity, (Resource)this.labelManager.getResourceByLabel(label, clusterResource));
            if (this.reservationsContinueLooking && checkReservations && label.equals("") && (potentialNewWithoutReservedCapacity = Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.subtract((Resource)potentialTotalCapacity, (Resource)application.getCurrentReservation()), (Resource)this.labelManager.getResourceByLabel(label, clusterResource))) <= this.queueCapacities.getAbsoluteMaximumCapacity()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("try to use reserved: " + this.getQueueName() + " usedResources: " + this.queueUsage.getUsed() + " clusterResources: " + clusterResource + " reservedResources: " + application.getCurrentReservation() + " currentCapacity " + Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)this.queueUsage.getUsed(), (Resource)clusterResource) + " required " + required + " potentialNewWithoutReservedCapacity: " + potentialNewWithoutReservedCapacity + " ( " + " max-capacity: " + this.queueCapacities.getAbsoluteMaximumCapacity() + ")"));
                }
                return true;
            }
            if ((double)potentialNewCapacity > (double)this.queueCapacities.getAbsoluteMaximumCapacity(label) + 1.0E-4) {
                canAssign = false;
                break;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)(this.getQueueName() + "Check assign to queue, label=" + label + " usedResources: " + this.queueUsage.getUsed(label) + " clusterResources: " + clusterResource + " currentCapacity " + Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)this.queueUsage.getUsed(label), (Resource)this.labelManager.getResourceByLabel(label, clusterResource)) + " potentialNewCapacity: " + potentialNewCapacity + " ( " + " max-capacity: " + this.queueCapacities.getAbsoluteMaximumCapacity() + ")"));
        }
        return canAssign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource updateHeadroomInfo(Resource clusterResource, float absoluteMaxAvailCapacity) {
        Resource queueMaxCap = Resources.multiplyAndNormalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (double)absoluteMaxAvailCapacity, (Resource)this.minimumAllocation);
        QueueHeadroomInfo queueHeadroomInfo = this.queueHeadroomInfo;
        synchronized (queueHeadroomInfo) {
            this.queueHeadroomInfo.setQueueMaxCap(queueMaxCap);
            this.queueHeadroomInfo.setClusterResource(clusterResource);
        }
        return queueMaxCap;
    }

    @Lock(value={LeafQueue.class, FiCaSchedulerApp.class})
    Resource computeUserLimitAndSetHeadroom(FiCaSchedulerApp application, Resource clusterResource, Resource required, Set<String> requestedLabels) {
        String user = application.getUser();
        User queueUser = this.getUser(user);
        Resource userLimit = this.computeUserLimit(application, clusterResource, required, queueUser, requestedLabels);
        Resource queueMaxCap = this.updateHeadroomInfo(clusterResource, this.absoluteMaxAvailCapacity);
        Resource headroom = this.getHeadroom(queueUser, queueMaxCap, clusterResource, userLimit);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Headroom calculation for user " + user + ": " + " userLimit=" + userLimit + " queueMaxCap=" + queueMaxCap + " consumed=" + queueUser.getUsed() + " headroom=" + headroom));
        }
        CapacityHeadroomProvider headroomProvider = new CapacityHeadroomProvider(queueUser, this, application, required, this.queueHeadroomInfo);
        application.setHeadroomProvider(headroomProvider);
        this.metrics.setAvailableResourcesToUser(user, headroom);
        return userLimit;
    }

    @Lock(value={Lock.NoLock.class})
    private Resource computeUserLimit(FiCaSchedulerApp application, Resource clusterResource, Resource required, User user, Set<String> requestedLabels) {
        Resource queueCapacity = Resource.newInstance((int)0, (int)0);
        if (requestedLabels != null && !requestedLabels.isEmpty()) {
            String firstLabel = requestedLabels.iterator().next();
            queueCapacity = Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)queueCapacity, (Resource)Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)this.labelManager.getResourceByLabel(firstLabel, clusterResource), (double)this.queueCapacities.getAbsoluteCapacity(firstLabel), (Resource)this.minimumAllocation));
        } else {
            queueCapacity = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)this.labelManager.getResourceByLabel("", clusterResource), (double)this.queueCapacities.getAbsoluteCapacity(), (Resource)this.minimumAllocation);
        }
        queueCapacity = Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)queueCapacity, (Resource)required);
        Resource currentCapacity = Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)this.queueUsage.getUsed(), (Resource)queueCapacity) ? queueCapacity : Resources.add((Resource)this.queueUsage.getUsed(), (Resource)required);
        int activeUsers = this.activeUsersManager.getNumActiveUsers();
        Resource limit = Resources.roundUp((ResourceCalculator)this.resourceCalculator, (Resource)Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.divideAndCeil((ResourceCalculator)this.resourceCalculator, (Resource)currentCapacity, (int)activeUsers), (Resource)Resources.divideAndCeil((ResourceCalculator)this.resourceCalculator, (Resource)Resources.multiplyAndRoundDown((Resource)currentCapacity, (double)this.userLimit), (int)100)), (Resource)Resources.multiplyAndRoundDown((Resource)queueCapacity, (double)this.userLimitFactor)), (Resource)this.minimumAllocation);
        if (LOG.isDebugEnabled()) {
            String userName = application.getUser();
            LOG.debug((Object)("User limit computation for " + userName + " in queue " + this.getQueueName() + " userLimit=" + this.userLimit + " userLimitFactor=" + this.userLimitFactor + " required: " + required + " consumed: " + user.getUsed() + " limit: " + limit + " queueCapacity: " + queueCapacity + " qconsumed: " + this.queueUsage.getUsed() + " currentCapacity: " + currentCapacity + " activeUsers: " + activeUsers + " clusterCapacity: " + clusterResource));
        }
        return limit;
    }

    @InterfaceAudience.Private
    protected synchronized boolean assignToUser(Resource clusterResource, String userName, Resource limit, FiCaSchedulerApp application, boolean checkReservations, Set<String> requestLabels) {
        User user = this.getUser(userName);
        String label = "";
        if (requestLabels != null && !requestLabels.isEmpty()) {
            label = requestLabels.iterator().next();
        }
        if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)user.getUsed(label), (Resource)limit)) {
            if (this.reservationsContinueLooking && checkReservations && Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.subtract((Resource)user.getUsed(), (Resource)application.getCurrentReservation()), (Resource)limit)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User " + userName + " in queue " + this.getQueueName() + " will exceed limit based on reservations - " + " consumed: " + user.getUsed() + " reserved: " + application.getCurrentReservation() + " limit: " + limit));
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("User " + userName + " in queue " + this.getQueueName() + " will exceed limit - " + " consumed: " + user.getUsed() + " limit: " + limit));
            }
            return false;
        }
        return true;
    }

    boolean needContainers(FiCaSchedulerApp application, Priority priority, Resource required) {
        int requiredContainers = application.getTotalRequiredResources(priority);
        int reservedContainers = application.getNumReservedContainers(priority);
        int starvation = 0;
        if (reservedContainers > 0) {
            float nodeFactor = Resources.ratio((ResourceCalculator)this.resourceCalculator, (Resource)required, (Resource)this.getMaximumAllocation());
            starvation = (int)((float)application.getReReservations(priority) / (float)reservedContainers * (1.0f - Math.min(nodeFactor, this.getMinimumAllocationFactor())));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("needsContainers: app.#re-reserve=" + application.getReReservations(priority) + " reserved=" + reservedContainers + " nodeFactor=" + nodeFactor + " minAllocFactor=" + this.getMinimumAllocationFactor() + " starvation=" + starvation));
            }
        }
        return starvation + requiredContainers - reservedContainers > 0;
    }

    private CSAssignment assignContainersOnNode(Resource clusterResource, FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, RMContainer reservedContainer, boolean needToUnreserve) {
        ResourceRequest offSwitchResourceRequest;
        Resource assigned = Resources.none();
        ResourceRequest nodeLocalResourceRequest = application.getResourceRequest(priority, node.getNodeName());
        if (nodeLocalResourceRequest != null && Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)(assigned = this.assignNodeLocalContainers(clusterResource, nodeLocalResourceRequest, node, application, priority, reservedContainer, needToUnreserve)), (Resource)Resources.none())) {
            return new CSAssignment(assigned, NodeType.NODE_LOCAL);
        }
        ResourceRequest rackLocalResourceRequest = application.getResourceRequest(priority, node.getRackName());
        if (rackLocalResourceRequest != null) {
            if (!rackLocalResourceRequest.getRelaxLocality()) {
                return SKIP_ASSIGNMENT;
            }
            assigned = this.assignRackLocalContainers(clusterResource, rackLocalResourceRequest, node, application, priority, reservedContainer, needToUnreserve);
            if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)assigned, (Resource)Resources.none())) {
                return new CSAssignment(assigned, NodeType.RACK_LOCAL);
            }
        }
        if ((offSwitchResourceRequest = application.getResourceRequest(priority, "*")) != null) {
            if (!offSwitchResourceRequest.getRelaxLocality()) {
                return SKIP_ASSIGNMENT;
            }
            return new CSAssignment(this.assignOffSwitchContainers(clusterResource, offSwitchResourceRequest, node, application, priority, reservedContainer, needToUnreserve), NodeType.OFF_SWITCH);
        }
        return SKIP_ASSIGNMENT;
    }

    @InterfaceAudience.Private
    protected boolean findNodeToUnreserve(Resource clusterResource, FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, Resource capability) {
        NodeId idToUnreserve = application.getNodeIdToUnreserve(priority, capability);
        if (idToUnreserve == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"checked to see if could unreserve for app but nothing reserved that matches for this app");
            }
            return false;
        }
        FiCaSchedulerNode nodeToUnreserve = this.scheduler.getNode(idToUnreserve);
        if (nodeToUnreserve == null) {
            LOG.error((Object)("node to unreserve doesn't exist, nodeid: " + idToUnreserve));
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("unreserving for app: " + application.getApplicationId() + " on nodeId: " + idToUnreserve + " in order to replace reserved application and place it on node: " + node.getNodeID() + " needing: " + capability));
        }
        Resources.addTo((Resource)application.getHeadroom(), (Resource)nodeToUnreserve.getReservedContainer().getReservedResource());
        this.completedContainer(clusterResource, application, nodeToUnreserve, nodeToUnreserve.getReservedContainer(), SchedulerUtils.createAbnormalContainerStatus(nodeToUnreserve.getReservedContainer().getContainerId(), "Container reservation no longer required."), RMContainerEventType.RELEASED, null, false);
        return true;
    }

    @InterfaceAudience.Private
    protected boolean checkLimitsToReserve(Resource clusterResource, FiCaSchedulerApp application, Resource capability, boolean needToUnreserve) {
        if (needToUnreserve) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"we needed to unreserve to be able to allocate");
            }
            return false;
        }
        Resource userLimit = this.computeUserLimitAndSetHeadroom(application, clusterResource, capability, null);
        if (!this.canAssignToThisQueue(clusterResource, capability, null, application, false)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"was going to reserve but hit queue limit");
            }
            return false;
        }
        if (!this.assignToUser(clusterResource, application.getUser(), userLimit, application, false, null)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"was going to reserve but hit user limit");
            }
            return false;
        }
        return true;
    }

    private Resource assignNodeLocalContainers(Resource clusterResource, ResourceRequest nodeLocalResourceRequest, FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, RMContainer reservedContainer, boolean needToUnreserve) {
        if (this.canAssign(application, priority, node, NodeType.NODE_LOCAL, reservedContainer)) {
            return this.assignContainer(clusterResource, node, application, priority, nodeLocalResourceRequest, NodeType.NODE_LOCAL, reservedContainer, needToUnreserve);
        }
        return Resources.none();
    }

    private Resource assignRackLocalContainers(Resource clusterResource, ResourceRequest rackLocalResourceRequest, FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, RMContainer reservedContainer, boolean needToUnreserve) {
        if (this.canAssign(application, priority, node, NodeType.RACK_LOCAL, reservedContainer)) {
            return this.assignContainer(clusterResource, node, application, priority, rackLocalResourceRequest, NodeType.RACK_LOCAL, reservedContainer, needToUnreserve);
        }
        return Resources.none();
    }

    private Resource assignOffSwitchContainers(Resource clusterResource, ResourceRequest offSwitchResourceRequest, FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, RMContainer reservedContainer, boolean needToUnreserve) {
        if (this.canAssign(application, priority, node, NodeType.OFF_SWITCH, reservedContainer)) {
            return this.assignContainer(clusterResource, node, application, priority, offSwitchResourceRequest, NodeType.OFF_SWITCH, reservedContainer, needToUnreserve);
        }
        return Resources.none();
    }

    boolean canAssign(FiCaSchedulerApp application, Priority priority, FiCaSchedulerNode node, NodeType type, RMContainer reservedContainer) {
        ResourceRequest nodeLocalRequest;
        if (type == NodeType.OFF_SWITCH) {
            float localityWaitFactor;
            if (reservedContainer != null) {
                return true;
            }
            ResourceRequest offSwitchRequest = application.getResourceRequest(priority, "*");
            long missedOpportunities = application.getSchedulingOpportunities(priority);
            long requiredContainers = offSwitchRequest.getNumContainers();
            return (float)requiredContainers * (localityWaitFactor = application.getLocalityWaitFactor(priority, this.scheduler.getNumClusterNodes())) < (float)missedOpportunities;
        }
        ResourceRequest rackLocalRequest = application.getResourceRequest(priority, node.getRackName());
        if (rackLocalRequest == null || rackLocalRequest.getNumContainers() <= 0) {
            return false;
        }
        if (type == NodeType.RACK_LOCAL) {
            long missedOpportunities = application.getSchedulingOpportunities(priority);
            return (long)Math.min(this.scheduler.getNumClusterNodes(), this.getNodeLocalityDelay()) < missedOpportunities;
        }
        if (type == NodeType.NODE_LOCAL && (nodeLocalRequest = application.getResourceRequest(priority, node.getNodeName())) != null) {
            return nodeLocalRequest.getNumContainers() > 0;
        }
        return false;
    }

    private Container getContainer(RMContainer rmContainer, FiCaSchedulerApp application, FiCaSchedulerNode node, Resource capability, Priority priority) {
        return rmContainer != null ? rmContainer.getContainer() : this.createContainer(application, node, capability, priority);
    }

    Container createContainer(FiCaSchedulerApp application, FiCaSchedulerNode node, Resource capability, Priority priority) {
        NodeId nodeId = node.getRMNode().getNodeID();
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)application.getApplicationAttemptId(), (long)application.getNewContainerId());
        Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (Resource)capability, (Priority)priority, null);
        return container;
    }

    private Resource assignContainer(Resource clusterResource, FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, ResourceRequest request, NodeType type, RMContainer rmContainer, boolean needToUnreserve) {
        int availableContainers;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("assignContainers: node=" + node.getNodeName() + " application=" + application.getApplicationId() + " priority=" + priority.getPriority() + " request=" + request + " type=" + (Object)((Object)type) + " needToUnreserve= " + needToUnreserve));
        }
        if (!SchedulerUtils.checkNodeLabelExpression(node.getLabels(), request.getNodeLabelExpression())) {
            if (rmContainer != null) {
                this.unreserve(application, priority, node, rmContainer);
            }
            return Resources.none();
        }
        Resource capability = request.getCapability();
        Resource available = node.getAvailableResource();
        Resource totalResource = node.getTotalResource();
        if (!Resources.fitsIn((Resource)capability, (Resource)totalResource)) {
            LOG.warn((Object)("Node : " + node.getNodeID() + " does not have sufficient resource for request : " + request + " node total capability : " + node.getTotalResource()));
            return Resources.none();
        }
        assert (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)available, (Resource)Resources.none()));
        Container container = this.getContainer(rmContainer, application, node, capability, priority);
        if (container == null) {
            LOG.warn((Object)"Couldn't get container for allocation!");
            return Resources.none();
        }
        boolean canAllocContainer = true;
        if (this.reservationsContinueLooking) {
            canAllocContainer = this.needContainers(application, priority, capability);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("can alloc container is: " + canAllocContainer));
            }
        }
        if ((availableContainers = this.resourceCalculator.computeAvailableContainers(available, capability)) > 0) {
            if (rmContainer != null) {
                this.unreserve(application, priority, node, rmContainer);
            } else if (this.reservationsContinueLooking && (!canAllocContainer || needToUnreserve)) {
                boolean res = this.findNodeToUnreserve(clusterResource, node, application, priority, capability);
                if (!res) {
                    return Resources.none();
                }
            } else if (needToUnreserve) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"we needed to unreserve to be able to allocate, skipping");
                }
                return Resources.none();
            }
            RMContainer allocatedContainer = application.allocate(type, node, priority, request, container);
            if (allocatedContainer == null) {
                return Resources.none();
            }
            node.allocateContainer(allocatedContainer);
            LOG.info((Object)("assignedContainer application attempt=" + application.getApplicationAttemptId() + " container=" + container + " queue=" + this + " clusterResource=" + clusterResource));
            return container.getResource();
        }
        if (canAllocContainer || rmContainer != null) {
            boolean res;
            if (this.reservationsContinueLooking && !(res = this.checkLimitsToReserve(clusterResource, application, capability, needToUnreserve))) {
                return Resources.none();
            }
            this.reserve(application, priority, node, rmContainer, container);
            LOG.info((Object)("Reserved container  application=" + application.getApplicationId() + " resource=" + request.getCapability() + " queue=" + this.toString() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            return request.getCapability();
        }
        return Resources.none();
    }

    private void reserve(FiCaSchedulerApp application, Priority priority, FiCaSchedulerNode node, RMContainer rmContainer, Container container) {
        if (rmContainer == null) {
            this.getMetrics().reserveResource(application.getUser(), container.getResource());
        }
        rmContainer = application.reserve(node, priority, rmContainer, container);
        node.reserveResource(application, priority, rmContainer);
    }

    private boolean unreserve(FiCaSchedulerApp application, Priority priority, FiCaSchedulerNode node, RMContainer rmContainer) {
        if (application.unreserve(node, priority)) {
            node.unreserveResource(application);
            this.getMetrics().unreserveResource(application.getUser(), rmContainer.getContainer().getResource());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completedContainer(Resource clusterResource, FiCaSchedulerApp application, FiCaSchedulerNode node, RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event, CSQueue childQueue, boolean sortQueues) {
        if (application != null) {
            boolean removed = false;
            LeafQueue leafQueue = this;
            synchronized (leafQueue) {
                Container container = rmContainer.getContainer();
                if (rmContainer.getState() == RMContainerState.RESERVED) {
                    removed = this.unreserve(application, rmContainer.getReservedPriority(), node, rmContainer);
                } else {
                    removed = application.containerCompleted(rmContainer, containerStatus, event);
                    node.releaseContainer(container);
                }
                if (removed) {
                    this.releaseResource(clusterResource, application, container.getResource(), node.getLabels());
                    LOG.info((Object)("completedContainer container=" + container + " queue=" + this + " cluster=" + clusterResource));
                }
            }
            if (removed) {
                this.getParent().completedContainer(clusterResource, application, node, rmContainer, null, event, this, sortQueues);
            }
        }
    }

    synchronized void allocateResource(Resource clusterResource, SchedulerApplicationAttempt application, Resource resource, Set<String> nodeLabels) {
        super.allocateResource(clusterResource, resource, nodeLabels);
        String userName = application.getUser();
        User user = this.getUser(userName);
        user.assignContainer(resource, nodeLabels);
        Resources.subtractFrom((Resource)application.getHeadroom(), (Resource)resource);
        this.metrics.setAvailableResourcesToUser(userName, application.getHeadroom());
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)(this.getQueueName() + " user=" + userName + " used=" + this.queueUsage.getUsed() + " numContainers=" + this.numContainers + " headroom = " + application.getHeadroom() + " user-resources=" + user.getUsed()));
        }
    }

    synchronized void releaseResource(Resource clusterResource, FiCaSchedulerApp application, Resource resource, Set<String> nodeLabels) {
        super.releaseResource(clusterResource, resource, nodeLabels);
        String userName = application.getUser();
        User user = this.getUser(userName);
        user.releaseContainer(resource, nodeLabels);
        this.metrics.setAvailableResourcesToUser(userName, application.getHeadroom());
        LOG.info((Object)(this.getQueueName() + " used=" + this.queueUsage.getUsed() + " numContainers=" + this.numContainers + " user=" + userName + " user-resources=" + user.getUsed()));
    }

    private void updateAbsoluteCapacityResource(Resource clusterResource) {
        this.absoluteCapacityResource = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (double)this.queueCapacities.getAbsoluteCapacity(), (Resource)this.minimumAllocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateClusterResource(Resource clusterResource) {
        this.lastClusterResource = clusterResource;
        this.updateAbsoluteCapacityResource(clusterResource);
        this.updateHeadroomInfo(clusterResource, this.queueCapacities.getAbsoluteMaximumCapacity());
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.getParent(), clusterResource, this.minimumAllocation);
        this.activateApplications();
        Iterator<FiCaSchedulerApp> i$ = this.activeApplications.iterator();
        while (i$.hasNext()) {
            FiCaSchedulerApp application;
            FiCaSchedulerApp fiCaSchedulerApp = application = i$.next();
            synchronized (fiCaSchedulerApp) {
                this.computeUserLimitAndSetHeadroom(application, clusterResource, Resources.none(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt attempt, RMContainer rmContainer) {
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, attempt, rmContainer.getContainer().getResource(), node.getLabels());
        }
        this.getParent().recoverContainer(clusterResource, attempt, rmContainer);
    }

    public Set<FiCaSchedulerApp> getApplications() {
        return this.activeApplications;
    }

    public synchronized Resource getTotalResourcePending() {
        Resource ret = BuilderUtils.newResource((int)0, (int)0);
        for (FiCaSchedulerApp f : this.activeApplications) {
            Resources.addTo((Resource)ret, (Resource)f.getTotalPendingRequests());
        }
        return ret;
    }

    @Override
    public synchronized void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        for (FiCaSchedulerApp pendingApp : this.pendingApplications) {
            apps.add(pendingApp.getApplicationAttemptId());
        }
        for (FiCaSchedulerApp app : this.activeApplications) {
            apps.add(app.getApplicationAttemptId());
        }
    }

    @Override
    public void attachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, application, rmContainer.getContainer().getResource(), node.getLabels());
            LOG.info((Object)("movedContainer container=" + rmContainer.getContainer() + " resource=" + rmContainer.getContainer().getResource() + " queueMoveIn=" + this + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            this.getParent().attachContainer(clusterResource, application, rmContainer);
        }
    }

    @Override
    public void detachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            this.releaseResource(clusterResource, application, rmContainer.getContainer().getResource(), node.getLabels());
            LOG.info((Object)("movedContainer container=" + rmContainer.getContainer() + " resource=" + rmContainer.getContainer().getResource() + " queueMoveOut=" + this + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            this.getParent().detachContainer(clusterResource, application, rmContainer);
        }
    }

    public void setCapacity(float capacity) {
        this.queueCapacities.setCapacity(capacity);
    }

    public void setAbsoluteCapacity(float absoluteCapacity) {
        this.queueCapacities.setAbsoluteCapacity(absoluteCapacity);
    }

    public void setMaxApplications(int maxApplications) {
        this.maxApplications = maxApplications;
    }

    static class QueueHeadroomInfo {
        private Resource queueMaxCap;
        private Resource clusterResource;

        QueueHeadroomInfo() {
        }

        public void setQueueMaxCap(Resource queueMaxCap) {
            this.queueMaxCap = queueMaxCap;
        }

        public Resource getQueueMaxCap() {
            return this.queueMaxCap;
        }

        public void setClusterResource(Resource clusterResource) {
            this.clusterResource = clusterResource;
        }

        public Resource getClusterResource() {
            return this.clusterResource;
        }
    }

    @VisibleForTesting
    public static class User {
        ResourceUsage userResourceUsage = new ResourceUsage();
        int pendingApplications = 0;
        int activeApplications = 0;

        public ResourceUsage getResourceUsage() {
            return this.userResourceUsage;
        }

        public Resource getUsed() {
            return this.userResourceUsage.getUsed();
        }

        public Resource getUsed(String label) {
            return this.userResourceUsage.getUsed(label);
        }

        public int getPendingApplications() {
            return this.pendingApplications;
        }

        public int getActiveApplications() {
            return this.activeApplications;
        }

        public Resource getConsumedAMResources() {
            return this.userResourceUsage.getAMUsed();
        }

        public int getTotalApplications() {
            return this.getPendingApplications() + this.getActiveApplications();
        }

        public synchronized void submitApplication() {
            ++this.pendingApplications;
        }

        public synchronized void activateApplication() {
            --this.pendingApplications;
            ++this.activeApplications;
        }

        public synchronized void finishApplication(boolean wasActive) {
            if (wasActive) {
                --this.activeApplications;
            } else {
                --this.pendingApplications;
            }
        }

        public void assignContainer(Resource resource, Set<String> nodeLabels) {
            if (nodeLabels == null || nodeLabels.isEmpty()) {
                this.userResourceUsage.incUsed(resource);
            } else {
                for (String label : nodeLabels) {
                    this.userResourceUsage.incUsed(label, resource);
                }
            }
        }

        public void releaseContainer(Resource resource, Set<String> nodeLabels) {
            if (nodeLabels == null || nodeLabels.isEmpty()) {
                this.userResourceUsage.decUsed(resource);
            } else {
                for (String label : nodeLabels) {
                    this.userResourceUsage.decUsed(label, resource);
                }
            }
        }
    }
}

