/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.TestApplicationACLs;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class QueueACLsTestBase {
    protected static final String COMMON_USER = "common_user";
    protected static final String QUEUE_A_USER = "queueA_user";
    protected static final String QUEUE_B_USER = "queueB_user";
    protected static final String ROOT_ADMIN = "root_admin";
    protected static final String QUEUE_A_ADMIN = "queueA_admin";
    protected static final String QUEUE_B_ADMIN = "queueB_admin";
    protected static final String QUEUEA = "queueA";
    protected static final String QUEUEB = "queueB";
    private static final Log LOG = LogFactory.getLog(TestApplicationACLs.class);
    MockRM resourceManager;
    Configuration conf;
    YarnRPC rpc;
    InetSocketAddress rmAddress;

    @Before
    public void setup() throws InterruptedException, IOException {
        this.conf = this.createConfiguration();
        this.rpc = YarnRPC.create((Configuration)this.conf);
        this.rmAddress = this.conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
        AccessControlList adminACL = new AccessControlList("");
        this.conf.set("yarn.admin.acl", adminACL.getAclString());
        this.resourceManager = new MockRM(this.conf){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService(this.getRMContext(), (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }

            protected void doSecureLogin() throws IOException {
            }
        };
        new Thread(){

            @Override
            public void run() {
                QueueACLsTestBase.this.resourceManager.start();
            }
        }.start();
        int waitCount = 0;
        while (this.resourceManager.getServiceState() == Service.STATE.INITED && waitCount++ < 60) {
            LOG.info((Object)"Waiting for RM to start...");
            Thread.sleep(1500L);
        }
        if (this.resourceManager.getServiceState() != Service.STATE.STARTED) {
            throw new IOException("ResourceManager failed to start. Final state is " + this.resourceManager.getServiceState());
        }
    }

    @After
    public void tearDown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
        }
    }

    @Test
    public void testApplicationACLs() throws Exception {
        this.verifyKillAppSuccess(QUEUE_A_USER, QUEUE_A_USER, QUEUEA, true);
        this.verifyKillAppSuccess(QUEUE_A_USER, QUEUE_A_ADMIN, QUEUEA, true);
        this.verifyKillAppSuccess(QUEUE_A_USER, COMMON_USER, QUEUEA, true);
        this.verifyKillAppSuccess(QUEUE_A_USER, ROOT_ADMIN, QUEUEA, true);
        this.verifyKillAppFailure(QUEUE_A_USER, QUEUE_B_USER, QUEUEA, true);
        this.verifyKillAppFailure(QUEUE_A_USER, QUEUE_B_ADMIN, QUEUEA, true);
        this.verifyKillAppSuccess(QUEUE_B_USER, QUEUE_B_USER, QUEUEB, true);
        this.verifyKillAppSuccess(QUEUE_B_USER, QUEUE_B_ADMIN, QUEUEB, true);
        this.verifyKillAppSuccess(QUEUE_B_USER, COMMON_USER, QUEUEB, true);
        this.verifyKillAppSuccess(QUEUE_B_USER, ROOT_ADMIN, QUEUEB, true);
        this.verifyKillAppFailure(QUEUE_B_USER, QUEUE_A_USER, QUEUEB, true);
        this.verifyKillAppFailure(QUEUE_B_USER, QUEUE_A_ADMIN, QUEUEB, true);
        this.verifyKillAppSuccess(ROOT_ADMIN, ROOT_ADMIN, QUEUEA, false);
        this.verifyKillAppSuccess(ROOT_ADMIN, ROOT_ADMIN, QUEUEB, false);
        this.verifyGetClientAMToken(QUEUE_A_USER, ROOT_ADMIN, QUEUEA, true);
    }

    private void verifyGetClientAMToken(String submitter, String queueAdmin, String queueName, boolean setupACLs) throws Exception {
        ApplicationId applicationId = this.submitAppAndGetAppId(submitter, queueName, setupACLs);
        GetApplicationReportRequest appReportRequest = GetApplicationReportRequest.newInstance((ApplicationId)applicationId);
        ApplicationClientProtocol submitterClient = this.getRMClientForUser(submitter);
        ApplicationClientProtocol adMinUserClient = this.getRMClientForUser(queueAdmin);
        GetApplicationReportResponse submitterGetReport = submitterClient.getApplicationReport(appReportRequest);
        GetApplicationReportResponse adMinUserGetReport = adMinUserClient.getApplicationReport(appReportRequest);
        Assert.assertEquals((Object)submitterGetReport.getApplicationReport().getClientToAMToken(), (Object)adMinUserGetReport.getApplicationReport().getClientToAMToken());
    }

    private void verifyKillAppFailure(String submitter, String killer, String queueName, boolean setupACLs) throws Exception {
        ApplicationId applicationId = this.submitAppAndGetAppId(submitter, queueName, setupACLs);
        KillApplicationRequest finishAppRequest = KillApplicationRequest.newInstance((ApplicationId)applicationId);
        ApplicationClientProtocol killerClient = this.getRMClientForUser(killer);
        try {
            killerClient.forceKillApplication(finishAppRequest);
            Assert.fail((String)"App killing by the enemy should fail!!");
        }
        catch (YarnException e) {
            LOG.info((Object)"Got exception while killing app as the enemy", (Throwable)e);
            Assert.assertTrue((boolean)e.getMessage().contains("User " + killer + " cannot perform operation MODIFY_APP on " + applicationId));
        }
        this.getRMClientForUser(submitter).forceKillApplication(finishAppRequest);
    }

    private void verifyKillAppSuccess(String submitter, String killer, String queueName, boolean setupACLs) throws Exception {
        ApplicationId applicationId = this.submitAppAndGetAppId(submitter, queueName, setupACLs);
        KillApplicationRequest finishAppRequest = KillApplicationRequest.newInstance((ApplicationId)applicationId);
        ApplicationClientProtocol ownerClient = this.getRMClientForUser(killer);
        ownerClient.forceKillApplication(finishAppRequest);
        this.resourceManager.waitForState(applicationId, RMAppState.KILLED);
    }

    private ApplicationId submitAppAndGetAppId(String submitter, String queueName, boolean setupACLs) throws Exception {
        GetNewApplicationRequest newAppRequest = GetNewApplicationRequest.newInstance();
        ApplicationClientProtocol submitterClient = this.getRMClientForUser(submitter);
        ApplicationId applicationId = submitterClient.getNewApplication(newAppRequest).getApplicationId();
        Resource resource = BuilderUtils.newResource((int)1024, (int)1);
        Map<ApplicationAccessType, String> acls = this.createACLs(submitter, setupACLs);
        ContainerLaunchContext amContainerSpec = ContainerLaunchContext.newInstance(null, null, null, null, null, acls);
        ApplicationSubmissionContext appSubmissionContext = ApplicationSubmissionContext.newInstance((ApplicationId)applicationId, (String)"applicationName", (String)queueName, null, (ContainerLaunchContext)amContainerSpec, (boolean)false, (boolean)true, (int)1, (Resource)resource, (String)"applicationType");
        appSubmissionContext.setApplicationId(applicationId);
        appSubmissionContext.setQueue(queueName);
        SubmitApplicationRequest submitRequest = SubmitApplicationRequest.newInstance((ApplicationSubmissionContext)appSubmissionContext);
        submitterClient.submitApplication(submitRequest);
        this.resourceManager.waitForState(applicationId, RMAppState.ACCEPTED);
        return applicationId;
    }

    private Map<ApplicationAccessType, String> createACLs(String submitter, boolean setupACLs) {
        AccessControlList viewACL = new AccessControlList("");
        AccessControlList modifyACL = new AccessControlList("");
        if (setupACLs) {
            viewACL.addUser(submitter);
            viewACL.addUser(COMMON_USER);
            modifyACL.addUser(submitter);
            modifyACL.addUser(COMMON_USER);
        }
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>();
        acls.put(ApplicationAccessType.VIEW_APP, viewACL.getAclString());
        acls.put(ApplicationAccessType.MODIFY_APP, modifyACL.getAclString());
        return acls;
    }

    private ApplicationClientProtocol getRMClientForUser(String user) throws IOException, InterruptedException {
        UserGroupInformation userUGI = UserGroupInformation.createRemoteUser((String)user);
        ApplicationClientProtocol userClient = (ApplicationClientProtocol)userUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationClientProtocol>(){

            @Override
            public ApplicationClientProtocol run() throws Exception {
                return (ApplicationClientProtocol)QueueACLsTestBase.this.rpc.getProxy(ApplicationClientProtocol.class, QueueACLsTestBase.this.rmAddress, QueueACLsTestBase.this.conf);
            }
        });
        return userClient;
    }

    protected abstract Configuration createConfiguration() throws IOException;
}

