/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationDefinitionPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationRequestsPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ReservationSystemTestUtil {
    private static Random rand = new Random();
    public static final String reservationQ = "dedicated";

    public static ReservationId getNewReservationId() {
        return ReservationId.newInstance((long)rand.nextLong(), (long)rand.nextLong());
    }

    public CapacityScheduler mockCapacityScheduler(int numContainers) throws IOException {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        ReservationSystemTestUtil.setupQueueConfiguration(conf);
        CapacityScheduler cs = (CapacityScheduler)Mockito.spy((Object)new CapacityScheduler());
        cs.setConf((Configuration)new YarnConfiguration());
        RMContext mockRmContext = (RMContext)Mockito.spy((Object)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null));
        RMNodeLabelsManager nlm = (RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class);
        Mockito.when((Object)nlm.getQueueResource((String)Matchers.any(String.class), (Set)Matchers.any(Set.class), (Resource)Matchers.any(Resource.class))).thenAnswer((Answer)new Answer<Resource>(){

            public Resource answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return (Resource)args[2];
            }
        });
        Mockito.when((Object)nlm.getResourceByLabel((String)Matchers.any(String.class), (Resource)Matchers.any(Resource.class))).thenAnswer((Answer)new Answer<Resource>(){

            public Resource answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return (Resource)args[1];
            }
        });
        mockRmContext.setNodeLabelManager(nlm);
        cs.setRMContext(mockRmContext);
        try {
            cs.serviceInit((Configuration)conf);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Mockito.when((Object)mockRmContext.getScheduler()).thenReturn((Object)cs);
        Resource r = Resource.newInstance((int)(numContainers * 1024), (int)numContainers);
        ((CapacityScheduler)Mockito.doReturn((Object)r).when((Object)cs)).getClusterResource();
        return cs;
    }

    public static void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        String defQ = "root.default";
        conf.setCapacity("root.default", 10.0f);
        conf.setQueues("root", new String[]{"default", "a", reservationQ});
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        String dedicated = "root.dedicated";
        conf.setCapacity("root.dedicated", 80.0f);
        conf.setReservable("root.dedicated", true);
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setCapacity("root.a.a2", 70.0f);
    }

    public String getFullReservationQueueName() {
        return "root.dedicated";
    }

    public String getreservationQueueName() {
        return reservationQ;
    }

    public void updateQueueConfiguration(CapacitySchedulerConfiguration conf, String newQ) {
        String prefix = "root.";
        String defQ = "root.default";
        conf.setCapacity("root.default", 5.0f);
        conf.setQueues("root", new String[]{"default", "a", reservationQ, newQ});
        String A = "root.a";
        conf.setCapacity("root.a", 5.0f);
        String dedicated = "root.dedicated";
        conf.setCapacity("root.dedicated", 80.0f);
        conf.setReservable("root.dedicated", true);
        conf.setCapacity("root." + newQ, 10.0f);
        conf.setReservable("root." + newQ, true);
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setCapacity("root.a.a2", 70.0f);
    }

    public static ReservationDefinition generateRandomRR(Random rand, long i) {
        rand.setSeed(i);
        long now = System.currentTimeMillis();
        long arrival = rand.nextInt(43200000);
        long deadline = arrival + (long)rand.nextInt(86400000);
        ReservationDefinitionPBImpl rr = new ReservationDefinitionPBImpl();
        rr.setArrival(now + arrival);
        rr.setDeadline(now + deadline);
        int gang = 1 + rand.nextInt(9);
        int par = (rand.nextInt(1000) + 1) * gang;
        long dur = rand.nextInt(0x6DDD00);
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)par, (int)gang, (long)dur);
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setReservationResources(Collections.singletonList(r));
        rand.nextInt(3);
        ReservationRequestInterpreter[] type = ReservationRequestInterpreter.values();
        reqs.setInterpreter(type[rand.nextInt(type.length)]);
        rr.setReservationRequests((ReservationRequests)reqs);
        return rr;
    }

    public static ReservationDefinition generateBigRR(Random rand, long i) {
        rand.setSeed(i);
        long now = System.currentTimeMillis();
        long arrival = rand.nextInt(0x6DDD00);
        long deadline = rand.nextInt(86400000);
        ReservationDefinitionPBImpl rr = new ReservationDefinitionPBImpl();
        rr.setArrival(now + arrival);
        rr.setDeadline(now + deadline);
        int gang = 1;
        int par = 100000;
        long dur = rand.nextInt(60000);
        ReservationRequest r = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)par, (int)gang, (long)dur);
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setReservationResources(Collections.singletonList(r));
        rand.nextInt(3);
        ReservationRequestInterpreter[] type = ReservationRequestInterpreter.values();
        reqs.setInterpreter(type[rand.nextInt(type.length)]);
        rr.setReservationRequests((ReservationRequests)reqs);
        return rr;
    }

    public static Map<ReservationInterval, ReservationRequest> generateAllocation(long startTime, long step, int[] alloc) {
        TreeMap<ReservationInterval, ReservationRequest> req = new TreeMap<ReservationInterval, ReservationRequest>();
        for (int i = 0; i < alloc.length; ++i) {
            req.put(new ReservationInterval(startTime + (long)i * step, startTime + (long)(i + 1) * step), ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)alloc[i]));
        }
        return req;
    }
}

