/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityOverTimePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.GreedyReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestCapacityReservationSystem {
    @Test
    public void testInitialize() {
        ReservationSystemTestUtil testUtil = new ReservationSystemTestUtil();
        CapacityScheduler capScheduler = null;
        try {
            capScheduler = testUtil.mockCapacityScheduler(10);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        CapacityReservationSystem reservationSystem = new CapacityReservationSystem();
        reservationSystem.setRMContext(capScheduler.getRMContext());
        try {
            reservationSystem.reinitialize(capScheduler.getConf(), capScheduler.getRMContext());
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        String planQName = testUtil.getreservationQueueName();
        Plan plan = reservationSystem.getPlan(planQName);
        Assert.assertNotNull((Object)plan);
        Assert.assertTrue((boolean)(plan instanceof InMemoryPlan));
        Assert.assertEquals((Object)planQName, (Object)plan.getQueueName());
        Assert.assertEquals((long)8192L, (long)plan.getTotalCapacity().getMemory());
        Assert.assertTrue((boolean)(plan.getReservationAgent() instanceof GreedyReservationAgent));
        Assert.assertTrue((boolean)(plan.getSharingPolicy() instanceof CapacityOverTimePolicy));
    }

    @Test
    public void testReinitialize() {
        ReservationSystemTestUtil testUtil = new ReservationSystemTestUtil();
        CapacityScheduler capScheduler = null;
        try {
            capScheduler = testUtil.mockCapacityScheduler(10);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        CapacityReservationSystem reservationSystem = new CapacityReservationSystem();
        CapacitySchedulerConfiguration conf = capScheduler.getConfiguration();
        RMContext mockContext = capScheduler.getRMContext();
        reservationSystem.setRMContext(mockContext);
        try {
            reservationSystem.reinitialize((Configuration)capScheduler.getConfiguration(), mockContext);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        String planQName = testUtil.getreservationQueueName();
        Plan plan = reservationSystem.getPlan(planQName);
        Assert.assertNotNull((Object)plan);
        Assert.assertTrue((boolean)(plan instanceof InMemoryPlan));
        Assert.assertEquals((Object)planQName, (Object)plan.getQueueName());
        Assert.assertEquals((long)8192L, (long)plan.getTotalCapacity().getMemory());
        Assert.assertTrue((boolean)(plan.getReservationAgent() instanceof GreedyReservationAgent));
        Assert.assertTrue((boolean)(plan.getSharingPolicy() instanceof CapacityOverTimePolicy));
        String newQ = "reservation";
        Assert.assertNull((Object)reservationSystem.getPlan(newQ));
        testUtil.updateQueueConfiguration(conf, newQ);
        try {
            capScheduler.reinitialize((Configuration)conf, mockContext);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            reservationSystem.reinitialize((Configuration)conf, mockContext);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        Plan newPlan = reservationSystem.getPlan(newQ);
        Assert.assertNotNull((Object)newPlan);
        Assert.assertTrue((boolean)(newPlan instanceof InMemoryPlan));
        Assert.assertEquals((Object)newQ, (Object)newPlan.getQueueName());
        Assert.assertEquals((long)1024L, (long)newPlan.getTotalCapacity().getMemory());
        Assert.assertTrue((boolean)(newPlan.getReservationAgent() instanceof GreedyReservationAgent));
        Assert.assertTrue((boolean)(newPlan.getSharingPolicy() instanceof CapacityOverTimePolicy));
    }
}

