/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.NoOverCommitPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Planner;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SimpleCapacityReplanner;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestSimpleCapacityReplanner {
    @Test
    public void testReplanningPlanCapacityLoss() throws PlanningException {
        Resource clusterCapacity = Resource.newInstance((int)102400, (int)10);
        Resource minAlloc = Resource.newInstance((int)1024, (int)1);
        Resource maxAlloc = Resource.newInstance((int)8192, (int)8);
        DefaultResourceCalculator res = new DefaultResourceCalculator();
        long step = 1L;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ReservationAgent agent = (ReservationAgent)Mockito.mock(ReservationAgent.class);
        NoOverCommitPolicy policy = new NoOverCommitPolicy();
        policy.init("root.dedicated", null);
        QueueMetrics queueMetrics = (QueueMetrics)Mockito.mock(QueueMetrics.class);
        Mockito.when((Object)clock.getTime()).thenReturn((Object)0L);
        SimpleCapacityReplanner enf = new SimpleCapacityReplanner(clock);
        CapacitySchedulerConfiguration conf = (CapacitySchedulerConfiguration)Mockito.mock(CapacitySchedulerConfiguration.class);
        Mockito.when((Object)conf.getEnforcementWindow((String)Matchers.any(String.class))).thenReturn((Object)6L);
        conf.setLong("yarn.scheduler.capacity.blah.reservation-enforcement-window", 6L);
        enf.init("blah", (Configuration)conf);
        InMemoryPlan plan = new InMemoryPlan(queueMetrics, (SharingPolicy)policy, agent, clusterCapacity, step, (ResourceCalculator)res, minAlloc, maxAlloc, "dedicated", (Planner)enf, true, clock);
        long ts = System.currentTimeMillis();
        ReservationId r1 = ReservationId.newInstance((long)ts, (long)1L);
        int[] f5 = new int[]{20, 20, 20, 20, 20};
        Assert.assertTrue((String)plan.toString(), (boolean)plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(r1, null, "u3", "dedicated", 0L, (long)(0 + f5.length), this.generateAllocation(0, f5), (ResourceCalculator)res, minAlloc)));
        Mockito.when((Object)clock.getTime()).thenReturn((Object)1L);
        ReservationId r2 = ReservationId.newInstance((long)ts, (long)2L);
        Assert.assertTrue((String)plan.toString(), (boolean)plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(r2, null, "u4", "dedicated", 0L, (long)(0 + f5.length), this.generateAllocation(0, f5), (ResourceCalculator)res, minAlloc)));
        Mockito.when((Object)clock.getTime()).thenReturn((Object)2L);
        ReservationId r3 = ReservationId.newInstance((long)ts, (long)3L);
        Assert.assertTrue((String)plan.toString(), (boolean)plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(r3, null, "u5", "dedicated", 0L, (long)(0 + f5.length), this.generateAllocation(0, f5), (ResourceCalculator)res, minAlloc)));
        Mockito.when((Object)clock.getTime()).thenReturn((Object)3L);
        ReservationId r4 = ReservationId.newInstance((long)ts, (long)4L);
        Assert.assertTrue((String)plan.toString(), (boolean)plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(r4, null, "u6", "dedicated", 0L, (long)(0 + f5.length), this.generateAllocation(0, f5), (ResourceCalculator)res, minAlloc)));
        Mockito.when((Object)clock.getTime()).thenReturn((Object)4L);
        ReservationId r5 = ReservationId.newInstance((long)ts, (long)5L);
        Assert.assertTrue((String)plan.toString(), (boolean)plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(r5, null, "u7", "dedicated", 0L, (long)(0 + f5.length), this.generateAllocation(0, f5), (ResourceCalculator)res, minAlloc)));
        int[] f6 = new int[]{50, 50, 50, 50, 50};
        ReservationId r6 = ReservationId.newInstance((long)ts, (long)6L);
        Assert.assertTrue((String)plan.toString(), (boolean)plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(r6, null, "u3", "dedicated", 10L, (long)(10 + f6.length), this.generateAllocation(10, f6), (ResourceCalculator)res, minAlloc)));
        Mockito.when((Object)clock.getTime()).thenReturn((Object)6L);
        ReservationId r7 = ReservationId.newInstance((long)ts, (long)7L);
        Assert.assertTrue((String)plan.toString(), (boolean)plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(r7, null, "u4", "dedicated", 10L, (long)(10 + f6.length), this.generateAllocation(10, f6), (ResourceCalculator)res, minAlloc)));
        plan.setTotalCapacity(Resource.newInstance((int)71680, (int)70));
        Mockito.when((Object)clock.getTime()).thenReturn((Object)0L);
        enf.plan((Plan)plan, null);
        Assert.assertNotNull((Object)plan.getReservationById(r1));
        Assert.assertNotNull((Object)plan.getReservationById(r2));
        Assert.assertNotNull((Object)plan.getReservationById(r3));
        Assert.assertNotNull((Object)plan.getReservationById(r6));
        Assert.assertNotNull((Object)plan.getReservationById(r7));
        Assert.assertNull((Object)plan.getReservationById(r4));
        Assert.assertNull((Object)plan.getReservationById(r5));
        for (int i = 0; i < 20; ++i) {
            int tot = 0;
            for (ReservationAllocation r : plan.getReservationsAtTime((long)i)) {
                tot = r.getResourcesAtTime((long)i).getMemory();
            }
            Assert.assertTrue((tot <= 71680 ? 1 : 0) != 0);
        }
    }

    private Map<ReservationInterval, ReservationRequest> generateAllocation(int startTime, int[] alloc) {
        TreeMap<ReservationInterval, ReservationRequest> req = new TreeMap<ReservationInterval, ReservationRequest>();
        for (int i = 0; i < alloc.length; ++i) {
            req.put(new ReservationInterval((long)(startTime + i), (long)(startTime + i + 1)), ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)alloc[i]));
        }
        return req;
    }
}

