/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.ParameterizedSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAbstractYarnScheduler
extends ParameterizedSchedulerTestBase {
    public TestAbstractYarnScheduler(ParameterizedSchedulerTestBase.SchedulerType type) {
        super(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testResourceRequestRestoreWhenRMContainerIsAtAllocated() throws Exception {
        this.configureScheduler();
        YarnConfiguration conf = this.getConf();
        MockRM rm1 = new MockRM((Configuration)conf);
        try {
            rm1.start();
            RMApp app1 = rm1.submitApp(200, "name", "user", new HashMap<ApplicationAccessType, String>(), false, "default", -1, null, "Test", false, true);
            MockNM nm1 = new MockNM("127.0.0.1:1234", 10240, rm1.getResourceTrackerService());
            nm1.registerNode();
            MockNM nm2 = new MockNM("127.0.0.1:2351", 10240, rm1.getResourceTrackerService());
            nm2.registerNode();
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
            int NUM_CONTAINERS = 1;
            am1.allocate("127.0.0.1", 1024, NUM_CONTAINERS, new ArrayList<ContainerId>());
            nm1.nodeHeartbeat(true);
            List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            while (containers.size() != NUM_CONTAINERS) {
                nm1.nodeHeartbeat(true);
                containers.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
                Thread.sleep(200L);
            }
            nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
            ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
            rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
            am1.allocate("127.0.0.1", 1024, NUM_CONTAINERS, new ArrayList<ContainerId>());
            nm2.nodeHeartbeat(true);
            ContainerId containerId3 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
            rm1.waitForContainerAllocated(nm2, containerId3);
            rm1.waitForState(nm2, containerId3, RMContainerState.ALLOCATED);
            nm2.registerNode();
            rm1.waitForState(nm2, containerId3, RMContainerState.KILLED);
            containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            while (containers.size() != NUM_CONTAINERS) {
                nm2.nodeHeartbeat(true);
                containers.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
                Thread.sleep(200L);
            }
            nm2.nodeHeartbeat(am1.getApplicationAttemptId(), 4L, ContainerState.RUNNING);
            ContainerId containerId4 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)4L);
            rm1.waitForState(nm2, containerId4, RMContainerState.RUNNING);
        }
        finally {
            rm1.stop();
        }
    }

    private ResourceTrackerService getPrivateResourceTrackerService(Dispatcher privateDispatcher, ResourceManager rm, SleepHandler sleepHandler) {
        YarnConfiguration conf = this.getConf();
        RMContextImpl privateContext = new RMContextImpl(privateDispatcher, null, null, null, null, null, null, null, null, null);
        privateContext.setNodeLabelManager((RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class));
        privateDispatcher.register(SchedulerEventType.class, (EventHandler)sleepHandler);
        privateDispatcher.register(SchedulerEventType.class, (EventHandler)rm.getResourceScheduler());
        privateDispatcher.register(RMNodeEventType.class, (EventHandler)new ResourceManager.NodeEventDispatcher((RMContext)privateContext));
        ((Service)privateDispatcher).init((Configuration)conf);
        ((Service)privateDispatcher).start();
        NMLivelinessMonitor nmLivelinessMonitor = new NMLivelinessMonitor(privateDispatcher);
        nmLivelinessMonitor.init((Configuration)conf);
        nmLivelinessMonitor.start();
        NodesListManager nodesListManager = new NodesListManager((RMContext)privateContext);
        nodesListManager.init((Configuration)conf);
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager((Configuration)conf);
        containerTokenSecretManager.start();
        NMTokenSecretManagerInRM nmTokenSecretManager = new NMTokenSecretManagerInRM((Configuration)conf);
        nmTokenSecretManager.start();
        ResourceTrackerService privateResourceTrackerService = new ResourceTrackerService((RMContext)privateContext, nodesListManager, nmLivelinessMonitor, containerTokenSecretManager, nmTokenSecretManager);
        privateResourceTrackerService.init((Configuration)conf);
        privateResourceTrackerService.start();
        rm.getResourceScheduler().setRMContext((RMContext)privateContext);
        return privateResourceTrackerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNodemanagerReconnect() throws Exception {
        this.configureScheduler();
        YarnConfiguration conf = this.getConf();
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            conf.setBoolean("yarn.dispatcher.exit-on-error", false);
            DrainDispatcher privateDispatcher = new DrainDispatcher();
            SleepHandler sleepHandler = new SleepHandler();
            ResourceTrackerService privateResourceTrackerService = this.getPrivateResourceTrackerService((Dispatcher)privateDispatcher, rm, sleepHandler);
            String hostname1 = "localhost1";
            Resource capability = BuilderUtils.newResource((int)4096, (int)4);
            RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
            RegisterNodeManagerRequest request1 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
            NodeId nodeId1 = NodeId.newInstance((String)hostname1, (int)0);
            request1.setNodeId(nodeId1);
            request1.setHttpPort(0);
            request1.setResource(capability);
            privateResourceTrackerService.registerNodeManager(request1);
            privateDispatcher.await();
            Resource clusterResource = rm.getResourceScheduler().getClusterResource();
            Assert.assertEquals((String)"Initial cluster resources don't match", (Object)capability, (Object)clusterResource);
            Resource newCapability = BuilderUtils.newResource((int)1024, (int)1);
            RegisterNodeManagerRequest request2 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
            request2.setNodeId(nodeId1);
            request2.setHttpPort(0);
            request2.setResource(newCapability);
            sleepHandler.sleepFlag = true;
            privateResourceTrackerService.registerNodeManager(request2);
            privateDispatcher.await();
            Assert.assertEquals((String)"Cluster resources don't match", (Object)newCapability, (Object)rm.getResourceScheduler().getClusterResource());
            privateResourceTrackerService.stop();
        }
        finally {
            rm.stop();
        }
    }

    private class SleepHandler
    implements EventHandler<SchedulerEvent> {
        boolean sleepFlag = false;
        int sleepTime = 20;

        private SleepHandler() {
        }

        public void handle(SchedulerEvent event) {
            try {
                if (this.sleepFlag) {
                    Thread.sleep(this.sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

