/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFairSchedulerFairShare
extends FairSchedulerTestBase {
    private static final String ALLOC_FILE = new File(TEST_DIR, TestFairSchedulerFairShare.class.getName() + ".xml").getAbsolutePath();

    @Before
    public void setup() throws IOException {
        this.conf = this.createConfiguration();
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
    }

    @After
    public void teardown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
        this.conf = null;
    }

    private void createClusterWithQueuesAndOneNode(int mem, String policy) throws IOException {
        this.createClusterWithQueuesAndOneNode(mem, 0, policy);
    }

    private void createClusterWithQueuesAndOneNode(int mem, int vCores, String policy) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\" >");
        out.println("   <queue name=\"parentA\" >");
        out.println("       <weight>8</weight>");
        out.println("       <queue name=\"childA1\" />");
        out.println("       <queue name=\"childA2\" />");
        out.println("       <queue name=\"childA3\" />");
        out.println("       <queue name=\"childA4\" />");
        out.println("   </queue>");
        out.println("   <queue name=\"parentB\" >");
        out.println("       <weight>1</weight>");
        out.println("       <queue name=\"childB1\" />");
        out.println("       <queue name=\"childB2\" />");
        out.println("   </queue>");
        out.println("</queue>");
        out.println("<defaultQueueSchedulingPolicy>" + policy + "</defaultQueueSchedulingPolicy>");
        out.println("</allocations>");
        out.close();
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)mem, (int)vCores), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
    }

    @Test
    public void testFairShareNoAppsRunning() throws IOException {
        int nodeCapacity = 16384;
        this.createClusterWithQueuesAndOneNode(nodeCapacity, "fair");
        this.scheduler.update();
        Collection leafQueues = this.scheduler.getQueueManager().getLeafQueues();
        for (FSLeafQueue leaf : leafQueues) {
            if (leaf.getName().startsWith("root.parentA")) {
                Assert.assertEquals((double)0.0, (double)((double)leaf.getFairShare().getMemory() / (double)nodeCapacity), (double)0.0);
                continue;
            }
            if (!leaf.getName().startsWith("root.parentB")) continue;
            Assert.assertEquals((double)0.0, (double)((double)leaf.getFairShare().getMemory() / (double)nodeCapacity), (double)0.0);
        }
        this.verifySteadyFairShareMemory(leafQueues, nodeCapacity);
    }

    @Test
    public void testFairShareOneAppRunning() throws IOException {
        int nodeCapacity = 16384;
        this.createClusterWithQueuesAndOneNode(nodeCapacity, "fair");
        this.createSchedulingRequest(2048, "root.parentA.childA1", "user1");
        this.scheduler.update();
        Assert.assertEquals((double)100.0, (double)((double)this.scheduler.getQueueManager().getLeafQueue("root.parentA.childA1", false).getFairShare().getMemory() / (double)nodeCapacity * 100.0), (double)0.1);
        Assert.assertEquals((double)0.0, (double)((double)this.scheduler.getQueueManager().getLeafQueue("root.parentA.childA2", false).getFairShare().getMemory() / (double)nodeCapacity), (double)0.1);
        this.verifySteadyFairShareMemory(this.scheduler.getQueueManager().getLeafQueues(), nodeCapacity);
    }

    @Test
    public void testFairShareMultipleActiveQueuesUnderSameParent() throws IOException {
        int nodeCapacity = 16384;
        this.createClusterWithQueuesAndOneNode(nodeCapacity, "fair");
        this.createSchedulingRequest(2048, "root.parentA.childA1", "user1");
        this.createSchedulingRequest(2048, "root.parentA.childA2", "user2");
        this.createSchedulingRequest(2048, "root.parentA.childA3", "user3");
        this.scheduler.update();
        for (int i = 1; i <= 3; ++i) {
            Assert.assertEquals((double)33.0, (double)((double)this.scheduler.getQueueManager().getLeafQueue("root.parentA.childA" + i, false).getFairShare().getMemory() / (double)nodeCapacity * 100.0), (double)0.9);
        }
        this.verifySteadyFairShareMemory(this.scheduler.getQueueManager().getLeafQueues(), nodeCapacity);
    }

    @Test
    public void testFairShareMultipleActiveQueuesUnderDifferentParent() throws IOException {
        int nodeCapacity = 16384;
        this.createClusterWithQueuesAndOneNode(nodeCapacity, "fair");
        this.createSchedulingRequest(2048, "root.parentA.childA1", "user1");
        this.createSchedulingRequest(3072, "root.parentA.childA2", "user2");
        this.createSchedulingRequest(1024, "root.parentB.childB1", "user3");
        this.createSchedulingRequest(1024, "root.default", "user4");
        this.scheduler.update();
        for (int i = 1; i <= 2; ++i) {
            Assert.assertEquals((double)40.0, (double)((double)this.scheduler.getQueueManager().getLeafQueue("root.parentA.childA" + i, false).getFairShare().getMemory() / (double)nodeCapacity * 100.0), (double)0.9);
        }
        Assert.assertEquals((double)10.0, (double)((double)this.scheduler.getQueueManager().getLeafQueue("root.parentB.childB1", false).getFairShare().getMemory() / (double)nodeCapacity * 100.0), (double)0.9);
        this.verifySteadyFairShareMemory(this.scheduler.getQueueManager().getLeafQueues(), nodeCapacity);
    }

    @Test
    public void testFairShareResetsToZeroWhenAppsComplete() throws IOException {
        int nodeCapacity = 16384;
        this.createClusterWithQueuesAndOneNode(nodeCapacity, "fair");
        ApplicationAttemptId app1 = this.createSchedulingRequest(2048, "root.parentA.childA1", "user1");
        ApplicationAttemptId app2 = this.createSchedulingRequest(3072, "root.parentA.childA2", "user2");
        this.scheduler.update();
        for (int i = 1; i <= 2; ++i) {
            Assert.assertEquals((double)50.0, (double)((double)this.scheduler.getQueueManager().getLeafQueue("root.parentA.childA" + i, false).getFairShare().getMemory() / (double)nodeCapacity * 100.0), (double)0.9);
        }
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(app1, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.scheduler.update();
        Assert.assertEquals((double)0.0, (double)((double)this.scheduler.getQueueManager().getLeafQueue("root.parentA.childA1", false).getFairShare().getMemory() / (double)nodeCapacity * 100.0), (double)0.0);
        Assert.assertEquals((double)100.0, (double)((double)this.scheduler.getQueueManager().getLeafQueue("root.parentA.childA2", false).getFairShare().getMemory() / (double)nodeCapacity * 100.0), (double)0.1);
        this.verifySteadyFairShareMemory(this.scheduler.getQueueManager().getLeafQueues(), nodeCapacity);
    }

    @Test
    public void testFairShareWithDRFMultipleActiveQueuesUnderDifferentParent() throws IOException {
        int nodeMem = 16384;
        int nodeVCores = 10;
        this.createClusterWithQueuesAndOneNode(nodeMem, nodeVCores, "drf");
        this.createSchedulingRequest(2048, "root.parentA.childA1", "user1");
        this.createSchedulingRequest(3072, "root.parentA.childA2", "user2");
        this.createSchedulingRequest(1024, "root.parentB.childB1", "user3");
        this.createSchedulingRequest(1024, "root.default", "user4");
        this.scheduler.update();
        for (int i = 1; i <= 2; ++i) {
            Assert.assertEquals((double)40.0, (double)((double)this.scheduler.getQueueManager().getLeafQueue("root.parentA.childA" + i, false).getFairShare().getMemory() / (double)nodeMem * 100.0), (double)0.9);
            Assert.assertEquals((double)40.0, (double)((double)this.scheduler.getQueueManager().getLeafQueue("root.parentA.childA" + i, false).getFairShare().getVirtualCores() / (double)nodeVCores * 100.0), (double)0.9);
        }
        Assert.assertEquals((double)10.0, (double)((double)this.scheduler.getQueueManager().getLeafQueue("root.parentB.childB1", false).getFairShare().getMemory() / (double)nodeMem * 100.0), (double)0.9);
        Assert.assertEquals((double)10.0, (double)((double)this.scheduler.getQueueManager().getLeafQueue("root.parentB.childB1", false).getFairShare().getVirtualCores() / (double)nodeVCores * 100.0), (double)0.9);
        Collection leafQueues = this.scheduler.getQueueManager().getLeafQueues();
        for (FSLeafQueue leaf : leafQueues) {
            if (leaf.getName().startsWith("root.parentA")) {
                Assert.assertEquals((double)0.2, (double)((double)leaf.getSteadyFairShare().getMemory() / (double)nodeMem), (double)0.001);
                Assert.assertEquals((double)0.2, (double)((double)leaf.getSteadyFairShare().getVirtualCores() / (double)nodeVCores), (double)0.001);
                continue;
            }
            if (!leaf.getName().startsWith("root.parentB")) continue;
            Assert.assertEquals((double)0.05, (double)((double)leaf.getSteadyFairShare().getMemory() / (double)nodeMem), (double)0.001);
            Assert.assertEquals((double)0.1, (double)((double)leaf.getSteadyFairShare().getVirtualCores() / (double)nodeVCores), (double)0.001);
        }
    }

    private void verifySteadyFairShareMemory(Collection<FSLeafQueue> leafQueues, int nodeCapacity) {
        for (FSLeafQueue leaf : leafQueues) {
            if (leaf.getName().startsWith("root.parentA")) {
                Assert.assertEquals((double)0.2, (double)((double)leaf.getSteadyFairShare().getMemory() / (double)nodeCapacity), (double)0.001);
                continue;
            }
            if (!leaf.getName().startsWith("root.parentB")) continue;
            Assert.assertEquals((double)0.05, (double)((double)leaf.getSteadyFairShare().getMemory() / (double)nodeCapacity), (double)0.001);
        }
    }
}

