/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnSecurityTestClientAMTokenProtos;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;

public class ClientToAMTokenIdentifierForTest
extends ClientToAMTokenIdentifier {
    private YarnSecurityTestClientAMTokenProtos.ClientToAMTokenIdentifierForTestProto proto;

    public ClientToAMTokenIdentifierForTest() {
    }

    public ClientToAMTokenIdentifierForTest(ClientToAMTokenIdentifier tokenIdentifier, String message) {
        YarnSecurityTestClientAMTokenProtos.ClientToAMTokenIdentifierForTestProto.Builder builder = YarnSecurityTestClientAMTokenProtos.ClientToAMTokenIdentifierForTestProto.newBuilder();
        builder.setAppAttemptId(tokenIdentifier.getProto().getAppAttemptId());
        builder.setClientName(tokenIdentifier.getProto().getClientName());
        builder.setMessage(message);
        this.proto = builder.build();
    }

    public ApplicationAttemptId getApplicationAttemptID() {
        if (!this.proto.hasAppAttemptId()) {
            return null;
        }
        return new ApplicationAttemptIdPBImpl(this.proto.getAppAttemptId());
    }

    public String getClientName() {
        return this.proto.getClientName();
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.proto.toByteArray());
    }

    public void readFields(DataInput in) throws IOException {
        DataInputStream dis = (DataInputStream)in;
        byte[] buffer = IOUtils.toByteArray((InputStream)dis);
        this.proto = YarnSecurityTestClientAMTokenProtos.ClientToAMTokenIdentifierForTestProto.parseFrom((byte[])buffer);
    }

    public UserGroupInformation getUser() {
        String clientName = this.getClientName();
        if (clientName == null) {
            return null;
        }
        return UserGroupInformation.createRemoteUser((String)clientName);
    }

    public int hashCode() {
        return this.getNewProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getNewProto().equals((Object)((ClientToAMTokenIdentifierForTest)((Object)((Object)((Object)this)).getClass().cast(other))).getNewProto());
        }
        return false;
    }

    public YarnSecurityTestClientAMTokenProtos.ClientToAMTokenIdentifierForTestProto getNewProto() {
        return this.proto;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getNewProto());
    }
}

